/*
MySQL Data Transfer
Source Host: localhost
Source Database: pvc
Target Host: localhost
Target Database: pvc
Date: 12/19/2009 01:57:56 .
*/

SET FOREIGN_KEY_CHECKS=0;
-- ----------------------------
-- Table structure for infinitive
-- ----------------------------
CREATE TABLE `infinitive` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `text` varchar(50) NOT NULL,
  `transcription` varchar(50) NOT NULL,
  `simplepart_id` int(10) DEFAULT NULL,
  `prefix_part` varchar(50) DEFAULT NULL,
  `past_stem` varchar(50) NOT NULL,
  `present_stem` varchar(50) NOT NULL,
  `past_participle` varchar(50) NOT NULL,
  `passive_voice` varchar(50) NOT NULL,
  `type` varchar(10) NOT NULL COMMENT 'WRITTEN, SPOKEN',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1548 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for infinitive_english_translation
-- ----------------------------
CREATE TABLE `infinitive_english_translation` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `infinitive_id` int(11) NOT NULL,
  `text` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3734 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for verb
-- ----------------------------
CREATE TABLE `verb` (
  `text` varchar(50) NOT NULL,
  `infinitive_id` varchar(50) NOT NULL,
  `voice` varchar(50) NOT NULL COMMENT 'ACTIVE, PASSIVE',
  `number` varchar(50) NOT NULL COMMENT 'SINGULAR, PLURAL',
  `person` varchar(50) NOT NULL COMMENT 'FIRST PERSON, SECOND PERSON, THIRD PERSON',
  `polarity` varchar(50) NOT NULL COMMENT 'POSITIVE, NEGATIVE',
  `pronoun` varchar(50) NOT NULL COMMENT 'PAST PRONOUN, PRESENT PRONOUN',
  `tense` varchar(50) NOT NULL COMMENT 'PAST TENSE, PRESENT TENSE, FUTURE TENSE',
  `mood` varchar(50) NOT NULL COMMENT 'INDICATIVE, SUBJUNCTIVE, IMPERATIVE',
  `aspect` varchar(50) NOT NULL DEFAULT '' COMMENT 'NARRATIVE, PRECEDENT, IMPERFECTIVE, PROGRESSIVE, NARRATIVE_IMPERFECTIVE',
  PRIMARY KEY (`text`,`infinitive_id`,`voice`,`polarity`,`tense`,`mood`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records 
-- ----------------------------
INSERT INTO `infinitive` VALUES ('1', 'آجیدن', 'ājidan', null, '', 'آجید', 'آج', 'آجیده ', 'آجیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('2', 'آختن', 'ākhtan', null, '', 'آخت', 'آز', 'آخته ', 'آخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('3', 'آراستن', 'ārāstan', null, '', 'آراست', 'آرا', 'آراسته ', 'آراسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('4', 'آزردن', 'āzordan', null, '', 'آزرد', 'آزر', 'آزرده ', 'آزرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('5', 'آزمودن', 'āzmudan', null, '', 'آزمود', 'آزما', 'آزموده ', 'آزموده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('6', 'آسودن', 'āsudan', null, '', 'آسود', 'آسا', 'آسوده ', 'آسوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('7', 'آشفتن', 'āshoftan', null, '', 'آشفت', 'آشوب', 'آشفته ', 'آشفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('8', 'آغشتن', 'āghashtan', null, '', 'آغشت', 'آغر', 'آغشته ', 'آغشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('9', 'آغشتن', 'āgheshtan', null, '', 'آغشت', 'آغر', 'آغشته ', 'آغشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('10', 'آفریدن', 'āfaridan', null, '', 'آفرید', 'آفرین', 'آفریده ', 'آفریده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('11', 'آکندن', 'ākandan', null, '', 'آکند', 'آکن', 'آکنده ', 'آکنده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('12', 'آگندن', 'āgandan', null, '', 'آگند', 'آگن', 'آگنده ', 'آگنده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('13', 'آلودن', 'āludan', null, '', 'آلود', 'آلا', 'آلوده ', 'آلوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('14', 'آمادن', 'āmādan', null, '', 'آماد', 'آما', 'آماده ', 'آماده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('15', 'آمدن', 'āmadan', null, '', 'آمد', 'آ', 'آمده ', 'آمده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('16', 'اومدن', 'umadan', null, '', 'اومد', 'یا', 'اومده ', 'اومده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('17', 'آموختن', 'āmukhtan', null, '', 'آموخت', 'آموز', 'آموخته ', 'آموخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('18', 'آمیختن', 'āmikhtan', null, '', 'آمیخت', 'آمیز', 'آمیخته ', 'آمیخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('19', 'آوردن', 'āvardan', null, '', 'آورد', 'آور', 'آورده ', 'آورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('20', 'آوردن', 'āvordan', null, '', 'آورد', 'آور', 'آورده ', 'آورده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('21', 'آویختن', 'āvikhtan', null, '', 'آویخت', 'آویز', 'آویخته ', 'آویخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('22', 'آهیختن', 'āhikhtan', null, '', 'آهیخت', 'آهیز', 'آهیخته ', 'آهیخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('23', 'ارزیدن', 'arzidan', null, '', 'ارزید', 'ارز', 'ارزیده ', 'ارزیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('24', 'افتادن', 'oftādan', null, '', 'افتاد', 'افت', 'افتاده ', 'افتاده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('25', 'افراختن', 'afrākhtan', null, '', 'افراخت', 'افراز', 'افراخته ', 'افراخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('26', 'افراشتن', 'afrāshtan', null, '', 'افراشت', 'افراز', 'افراشته ', 'افراشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('27', 'افروختن', 'afrukhtan', null, '', 'افروخت', 'افروز', 'افروخته ', 'افروخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('28', 'افزودن', 'afzudan', null, '', 'افزود', 'افزا', 'افزوده ', 'افزوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('29', 'افسردن', 'afsordan', null, '', 'افسرد', 'افسر', 'افسرده ', 'افسرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('30', 'افشردن', 'afshordan', null, '', 'افشرد', 'افشر', 'افشرده ', 'افشرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('31', 'افکندن', 'afkandan', null, '', 'افکند', 'افکن', 'افکنده ', 'افکنده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('32', 'انباشتن', 'anbāshtan', null, '', 'انباشت', 'انبار', 'انباشته ', 'انباشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('33', 'انجامیدن', 'anjāmidan', null, '', 'انجامید', 'انجام', 'انجامیده ', 'انجامیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('34', 'انداختن', 'andākhtan', null, '', 'انداخت', 'انداز', 'انداخته ', 'انداخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('35', 'اندوختن', 'andukhtan', null, '', 'اندوخت', 'اندوز', 'اندوخته ', 'اندوخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('36', 'اندودن', 'andudan', null, '', 'اندود', 'اندا', 'اندوده ', 'اندوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('37', 'اندیشیدن', 'andishidan', null, '', 'اندیشید', 'اندیش', 'اندیشیده ', 'اندیشیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('38', 'انگاشتن', 'engāshtan', null, '', 'انگاشت', 'انگار', 'انگاشته ', 'انگاشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('39', 'انگیختن', 'angikhtan', null, '', 'انگیخت', 'انگیز', 'انگیخته ', 'انگیخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('40', 'ایستادن', 'istādan', null, '', 'ایستاد', 'ایست', 'ایستاده ', 'ایستاده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('41', 'باختن', 'bakhtan', null, '', 'باخت', 'باز', 'باخته ', 'باخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('42', 'باراندن', 'bārāndan', null, '', 'باراند', 'باران', 'بارانده ', 'بارانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('43', 'بارانیدن', 'bārānidan', null, '', 'بارانید', 'باران', 'بارانیده ', 'بارانیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('44', 'باریدن', 'bāridan', null, '', 'بارید', 'بار', 'باریده ', 'باریده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('45', 'بافتن', 'bāftan', null, '', 'بافت', 'باف', 'بافته ', 'بافته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('46', 'بالیدن', 'bālidan', null, '', 'بالید', 'بال', 'بالیده ', 'بالیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('47', 'بایستن', 'bāyestan', null, '', 'بایست', 'بای', 'بایسته ', 'بایسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('48', 'بخشاییدن', 'bakhshāidan', null, '', 'بخشایید', 'بخشا', 'بخشاییده ', 'بخشاییده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('49', 'بخشودن', 'bakhshudan', null, '', 'بخشود', 'بخشا', 'بخشوده ', 'بخشوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('50', 'بخشیدن', 'bakhshidan', null, '', 'بخشید', 'بخش', 'بخشیده ', 'بخشیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('51', 'برازیدن', 'barāzidan', null, '', 'برازید', 'براز', 'برازیده ', 'برازیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('52', 'بردن', 'bordan', null, '', 'برد', 'بر', 'برده ', 'برده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('53', 'بریدن', 'boridan', null, '', 'برید', 'بر', 'بریده ', 'بریده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('54', 'بستن', 'bastan', null, '', 'بست', 'بند', 'بسته ', 'بسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('55', 'بودن', 'budan', null, '', 'بود', 'باش', 'بوده ', 'بوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('56', 'بیختن', 'bikhtan', null, '', 'بیخت', 'بیز', 'بیخته ', 'بیخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('57', 'پالودن', 'pāludan', null, '', 'پالود', 'پالا', 'پالوده ', 'پالوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('58', 'پختن', 'pokhtan', null, '', 'پخت', 'پز', 'پخته ', 'پخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('59', 'پذیرفتن', 'paziroftan', null, '', 'پذیرفت', 'پذیر', 'پذیرفته ', 'پذیرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('60', 'پراکندن', 'parākandan', null, '', 'پراکند', 'پراکن', 'پراکنده ', 'پراکنده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('61', 'پرداختن', 'pardākhtan', null, '', 'پرداخت', 'پرداز', 'پرداخته ', 'پرداخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('62', 'پرسیدن', 'porsidan', null, '', 'پرسید', 'پرس', 'پرسیده ', 'پرسیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('63', 'پروردن', 'parvardan', null, '', 'پرورد', 'پرور', 'پرورده ', 'پرورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('64', 'پرهیختن', 'parhikhtan', null, '', 'پرهیخت', 'پرهیز', 'پرهیخته ', 'پرهیخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('65', 'پرهیزیدن', 'parhizidan', null, '', 'پرهیزید', 'پرهیز', 'پرهیزیده ', 'پرهیزیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('66', 'پریدن', 'paridan', null, '', 'پرید', 'پر', 'پریده ', 'پریده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('67', 'پژوهیدن', 'pezhuhidan', null, '', 'پژوهید', 'پژوه', 'پژوهیده ', 'پژوهیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('68', 'پژوهیدن', 'pazhuhidan', null, '', 'پژوهید', 'پژوه', 'پژوهیده ', 'پژوهیده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('69', 'پسندیدن', 'pasandidan', null, '', 'پسندید', 'پسند', 'پسندیده ', 'پسندیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('70', 'پنداریدن', 'pendāridan', null, '', 'پندارید', 'پندار', 'پنداریده ', 'پنداریده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('71', 'پنداشتن', 'pendāshtan', null, '', 'پنداشت', 'پندار', 'پنداشته ', 'پنداشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('72', 'پوشیدن', 'pushidan', null, '', 'پوشید', 'پوش', 'پوشیده ', 'پوشیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('73', 'پیچیدن', 'pichidan', null, '', 'پیچید', 'پیچ', 'پیچیده ', 'پیچیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('74', 'پیراستن', 'payrāstan', null, '', 'پیراست', 'پیرا', 'پیراسته ', 'پیراسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('75', 'پیراستن', 'pirāstan', null, '', 'پیراست', 'پیرا', 'پیراسته ', 'پیراسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('76', 'پیمودن', 'paymudan', null, '', 'پیمود', 'پیما', 'پیموده ', 'پیموده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('77', 'پیوستن', 'payvastan', null, '', 'پیوست', 'پیوند', 'پیوسته ', 'پیوسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('78', 'تاختن', 'tākhtan', null, '', 'تاخت', 'تاز', 'تاخته ', 'تاخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('79', 'تافتن', 'tāftan', null, '', 'تافت', 'تاب', 'تافته ', 'تافته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('80', 'پاشیدن', 'pāshidan', null, '', 'پاشید', 'پاش', 'پاشیده ', 'پاشیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('81', 'تخم پاشیدن', 'tokhm pāshidan', '80', 'تخم ', 'تخم پاشید', 'تخم پاش', 'تخم پاشیده ', 'تخم پاشیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('82', 'تراشیدن', 'tarāshidan', null, '', 'تراشید', 'تراش', 'تراشیده ', 'تراشیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('83', 'ترساندن', 'tarsāndan', null, '', 'ترساند', 'ترسان', 'ترسانده ', 'ترسانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('84', 'ترسوندن', 'tarsundan', null, '', 'ترسوند', 'ترسون', 'ترسونده ', 'ترسونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('85', 'ترسیدن', 'tarsidan', null, '', 'ترسید', 'ترس', 'ترسیده ', 'ترسیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('86', 'تمرگیدن', 'tamargidan', null, '', 'تمرگید', 'تمرگ', 'تمرگیده ', 'تمرگیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('87', 'توانستن', 'tavānestan', null, '', 'توانست', 'توان', 'توانسته ', 'توانسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('88', 'تونستن', 'tunestan', null, '', 'تونست', 'تونس', 'تونسته ', 'تونسته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('89', 'توختن', 'tukhtan', null, '', 'توخت', 'توخ', 'توخته ', 'توخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('90', 'تیغیدن', 'tighidan', null, '', 'تیغید', 'تیغ', 'تیغیده ', 'تیغیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('91', 'جستن', 'jastan', null, '', 'جست', 'جه', 'جسته ', 'جسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('92', 'جستن', 'jostan', null, '', 'جست', 'جو', 'جسته ', 'جسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('93', 'جنباندن', 'jonbāndan', null, '', 'جنباند', 'جنبان', 'جنبانده ', 'جنبانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('94', 'جنبانیدن', 'jonbānidan', null, '', 'جنبانید', 'جنبان', 'جنبانیده ', 'جنبانیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('95', 'جنبیدن', 'jonbidan', null, '', 'جنبید', 'جنب', 'جنبیده ', 'جنبیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('96', 'جنگیدن', 'jangidan', null, '', 'جنگید', 'جنگ', 'جنگیده ', 'جنگیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('97', 'جوشاندن', 'jushāndan', null, '', 'جوشاند', 'جوشان', 'جوشانده ', 'جوشانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('98', 'جوشوندن', 'jushundan', null, '', 'جوشوند', 'جوشون', 'جوشونده ', 'جوشونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('99', 'جوشیدن', 'jushidan', null, '', 'جوشید', 'جوش', 'جوشیده ', 'جوشیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('100', 'جویدن', 'javidan', null, '', 'جوید', 'جو', 'جویده ', 'جویده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('101', 'جوییدن', 'juidan', null, '', 'جویید', 'جو', 'جوییده ', 'جوییده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('102', 'چسباندن', 'chasbāndan', null, '', 'چسباند', 'چسبان', 'چسبانده ', 'چسبانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('103', 'چسبوندن', 'chasbundan', null, '', 'چسبوند', 'چسبون', 'چسبونده ', 'چسبونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('104', 'چسبیدن', 'chasbidan', null, '', 'چسبید', 'چسب', 'چسبیده ', 'چسبیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('105', 'چیدن', 'chidan', null, '', 'چید', 'چین', 'چیده ', 'چیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('106', 'خاراندن', 'khārāndan', null, '', 'خاراند', 'خاران', 'خارانده ', 'خارانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('107', 'خاروندن', 'khārundan', null, '', 'خاروند', 'خارون', 'خارونده ', 'خارونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('108', 'خاریدن', 'khāridan', null, '', 'خارید', 'خار', 'خاریده ', 'خاریده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('109', 'خاستن', 'khāstan', null, '', 'خاست', 'خیز', 'خاسته ', 'خاسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('110', 'خاییدن', 'khāidan', null, '', 'خایید', 'خای', 'خاییده ', 'خاییده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('111', 'خراشاندن', 'kharāshāndan', null, '', 'خراشاند', 'خراشان', 'خراشانده ', 'خراشانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('112', 'خراشوندن', 'kharāshundan', null, '', 'خراشوند', 'خراشون', 'خراشونده ', 'خراشونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('113', 'خرامیدن', 'kharāmidan', null, '', 'خرامید', 'خرام', 'خرامیده ', 'خرامیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('114', 'خریدن', 'kharidan', null, '', 'خرید', 'خر', 'خریده ', 'خریده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('115', 'خسبیدن', 'khosbidan', null, '', 'خسبید', 'خسب', 'خسبیده ', 'خسبیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('116', 'خسپیدن', 'khospidan', null, '', 'خسپید', 'خسپ', 'خسپیده ', 'خسپیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('117', 'خندیدن', 'khandidan', null, '', 'خندید', 'خند', 'خندیده ', 'خندیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('118', 'خوابیدن', 'khābidan', null, '', 'خوابید', 'خواب', 'خوابیده ', 'خوابیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('119', 'خواستن', 'khāstan', null, '', 'خواست', 'خواه', 'خواسته ', 'خواسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('120', 'خواندن', 'khāndan', null, '', 'خواند', 'خوان', 'خوانده ', 'خوانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('121', 'خوندن', 'khundan', null, '', 'خوند', 'خون', 'خونده ', 'خونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('122', 'خوردن', 'khordan', null, '', 'خورد', 'خور', 'خورده ', 'خورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('123', 'دادن', 'dādan', null, '', 'داد', 'ده', 'داده ', 'داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('124', 'داشتن', 'dāshtan', null, '', 'داشت', 'دار', 'داشته ', 'داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('125', 'دانستن', 'dānestan', null, '', 'دانست', 'دان', 'دانسته ', 'دانسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('126', 'دونستن', 'dunestan', null, '', 'دونست', 'دونس', 'دونسته ', 'دونسته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('127', 'درازیدن', 'derāzidan', null, '', 'درازید', 'دراز', 'درازیده ', 'درازیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('128', 'درودن', 'dorudan', null, '', 'درود', 'درو', 'دروده ', 'دروده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('129', 'درویدن', 'deravidan', null, '', 'دروید', 'درو', 'درویده ', 'درویده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('130', 'دریدن', 'daridan', null, '', 'درید', 'در', 'دریده ', 'دریده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('131', 'دزدیدن', 'dozdidan', null, '', 'دزدید', 'دزد', 'دزدیده ', 'دزدیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('132', 'دواندن', 'davāndan', null, '', 'دواند', 'دوان', 'دوانده ', 'دوانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('133', 'دووندن', 'davundan', null, '', 'دووند', 'دوون', 'دوونده ', 'دوونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('134', 'دوختن', 'dukhtan', null, '', 'دوخت', 'دوز', 'دوخته ', 'دوخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('135', 'دوشیدن', 'dushidan', null, '', 'دوشید', 'دوش', 'دوشیده ', 'دوشیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('136', 'دویدن', 'davidan', null, '', 'دوید', 'دو', 'دویده ', 'دویده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('137', 'دویدن', 'doidan', null, '', 'دوید', 'دو', 'دویده ', 'دویده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('138', 'دیدن', 'didan', null, '', 'دید', 'بین', 'دیده ', 'دیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('139', 'راندن', 'rāndan', null, '', 'راند', 'ران', 'رانده ', 'رانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('140', 'روندن', 'rundan', null, '', 'روند', 'رون', 'رونده ', 'رونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('141', 'ربودن', 'robudan', null, '', 'ربود', 'ربا', 'ربوده ', 'ربوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('142', 'رساندن', 'resāndan', null, '', 'رساند', 'رسان', 'رسانده ', 'رسانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('143', 'رسوندن', 'resundan', null, '', 'رسوند', 'رسون', 'رسونده ', 'رسونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('144', 'رستن', 'rostan', null, '', 'رست', 'ره', 'رسته ', 'رسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('145', 'رستن', 'rastan', null, '', 'رست', 'ره', 'رسته ', 'رسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('146', 'رسیدن', 'residan', null, '', 'رسید', 'رس', 'رسیده ', 'رسیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('147', 'رشتن', 'reshtan', null, '', 'رشت', 'ریس', 'رشته ', 'رشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('148', 'رفتن', 'roftan', null, '', 'رفت', 'روب', 'رفته ', 'رفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('149', 'رفتن', 'raftan', null, '', 'رفت', 'رو', 'رفته ', 'رفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('150', 'روییدن', 'ruidan', null, '', 'رویید', 'رو', 'روییده ', 'روییده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('151', 'ریختن', 'rikhtan', null, '', 'ریخت', 'ریز', 'ریخته ', 'ریخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('152', 'ریدن', 'ridan', null, '', 'رید', 'رین', 'ریده ', 'ریده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('153', 'زادن', 'zādan', null, '', 'زاد', 'زا', 'زاده ', 'زاده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('154', 'زدن', 'zadan', null, '', 'زد', 'زن', 'زده ', 'زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('155', 'زدودن', 'zodudan', null, '', 'زدود', 'زدا', 'زدوده ', 'زدوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('156', 'زنگیدن', 'zangidan', null, '', 'زنگید', 'زنگ', 'زنگیده ', 'زنگیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('157', 'زیستن', 'zistan', null, '', 'زیست', 'زی', 'زیسته ', 'زیسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('158', 'ژولیدن', 'zhulidan', null, '', 'ژولید', 'ژول', 'ژولیده ', 'ژولیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('159', 'ساختن', 'sākhtan', null, '', 'ساخت', 'ساز', 'ساخته ', 'ساخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('160', 'ساییدن', 'sāidan', null, '', 'سایید', 'سا', 'ساییده ', 'ساییده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('161', 'سپردن', 'sepordan', null, '', 'سپرد', 'سپر', 'سپرده ', 'سپرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('162', 'سپردن', 'separdan', null, '', 'سپرد', 'سپار', 'سپرده ', 'سپرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('163', 'ستادن', 'setādan', null, '', 'ستاد', 'ستا', 'ستاده ', 'ستاده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('164', 'ستدن', 'setadan', null, '', 'ستد', 'ستان', 'ستده ', 'ستده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('165', 'ستردن', 'setordan', null, '', 'سترد', 'ستر', 'سترده ', 'سترده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('166', 'ستودن', 'sotudan', null, '', 'ستود', 'ست', 'ستوده ', 'ستوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('167', 'سرشتن', 'sereshtan', null, '', 'سرشت', 'سرش', 'سرشته ', 'سرشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('168', 'سرودن', 'sorudan', null, '', 'سرود', 'سرا', 'سروده ', 'سروده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('169', 'سریدن', 'soridan', null, '', 'سرید', 'سر', 'سریده ', 'سریده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('170', 'سفتن', 'softan', null, '', 'سفت', 'سنب', 'سفته ', 'سفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('171', 'سگالیدن', 'segālidan', null, '', 'سگالید', 'سگال', 'سگالیده ', 'سگالیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('172', 'سوختن', 'sukhtan', null, '', 'سوخت', 'سوز', 'سوخته ', 'سوخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('173', 'سودن', 'sudan', null, '', 'سود', 'سا', 'سوده ', 'سوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('174', 'شاشیدن', 'shāshidan', null, '', 'شاشید', 'شاش', 'شاشیده ', 'شاشیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('175', 'شایستن', 'shāyestan', null, '', 'شایست', 'شای', 'شایسته ', 'شایسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('176', 'شتابیدن', 'shetābidan', null, '', 'شتابید', 'شتاب', 'شتابیده ', 'شتابیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('177', 'شتافتن', 'shetāftan', null, '', 'شتافت', 'شتاب', 'شتافته ', 'شتافته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('178', 'شدن', 'shodan', null, '', 'شد', 'شو', 'شده ', 'شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('179', 'شستن', 'shostan', null, '', 'شست', 'شو', 'شسته ', 'شسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('180', 'شکافتن', 'shekāftan', null, '', 'شکافت', 'شکاف', 'شکافته ', 'شکافته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('181', 'شکافیدن', 'shekāfidan', null, '', 'شکافید', 'شکاف', 'شکافیده ', 'شکافیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('182', 'شکاندن', 'shekāndan', null, '', 'شکاند', 'شکان', 'شکانده ', 'شکانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('183', 'شکوندن', 'shekundan', null, '', 'شکوند', 'شکون', 'شکونده ', 'شکونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('184', 'شکستن', 'shekastan', null, '', 'شکست', 'شکن', 'شکسته ', 'شکسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('185', 'شکفتن', 'shekoftan', null, '', 'شکفت', 'شکف', 'شکفته ', 'شکفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('186', 'شکوفیدن', 'shokufidan', null, '', 'شکوفید', 'شکوف', 'شکوفیده ', 'شکوفیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('187', 'شکوفیدن', 'shekufidan', null, '', 'شکوفید', 'شکوف', 'شکوفیده ', 'شکوفیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('188', 'شکیبیدن', 'shakibidan', null, '', 'شکیبید', 'شکیب', 'شکیبیده ', 'شکیبیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('189', 'شکیبیدن', 'shekibidan', null, '', 'شکیبید', 'شکیب', 'شکیبیده ', 'شکیبیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('190', 'شمردن', 'shomordan', null, '', 'شمرد', 'شمر', 'شمرده ', 'شمرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('191', 'شناختن', 'shenākhtan', null, '', 'شناخت', 'شناس', 'شناخته ', 'شناخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('192', 'شنفتن', 'shenoftan', null, '', 'شنفت', 'شنف', 'شنفته ', 'شنفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('193', 'شنودن', 'shonudan', null, '', 'شنود', 'شنو', 'شنوده ', 'شنوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('194', 'شنیدن', 'shenidan', null, '', 'شنید', 'شنو', 'شنیده ', 'شنیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('195', 'صرفیدن', 'sarfidan', null, '', 'صرفید', 'صرف', 'صرفیده ', 'صرفیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('196', 'طلبیدن', 'talabidan', null, '', 'طلبید', 'طلب', 'طلبیده ', 'طلبیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('197', 'غنودن', 'ghonudan', null, '', 'غنود', 'غنو', 'غنوده ', 'غنوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('198', 'فرساییدن', 'farsāidan', null, '', 'فرسایید', 'فرسا', 'فرساییده ', 'فرساییده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('199', 'فرستادن', 'ferestādan', null, '', 'فرستاد', 'فرست', 'فرستاده ', 'فرستاده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('200', 'فرسودن', 'farsudan', null, '', 'فرسود', 'فرسا', 'فرسوده ', 'فرسوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('201', 'فرمودن', 'farmudan', null, '', 'فرمود', 'فرما', 'فرموده ', 'فرموده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('202', 'فروختن', 'afrukhtan', null, '', 'فروخت', 'فروز', 'فروخته ', 'فروخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('203', 'فروختن', 'forukhtan', null, '', 'فروخت', 'فروش', 'فروخته ', 'فروخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('204', 'فریفتن', 'fariftan', null, '', 'فریفت', 'فریب', 'فریفته ', 'فریفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('205', 'فسردن', 'fesordan', null, '', 'فسرد', 'فسر', 'فسرده ', 'فسرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('206', 'فشردن', 'feshordan', null, '', 'فشرد', 'فشار', 'فشرده ', 'فشرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('207', 'فکندن', 'fakandan', null, '', 'فکند', 'فکن', 'فکنده ', 'فکنده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('208', 'فهماندن', 'fahmāndan', null, '', 'فهماند', 'فهمان', 'فهمانده ', 'فهمانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('209', 'فهموندن', 'fahmundan', null, '', 'فهموند', 'فهمون', 'فهمونده ', 'فهمونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('210', 'فهمیدن', 'fahmidan', null, '', 'فهمید', 'فهم', 'فهمیده ', 'فهمیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('211', 'کاستن', 'kāstan', null, '', 'کاست', 'کاه', 'کاسته ', 'کاسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('212', 'کاشتن', 'kāshtan', null, '', 'کاشت', 'کار', 'کاشته ', 'کاشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('213', 'کافتن', 'kāftan', null, '', 'کافت', 'کاف', 'کافته ', 'کافته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('214', 'کاویدن', 'kāvidan', null, '', 'کاوید', 'کاو', 'کاویده ', 'کاویده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('215', 'کردن', 'kardan', null, '', 'کرد', 'کن', 'کرده ', 'کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('216', 'کشتن', 'koshtan', null, '', 'کشت', 'کش', 'کشته ', 'کشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('217', 'کشتن', 'keshtan', null, '', 'کشت', 'کار', 'کشته ', 'کشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('218', 'کشیدن', 'keshidan', null, '', 'کشید', 'کش', 'کشیده ', 'کشیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('219', 'کندن', 'kandan', null, '', 'کند', 'کن', 'کنده ', 'کنده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('220', 'کوبیدن', 'kubidan', null, '', 'کوبید', 'کوب', 'کوبیده ', 'کوبیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('221', 'کوشیدن', 'kushidan', null, '', 'کوشید', 'کوش', 'کوشیده ', 'کوشیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('222', 'کوفتن', 'kuftan', null, '', 'کوفت', 'کوب', 'کوفته ', 'کوفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('223', 'گداختن', 'godākhtan', null, '', 'گداخت', 'گداز', 'گداخته ', 'گداخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('224', 'گذاشتن', 'gozāshtan', null, '', 'گذاشت', 'گذار', 'گذاشته ', 'گذاشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('225', 'گذشتن', 'gozashtan', null, '', 'گذشت', 'گذر', 'گذشته ', 'گذشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('226', 'گرداندن', 'gardāndan', null, '', 'گرداند', 'گردان', 'گردانده ', 'گردانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('227', 'گردوندن', 'gardundan', null, '', 'گردوند', 'گردون', 'گردونده ', 'گردونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('228', 'گرفتن', 'gereftan', null, '', 'گرفت', 'گیر', 'گرفته ', 'گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('229', 'گریختن', 'gorikhtan', null, '', 'گریخت', 'گریز', 'گریخته ', 'گریخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('230', 'گریستن', 'geristan', null, '', 'گریست', 'گری', 'گریسته ', 'گریسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('231', 'گزاردن', 'gozārdan', null, '', 'گزارد', 'گزار', 'گزارده ', 'گزارده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('232', 'گزیدن', 'gozidan', null, '', 'گزید', 'گزین', 'گزیده ', 'گزیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('233', 'گزیدن', 'gazidan', null, '', 'گزید', 'گز', 'گزیده ', 'گزیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('234', 'گسستن', 'gosestan', null, '', 'گسست', 'گسل', 'گسسته ', 'گسسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('235', 'گسستن', 'gosastan', null, '', 'گسست', 'گسل', 'گسسته ', 'گسسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('236', 'گسیختن', 'gosikhtan', null, '', 'گسیخت', 'گسل', 'گسیخته ', 'گسیخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('237', 'گشادن', 'goshādan', null, '', 'گشاد', 'گشا', 'گشاده ', 'گشاده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('238', 'گشتن', 'gashtan', null, '', 'گشت', 'گرد', 'گشته ', 'گشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('239', 'گشودن', 'goshudan', null, '', 'گشود', 'گشا', 'گشوده ', 'گشوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('240', 'گفتن', 'goftan', null, '', 'گفت', 'گو', 'گفته ', 'گفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('241', 'گماشتن', 'gomāshtan', null, '', 'گماشت', 'گمار', 'گماشته ', 'گماشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('242', 'لاغریدن', 'lāgharidan', null, '', 'لاغرید', 'لاغر', 'لاغریده ', 'لاغریده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('243', 'لستن', 'lestan', null, '', 'لست', 'لس', 'لسته ', 'لسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('244', 'لشتن', 'leshtan', null, '', 'لشت', 'لش', 'لشته ', 'لشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('245', 'لغزیدن', 'laghzidan', null, '', 'لغزید', 'لغز', 'لغزیده ', 'لغزیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('246', 'لیسیدن', 'lisidan', null, '', 'لیسید', 'لیس', 'لیسیده ', 'لیسیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('247', 'مالاندن', 'mālāndan', null, '', 'مالاند', 'مالان', 'مالانده ', 'مالانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('248', 'مالیدن', 'mālidan', null, '', 'مالید', 'مال', 'مالیده ', 'مالیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('249', 'ماندن', 'māndan', null, '', 'ماند', 'مان', 'مانده ', 'مانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('250', 'موندن', 'mundan', null, '', 'موند', 'مون', 'مونده ', 'مونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('251', 'مانستن', 'mānestan', null, '', 'مانست', 'مان', 'مانسته ', 'مانسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('252', 'مردن', 'mordan', null, '', 'مرد', 'میر', 'مرده ', 'مرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('253', 'مشتن', 'meshtan', null, '', 'مشت', 'مش', 'مشته ', 'مشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('254', 'مشتن', 'moshtan', null, '', 'مشت', 'مش', 'مشته ', 'مشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('255', 'موییدن', 'muidan', null, '', 'مویید', 'موی', 'موییده ', 'موییده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('256', 'نالیدن', 'nālidan', null, '', 'نالید', 'نال', 'نالیده ', 'نالیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('257', 'نشاستن', 'neshāstan', null, '', 'نشاست', 'نشا', 'نشاسته ', 'نشاسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('258', 'نشستن', 'neshastan', null, '', 'نشست', 'نشین', 'نشسته ', 'نشسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('259', 'نگاشتن', 'negāshtan', null, '', 'نگاشت', 'نگار', 'نگاشته ', 'نگاشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('260', 'نگریستن', 'negaristan', null, '', 'نگریست', 'نگر', 'نگریسته ', 'نگریسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('261', 'نمودن', 'nemudan', null, '', 'نمود', 'نما', 'نموده ', 'نموده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('262', 'نواختن', 'navākhtan', null, '', 'نواخت', 'نواز', 'نواخته ', 'نواخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('263', 'نوردیدن', 'navardidan', null, '', 'نوردید', 'نورد', 'نوردیده ', 'نوردیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('264', 'نوشتن', 'neveshtan', null, '', 'نوشت', 'نویس', 'نوشته ', 'نوشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('265', 'نهادن', 'nahādan', null, '', 'نهاد', 'نه', 'نهاده ', 'نهاده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('266', 'نهفتن', 'nahoftan', null, '', 'نهفت', 'نهنب', 'نهفته ', 'نهفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('267', 'وا گذاشتن', 'vā gozāshtan', '224', 'وا ', 'وا گذاشت', 'وا گذار', 'وا گذاشته ', 'وا گذاشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('268', 'ورزیدن', 'varzidan', null, '', 'ورزید', 'ورز', 'ورزیده ', 'ورزیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('269', 'وزیدن', 'vazidan', null, '', 'وزید', 'وز', 'وزیده ', 'وزیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('270', 'هراسیدن', 'harāsidan', null, '', 'هراسید', 'هراس', 'هراسیده ', 'هراسیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('271', 'هشتن', 'heshtan', null, '', 'هشت', 'هل', 'هشته ', 'هشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('272', 'یاختن', 'yākhtan', null, '', 'یاخت', 'یاز', 'یاخته ', 'یاخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('273', 'یارستن', 'yārestan', null, '', 'یارست', 'یار', 'یارسته ', 'یارسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('274', 'یازیدن', 'yāzidan', null, '', 'یازید', 'یاز', 'یازیده ', 'یازیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('275', 'یافتن', 'yāftan', null, '', 'یافت', 'یاب', 'یافته ', 'یافته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('276', 'دوختن', 'dukhtan', null, null, 'دوخت', 'دوش', 'دوخته', 'دوخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('277', 'آب خوردن', 'āb khordan', '122', 'آب ', 'آب خورد', 'آب خور', 'آب خورده ', 'آب خورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('278', 'آب رفتن', 'āb raftan', '149', 'آب ', 'آب رفت', 'آب رو', 'آب رفته ', 'آب رفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('279', 'آب شدن', 'āb shodan', '178', 'آب ', 'آب شد', 'آب شو', 'آب شده ', 'آب شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('280', 'آب کردن', 'āb kardan', '215', 'آب ', 'آب کرد', 'آب کن', 'آب کرده ', 'آب کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('281', 'آب تنی کردن', 'āb-tani kardan', '215', 'آب تنی ', 'آب تنی کرد', 'آب تنی کن', 'آب تنی کرده ', 'آب تنی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('282', 'آجیده کردن', 'ājide kardan', '215', 'آجیده ', 'آجیده کرد', 'آجیده کن', 'آجیده کرده ', 'آجیده کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('283', 'آرام گرفتن', 'ārām gereftan', '228', 'آرام ', 'آرام گرفت', 'آرام گیر', 'آرام گرفته ', 'آرام گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('284', 'آروم گرفتن', 'ārum gereftan', '228', 'آروم ', 'آروم گرفت', 'آروم گیر', 'آروم گرفته ', 'آروم گرفته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('285', 'آزاد شدن', 'āzād shodan', '178', 'آزاد ', 'آزاد شد', 'آزاد شو', 'آزاد شده ', 'آزاد شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('286', 'آشپزی کردن', 'āsh-pazi kardan', '215', 'آشپزی ', 'آشپزی کرد', 'آشپزی کن', 'آشپزی کرده ', 'آشپزی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('287', 'آشنا شدن', 'āshnā shodan', '178', 'آشنا ', 'آشنا شد', 'آشنا شو', 'آشنا شده ', 'آشنا شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('288', 'آغاز شدن', 'āghāz shodan', '178', 'آغاز ', 'آغاز شد', 'آغاز شو', 'آغاز شده ', 'آغاز شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('289', 'آغاز کردن', 'āghāz kardan', '215', 'آغاز ', 'آغاز کرد', 'آغاز کن', 'آغاز کرده ', 'آغاز کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('290', 'آغشته شدن', 'āghashte shodan', '178', 'آغشته ', 'آغشته شد', 'آغشته شو', 'آغشته شده ', 'آغشته شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('291', 'آغشته کردن', 'āghashte kardan', '215', 'آغشته ', 'آغشته کرد', 'آغشته کن', 'آغشته کرده ', 'آغشته کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('292', 'آکنده کردن', 'ākande kardan', '215', 'آکنده ', 'آکنده کرد', 'آکنده کن', 'آکنده کرده ', 'آکنده کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('293', 'آگاه بودن', 'āgāh budan', '55', 'آگاه ', 'آگاه بود', 'آگاه باش', 'آگاه بوده ', 'آگاه بوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('294', 'آلوده کردن', 'ālude kardan', '215', 'آلوده ', 'آلوده کرد', 'آلوده کن', 'آلوده کرده ', 'آلوده کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('295', 'آواز خواندن', 'āvāz khāndan', '120', 'آواز ', 'آواز خواند', 'آواز خوان', 'آواز خوانده ', 'آواز خوانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('296', 'آواز خوندن', 'āvāz khundan', '121', 'آواز ', 'آواز خوند', 'آواز خون', 'آواز خونده ', 'آواز خونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('297', 'آینه کردن', 'āyne kardan', '215', 'آینه ', 'آینه کرد', 'آینه کن', 'آینه کرده ', 'آینه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('298', 'اجازه خواستن', 'ejāze khāstan', '119', 'اجازه ', 'اجازه خواست', 'اجازه خواه', 'اجازه خواسته ', 'اجازه خواسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('299', 'اجازه دادن', 'ejāze dādan', '123', 'اجازه ', 'اجازه داد', 'اجازه ده', 'اجازه داده ', 'اجازه داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('300', 'اجرا کردن', 'ejrā kardan', '215', 'اجرا ', 'اجرا کرد', 'اجرا کن', 'اجرا کرده ', 'اجرا کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('301', 'احتیاج داشتن', 'ehtiāj dāshtan', '124', 'احتیاج ', 'احتیاج داشت', 'احتیاج دار', 'احتیاج داشته ', 'احتیاج داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('302', 'احوال گرفتن', 'ahvāl gereftan', '228', 'احوال ', 'احوال گرفت', 'احوال گیر', 'احوال گرفته ', 'احوال گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('303', 'احوال پرسی کردن', 'ahvāl-porsi kardan', '215', 'احوال پرسی ', 'احوال پرسی کرد', 'احوال پرسی کن', 'احوال پرسی کرده ', 'احوال پرسی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('304', 'اختلاط کردن', 'ekhtelāt kardan', '215', 'اختلاط ', 'اختلاط کرد', 'اختلاط کن', 'اختلاط کرده ', 'اختلاط کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('305', 'ادامه دادن', 'edāme dādan', '123', 'ادامه ', 'ادامه داد', 'ادامه ده', 'ادامه داده ', 'ادامه داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('306', 'ادرار کردن', 'edrār kardan', '215', 'ادرار ', 'ادرار کرد', 'ادرار کن', 'ادرار کرده ', 'ادرار کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('307', 'ادعا کردن', 'edde`ā kardan', '215', 'ادعا ', 'ادعا کرد', 'ادعا کن', 'ادعا کرده ', 'ادعا کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('308', 'اذیت کردن', 'aziyyat kardan', '215', 'اذیت ', 'اذیت کرد', 'اذیت کن', 'اذیت کرده ', 'اذیت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('309', 'اذیت کردن', 'aziyat kardan', '215', 'اذیت ', 'اذیت کرد', 'اذیت کن', 'اذیت کرده ', 'اذیت کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('310', 'ارتباط دادن', 'ertebāt dādan', '123', 'ارتباط ', 'ارتباط داد', 'ارتباط ده', 'ارتباط داده ', 'ارتباط داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('311', 'از بر خواندن', 'az bar khāndan', '120', 'از بر ', 'از بر خواند', 'از بر خوان', 'از بر خوانده ', 'از بر خوانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('312', 'از بر خوندن', 'az bar khundan', '121', 'از بر ', 'از بر خوند', 'از بر خون', 'از بر خونده ', 'از بر خونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('313', 'از پا افتادن', 'az pā oftādan', '24', 'از پا ', 'از پا افتاد', 'از پا افت', 'از پا افتاده ', 'از پا افتاده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('314', 'از حرکت افتادن', 'az harakat oftādan', '24', 'از حرکت ', 'از حرکت افتاد', 'از حرکت افت', 'از حرکت افتاده ', 'از حرکت افتاده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('315', 'از حرکت افتادن', 'az harekat oftādan', '24', 'از حرکت ', 'از حرکت افتاد', 'از حرکت افت', 'از حرکت افتاده ', 'از حرکت افتاده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('316', 'از خاطر بردن', 'az khāter bordan', '52', 'از خاطر ', 'از خاطر برد', 'از خاطر بر', 'از خاطر برده ', 'از خاطر برده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('317', 'از دست دادن', 'az dast dādan', '123', 'از دست ', 'از دست داد', 'از دست ده', 'از دست داده ', 'از دست داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('318', 'از دست رفتن', 'az dast raftan', '149', 'از دست ', 'از دست رفت', 'از دست رو', 'از دست رفته ', 'از دست رفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('319', 'از قلم انداختن', 'az qalam andākhtan', '34', 'از قلم ', 'از قلم انداخت', 'از قلم انداز', 'از قلم انداخته ', 'از قلم انداخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('320', 'از قلم انداختن', 'az ghalam andākhtan', '34', 'از قلم ', 'از قلم انداخت', 'از قلم انداز', 'از قلم انداخته ', 'از قلم انداخته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('321', 'از مد افتادن', 'az mod oftādan', '24', 'از مد ', 'از مد افتاد', 'از مد افت', 'از مد افتاده ', 'از مد افتاده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('322', 'از یاد بردن', 'az yād bordan', '52', 'از یاد ', 'از یاد برد', 'از یاد بر', 'از یاد برده ', 'از یاد برده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('323', 'ازدواج کردن', 'ezdevāj kardan', '215', 'ازدواج ', 'ازدواج کرد', 'ازدواج کن', 'ازدواج کرده ', 'ازدواج کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('324', 'استراحت کردن', 'esterāhat kardan', '215', 'استراحت ', 'استراحت کرد', 'استراحت کن', 'استراحت کرده ', 'استراحت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('325', 'اسیر شدن', 'asir shodan', '178', 'اسیر ', 'اسیر شد', 'اسیر شو', 'اسیر شده ', 'اسیر شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('326', 'اسیر کردن', 'asir kardan', '215', 'اسیر ', 'اسیر کرد', 'اسیر کن', 'اسیر کرده ', 'اسیر کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('327', 'اشتباه در آمدن', 'eshtebāh dar āmadan', '15', 'اشتباه در ', 'اشتباه در آمد', 'اشتباه در آ', 'اشتباه در آمده ', 'اشتباه در آمده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('328', 'اشتباه در اومدن', 'eshtebāh dar umadan', '16', 'اشتباه در ', 'اشتباه در اومد', 'اشتباه در یا', 'اشتباه در اومده ', 'اشتباه در اومده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('329', 'اشتباه کردن', 'eshtebāh kardan', '215', 'اشتباه ', 'اشتباه کرد', 'اشتباه کن', 'اشتباه کرده ', 'اشتباه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('330', 'اشکال زدایی کردن', 'eshkāl-zodāi kardan', '215', 'اشکال زدایی ', 'اشکال زدایی کرد', 'اشکال زدایی کن', 'اشکال زدایی کرده ', 'اشکال زدایی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('331', 'اصلاح کردن', 'eslāh kardan', '215', 'اصلاح ', 'اصلاح کرد', 'اصلاح کن', 'اصلاح کرده ', 'اصلاح کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('332', 'اصلا کردن', 'eslā kardan', '215', 'اصلا ', 'اصلا کرد', 'اصلا کن', 'اصلا کرده ', 'اصلا کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('333', 'اعطا کردن', '`etā kardan', '215', 'اعطا ', 'اعطا کرد', 'اعطا کن', 'اعطا کرده ', 'اعطا کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('334', 'اقامت داشتن', 'eqāmat dāshtan', '124', 'اقامت ', 'اقامت داشت', 'اقامت دار', 'اقامت داشته ', 'اقامت داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('335', 'اقامت داشتن', 'eghāmat dāshtan', '124', 'اقامت ', 'اقامت داشت', 'اقامت دار', 'اقامت داشته ', 'اقامت داشته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('336', 'اقامت کردن', 'eqāmat kardan', '215', 'اقامت ', 'اقامت کرد', 'اقامت کن', 'اقامت کرده ', 'اقامت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('337', 'اقامت کردن', 'eghāmat kardan', '215', 'اقامت ', 'اقامت کرد', 'اقامت کن', 'اقامت کرده ', 'اقامت کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('338', 'التماس کردن', 'eltemās kardan', '215', 'التماس ', 'التماس کرد', 'التماس کن', 'التماس کرده ', 'التماس کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('339', 'امتحان دادن', 'emtehān dādan', '123', 'امتحان ', 'امتحان داد', 'امتحان ده', 'امتحان داده ', 'امتحان داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('340', 'امتحان کردن', 'emtehān kardan', '215', 'امتحان ', 'امتحان کرد', 'امتحان کن', 'امتحان کرده ', 'امتحان کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('341', 'امتحان گرفتن', 'emtehān gereftan', '228', 'امتحان ', 'امتحان گرفت', 'امتحان گیر', 'امتحان گرفته ', 'امتحان گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('342', 'امید بستن', 'ommid bastan', '54', 'امید ', 'امید بست', 'امید بند', 'امید بسته ', 'امید بسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('343', 'امید بستن', 'omid bastan', '54', 'امید ', 'امید بست', 'امید بند', 'امید بسته ', 'امید بسته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('344', 'انتخاب کردن', 'entekhāb kardan', '215', 'انتخاب ', 'انتخاب کرد', 'انتخاب کن', 'انتخاب کرده ', 'انتخاب کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('345', 'انتقال دادن', 'enteqāl dādan', '123', 'انتقال ', 'انتقال داد', 'انتقال ده', 'انتقال داده ', 'انتقال داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('346', 'انتقال دادن', 'enteghāl dādan', '123', 'انتقال ', 'انتقال داد', 'انتقال ده', 'انتقال داده ', 'انتقال داده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('347', 'انتقام گرفتن', 'enteqām gereftan', '228', 'انتقام ', 'انتقام گرفت', 'انتقام گیر', 'انتقام گرفته ', 'انتقام گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('348', 'انتقام گرفتن', 'enteghām gereftan', '228', 'انتقام ', 'انتقام گرفت', 'انتقام گیر', 'انتقام گرفته ', 'انتقام گرفته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('349', 'انجام دادن', 'anjām dādan', '123', 'انجام ', 'انجام داد', 'انجام ده', 'انجام داده ', 'انجام داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('350', 'اندازه گرفتن', 'andāze gereftan', '228', 'اندازه ', 'اندازه گرفت', 'اندازه گیر', 'اندازه گرفته ', 'اندازه گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('351', 'باز ایستادن', 'bāz istādan', '40', 'باز ', 'باز ایستاد', 'باز ایست', 'باز ایستاده ', 'باز ایستاده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('352', 'وایستادن', 'vāystādan', null, '', 'وایستاد', '', 'وایستاده ', 'وایستاده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('353', 'باز داشتن', 'bāz dāshtan', '124', 'باز ', 'باز داشت', 'باز دار', 'باز داشته ', 'باز داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('354', 'باز شدن', 'bāz shodan', '178', 'باز ', 'باز شد', 'باز شو', 'باز شده ', 'باز شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('355', 'باز کردن', 'bāz kardan', '215', 'باز ', 'باز کرد', 'باز کن', 'باز کرده ', 'باز کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('356', 'وا کردن', 'vā kardan', '215', 'وا ', 'وا کرد', 'وا کن', 'وا کرده ', 'وا کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('357', 'باز گرداندن', 'bāz gardāndan', '226', 'باز ', 'باز گرداند', 'باز گردان', 'باز گردانده ', 'باز گردانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('358', 'باز گردوندن', 'bāz gardundan', '227', 'باز ', 'باز گردوند', 'باز گردون', 'باز گردونده ', 'باز گردونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('359', 'بازپرداخت کردن', 'bāz-pardākht kardan', '215', 'بازپرداخت ', 'بازپرداخت کرد', 'بازپرداخت کن', 'بازپرداخت کرده ', 'بازپرداخت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('360', 'بازی کردن', 'bāzi kardan', '215', 'بازی ', 'بازی کرد', 'بازی کن', 'بازی کرده ', 'بازی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('361', 'بازیابی کردن', 'bāz-yābi kardan', '215', 'بازیابی ', 'بازیابی کرد', 'بازیابی کن', 'بازیابی کرده ', 'بازیابی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('362', 'بالا بردن', 'bālā bordan', '52', 'بالا ', 'بالا برد', 'بالا بر', 'بالا برده ', 'بالا برده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('363', 'بایگانی کردن', 'bāygāni kardan', '215', 'بایگانی ', 'بایگانی کرد', 'بایگانی کن', 'بایگانی کرده ', 'بایگانی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('364', 'بحث کردن', 'bahs kardan', '215', 'بحث ', 'بحث کرد', 'بحث کن', 'بحث کرده ', 'بحث کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('365', 'بدگویی کردن', 'bad-gui kardan', '215', 'بدگویی ', 'بدگویی کرد', 'بدگویی کن', 'بدگویی کرده ', 'بدگویی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('366', 'بر آشفتن', 'bar āshoftan', '7', 'بر ', 'بر آشفت', 'بر آشوب', 'بر آشفته ', 'بر آشفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('367', 'بر پا شدن', 'bar pā shodan', '178', 'بر پا ', 'بر پا شد', 'بر پا شو', 'بر پا شده ', 'بر پا شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('368', 'بر پا کردن', 'bar pā kardan', '215', 'بر پا ', 'بر پا کرد', 'بر پا کن', 'بر پا کرده ', 'بر پا کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('369', 'بر چیدن', 'bar chidan', '105', 'بر ', 'بر چید', 'بر چین', 'بر چیده ', 'بر چیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('370', 'بر خاستن', 'bar khāstan', '109', 'بر ', 'بر خاست', 'بر خیز', 'بر خاسته ', 'بر خاسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('371', 'بر داشتن', 'bar dāshtan', '124', 'بر ', 'بر داشت', 'بر دار', 'بر داشته ', 'بر داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('372', 'بر شمردن', 'bar shomordan', '190', 'بر ', 'بر شمرد', 'بر شمر', 'بر شمرده ', 'بر شمرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('373', 'بر طرف کردن', 'bar taraf kardan', '215', 'بر طرف ', 'بر طرف کرد', 'بر طرف کن', 'بر طرف کرده ', 'بر طرف کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('374', 'بر عهده گرفتن', 'bar `ohde gereftan', '228', 'بر عهده ', 'بر عهده گرفت', 'بر عهده گیر', 'بر عهده گرفته ', 'بر عهده گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('375', 'بر عهده گرفتن', 'bar ohde gereftan', '228', 'بر عهده ', 'بر عهده گرفت', 'بر عهده گیر', 'بر عهده گرفته ', 'بر عهده گرفته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('376', 'بر قرار شدن', 'bar qarār shodan', '178', 'بر قرار ', 'بر قرار شد', 'بر قرار شو', 'بر قرار شده ', 'بر قرار شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('377', 'بر قرار شدن', 'bar gharār shodan', '178', 'بر قرار ', 'بر قرار شد', 'بر قرار شو', 'بر قرار شده ', 'بر قرار شده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('378', 'بر قرار کردن', 'bar qarār kardan', '215', 'بر قرار ', 'بر قرار کرد', 'بر قرار کن', 'بر قرار کرده ', 'بر قرار کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('379', 'بر قرار کردن', 'bar gharār kardan', '215', 'بر قرار ', 'بر قرار کرد', 'بر قرار کن', 'بر قرار کرده ', 'بر قرار کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('380', 'بر گذار کردن', 'bar gozār kardan', '215', 'بر گذار ', 'بر گذار کرد', 'بر گذار کن', 'بر گذار کرده ', 'بر گذار کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('381', 'بر گزار کردن', 'bar gozār kardan', '215', 'بر گزار ', 'بر گزار کرد', 'بر گزار کن', 'بر گزار کرده ', 'بر گزار کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('382', 'بر گرداندن', 'bar gardāndan', '226', 'بر ', 'بر گرداند', 'بر گردان', 'بر گردانده ', 'بر گردانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('383', 'بر گردوندن', 'bar gardundan', '227', 'بر ', 'بر گردوند', 'بر گردون', 'بر گردونده ', 'بر گردونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('384', 'بر گزار شدن', 'bar gozār shodan', '178', 'بر گزار ', 'بر گزار شد', 'بر گزار شو', 'بر گزار شده ', 'بر گزار شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('385', 'بر گزیدن', 'bar gozidan', '232', 'بر ', 'بر گزید', 'بر گزین', 'بر گزیده ', 'بر گزیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('386', 'بر گشتن', 'bar gashtan', '238', 'بر ', 'بر گشت', 'بر گرد', 'بر گشته ', 'بر گشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('387', 'بررسی کردن', 'bar-rasi kardan', '215', 'بررسی ', 'بررسی کرد', 'بررسی کن', 'بررسی کرده ', 'بررسی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('388', 'بررسی کردن', 'bar-resi kardan', '215', 'بررسی ', 'بررسی کرد', 'بررسی کن', 'بررسی کرده ', 'بررسی کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('389', 'برش دادن', 'boresh dādan', '123', 'برش ', 'برش داد', 'برش ده', 'برش داده ', 'برش داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('390', 'برشته کردن', 'bereshte kardan', '215', 'برشته ', 'برشته کرد', 'برشته کن', 'برشته کرده ', 'برشته کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('391', 'بروز کردن', 'boruz kardan', '215', 'بروز ', 'بروز کرد', 'بروز کن', 'بروز کرده ', 'بروز کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('392', 'بزرگ شدن', 'bozorg shodan', '178', 'بزرگ ', 'بزرگ شد', 'بزرگ شو', 'بزرگ شده ', 'بزرگ شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('393', 'بزور گرفتن', 'be-zur gereftan', '228', 'بزور ', 'بزور گرفت', 'بزور گیر', 'بزور گرفته ', 'بزور گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('394', 'بس کردن', 'bas kardan', '215', 'بس ', 'بس کرد', 'بس کن', 'بس کرده ', 'بس کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('395', 'بستری شدن', 'bastari shodan', '178', 'بستری ', 'بستری شد', 'بستری شو', 'بستری شده ', 'بستری شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('396', 'بسته بندی کردن', 'baste-bandi kardan', '215', 'بسته بندی ', 'بسته بندی کرد', 'بسته بندی کن', 'بسته بندی کرده ', 'بسته بندی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('397', 'بکار زور آوردن', 'be-kār zur āvardan', '19', 'بکار زور ', 'بکار زور آورد', 'بکار زور آور', 'بکار زور آورده ', 'بکار زور آورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('398', 'بکار زور آوردن', 'be-kār zur āvordan', '20', 'بکار زور ', 'بکار زور آورد', 'بکار زور آور', 'بکار زور آورده ', 'بکار زور آورده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('399', 'بکس بازی کردن', 'boks-bāzi kardan', '215', 'بکس بازی ', 'بکس بازی کرد', 'بکس بازی کن', 'بکس بازی کرده ', 'بکس بازی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('400', 'بگومگو کردن', 'begu-magu kardan', '215', 'بگومگو ', 'بگومگو کرد', 'بگومگو کن', 'بگومگو کرده ', 'بگومگو کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('401', 'بلد بودن', 'balad budan', '55', 'بلد ', 'بلد بود', 'بلد باش', 'بلد بوده ', 'بلد بوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('402', 'بلند شدن', 'boland shodan', '178', 'بلند ', 'بلند شد', 'بلند شو', 'بلند شده ', 'بلند شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('403', 'بلن شدن', 'bolan shodan', '178', 'بلن ', 'بلن شد', 'بلن شو', 'بلن شده ', 'بلن شده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('404', 'بلند کردن', 'boland kardan', '215', 'بلند ', 'بلند کرد', 'بلند کن', 'بلند کرده ', 'بلند کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('405', 'بلند و کوتاه کردن', 'boland-o kutāh kardan', '215', 'بلند و کوتاه ', 'بلند و کوتاه کرد', 'بلند و کوتاه کن', 'بلند و کوتاه کرده ', 'بلند و کوتاه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('406', 'به انجام رساندن', 'be anjām resāndan', '142', 'به انجام ', 'به انجام رساند', 'به انجام رسان', 'به انجام رسانده ', 'به انجام رسانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('407', 'به انجام رسوندن', 'be anjām resundan', '143', 'به انجام ', 'به انجام رسوند', 'به انجام رسون', 'به انجام رسونده ', 'به انجام رسونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('408', 'به انجام رسیدن', 'be anjām residan', '146', 'به انجام ', 'به انجام رسید', 'به انجام رس', 'به انجام رسیده ', 'به انجام رسیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('409', 'به برق زدن', 'be barq zadan', '154', 'به برق ', 'به برق زد', 'به برق زن', 'به برق زده ', 'به برق زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('410', 'به برق زدن', 'be bargh zadan', '154', 'به برق ', 'به برق زد', 'به برق زن', 'به برق زده ', 'به برق زده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('411', 'به برق وصل کردن', 'be barq vasl kardan', '215', 'به برق وصل ', 'به برق وصل کرد', 'به برق وصل کن', 'به برق وصل کرده ', 'به برق وصل کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('412', 'به برق وصل کردن', 'be bargh vasl kardan', '215', 'به برق وصل ', 'به برق وصل کرد', 'به برق وصل کن', 'به برق وصل کرده ', 'به برق وصل کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('413', 'به پایان رسیدن', 'be pāyān residan', '146', 'به پایان ', 'به پایان رسید', 'به پایان رس', 'به پایان رسیده ', 'به پایان رسیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('414', 'به پریز زدن', 'be periz zadan', '154', 'به پریز ', 'به پریز زد', 'به پریز زن', 'به پریز زده ', 'به پریز زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('415', 'به چنگ آوردن', 'be chang āvardan', '19', 'به چنگ ', 'به چنگ آورد', 'به چنگ آور', 'به چنگ آورده ', 'به چنگ آورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('416', 'به چنگ آوردن', 'be chang āvordan', '20', 'به چنگ ', 'به چنگ آورد', 'به چنگ آور', 'به چنگ آورده ', 'به چنگ آورده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('417', 'به حرکت در آوردن', 'be harakat dar āvardan', '19', 'به حرکت در ', 'به حرکت در آورد', 'به حرکت در آور', 'به حرکت در آورده ', 'به حرکت در آورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('418', 'به خاطر سپردن', 'be khāter sepordan', '161', 'به خاطر ', 'به خاطر سپرد', 'به خاطر سپر', 'به خاطر سپرده ', 'به خاطر سپرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('419', 'به خرج دادن', 'be kharj dādan', '123', 'به خرج ', 'به خرج داد', 'به خرج ده', 'به خرج داده ', 'به خرج داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('420', 'به درد آوردن', 'be dard āvardan', '19', 'به درد ', 'به درد آورد', 'به درد آور', 'به درد آورده ', 'به درد آورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('421', 'آوردن', 'vordan', null, '', 'آورد', 'آور', 'آورده ', 'آورده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('422', 'به درد آوردن', 'āvordan', '421', 'به درد ', 'به درد آورد', 'به درد آور', 'به درد آورده ', 'به درد آورده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('423', 'به درد خوردن', 'be dard khordan', '122', 'به درد ', 'به درد خورد', 'به درد خور', 'به درد خورده ', 'به درد خورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('424', 'به دست آوردن', 'be dast āvardan', '19', 'به دست ', 'به دست آورد', 'به دست آور', 'به دست آورده ', 'به دست آورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('425', 'به دست آوردن', 'be dast āvordan', '20', 'به دست ', 'به دست آورد', 'به دست آور', 'به دست آورده ', 'به دست آورده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('426', 'به دنیا آمدن', 'be donyā āmadan', '15', 'به دنیا ', 'به دنیا آمد', 'به دنیا آ', 'به دنیا آمده ', 'به دنیا آمده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('427', 'به دنیا اومدن', 'be donyā umadan', '16', 'به دنیا ', 'به دنیا اومد', 'به دنیا یا', 'به دنیا اومده ', 'به دنیا اومده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('428', 'به زبان آوردن', 'be zabān āvardan', '19', 'به زبان ', 'به زبان آورد', 'به زبان آور', 'به زبان آورده ', 'به زبان آورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('429', 'به زبان آوردن', 'be zabān āvordan', '20', 'به زبان ', 'به زبان آورد', 'به زبان آور', 'به زبان آورده ', 'به زبان آورده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('430', 'به سزا رساندن', 'be sazā resāndan', '142', 'به سزا ', 'به سزا رساند', 'به سزا رسان', 'به سزا رسانده ', 'به سزا رسانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('431', 'به سزا رسوندن', 'be sazā resundan', '143', 'به سزا ', 'به سزا رسوند', 'به سزا رسون', 'به سزا رسونده ', 'به سزا رسونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('432', 'به سزا رسیدن', 'be sazā residan', '146', 'به سزا ', 'به سزا رسید', 'به سزا رس', 'به سزا رسیده ', 'به سزا رسیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('433', 'به سفر رفتن', 'be safar raftan', '149', 'به سفر ', 'به سفر رفت', 'به سفر رو', 'به سفر رفته ', 'به سفر رفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('434', 'به صف ایستادن', 'be saff istādan', '40', 'به صف ', 'به صف ایستاد', 'به صف ایست', 'به صف ایستاده ', 'به صف ایستاده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('435', 'به صف ایستادن', 'be saf istādan', '40', 'به صف ', 'به صف ایستاد', 'به صف ایست', 'به صف ایستاده ', 'به صف ایستاده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('436', 'به طول انجامیدن', 'be tul anjāmidan', '33', 'به طول ', 'به طول انجامید', 'به طول انجام', 'به طول انجامیده ', 'به طول انجامیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('437', 'به عمل آوردن', 'be `amal āvardan', '19', 'به عمل ', 'به عمل آورد', 'به عمل آور', 'به عمل آورده ', 'به عمل آورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('438', 'به عمل آوردن', 'be amal āvordan', '20', 'به عمل ', 'به عمل آورد', 'به عمل آور', 'به عمل آورده ', 'به عمل آورده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('439', 'به عهده گرفتن', 'be `ohde gereftan', '228', 'به عهده ', 'به عهده گرفت', 'به عهده گیر', 'به عهده گرفته ', 'به عهده گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('440', 'به عهده گرفتن', 'be ohde gereftan', '228', 'به عهده ', 'به عهده گرفت', 'به عهده گیر', 'به عهده گرفته ', 'به عهده گرفته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('441', 'به فراموشی سپردن', 'be farāmushi sepordan', '161', 'به فراموشی ', 'به فراموشی سپرد', 'به فراموشی سپر', 'به فراموشی سپرده ', 'به فراموشی سپرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('442', 'به فروشگاه رفتن', 'be forush-gāh raftan', '149', 'به فروشگاه ', 'به فروشگاه رفت', 'به فروشگاه رو', 'به فروشگاه رفته ', 'به فروشگاه رفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('443', 'به فلک بستن', 'be falak bastan', '54', 'به فلک ', 'به فلک بست', 'به فلک بند', 'به فلک بسته ', 'به فلک بسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('444', 'به قتل رساندن', 'be qatl resāndan', '142', 'به قتل ', 'به قتل رساند', 'به قتل رسان', 'به قتل رسانده ', 'به قتل رسانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('445', 'به کسی یا چیزی عاشق شدن', 'be kasi yā chizi `āsheq shodan', '178', 'به کسی یا چیزی عاشق ', 'به کسی یا چیزی عاشق شد', 'به کسی یا چیزی عاشق شو', 'به کسی یا چیزی عاشق شده ', 'به کسی یا چیزی عاشق شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('446', 'به کسی یا چیزی شدن', 'be kasi yā chizi āshegh shodan', '178', 'به کسی یا چیزی ', 'به کسی یا چیزی شد', 'به کسی یا چیزی شو', 'به کسی یا چیزی شده ', 'به کسی یا چیزی شده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('447', 'به کیفر رساندن', 'be kayfar resāndan', '142', 'به کیفر ', 'به کیفر رساند', 'به کیفر رسان', 'به کیفر رسانده ', 'به کیفر رسانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('448', 'به کیفر رسوندن', 'be keifar resundan', '143', 'به کیفر ', 'به کیفر رسوند', 'به کیفر رسون', 'به کیفر رسونده ', 'به کیفر رسونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('449', 'به کیفر رسیدن', 'be kayfar residan', '146', 'به کیفر ', 'به کیفر رسید', 'به کیفر رس', 'به کیفر رسیده ', 'به کیفر رسیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('450', 'به کیفر رسیدن', 'be keifar residan', '146', 'به کیفر ', 'به کیفر رسید', 'به کیفر رس', 'به کیفر رسیده ', 'به کیفر رسیده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('451', 'به وجود آمدن', 'be vojud āmadan', '15', 'به وجود ', 'به وجود آمد', 'به وجود آ', 'به وجود آمده ', 'به وجود آمده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('452', 'به وجود اومدن', 'be vojud umadan', '16', 'به وجود ', 'به وجود اومد', 'به وجود یا', 'به وجود اومده ', 'به وجود اومده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('453', 'به وجود آوردن', 'be vojud āvardan', '19', 'به وجود ', 'به وجود آورد', 'به وجود آور', 'به وجود آورده ', 'به وجود آورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('454', 'به وجود آوردن', 'be vojud āvordan', '20', 'به وجود ', 'به وجود آورد', 'به وجود آور', 'به وجود آورده ', 'به وجود آورده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('455', 'به هدر دادن', 'be hadar dādan', '123', 'به هدر ', 'به هدر داد', 'به هدر ده', 'به هدر داده ', 'به هدر داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('456', 'به هدر رفتن', 'be hadar raftan', '149', 'به هدر ', 'به هدر رفت', 'به هدر رو', 'به هدر رفته ', 'به هدر رفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('457', 'به هوش آوردن', 'be hush āvardan', '19', 'به هوش ', 'به هوش آورد', 'به هوش آور', 'به هوش آورده ', 'به هوش آورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('458', 'به هوش آوردن', 'be hush āvordan', '20', 'به هوش ', 'به هوش آورد', 'به هوش آور', 'به هوش آورده ', 'به هوش آورده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('459', 'به هیجان آمدن', 'be hayajān āmadan', '15', 'به هیجان ', 'به هیجان آمد', 'به هیجان آ', 'به هیجان آمده ', 'به هیجان آمده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('460', 'به هیجان اومدن', 'be hayejān umadan', '16', 'به هیجان ', 'به هیجان اومد', 'به هیجان یا', 'به هیجان اومده ', 'به هیجان اومده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('461', 'به هیجان آوردن', 'be hayajān āvardan', '19', 'به هیجان ', 'به هیجان آورد', 'به هیجان آور', 'به هیجان آورده ', 'به هیجان آورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('462', 'به هیجان آوردن', 'be hayejān āvordan', '20', 'به هیجان ', 'به هیجان آورد', 'به هیجان آور', 'به هیجان آورده ', 'به هیجان آورده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('463', 'به هیجان انداختن', 'be hayajān andākhtan', '34', 'به هیجان ', 'به هیجان انداخت', 'به هیجان انداز', 'به هیجان انداخته ', 'به هیجان انداخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('464', 'به هیجان انداختن', 'be hayejān andākhtan', '34', 'به هیجان ', 'به هیجان انداخت', 'به هیجان انداز', 'به هیجان انداخته ', 'به هیجان انداخته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('465', 'به هیجان در آمدن', 'be hayajān dar āmadan', '15', 'به هیجان در ', 'به هیجان در آمد', 'به هیجان در آ', 'به هیجان در آمده ', 'به هیجان در آمده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('466', 'به هیجان در اومدن', 'be hayejān dar umadan', '16', 'به هیجان در ', 'به هیجان در اومد', 'به هیجان در یا', 'به هیجان در اومده ', 'به هیجان در اومده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('467', 'به یاد آوردن', 'be yād āvardan', '19', 'به یاد ', 'به یاد آورد', 'به یاد آور', 'به یاد آورده ', 'به یاد آورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('468', 'به یاد آوردن', 'be yād āvordan', '20', 'به یاد ', 'به یاد آورد', 'به یاد آور', 'به یاد آورده ', 'به یاد آورده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('469', 'به سر بردن', 'be-sar bordan', '52', 'به سر ', 'به سر برد', 'به سر بر', 'به سر برده ', 'به سر برده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('470', 'به کار بردن', 'be-kār bordan', '52', 'به کار ', 'به کار برد', 'به کار بر', 'به کار برده ', 'به کار برده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('471', 'به هم خوردن', 'be-ham khordan', '122', 'به هم ', 'به هم خورد', 'به هم خور', 'به هم خورده ', 'به هم خورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('472', 'به هم ریختن', 'be-ham rikhtan', '151', 'به هم ', 'به هم ریخت', 'به هم ریز', 'به هم ریخته ', 'به هم ریخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('473', 'به هم زدن', 'be-ham zadan', '154', 'به هم ', 'به هم زد', 'به هم زن', 'به هم زده ', 'به هم زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('474', 'بیان کردن', 'bayān kardan', '215', 'بیان ', 'بیان کرد', 'بیان کن', 'بیان کرده ', 'بیان کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('475', 'بی باکی نشان دادن', 'bi-bāki neshān dādan', '123', 'بی باکی نشان ', 'بی باکی نشان داد', 'بی باکی نشان ده', 'بی باکی نشان داده ', 'بی باکی نشان داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('476', 'بی باکی نشون دادن', 'bi-bāki neshun dādan', '123', 'بی باکی نشون ', 'بی باکی نشون داد', 'بی باکی نشون ده', 'بی باکی نشون داده ', 'بی باکی نشون داده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('477', 'بیدار شدن', 'bidār shodan', '178', 'بیدار ', 'بیدار شد', 'بیدار شو', 'بیدار شده ', 'بیدار شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('478', 'بیدار کردن', 'bidār kardan', '215', 'بیدار ', 'بیدار کرد', 'بیدار کن', 'بیدار کرده ', 'بیدار کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('479', 'بیرون پریدن', 'birun paridan', '66', 'بیرون ', 'بیرون پرید', 'بیرون پر', 'بیرون پریده ', 'بیرون پریده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('480', 'بیمار بودن', 'bimār budan', '55', 'بیمار ', 'بیمار بود', 'بیمار باش', 'بیمار بوده ', 'بیمار بوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('481', 'بیمار شدن', 'bimār shodan', '178', 'بیمار ', 'بیمار شد', 'بیمار شو', 'بیمار شده ', 'بیمار شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('482', 'بیمار کردن', 'bimār kardan', '215', 'بیمار ', 'بیمار کرد', 'بیمار کن', 'بیمار کرده ', 'بیمار کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('483', 'پا به جهان گذاشتن', 'pā be jahān gozāshtan', '224', 'پا به جهان ', 'پا به جهان گذاشت', 'پا به جهان گذار', 'پا به جهان گذاشته ', 'پا به جهان گذاشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('484', 'پا به دنیا گذشتن', 'pā be donyā gozashtan', '225', 'پا به دنیا ', 'پا به دنیا گذشت', 'پا به دنیا گذر', 'پا به دنیا گذشته ', 'پا به دنیا گذشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('485', 'پا به دنیا گذاشتن', 'pā be donyā gozāshtan', '224', 'پا به دنیا ', 'پا به دنیا گذاشت', 'پا به دنیا گذار', 'پا به دنیا گذاشته ', 'پا به دنیا گذاشته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('486', 'پا به سن گذاشتن', 'pā be senn gozāshtan', '224', 'پا به سن ', 'پا به سن گذاشت', 'پا به سن گذار', 'پا به سن گذاشته ', 'پا به سن گذاشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('487', 'پا به عرصهٔ وجود گذاشتن', 'pā be `arse-ye vojud gozāshtan', '224', 'پا به عرصهٔ وجود ', 'پا به عرصهٔ وجود گذاشت', 'پا به عرصهٔ وجود گذار', 'پا به عرصهٔ وجود گذاشته ', 'پا به عرصهٔ وجود گذاشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('488', 'پا به عرسهٔ وجود گذاشتن', 'pā be arse-ye vojud gozāshtan', '224', 'پا به عرسهٔ وجود ', 'پا به عرسهٔ وجود گذاشت', 'پا به عرسهٔ وجود گذار', 'پا به عرسهٔ وجود گذاشته ', 'پا به عرسهٔ وجود گذاشته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('489', 'پا در میان گذاشتن', 'pā dar miān gozāshtan', '224', 'پا در میان ', 'پا در میان گذاشت', 'پا در میان گذار', 'پا در میان گذاشته ', 'پا در میان گذاشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('490', 'پا در میون گذاشتن', 'pā dar miun gozāshtan', '224', 'پا در میون ', 'پا در میون گذاشت', 'پا در میون گذار', 'پا در میون گذاشته ', 'پا در میون گذاشته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('491', 'پا در میانی کردن', 'pā dar miāni kardan', '215', 'پا در میانی ', 'پا در میانی کرد', 'پا در میانی کن', 'پا در میانی کرده ', 'پا در میانی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('492', 'پا در میونی کردن', 'pā dar miuni kardan', '215', 'پا در میونی ', 'پا در میونی کرد', 'پا در میونی کن', 'پا در میونی کرده ', 'پا در میونی کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('493', 'پاره شدن', 'pāre shodan', '178', 'پاره ', 'پاره شد', 'پاره شو', 'پاره شده ', 'پاره شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('494', 'پاره کردن', 'pāre kardan', '215', 'پاره ', 'پاره کرد', 'پاره کن', 'پاره کرده ', 'پاره کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('495', 'پاس دادن', 'pās dādan', '123', 'پاس ', 'پاس داد', 'پاس ده', 'پاس داده ', 'پاس داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('496', 'پاسخ دادن', 'pāsokh dādan', '123', 'پاسخ ', 'پاسخ داد', 'پاسخ ده', 'پاسخ داده ', 'پاسخ داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('497', 'پاک کردن', 'pāk kardan', '215', 'پاک ', 'پاک کرد', 'پاک کن', 'پاک کرده ', 'پاک کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('498', 'پانچ کردن', 'pānch kardan', '215', 'پانچ ', 'پانچ کرد', 'پانچ کن', 'پانچ کرده ', 'پانچ کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('499', 'پای مردی کردن', 'pāy-mardi kardan', '215', 'پای مردی ', 'پای مردی کرد', 'پای مردی کن', 'پای مردی کرده ', 'پای مردی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('500', 'پایین آوردن', 'pāin āvardan', '19', 'پایین ', 'پایین آورد', 'پایین آور', 'پایین آورده ', 'پایین آورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('501', 'پایین آوردن', 'pāin āvordan', '20', 'پایین ', 'پایین آورد', 'پایین آور', 'پایین آورده ', 'پایین آورده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('502', 'پخت و پز کردن', 'pokht-o paz kardan', '215', 'پخت و پز ', 'پخت و پز کرد', 'پخت و پز کن', 'پخت و پز کرده ', 'پخت و پز کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('503', 'پر کردن', 'por kardan', '215', 'پر ', 'پر کرد', 'پر کن', 'پر کرده ', 'پر کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('504', 'پردازش کردن', 'pardāzesh kardan', '215', 'پردازش ', 'پردازش کرد', 'پردازش کن', 'پردازش کرده ', 'پردازش کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('505', 'پرسش کردن', 'porsesh kardan', '215', 'پرسش ', 'پرسش کرد', 'پرسش کن', 'پرسش کرده ', 'پرسش کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('506', 'پروانه گرفتن', 'parvāne gereftan', '228', 'پروانه ', 'پروانه گرفت', 'پروانه گیر', 'پروانه گرفته ', 'پروانه گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('507', 'پرونده تشکیل دادن', 'parvande tashkil dādan', '123', 'پرونده تشکیل ', 'پرونده تشکیل داد', 'پرونده تشکیل ده', 'پرونده تشکیل داده ', 'پرونده تشکیل داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('508', 'پرونده ساختن', 'parvande sākhtan', '159', 'پرونده ', 'پرونده ساخت', 'پرونده ساز', 'پرونده ساخته ', 'پرونده ساخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('509', 'پرونده سازی کردن', 'parvande-sāzi kardan', '215', 'پرونده سازی ', 'پرونده سازی کرد', 'پرونده سازی کن', 'پرونده سازی کرده ', 'پرونده سازی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('510', 'پریشان شدن', 'parishān shodan', '178', 'پریشان ', 'پریشان شد', 'پریشان شو', 'پریشان شده ', 'پریشان شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('511', 'پریشان کردن', 'parishān kardan', '215', 'پریشان ', 'پریشان کرد', 'پریشان کن', 'پریشان کرده ', 'پریشان کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('512', 'پژوهش کردن', 'pezhuhesh kardan', '215', 'پژوهش ', 'پژوهش کرد', 'پژوهش کن', 'پژوهش کرده ', 'پژوهش کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('513', 'پژوهش کردن', 'pazhuhesh kardan', '215', 'پژوهش ', 'پژوهش کرد', 'پژوهش کن', 'پژوهش کرده ', 'پژوهش کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('514', 'پس دادن', 'pas dādan', '123', 'پس ', 'پس داد', 'پس ده', 'پس داده ', 'پس داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('515', 'پس گرفتن', 'pas gereftan', '228', 'پس ', 'پس گرفت', 'پس گیر', 'پس گرفته ', 'پس گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('516', 'پست کردن', 'past kardan', '215', 'پست ', 'پست کرد', 'پست کن', 'پست کرده ', 'پست کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('517', 'پسند آمدن', 'pasand āmadan', '15', 'پسند ', 'پسند آمد', 'پسند آ', 'پسند آمده ', 'پسند آمده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('518', 'پسند افتادن', 'pasand oftādan', '24', 'پسند ', 'پسند افتاد', 'پسند افت', 'پسند افتاده ', 'پسند افتاده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('519', 'پسند کردن', 'pasand kardan', '215', 'پسند ', 'پسند کرد', 'پسند کن', 'پسند کرده ', 'پسند کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('520', 'پشت ِپا خوردن', 'posht-e pā khordan', '122', 'پشت ِپا ', 'پشت ِپا خورد', 'پشت ِپا خور', 'پشت ِپا خورده ', 'پشت ِپا خورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('521', 'پشت ِپا زدن', 'posht-e pā zadan', '154', 'پشت ِپا ', 'پشت ِپا زد', 'پشت ِپا زن', 'پشت ِپا زده ', 'پشت ِپا زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('522', 'پشت کار داشتن', 'posht-kār dāshtan', '124', 'پشت کار ', 'پشت کار داشت', 'پشت کار دار', 'پشت کار داشته ', 'پشت کار داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('523', 'پنبه زنی کردن', 'panbe-zani kardan', '215', 'پنبه زنی ', 'پنبه زنی کرد', 'پنبه زنی کن', 'پنبه زنی کرده ', 'پنبه زنی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('524', 'پنبه زنی کردن', 'pambe-zani kardan', '215', 'پنبه زنی ', 'پنبه زنی کرد', 'پنبه زنی کن', 'پنبه زنی کرده ', 'پنبه زنی کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('525', 'پوست کندن', 'pust kandan', '219', 'پوست ', 'پوست کند', 'پوست کن', 'پوست کنده ', 'پوست کنده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('526', 'پول چای دادن', 'pul-e chāy dādan', '123', 'پول چای ', 'پول چای داد', 'پول چای ده', 'پول چای داده ', 'پول چای داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('527', 'پول چایی دادن', 'pul-e chāi dādan', '123', 'پول چایی ', 'پول چایی داد', 'پول چایی ده', 'پول چایی داده ', 'پول چایی داده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('528', 'پول خرج کردن', 'pul kharj kardan', '215', 'پول خرج ', 'پول خرج کرد', 'پول خرج کن', 'پول خرج کرده ', 'پول خرج کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('529', 'پول خرد داشتن', 'pul-e khord dāshtan', '124', 'پول خرد ', 'پول خرد داشت', 'پول خرد دار', 'پول خرد داشته ', 'پول خرد داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('530', 'پول دادن', 'pul dādan', '123', 'پول ', 'پول داد', 'پول ده', 'پول داده ', 'پول داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('531', 'پول دور ریختن', 'pul dur rikhtan', '151', 'پول دور ', 'پول دور ریخت', 'پول دور ریز', 'پول دور ریخته ', 'پول دور ریخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('532', 'پول هدر دادن', 'pul hadar dādan', '123', 'پول هدر ', 'پول هدر داد', 'پول هدر ده', 'پول هدر داده ', 'پول هدر داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('533', 'پیاده رفتن', 'piāde raftan', '149', 'پیاده ', 'پیاده رفت', 'پیاده رو', 'پیاده رفته ', 'پیاده رفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('534', 'پیاده شدن', 'piāde shodan', '178', 'پیاده ', 'پیاده شد', 'پیاده شو', 'پیاده شده ', 'پیاده شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('535', 'پیاده کردن', 'piāde kardan', '215', 'پیاده ', 'پیاده کرد', 'پیاده کن', 'پیاده کرده ', 'پیاده کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('536', 'پیانو زدن', 'piāno zadan', '154', 'پیانو ', 'پیانو زد', 'پیانو زن', 'پیانو زده ', 'پیانو زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('537', 'پیدا کردن', 'paydā kardan', '215', 'پیدا ', 'پیدا کرد', 'پیدا کن', 'پیدا کرده ', 'پیدا کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('538', 'پیدا کردن', 'peidā kardan', '215', 'پیدا ', 'پیدا کرد', 'پیدا کن', 'پیدا کرده ', 'پیدا کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('539', 'تاخت و تاز کردن', 'tākht-o tāz kardan', '215', 'تاخت و تاز ', 'تاخت و تاز کرد', 'تاخت و تاز کن', 'تاخت و تاز کرده ', 'تاخت و تاز کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('540', 'تازیانه خوردن', 'tāziāne khordan', '122', 'تازیانه ', 'تازیانه خورد', 'تازیانه خور', 'تازیانه خورده ', 'تازیانه خورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('541', 'تازیانه زدن', 'tāziāne zadan', '154', 'تازیانه ', 'تازیانه زد', 'تازیانه زن', 'تازیانه زده ', 'تازیانه زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('542', 'تایپ کردن', 'tāyp kardan', '215', 'تایپ ', 'تایپ کرد', 'تایپ کن', 'تایپ کرده ', 'تایپ کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('543', 'تأدیب کردن', 'ta\\\'adib kardan', '215', 'تأدیب ', 'تأدیب کرد', 'تأدیب کن', 'تأدیب کرده ', 'تأدیب کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('544', 'تأمل کردن', 'ta\\\'ammol kardan', '215', 'تأمل ', 'تأمل کرد', 'تأمل کن', 'تأمل کرده ', 'تأمل کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('545', 'تبدیل شدن', 'tabdil shodan', '178', 'تبدیل ', 'تبدیل شد', 'تبدیل شو', 'تبدیل شده ', 'تبدیل شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('546', 'تبدیل کردن', 'tabdil kardan', '215', 'تبدیل ', 'تبدیل کرد', 'تبدیل کن', 'تبدیل کرده ', 'تبدیل کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('547', 'تتبع کردن', 'tatabbo` kardan', '215', 'تتبع ', 'تتبع کرد', 'تتبع کن', 'تتبع کرده ', 'تتبع کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('548', 'تجاوز به کسی یا چیزی کردن', 'tajāvoz be kasi yā chizi kardan', '215', 'تجاوز به کسی یا چیزی ', 'تجاوز به کسی یا چیزی کرد', 'تجاوز به کسی یا چیزی کن', 'تجاوز به کسی یا چیزی کرده ', 'تجاوز به کسی یا چیزی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('549', 'تجزیه کردن', 'tajzie kardan', '215', 'تجزیه ', 'تجزیه کرد', 'تجزیه کن', 'تجزیه کرده ', 'تجزیه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('550', ' تجزيه و تحليل کردن', 'tajzie-o tahlil kardan', '215', 'تجزیه وتحلیل ', 'تجزیه وتحلیل کرد', 'تجزیه وتحلیل کن', 'تجزیه وتحلیل کرده ', 'تجزیه وتحلیل کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('551', 'تحصیل کردن', 'tahsil kardan', '215', 'تحصیل ', 'تحصیل کرد', 'تحصیل کن', 'تحصیل کرده ', 'تحصیل کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('552', 'تحقیق کردن', 'tahqiq kardan', '215', 'تحقیق ', 'تحقیق کرد', 'تحقیق کن', 'تحقیق کرده ', 'تحقیق کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('553', 'تحقیق کردن', 'tahghigh kardan', '215', 'تحقیق ', 'تحقیق کرد', 'تحقیق کن', 'تحقیق کرده ', 'تحقیق کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('554', 'تحلیل کردن', 'tahlil kardan', '215', 'تحلیل ', 'تحلیل کرد', 'تحلیل کن', 'تحلیل کرده ', 'تحلیل کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('555', 'تحویل دادن', 'tahvil dādan', '123', 'تحویل ', 'تحویل داد', 'تحویل ده', 'تحویل داده ', 'تحویل داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('556', 'تخفیف دادن', 'takhfif dādan', '123', 'تخفیف ', 'تخفیف داد', 'تخفیف ده', 'تخفیف داده ', 'تخفیف داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('557', 'تخفیف گرفتن', 'takhfif gereftan', '228', 'تخفیف ', 'تخفیف گرفت', 'تخفیف گیر', 'تخفیف گرفته ', 'تخفیف گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('558', 'ترجمه شدن', 'tarjome shodan', '178', 'ترجمه ', 'ترجمه شد', 'ترجمه شو', 'ترجمه شده ', 'ترجمه شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('559', 'ترجمه کردن', 'tarjome kardan', '215', 'ترجمه ', 'ترجمه کرد', 'ترجمه کن', 'ترجمه کرده ', 'ترجمه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('560', 'ترک کردن', 'tark kardan', '215', 'ترک ', 'ترک کرد', 'ترک کن', 'ترک کرده ', 'ترک کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('561', 'ترکیب شدن', 'tarkib shodan', '178', 'ترکیب ', 'ترکیب شد', 'ترکیب شو', 'ترکیب شده ', 'ترکیب شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('562', 'ترکیب کردن', 'tarkib kardan', '215', 'ترکیب ', 'ترکیب کرد', 'ترکیب کن', 'ترکیب کرده ', 'ترکیب کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('563', 'تشریح کردن', 'tashrih kardan', '215', 'تشریح ', 'تشریح کرد', 'تشریح کن', 'تشریح کرده ', 'تشریح کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('564', 'تشریف آوردن', 'tashrif āvardan', '19', 'تشریف ', 'تشریف آورد', 'تشریف آور', 'تشریف آورده ', 'تشریف آورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('565', 'تشریف آوردن', 'tashrif āvordan', '20', 'تشریف ', 'تشریف آورد', 'تشریف آور', 'تشریف آورده ', 'تشریف آورده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('566', 'تشکر کردن', 'tashakkor kardan', '215', 'تشکر ', 'تشکر کرد', 'تشکر کن', 'تشکر کرده ', 'تشکر کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('567', 'تشکیل دادن', 'tashkil dādan', '123', 'تشکیل ', 'تشکیل داد', 'تشکیل ده', 'تشکیل داده ', 'تشکیل داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('568', 'تصحیح کردن', 'tashih kardan', '215', 'تصحیح ', 'تصحیح کرد', 'تصحیح کن', 'تصحیح کرده ', 'تصحیح کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('569', 'تصی کردن', 'tasi kardan', '215', 'تصی ', 'تصی کرد', 'تصی کن', 'تصی کرده ', 'تصی کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('570', 'تصمیم اتخاذ کردن', 'tasmim ettekhāz kardan', '215', 'تصمیم اتخاذ ', 'تصمیم اتخاذ کرد', 'تصمیم اتخاذ کن', 'تصمیم اتخاذ کرده ', 'تصمیم اتخاذ کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('571', 'تصمیم گرفتن', 'tasmim gereftan', '228', 'تصمیم ', 'تصمیم گرفت', 'تصمیم گیر', 'تصمیم گرفته ', 'تصمیم گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('572', 'تصمیم یافتن', 'tasmim yāftan', '275', 'تصمیم ', 'تصمیم یافت', 'تصمیم یاب', 'تصمیم یافته ', 'تصمیم یافته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('573', 'تصور کردن', 'tasavvor kardan', '215', 'تصور ', 'تصور کرد', 'تصور کن', 'تصور کرده ', 'تصور کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('574', 'تعارف کردن', 'ta`ārof kardan', '215', 'تعارف ', 'تعارف کرد', 'تعارف کن', 'تعارف کرده ', 'تعارف کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('575', 'تارف کردن', 'tārof kardan', '215', 'تارف ', 'تارف کرد', 'تارف کن', 'تارف کرده ', 'تارف کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('576', 'تعبیر کردن', 'ta`bir kardan', '215', 'تعبیر ', 'تعبیر کرد', 'تعبیر کن', 'تعبیر کرده ', 'تعبیر کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('577', 'تعدی کردن', 'ta`addi kardan', '215', 'تعدی ', 'تعدی کرد', 'تعدی کن', 'تعدی کرده ', 'تعدی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('578', 'تغییر کردن', 'taghir kardan', '215', 'تغییر ', 'تغییر کرد', 'تغییر کن', 'تغییر کرده ', 'تغییر کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('579', 'تفسیر کردن', 'tafsir kardan', '215', 'تفسیر ', 'تفسیر کرد', 'تفسیر کن', 'تفسیر کرده ', 'تفسیر کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('580', 'تفکر کردن', 'tafakkor kardan', '215', 'تفکر ', 'تفکر کرد', 'تفکر کن', 'تفکر کرده ', 'تفکر کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('581', 'تقاضا کردن', 'taqāzā kardan', '215', 'تقاضا ', 'تقاضا کرد', 'تقاضا کن', 'تقاضا کرده ', 'تقاضا کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('582', 'تقاضا کردن', 'taghāzā kardan', '215', 'تقاضا ', 'تقاضا کرد', 'تقاضا کن', 'تقاضا کرده ', 'تقاضا کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('583', 'تقسیم کردن', 'taqsim kardan', '215', 'تقسیم ', 'تقسیم کرد', 'تقسیم کن', 'تقسیم کرده ', 'تقسیم کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('584', 'تقسیم کردن', 'taghsim kardan', '215', 'تقسیم ', 'تقسیم کرد', 'تقسیم کن', 'تقسیم کرده ', 'تقسیم کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('585', 'تقلا کردن', 'taqallā kardan', '215', 'تقلا ', 'تقلا کرد', 'تقلا کن', 'تقلا کرده ', 'تقلا کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('586', 'تقلا کردن', 'taghallā kardan', '215', 'تقلا ', 'تقلا کرد', 'تقلا کن', 'تقلا کرده ', 'تقلا کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('587', 'تکاپو کردن', 'tak-ā-pu kardan', '215', 'تکاپو ', 'تکاپو کرد', 'تکاپو کن', 'تکاپو کرده ', 'تکاپو کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('588', 'تکان دادن', 'takān dādan', '123', 'تکان ', 'تکان داد', 'تکان ده', 'تکان داده ', 'تکان داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('589', 'تکون دادن', 'tekun dādan', '123', 'تکون ', 'تکون داد', 'تکون ده', 'تکون داده ', 'تکون داده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('590', 'تکرار کردن', 'tekrār kardan', '215', 'تکرار ', 'تکرار کرد', 'تکرار کن', 'تکرار کرده ', 'تکرار کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('591', 'تلاش کردن', 'talāsh kardan', '215', 'تلاش ', 'تلاش کرد', 'تلاش کن', 'تلاش کرده ', 'تلاش کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('592', 'تلفظ کردن', 'talaffoz kardan', '215', 'تلفظ ', 'تلفظ کرد', 'تلفظ کن', 'تلفظ کرده ', 'تلفظ کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('593', 'تلفن زدن', 'telefon zadan', '154', 'تلفن ', 'تلفن زد', 'تلفن زن', 'تلفن زده ', 'تلفن زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('594', 'تلفن کردن', 'telefon kardan', '215', 'تلفن ', 'تلفن کرد', 'تلفن کن', 'تلفن کرده ', 'تلفن کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('595', 'تماشا کردن', 'tamāshā kardan', '215', 'تماشا ', 'تماشا کرد', 'تماشا کن', 'تماشا کرده ', 'تماشا کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('596', 'تمام شدن', 'tamām shodan', '178', 'تمام ', 'تمام شد', 'تمام شو', 'تمام شده ', 'تمام شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('597', 'تموم شدن', 'tamum shodan', '178', 'تموم ', 'تموم شد', 'تموم شو', 'تموم شده ', 'تموم شده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('598', 'تمرین کردن', 'tamrin kardan', '215', 'تمرین ', 'تمرین کرد', 'تمرین کن', 'تمرین کرده ', 'تمرین کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('599', 'تمنا کردن', 'tamannā kardan', '215', 'تمنا ', 'تمنا کرد', 'تمنا کن', 'تمنا کرده ', 'تمنا کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('600', 'تمیز کردن', 'tamiz kardan', '215', 'تمیز ', 'تمیز کرد', 'تمیز کن', 'تمیز کرده ', 'تمیز کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('601', 'تن کردن', 'tan kardan', '215', 'تن ', 'تن کرد', 'تن کن', 'تن کرده ', 'تن کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('602', 'تنبیه کردن', 'tanbih kardan', '215', 'تنبیه ', 'تنبیه کرد', 'تنبیه کن', 'تنبیه کرده ', 'تنبیه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('603', 'تنبیه کردن', 'tambih kardan', '215', 'تنبیه ', 'تنبیه کرد', 'تنبیه کن', 'تنبیه کرده ', 'تنبیه کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('604', 'تنه زدن', 'tane zadan', '154', 'تنه ', 'تنه زد', 'تنه زن', 'تنه زده ', 'تنه زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('605', 'تنیس بازی کردن', 'tenis bāzi kardan', '215', 'تنیس بازی ', 'تنیس بازی کرد', 'تنیس بازی کن', 'تنیس بازی کرده ', 'تنیس بازی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('606', 'توالت داشتن', 'tovālet dāshtan', '124', 'توالت ', 'توالت داشت', 'توالت دار', 'توالت داشته ', 'توالت داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('607', 'توالت رفتن', 'tovālet raftan', '149', 'توالت ', 'توالت رفت', 'توالت رو', 'توالت رفته ', 'توالت رفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('608', 'توالت کردن', 'tovālet kardan', '215', 'توالت ', 'توالت کرد', 'توالت کن', 'توالت کرده ', 'توالت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('609', 'توجه کردن', 'tavajjoh kardan', '215', 'توجه ', 'توجه کرد', 'توجه کن', 'توجه کرده ', 'توجه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('610', 'توجیه کردن', 'tawjih kardan', '215', 'توجیه ', 'توجیه کرد', 'توجیه کن', 'توجیه کرده ', 'توجیه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('611', 'توجی کردن', 'toji kardan', '215', 'توجی ', 'توجی کرد', 'توجی کن', 'توجی کرده ', 'توجی کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('612', 'توزیع شدن', 'tawzi` shodan', '178', 'توزیع ', 'توزیع شد', 'توزیع شو', 'توزیع شده ', 'توزیع شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('613', 'توزی شدن', 'tozi shodan', '178', 'توزی ', 'توزی شد', 'توزی شو', 'توزی شده ', 'توزی شده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('614', 'توزیع کردن', 'tawzi` kardan', '215', 'توزیع ', 'توزیع کرد', 'توزیع کن', 'توزیع کرده ', 'توزیع کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('615', 'توزیع کردن', 'tozi kardan', '215', 'توزیع ', 'توزیع کرد', 'توزیع کن', 'توزیع کرده ', 'توزیع کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('616', 'توسری خوردن', 'tu-sari khordan', '122', 'توسری ', 'توسری خورد', 'توسری خور', 'توسری خورده ', 'توسری خورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('617', 'توسری زدن', 'tu-sari zadan', '154', 'توسری ', 'توسری زد', 'توسری زن', 'توسری زده ', 'توسری زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('618', 'توسعه دادن', 'tawse`e dādan', '123', 'توسعه ', 'توسعه داد', 'توسعه ده', 'توسعه داده ', 'توسعه داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('619', 'توسه دادن', 'tose dādan', '123', 'توسه ', 'توسه داد', 'توسه ده', 'توسه داده ', 'توسه داده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('620', 'توصیف کردن', 'tawsif kardan', '215', 'توصیف ', 'توصیف کرد', 'توصیف کن', 'توصیف کرده ', 'توصیف کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('621', 'توصیف کردن', 'tosif kardan', '215', 'توصیف ', 'توصیف کرد', 'توصیف کن', 'توصیف کرده ', 'توصیف کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('622', 'توصیه کردن', 'tawsie kardan', '215', 'توصیه ', 'توصیه کرد', 'توصیه کن', 'توصیه کرده ', 'توصیه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('623', 'توصیه کردن', 'tosie kardan', '215', 'توصیه ', 'توصیه کرد', 'توصیه کن', 'توصیه کرده ', 'توصیه کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('624', 'توضیح دادن', 'tawzih dādan', '123', 'توضیح ', 'توضیح داد', 'توضیح ده', 'توضیح داده ', 'توضیح داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('625', 'توضی دادن', 'tozi dādan', '123', 'توضی ', 'توضی داد', 'توضی ده', 'توضی داده ', 'توضی داده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('626', 'تولید کردن', 'tawlid kardan', '215', 'تولید ', 'تولید کرد', 'تولید کن', 'تولید کرده ', 'تولید کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('627', 'تولید کردن', 'towlid kardan', '215', 'تولید ', 'تولید کرد', 'تولید کن', 'تولید کرده ', 'تولید کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('628', 'توهم داشتن', 'tavahhom dāshtan', '124', 'توهم ', 'توهم داشت', 'توهم دار', 'توهم داشته ', 'توهم داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('629', 'توهم کردن', 'tavahhom kardan', '215', 'توهم ', 'توهم کرد', 'توهم کن', 'توهم کرده ', 'توهم کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('630', 'توهین کردن', 'tawhin kardan', '215', 'توهین ', 'توهین کرد', 'توهین کن', 'توهین کرده ', 'توهین کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('631', 'توهین کردن', 'towhin kardan', '215', 'توهین ', 'توهین کرد', 'توهین کن', 'توهین کرده ', 'توهین کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('632', 'ته کشیدن', 'tah keshidan', '218', 'ته ', 'ته کشید', 'ته کش', 'ته کشیده ', 'ته کشیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('633', 'تهی شدن', 'tahi shodan', '178', 'تهی ', 'تهی شد', 'تهی شو', 'تهی شده ', 'تهی شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('634', 'تهی شدن', 'tohi shodan', '178', 'تهی ', 'تهی شد', 'تهی شو', 'تهی شده ', 'تهی شده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('635', 'تیغ زدن', 'tigh zadan', '154', 'تیغ ', 'تیغ زد', 'تیغ زن', 'تیغ زده ', 'تیغ زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('636', 'ثابت کردن', 'sābet kardan', '215', 'ثابت ', 'ثابت کرد', 'ثابت کن', 'ثابت کرده ', 'ثابت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('637', 'ثبات داشتن', 'sabāt dāshtan', '124', 'ثبات ', 'ثبات داشت', 'ثبات دار', 'ثبات داشته ', 'ثبات داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('638', 'ثبات داشتن', 'sobāt dāshtan', '124', 'ثبات ', 'ثبات داشت', 'ثبات دار', 'ثبات داشته ', 'ثبات داشته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('639', 'ثبت نام کردن', 'sabt-e nām kardan', '215', 'ثبت نام ', 'ثبت نام کرد', 'ثبت نام کن', 'ثبت نام کرده ', 'ثبت نام کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('640', 'جا گذاشتن', 'jā gozāshtan', '224', 'جا ', 'جا گذاشت', 'جا گذار', 'جا گذاشته ', 'جا گذاشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('641', 'جابه جا کردن', 'jā-be-jā kardan', '215', 'جابه جا ', 'جابه جا کرد', 'جابه جا کن', 'جابه جا کرده ', 'جابه جا کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('642', 'جارو کردن', 'jāru kardan', '215', 'جارو ', 'جارو کرد', 'جارو کن', 'جارو کرده ', 'جارو کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('643', 'جدا شدن', 'jodā shodan', '178', 'جدا ', 'جدا شد', 'جدا شو', 'جدا شده ', 'جدا شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('644', 'جدا کردن', 'jodā kardan', '215', 'جدا ', 'جدا کرد', 'جدا کن', 'جدا کرده ', 'جدا کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('645', 'جدو جهد کردن', 'jedd-o jahd kardan', '215', 'جدو جهد ', 'جدو جهد کرد', 'جدو جهد کن', 'جدو جهد کرده ', 'جدو جهد کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('646', 'جدو جهد کردن', 'jed-o jahd kardan', '215', 'جدو جهد ', 'جدو جهد کرد', 'جدو جهد کن', 'جدو جهد کرده ', 'جدو جهد کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('647', 'جرأت به خرج دادن', 'jor\\\'at be kharj dādan', '123', 'جرأت به خرج ', 'جرأت به خرج داد', 'جرأت به خرج ده', 'جرأت به خرج داده ', 'جرأت به خرج داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('648', 'جرأت داشتن', 'jor\\\'at dāshtan', '124', 'جرأت ', 'جرأت داشت', 'جرأت دار', 'جرأت داشته ', 'جرأت داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('649', 'جرأت کردن', 'jor\\\'at kardan', '215', 'جرأت ', 'جرأت کرد', 'جرأت کن', 'جرأت کرده ', 'جرأت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('650', 'جرئت به خرج دادن', 'jor\\\'at be kharj dādan', '123', 'جرئت به خرج ', 'جرئت به خرج داد', 'جرئت به خرج ده', 'جرئت به خرج داده ', 'جرئت به خرج داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('651', 'جرئت داشتن', 'jor\\\'at dāshtan', '124', 'جرئت ', 'جرئت داشت', 'جرئت دار', 'جرئت داشته ', 'جرئت داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('652', 'جرئت کردن', 'jor\\\'at kardan', '215', 'جرئت ', 'جرئت کرد', 'جرئت کن', 'جرئت کرده ', 'جرئت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('653', 'جریمه کردن', 'jarime kardan', '215', 'جریمه ', 'جریمه کرد', 'جریمه کن', 'جریمه کرده ', 'جریمه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('654', 'جست و جو کردن', 'jost-o ju kardan', '215', 'جست و جو ', 'جست و جو کرد', 'جست و جو کن', 'جست و جو کرده ', 'جست و جو کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('655', 'جلو کسی ایستادن', 'jelaw-e kasi istādan', '40', 'جلو کسی ', 'جلو کسی ایستاد', 'جلو کسی ایست', 'جلو کسی ایستاده ', 'جلو کسی ایستاده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('656', 'جلو کسی ایستادن', 'jelow-ye kasi istādan', '40', 'جلو کسی ', 'جلو کسی ایستاد', 'جلو کسی ایست', 'جلو کسی ایستاده ', 'جلو کسی ایستاده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('657', 'جلوگیری کردن', 'jelaw-giri kardan', '215', 'جلوگیری ', 'جلوگیری کرد', 'جلوگیری کن', 'جلوگیری کرده ', 'جلوگیری کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('658', 'جلوگیری کردن', 'jelo-giri kardan', '215', 'جلوگیری ', 'جلوگیری کرد', 'جلوگیری کن', 'جلوگیری کرده ', 'جلوگیری کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('659', 'جمع شدن', 'jam` shodan', '178', 'جمع ', 'جمع شد', 'جمع شو', 'جمع شده ', 'جمع شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('660', 'جم شدن', 'jam shodan', '178', 'جم ', 'جم شد', 'جم شو', 'جم شده ', 'جم شده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('661', 'جمع کردن', 'jam` kardan', '215', 'جمع ', 'جمع کرد', 'جمع کن', 'جمع کرده ', 'جمع کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('662', 'جم کردن', 'jam kardan', '215', 'جم ', 'جم کرد', 'جم کن', 'جم کرده ', 'جم کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('663', 'جمع آوری کردن', 'jam`-āvari kardan', '215', 'جمع آوری ', 'جمع آوری کرد', 'جمع آوری کن', 'جمع آوری کرده ', 'جمع آوری کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('664', 'جم آوری کردن', 'jam-āvari kardan', '215', 'جم آوری ', 'جم آوری کرد', 'جم آوری کن', 'جم آوری کرده ', 'جم آوری کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('665', 'جمع وجور کردن', 'jam`-o-jur kardan', '215', 'جمع وجور ', 'جمع وجور کرد', 'جمع وجور کن', 'جمع وجور کرده ', 'جمع وجور کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('666', 'جم وجور کردن', 'jam-o-jur kardan', '215', 'جم وجور ', 'جم وجور کرد', 'جم وجور کن', 'جم وجور کرده ', 'جم وجور کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('667', 'جواب پس دادن', 'javāb pas dādan', '123', 'جواب پس ', 'جواب پس داد', 'جواب پس ده', 'جواب پس داده ', 'جواب پس داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('668', 'جواب دادن', 'javāb dādan', '123', 'جواب ', 'جواب داد', 'جواب ده', 'جواب داده ', 'جواب داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('669', 'جواب سلام دادن', 'javāb-e salām dādan', '123', 'جواب سلام ', 'جواب سلام داد', 'جواب سلام ده', 'جواب سلام داده ', 'جواب سلام داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('670', 'جور کردن', 'jur kardan', '215', 'جور ', 'جور کرد', 'جور کن', 'جور کرده ', 'جور کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('671', 'جور کردن', 'jawr kardan', '215', 'جور ', 'جور کرد', 'جور کن', 'جور کرده ', 'جور کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('672', 'جور کردن', 'jor kardan', '215', 'جور ', 'جور کرد', 'جور کن', 'جور کرده ', 'جور کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('673', 'جوش آمدن', 'jush āmadan', '15', 'جوش ', 'جوش آمد', 'جوش آ', 'جوش آمده ', 'جوش آمده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('674', 'جوش اومدن', 'jush umadan', '16', 'جوش ', 'جوش اومد', 'جوش یا', 'جوش اومده ', 'جوش اومده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('675', 'جوش آوردن', 'jush āvardan', '19', 'جوش ', 'جوش آورد', 'جوش آور', 'جوش آورده ', 'جوش آورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('676', 'جوش آوردن', 'jush āvordan', '20', 'جوش ', 'جوش آورد', 'جوش آور', 'جوش آورده ', 'جوش آورده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('677', 'جوش خوردن', 'jush khordan', '122', 'جوش ', 'جوش خورد', 'جوش خور', 'جوش خورده ', 'جوش خورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('678', 'جوش دادن', 'jush dādan', '123', 'جوش ', 'جوش داد', 'جوش ده', 'جوش داده ', 'جوش داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('679', 'جوش زدن', 'jush zadan', '154', 'جوش ', 'جوش زد', 'جوش زن', 'جوش زده ', 'جوش زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('680', 'جیش داشتن', 'jish dāshtan', '124', 'جیش ', 'جیش داشت', 'جیش دار', 'جیش داشته ', 'جیش داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('681', 'جیش کردن', 'jish kardan', '215', 'جیش ', 'جیش کرد', 'جیش کن', 'جیش کرده ', 'جیش کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('682', 'چاپ زدن', 'chāp zadan', '154', 'چاپ ', 'چاپ زد', 'چاپ زن', 'چاپ زده ', 'چاپ زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('683', 'چاپ کردن', 'chāp kardan', '215', 'چاپ ', 'چاپ کرد', 'چاپ کن', 'چاپ کرده ', 'چاپ کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('684', 'چادر زدن', 'chādor zadan', '154', 'چادر ', 'چادر زد', 'چادر زن', 'چادر زده ', 'چادر زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('685', 'چانه زدن', 'chāne zadan', '154', 'چانه ', 'چانه زد', 'چانه زن', 'چانه زده ', 'چانه زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('686', 'چونه زدن', 'chune zadan', '154', 'چونه ', 'چونه زد', 'چونه زن', 'چونه زده ', 'چونه زده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('687', 'چت کردن', 'chat kardan', '215', 'چت ', 'چت کرد', 'چت کن', 'چت کرده ', 'چت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('688', 'چش کردن', 'chosh kardan', '215', 'چش ', 'چش کرد', 'چش کن', 'چش کرده ', 'چش کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('689', 'حال کردن', 'hāl kardan', '215', 'حال ', 'حال کرد', 'حال کن', 'حال کرده ', 'حال کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('690', 'حالی شدن', 'hāli shodan', '178', 'حالی ', 'حالی شد', 'حالی شو', 'حالی شده ', 'حالی شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('691', 'حالی کردن', 'hāli kardan', '215', 'حالی ', 'حالی کرد', 'حالی کن', 'حالی کرده ', 'حالی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('692', 'حذف کردن', 'hazf kardan', '215', 'حذف ', 'حذف کرد', 'حذف کن', 'حذف کرده ', 'حذف کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('693', 'حرص دادن', 'hers dādan', '123', 'حرص ', 'حرص داد', 'حرص ده', 'حرص داده ', 'حرص داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('694', 'حرف زدن', 'harf zadan', '154', 'حرف ', 'حرف زد', 'حرف زن', 'حرف زده ', 'حرف زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('695', 'حرکت دادن', 'harakat dādan', '123', 'حرکت ', 'حرکت داد', 'حرکت ده', 'حرکت داده ', 'حرکت داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('696', 'حرکت دادن', 'harekat dādan', '123', 'حرکت ', 'حرکت داد', 'حرکت ده', 'حرکت داده ', 'حرکت داده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('697', 'حرکت کردن', 'harakat kardan', '215', 'حرکت ', 'حرکت کرد', 'حرکت کن', 'حرکت کرده ', 'حرکت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('698', 'حرکت کردن', 'harekat kardan', '215', 'حرکت ', 'حرکت کرد', 'حرکت کن', 'حرکت کرده ', 'حرکت کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('699', 'حفظ کردن', 'hefz kardan', '215', 'حفظ ', 'حفظ کرد', 'حفظ کن', 'حفظ کرده ', 'حفظ کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('700', 'حفص کردن', 'hefs kardan', '215', 'حفص ', 'حفص کرد', 'حفص کن', 'حفص کرده ', 'حفص کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('701', 'حلاجی کردن', 'halāji kardan', '215', 'حلاجی ', 'حلاجی کرد', 'حلاجی کن', 'حلاجی کرده ', 'حلاجی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('702', 'حمام کردن', 'hammām kardan', '215', 'حمام ', 'حمام کرد', 'حمام کن', 'حمام کرده ', 'حمام کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('703', 'حموم کردن', 'hammum kardan', '215', 'حموم ', 'حموم کرد', 'حموم کن', 'حموم کرده ', 'حموم کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('704', 'حمله کردن', 'hamle kardan', '215', 'حمله ', 'حمله کرد', 'حمله کن', 'حمله کرده ', 'حمله کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('705', 'خارج شدن', 'khārej shodan', '178', 'خارج ', 'خارج شد', 'خارج شو', 'خارج شده ', 'خارج شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('706', 'خال کوبیدن', 'khāl kubidan', '220', 'خال ', 'خال کوبید', 'خال کوب', 'خال کوبیده ', 'خال کوبیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('707', 'خالکوبی کردن', 'khāl-kubi kardan', '215', 'خالکوبی ', 'خالکوبی کرد', 'خالکوبی کن', 'خالکوبی کرده ', 'خالکوبی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('708', 'خالی شدن', 'khāli shodan', '178', 'خالی ', 'خالی شد', 'خالی شو', 'خالی شده ', 'خالی شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('709', 'خالی کردن', 'khāli kardan', '215', 'خالی ', 'خالی کرد', 'خالی کن', 'خالی کرده ', 'خالی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('710', 'خاموش شدن', 'khāmush shodan', '178', 'خاموش ', 'خاموش شد', 'خاموش شو', 'خاموش شده ', 'خاموش شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('711', 'خاموش کردن', 'khāmush kardan', '215', 'خاموش ', 'خاموش کرد', 'خاموش کن', 'خاموش کرده ', 'خاموش کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('712', 'خبر داشتن', 'khabar dāshtan', '124', 'خبر ', 'خبر داشت', 'خبر دار', 'خبر داشته ', 'خبر داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('713', 'ختنه کردن', 'khatne kardan', '215', 'ختنه ', 'ختنه کرد', 'ختنه کن', 'ختنه کرده ', 'ختنه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('714', 'خجالت کشیدن', 'khejālat keshidan', '218', 'خجالت ', 'خجالت کشید', 'خجالت کش', 'خجالت کشیده ', 'خجالت کشیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('715', 'خدا حافظی کردن', 'khodā hāfezi kardan', '215', 'خدا حافظی ', 'خدا حافظی کرد', 'خدا حافظی کن', 'خدا حافظی کرده ', 'خدا حافظی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('716', 'خدافظی کردن', 'khodāfezi kardan', '215', 'خدافظی ', 'خدافظی کرد', 'خدافظی کن', 'خدافظی کرده ', 'خدافظی کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('717', 'خراش دادن', 'kharāsh dādan', '123', 'خراش ', 'خراش داد', 'خراش ده', 'خراش داده ', 'خراش داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('718', 'خراطی کردن', 'kharrāti kardan', '215', 'خراطی ', 'خراطی کرد', 'خراطی کن', 'خراطی کرده ', 'خراطی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('719', 'خرخر کردن', 'khor-khor kardan', '215', 'خرخر ', 'خرخر کرد', 'خرخر کن', 'خرخر کرده ', 'خرخر کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('720', 'خرید کردن', 'kharid kardan', '215', 'خرید ', 'خرید کرد', 'خرید کن', 'خرید کرده ', 'خرید کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('721', 'خریداری کردن', 'kharidāri kardan', '215', 'خریداری ', 'خریداری کرد', 'خریداری کن', 'خریداری کرده ', 'خریداری کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('722', 'خسته بودن', 'khaste budan', '55', 'خسته ', 'خسته بود', 'خسته باش', 'خسته بوده ', 'خسته بوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('723', 'خسته شدن', 'khaste shodan', '178', 'خسته ', 'خسته شد', 'خسته شو', 'خسته شده ', 'خسته شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('724', 'خسته کردن', 'khaste kardan', '215', 'خسته ', 'خسته کرد', 'خسته کن', 'خسته کرده ', 'خسته کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('725', 'خط زدن', 'khatt zadan', '154', 'خط ', 'خط زد', 'خط زن', 'خط زده ', 'خط زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('726', 'خط زدن', 'khat zadan', '154', 'خط ', 'خط زد', 'خط زن', 'خط زده ', 'خط زده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('727', 'خط کشیدن', 'khatt keshidan', '218', 'خط ', 'خط کشید', 'خط کش', 'خط کشیده ', 'خط کشیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('728', 'خط کشیدن', 'khat keshidan', '218', 'خط ', 'خط کشید', 'خط کش', 'خط کشیده ', 'خط کشیده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('729', 'خلا رفتن', 'khalā raftan', '149', 'خلا ', 'خلا رفت', 'خلا رو', 'خلا رفته ', 'خلا رفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('730', 'خلاصه کردن', 'kholāse kardan', '215', 'خلاصه ', 'خلاصه کرد', 'خلاصه کن', 'خلاصه کرده ', 'خلاصه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('731', 'خلاف کردن', 'khalāf kardan', '215', 'خلاف ', 'خلاف کرد', 'خلاف کن', 'خلاف کرده ', 'خلاف کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('732', 'خلال کردن', 'khalāl kardan', '215', 'خلال ', 'خلال کرد', 'خلال کن', 'خلال کرده ', 'خلال کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('733', 'خمیر کردن', 'khamir kardan', '215', 'خمیر ', 'خمیر کرد', 'خمیر کن', 'خمیر کرده ', 'خمیر کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('734', 'خمیر گرفتن', 'khamir gereftan', '228', 'خمیر ', 'خمیر گرفت', 'خمیر گیر', 'خمیر گرفته ', 'خمیر گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('735', 'خمیر مالیدن', 'khamir mālidan', '248', 'خمیر ', 'خمیر مالید', 'خمیر مال', 'خمیر مالیده ', 'خمیر مالیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('736', 'خنثی کردن', 'khonsā kardan', '215', 'خنثی ', 'خنثی کرد', 'خنثی کن', 'خنثی کرده ', 'خنثی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('737', 'خو گرفتن', 'khu gereftan', '228', 'خو ', 'خو گرفت', 'خو گیر', 'خو گرفته ', 'خو گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('738', 'خواهش کردن', 'khāhesh kardan', '215', 'خواهش ', 'خواهش کرد', 'خواهش کن', 'خواهش کرده ', 'خواهش کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('739', 'خودداری کردن', 'khod-dāri kardan', '215', 'خودداری ', 'خودداری کرد', 'خودداری کن', 'خودداری کرده ', 'خودداری کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('740', 'خوش وبش کردن', 'khosh-o-besh kardan', '215', 'خوش وبش ', 'خوش وبش کرد', 'خوش وبش کن', 'خوش وبش کرده ', 'خوش وبش کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('741', 'خوف داشتن', 'khawf dāshtan', '124', 'خوف ', 'خوف داشت', 'خوف دار', 'خوف داشته ', 'خوف داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('742', 'خوف داشتن', 'khowf dāshtan', '124', 'خوف ', 'خوف داشت', 'خوف دار', 'خوف داشته ', 'خوف داشته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('743', 'خیاطی کردن', 'khayyāti kardan', '215', 'خیاطی ', 'خیاطی کرد', 'خیاطی کن', 'خیاطی کرده ', 'خیاطی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('744', 'خیال کردن', 'khiāl kardan', '215', 'خیال ', 'خیال کرد', 'خیال کن', 'خیال کرده ', 'خیال کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('745', 'دارای چیزی شدن', 'dārā-ye chizi shodan', '178', 'دارای چیزی ', 'دارای چیزی شد', 'دارای چیزی شو', 'دارای چیزی شده ', 'دارای چیزی شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('746', 'دخالت کردن', 'dekhālat kardan', '215', 'دخالت ', 'دخالت کرد', 'دخالت کن', 'دخالت کرده ', 'دخالت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('747', 'در آغوش گرفتن', 'dar āghush gereftan', '228', 'در آغوش ', 'در آغوش گرفت', 'در آغوش گیر', 'در آغوش گرفته ', 'در آغوش گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('748', 'در بر داشتن', 'dar bar dāshtan', '124', 'در بر ', 'در بر داشت', 'در بر دار', 'در بر داشته ', 'در بر داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('749', 'در پیچیدن', 'dar pichidan', '73', 'در ', 'در پیچید', 'در پیچ', 'در پیچیده ', 'در پیچیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('750', 'در رفتن', 'dar raftan', '149', 'در ', 'در رفت', 'در رو', 'در رفته ', 'در رفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('751', 'در زدن', 'dar zadan', '154', 'در ', 'در زد', 'در زن', 'در زده ', 'در زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('752', 'در کردن', 'dar kardan', '215', 'در ', 'در کرد', 'در کن', 'در کرده ', 'در کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('753', 'در گذشتن', 'dar gozashtan', '225', 'در ', 'در گذشت', 'در گذر', 'در گذشته ', 'در گذشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('754', 'در گرفتن', 'dar gereftan', '228', 'در ', 'در گرفت', 'در گیر', 'در گرفته ', 'در گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('755', 'در ماندن', 'dar māndan', '249', 'در ', 'در ماند', 'در مان', 'در مانده ', 'در مانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('756', 'در موندن', 'dar mundan', '250', 'در ', 'در موند', 'در مون', 'در مونده ', 'در مونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('757', 'در نظر گرفتن', 'dar nazar gereftan', '228', 'در نظر ', 'در نظر گرفت', 'در نظر گیر', 'در نظر گرفته ', 'در نظر گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('758', 'در نوردیدن', 'dar navardidan', '263', 'در ', 'در نوردید', 'در نورد', 'در نوردیده ', 'در نوردیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('759', 'دراز کشیدن', 'derāz keshidan', '218', 'دراز ', 'دراز کشید', 'دراز کش', 'دراز کشیده ', 'دراز کشیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('760', 'درخواست کردن', 'dar-khāst kardan', '215', 'درخواست ', 'درخواست کرد', 'درخواست کن', 'درخواست کرده ', 'درخواست کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('761', 'درخواستن', 'dar-khāstan', null, '', 'درخواست', '', 'درخواسته ', 'درخواسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('762', 'درد داشتن', 'dard dāshtan', '124', 'درد ', 'درد داشت', 'درد دار', 'درد داشته ', 'درد داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('763', 'دردسر دادن', 'dard-e sar dādan', '123', 'دردسر ', 'دردسر داد', 'دردسر ده', 'دردسر داده ', 'دردسر داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('764', 'درس پس دادن', 'dars pas dādan', '123', 'درس پس ', 'درس پس داد', 'درس پس ده', 'درس پس داده ', 'درس پس داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('765', 'درس خواندن', 'dars khāndan', '120', 'درس ', 'درس خواند', 'درس خوان', 'درس خوانده ', 'درس خوانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('766', 'درس خوندن', 'dars khundan', '121', 'درس ', 'درس خوند', 'درس خون', 'درس خونده ', 'درس خونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('767', 'درس دادن', 'dars dādan', '123', 'درس ', 'درس داد', 'درس ده', 'درس داده ', 'درس داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('768', 'درست بودن', 'dorost budan', '55', 'درست ', 'درست بود', 'درست باش', 'درست بوده ', 'درست بوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('769', 'درست شدن', 'dorost shodan', '178', 'درست ', 'درست شد', 'درست شو', 'درست شده ', 'درست شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('770', 'درست کردن', 'dorost kardan', '215', 'درست ', 'درست کرد', 'درست کن', 'درست کرده ', 'درست کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('771', 'درک کردن', 'dark kardan', '215', 'درک ', 'درک کرد', 'درک کن', 'درک کرده ', 'درک کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('772', 'درگیر شدن', 'dar-gir shodan', '178', 'درگیر ', 'درگیر شد', 'درگیر شو', 'درگیر شده ', 'درگیر شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('773', 'درو کردن', 'deraw kardan', '215', 'درو ', 'درو کرد', 'درو کن', 'درو کرده ', 'درو کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('774', 'درو کردن', 'derow kardan', '215', 'درو ', 'درو کرد', 'درو کن', 'درو کرده ', 'درو کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('775', 'دروغ بافتن', 'dorugh bāftan', '45', 'دروغ ', 'دروغ بافت', 'دروغ باف', 'دروغ بافته ', 'دروغ بافته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('776', 'دروغ گفتن', 'dorugh goftan', '240', 'دروغ ', 'دروغ گفت', 'دروغ گو', 'دروغ گفته ', 'دروغ گفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('777', 'درهم رفتن', 'dar-ham raftan', '149', 'درهم ', 'درهم رفت', 'درهم رو', 'درهم رفته ', 'درهم رفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('778', 'درهم ریختن', 'dar-ham rikhtan', '151', 'درهم ', 'درهم ریخت', 'درهم ریز', 'درهم ریخته ', 'درهم ریخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('779', 'درهم شدن', 'dar-ham shodan', '178', 'درهم ', 'درهم شد', 'درهم شو', 'درهم شده ', 'درهم شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('780', 'درهم کردن', 'dar-ham kardan', '215', 'درهم ', 'درهم کرد', 'درهم کن', 'درهم کرده ', 'درهم کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('781', 'درهم برهم کردن', 'dar-ham-bar-ham kardan', '215', 'درهم برهم ', 'درهم برهم کرد', 'درهم برهم کن', 'درهم برهم کرده ', 'درهم برهم کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('782', 'درهم و برهم کردن', 'dar-ham-o bar-ham kardan', '215', 'درهم و برهم ', 'درهم و برهم کرد', 'درهم و برهم کن', 'درهم و برهم کرده ', 'درهم و برهم کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('783', 'دریافت کردن', 'daryāft kardan', '215', 'دریافت ', 'دریافت کرد', 'دریافت کن', 'دریافت کرده ', 'دریافت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('784', 'دست از چیزی کشیدن', 'dast az chizi keshidan', '218', 'دست از چیزی ', 'دست از چیزی کشید', 'دست از چیزی کش', 'دست از چیزی کشیده ', 'دست از چیزی کشیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('785', 'دست انداختن', 'dast andākhtan', '34', 'دست ', 'دست انداخت', 'دست انداز', 'دست انداخته ', 'دست انداخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('786', 'دست دادن', 'dast dādan', '123', 'دست ', 'دست داد', 'دست ده', 'دست داده ', 'دست داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('787', 'دست اندازی کردن', 'dast-andāzi kardan', '215', 'دست اندازی ', 'دست اندازی کرد', 'دست اندازی کن', 'دست اندازی کرده ', 'دست اندازی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('788', 'دستپاچه شدن', 'dast-pāche shodan', '178', 'دستپاچه ', 'دستپاچه شد', 'دستپاچه شو', 'دستپاچه شده ', 'دستپاچه شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('789', 'دست وپا کردن', 'dast-o pā kardan', '215', 'دست وپا ', 'دست وپا کرد', 'دست وپا کن', 'دست وپا کرده ', 'دست وپا کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('790', 'دست یاری کردن', 'dast-yāri kardan', '215', 'دست یاری ', 'دست یاری کرد', 'دست یاری کن', 'دست یاری کرده ', 'دست یاری کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('791', 'دعوا کردن', 'da`vā kardan', '215', 'دعوا ', 'دعوا کرد', 'دعوا کن', 'دعوا کرده ', 'دعوا کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('792', 'دعوی کردن', 'da`vi kardan', '215', 'دعوی ', 'دعوی کرد', 'دعوی کن', 'دعوی کرده ', 'دعوی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('793', 'دلخور کردن', 'delkhor kardan', '215', 'دلخور ', 'دلخور کرد', 'دلخور کن', 'دلخور کرده ', 'دلخور کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('794', 'دندان در آوردن', 'dandān dar āvardan', '19', 'دندان در ', 'دندان در آورد', 'دندان در آور', 'دندان در آورده ', 'دندان در آورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('795', 'دندون در آوردن', 'dandun dar āvordan', '20', 'دندون در ', 'دندون در آورد', 'دندون در آور', 'دندون در آورده ', 'دندون در آورده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('796', 'دنگی رفتن', 'dongi raftan', '149', 'دنگی ', 'دنگی رفت', 'دنگی رو', 'دنگی رفته ', 'دنگی رفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('797', 'دوام داشتن', 'davām dāshtan', '124', 'دوام ', 'دوام داشت', 'دوام دار', 'دوام داشته ', 'دوام داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('798', 'دوبرابر کردن', 'do-barābar kardan', '215', 'دوبرابر ', 'دوبرابر کرد', 'دوبرابر کن', 'دوبرابر کرده ', 'دوبرابر کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('799', 'دوبه هم زنی کردن', 'do-be-ham-zani kardan', '215', 'دوبه هم زنی ', 'دوبه هم زنی کرد', 'دوبه هم زنی کن', 'دوبه هم زنی کرده ', 'دوبه هم زنی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('800', 'دود کردن', 'dud kardan', '215', 'دود ', 'دود کرد', 'دود کن', 'دود کرده ', 'دود کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('801', 'دور افتادن', 'dur oftādan', '24', 'دور ', 'دور افتاد', 'دور افت', 'دور افتاده ', 'دور افتاده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('802', 'دور انداختن', 'dur andākhtan', '34', 'دور ', 'دور انداخت', 'دور انداز', 'دور انداخته ', 'دور انداخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('803', 'دور ریختن', 'dur rikhtan', '151', 'دور ', 'دور ریخت', 'دور ریز', 'دور ریخته ', 'دور ریخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('804', 'دوره کردن', 'dawre kardan', '215', 'دوره ', 'دوره کرد', 'دوره کن', 'دوره کرده ', 'دوره کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('805', 'دوره کردن', 'dowre kardan', '215', 'دوره ', 'دوره کرد', 'دوره کن', 'دوره کرده ', 'دوره کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('806', 'دوست داشتن', 'dust dāshtan', '124', 'دوست ', 'دوست داشت', 'دوست دار', 'دوست داشته ', 'دوست داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('807', 'دوس داشتن', 'dus dāshtan', '124', 'دوس ', 'دوس داشت', 'دوس دار', 'دوس داشته ', 'دوس داشته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('808', 'دوش گرفتن', 'dush gereftan', '228', 'دوش ', 'دوش گرفت', 'دوش گیر', 'دوش گرفته ', 'دوش گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('809', 'ذخیره کردن', 'zakhire kardan', '215', 'ذخیره ', 'ذخیره کرد', 'ذخیره کن', 'ذخیره کرده ', 'ذخیره کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('810', 'ذکر کردن', 'zekr kardan', '215', 'ذکر ', 'ذکر کرد', 'ذکر کن', 'ذکر کرده ', 'ذکر کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('811', 'ذک کردن', 'zek kardan', '215', 'ذک ', 'ذک کرد', 'ذک کن', 'ذک کرده ', 'ذک کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('812', 'ذکر گفتن', 'zekr goftan', '240', 'ذکر ', 'ذکر گفت', 'ذکر گو', 'ذکر گفته ', 'ذکر گفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('813', 'راست گفتن', 'rāst goftan', '240', 'راست ', 'راست گفت', 'راست گو', 'راست گفته ', 'راست گفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('814', 'راست گویی کردن', 'rāst-gui kardan', '215', 'راست گویی ', 'راست گویی کرد', 'راست گویی کن', 'راست گویی کرده ', 'راست گویی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('815', 'راضی بودن', 'rāzi budan', '55', 'راضی ', 'راضی بود', 'راضی باش', 'راضی بوده ', 'راضی بوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('816', 'راضی شدن', 'rāzi shodan', '178', 'راضی ', 'راضی شد', 'راضی شو', 'راضی شده ', 'راضی شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('817', 'راضی کردن', 'rāzi kardan', '215', 'راضی ', 'راضی کرد', 'راضی کن', 'راضی کرده ', 'راضی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('818', 'رانندگی کردن', 'rānandegi kardan', '215', 'رانندگی ', 'رانندگی کرد', 'رانندگی کن', 'رانندگی کرده ', 'رانندگی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('819', 'راه افتادن', 'rāh oftādan', '24', 'راه ', 'راه افتاد', 'راه افت', 'راه افتاده ', 'راه افتاده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('820', 'راه انداختن', 'rāh andākhtan', '34', 'راه ', 'راه انداخت', 'راه انداز', 'راه انداخته ', 'راه انداخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('821', 'راه پیمودن', 'rāh paymudan', '76', 'راه ', 'راه پیمود', 'راه پیما', 'راه پیموده ', 'راه پیموده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('822', 'راه رفتن', 'rāh raftan', '149', 'راه ', 'راه رفت', 'راه رو', 'راه رفته ', 'راه رفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('823', 'راه بری کردن', 'rāh-bari kardan', '215', 'راه بری ', 'راه بری کرد', 'راه بری کن', 'راه بری کرده ', 'راه بری کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('824', 'راهپیمایی کردن', 'rāh-paymāi kardan', '215', 'راهپیمایی ', 'راهپیمایی کرد', 'راهپیمایی کن', 'راهپیمایی کرده ', 'راهپیمایی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('825', 'راهپیمایی کردن', 'rāh-peimāi kardan', '215', 'راهپیمایی ', 'راهپیمایی کرد', 'راهپیمایی کن', 'راهپیمایی کرده ', 'راهپیمایی کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('826', 'راه نمایی کردن', 'rāh-namāi kardan', '215', 'راه نمایی ', 'راه نمایی کرد', 'راه نمایی کن', 'راه نمایی کرده ', 'راه نمایی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('827', 'رخصت خواستن', 'rokhsat khāstan', '119', 'رخصت ', 'رخصت خواست', 'رخصت خواه', 'رخصت خواسته ', 'رخصت خواسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('828', 'رد کردن', 'radd kardan', '215', 'رد ', 'رد کرد', 'رد کن', 'رد کرده ', 'رد کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('829', 'رد کردن', 'rad kardan', '215', 'رد ', 'رد کرد', 'رد کن', 'رد کرده ', 'رد کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('830', 'رژیم گرفتن', 'rezhim gereftan', '228', 'رژیم ', 'رژیم گرفت', 'رژیم گیر', 'رژیم گرفته ', 'رژیم گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('831', 'رشد کردن', 'roshd kardan', '215', 'رشد ', 'رشد کرد', 'رشد کن', 'رشد کرده ', 'رشد کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('832', 'رفع نقص کردن', 'raf`-e naqs kardan', '215', 'رفع نقص ', 'رفع نقص کرد', 'رفع نقص کن', 'رفع نقص کرده ', 'رفع نقص کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('833', 'رف نقص کردن', 'raf-e naghs kardan', '215', 'رف نقص ', 'رف نقص کرد', 'رف نقص کن', 'رف نقص کرده ', 'رف نقص کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('834', 'رنگ باختن', 'rang bakhtan', '41', 'رنگ ', 'رنگ باخت', 'رنگ باز', 'رنگ باخته ', 'رنگ باخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('835', 'رنگ زدن', 'rang zadan', '154', 'رنگ ', 'رنگ زد', 'رنگ زن', 'رنگ زده ', 'رنگ زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('836', 'رو آوردن', 'ru āvardan', '19', 'رو ', 'رو آورد', 'رو آور', 'رو آورده ', 'رو آورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('837', 'رو کردن', 'ru kardan', '215', 'رو ', 'رو کرد', 'رو کن', 'رو کرده ', 'رو کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('838', 'رو گرداندن', 'ru gardāndan', '226', 'رو ', 'رو گرداند', 'رو گردان', 'رو گردانده ', 'رو گردانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('839', 'روا داشتن', 'ravā dāshtan', '124', 'روا ', 'روا داشت', 'روا دار', 'روا داشته ', 'روا داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('840', 'رواج داشتن', 'ravāj dāshtan', '124', 'رواج ', 'رواج داشت', 'رواج دار', 'رواج داشته ', 'رواج داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('841', 'روان شدن', 'ravān shodan', '178', 'روان ', 'روان شد', 'روان شو', 'روان شده ', 'روان شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('842', 'روانه شدن', 'ravāne shodan', '178', 'روانه ', 'روانه شد', 'روانه شو', 'روانه شده ', 'روانه شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('843', 'روانه کردن', 'ravāne kardan', '215', 'روانه ', 'روانه کرد', 'روانه کن', 'روانه کرده ', 'روانه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('844', 'روبرو شدن', 'ru-be-ru shodan', '178', 'روبرو ', 'روبرو شد', 'روبرو شو', 'روبرو شده ', 'روبرو شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('845', 'روبرو کردن', 'ru-be-ru kardan', '215', 'روبرو ', 'روبرو کرد', 'روبرو کن', 'روبرو کرده ', 'روبرو کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('846', 'روزه گرفتن', 'ruze gereftan', '228', 'روزه ', 'روزه گرفت', 'روزه گیر', 'روزه گرفته ', 'روزه گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('847', 'رونق یافتن', 'rawnaq yāftan', '275', 'رونق ', 'رونق یافت', 'رونق یاب', 'رونق یافته ', 'رونق یافته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('848', 'رها شدن', 'rahā shodan', '178', 'رها ', 'رها شد', 'رها شو', 'رها شده ', 'رها شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('849', 'ره بری کردن', 'rah-bari kardan', '215', 'ره بری ', 'ره بری کرد', 'ره بری کن', 'ره بری کرده ', 'ره بری کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('850', 'رهن گذاشتن', 'rahn gozāshtan', '224', 'رهن ', 'رهن گذاشت', 'رهن گذار', 'رهن گذاشته ', 'رهن گذاشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('851', 'ریشه دواندن', 'rishe davāndan', '132', 'ریشه ', 'ریشه دواند', 'ریشه دوان', 'ریشه دوانده ', 'ریشه دوانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('852', 'ریشه دووندن', 'rishe davundan', '133', 'ریشه ', 'ریشه دووند', 'ریشه دوون', 'ریشه دوونده ', 'ریشه دوونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('853', 'زجر کشیدن', 'zajr keshidan', '218', 'زجر ', 'زجر کشید', 'زجر کش', 'زجر کشیده ', 'زجر کشیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('854', 'زحمت کشیدن', 'zahmat keshidan', '218', 'زحمت ', 'زحمت کشید', 'زحمت کش', 'زحمت کشیده ', 'زحمت کشیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('855', 'زرد شدن', 'zard shodan', '178', 'زرد ', 'زرد شد', 'زرد شو', 'زرد شده ', 'زرد شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('856', 'زمین خوردن', 'zamin khordan', '122', 'زمین ', 'زمین خورد', 'زمین خور', 'زمین خورده ', 'زمین خورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('857', 'زن گرفتن', 'zan gereftan', '228', 'زن ', 'زن گرفت', 'زن گیر', 'زن گرفته ', 'زن گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('858', 'زناشویی کردن', 'zan-ā-shui kardan', '215', 'زناشویی ', 'زناشویی کرد', 'زناشویی کن', 'زناشویی کرده ', 'زناشویی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('859', 'زندگی کردن', 'zendegi kardan', '215', 'زندگی ', 'زندگی کرد', 'زندگی کن', 'زندگی کرده ', 'زندگی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('860', 'زنگ زدن', 'zang zadan', '154', 'زنگ ', 'زنگ زد', 'زنگ زن', 'زنگ زده ', 'زنگ زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('861', 'زور بکار بردن', 'zur be-kār bordan', '52', 'زور بکار ', 'زور بکار برد', 'زور بکار بر', 'زور بکار برده ', 'زور بکار برده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('862', 'زیر خنده زدن', 'zir-e khande zadan', '154', 'زیر خنده ', 'زیر خنده زد', 'زیر خنده زن', 'زیر خنده زده ', 'زیر خنده زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('863', 'زیر منگنه گذاشتن', 'zir-e mangane gozāshtan', '224', 'زیر منگنه ', 'زیر منگنه گذاشت', 'زیر منگنه گذار', 'زیر منگنه گذاشته ', 'زیر منگنه گذاشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('864', 'ژست گرفتن', 'zhest gereftan', '228', 'ژست ', 'ژست گرفت', 'ژست گیر', 'ژست گرفته ', 'ژست گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('865', 'ژل زدن', 'zhel zadan', '154', 'ژل ', 'ژل زد', 'ژل زن', 'ژل زده ', 'ژل زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('866', 'ژنده شدن', 'zhende shodan', '178', 'ژنده ', 'ژنده شد', 'ژنده شو', 'ژنده شده ', 'ژنده شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('867', 'ژولیده شدن', 'zhulide shodan', '178', 'ژولیده ', 'ژولیده شد', 'ژولیده شو', 'ژولیده شده ', 'ژولیده شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('868', 'ژیمناستیک بازی کردن', 'zhimnāstik bāzi kardan', '215', 'ژیمناستیک بازی ', 'ژیمناستیک بازی کرد', 'ژیمناستیک بازی کن', 'ژیمناستیک بازی کرده ', 'ژیمناستیک بازی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('869', 'ژیمناستیک کار کردن', 'zhimnāstik kār kardan', '215', 'ژیمناستیک کار ', 'ژیمناستیک کار کرد', 'ژیمناستیک کار کن', 'ژیمناستیک کار کرده ', 'ژیمناستیک کار کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('870', 'سال داشتن', 'sāl dāshtan', '124', 'سال ', 'سال داشت', 'سال دار', 'سال داشته ', 'سال داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('871', 'سؤال پرسیدن', 'soāl porsidan', '62', 'سؤال ', 'سؤال پرسید', 'سؤال پرس', 'سؤال پرسیده ', 'سؤال پرسیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('872', 'سؤال داشتن', 'soāl dāshtan', '124', 'سؤال ', 'سؤال داشت', 'سؤال دار', 'سؤال داشته ', 'سؤال داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('873', 'سؤال کردن', 'soāl kardan', '215', 'سؤال ', 'سؤال کرد', 'سؤال کن', 'سؤال کرده ', 'سؤال کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('874', 'سبز شدن', 'sabz shodan', '178', 'سبز ', 'سبز شد', 'سبز شو', 'سبز شده ', 'سبز شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('875', 'سپاس گزاری کردن', 'sepās-gozāri kardan', '215', 'سپاس گزاری ', 'سپاس گزاری کرد', 'سپاس گزاری کن', 'سپاس گزاری کرده ', 'سپاس گزاری کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('876', 'سپری کردن', 'separi kardan', '215', 'سپری ', 'سپری کرد', 'سپری کن', 'سپری کرده ', 'سپری کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('877', 'ستم دیدن', 'setam didan', '138', 'ستم ', 'ستم دید', 'ستم بین', 'ستم دیده ', 'ستم دیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('878', 'ستم کردن', 'setam kardan', '215', 'ستم ', 'ستم کرد', 'ستم کن', 'ستم کرده ', 'ستم کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('879', 'ستم کشیدن', 'setam keshidan', '218', 'ستم ', 'ستم کشید', 'ستم کش', 'ستم کشیده ', 'ستم کشیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('880', 'ستم کاری کردن', 'setam-kāri kardan', '215', 'ستم کاری ', 'ستم کاری کرد', 'ستم کاری کن', 'ستم کاری کرده ', 'ستم کاری کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('881', 'ستم گری کردن', 'setam-gari kardan', '215', 'ستم گری ', 'ستم گری کرد', 'ستم گری کن', 'ستم گری کرده ', 'ستم گری کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('882', 'سخن گفتن', 'sokhan goftan', '240', 'سخن ', 'سخن گفت', 'سخن گو', 'سخن گفته ', 'سخن گفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('883', 'سد بستن', 'sadd bastan', '54', 'سد ', 'سد بست', 'سد بند', 'سد بسته ', 'سد بسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('884', 'سد بستن', 'sad bastan', '54', 'سد ', 'سد بست', 'سد بند', 'سد بسته ', 'سد بسته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('885', 'سد جوع کردن', 'sadd-e jaw` kardan', '215', 'سد جوع ', 'سد جوع کرد', 'سد جوع کن', 'سد جوع کرده ', 'سد جوع کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('886', 'سد کردن', 'sadd kardan', '215', 'سد ', 'سد کرد', 'سد کن', 'سد کرده ', 'سد کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('887', 'سد کردن', 'sad kardan', '215', 'سد ', 'سد کرد', 'سد کن', 'سد کرده ', 'سد کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('888', 'سر خوردن', 'sor khordan', '122', 'سر ', 'سر خورد', 'سر خور', 'سر خورده ', 'سر خورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('889', 'سر در آوردن', 'sar dar āvardan', '19', 'سر در ', 'سر در آورد', 'سر در آور', 'سر در آورده ', 'سر در آورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('890', 'سر در آوردن', 'sar dar āvordan', '20', 'سر در ', 'سر در آورد', 'سر در آور', 'سر در آورده ', 'سر در آورده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('891', 'سر زدن', 'sar zadan', '154', 'سر ', 'سر زد', 'سر زن', 'سر زده ', 'سر زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('892', 'سربلند شدن', 'sar-boland shodan', '178', 'سربلند ', 'سربلند شد', 'سربلند شو', 'سربلند شده ', 'سربلند شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('893', 'سربلن شدن', 'sar-bolan shodan', '178', 'سربلن ', 'سربلن شد', 'سربلن شو', 'سربلن شده ', 'سربلن شده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('894', 'سربه سر گذاشتن', 'sar be sar gozāshtan', '224', 'سربه سر ', 'سربه سر گذاشت', 'سربه سر گذار', 'سربه سر گذاشته ', 'سربه سر گذاشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('895', 'سرکوب کردن', 'sar-kub kardan', '215', 'سرکوب ', 'سرکوب کرد', 'سرکوب کن', 'سرکوب کرده ', 'سرکوب کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('896', 'سری به چیزی زدن', 'sari be chizi zadan', '154', 'سری به چیزی ', 'سری به چیزی زد', 'سری به چیزی زن', 'سری به چیزی زده ', 'سری به چیزی زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('897', 'سعی کردن', 'sa`y kardan', '215', 'سعی ', 'سعی کرد', 'سعی کن', 'سعی کرده ', 'سعی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('898', 'سفارش کردن', 'sefāresh kardan', '215', 'سفارش ', 'سفارش کرد', 'سفارش کن', 'سفارش کرده ', 'سفارش کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('899', 'سفر کردن', 'safar kardan', '215', 'سفر ', 'سفر کرد', 'سفر کن', 'سفر کرده ', 'سفر کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('900', 'سلام رساندن', 'salām resāndan', '142', 'سلام ', 'سلام رساند', 'سلام رسان', 'سلام رسانده ', 'سلام رسانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('901', 'سلام کردن', 'salām kardan', '215', 'سلام ', 'سلام کرد', 'سلام کن', 'سلام کرده ', 'سلام کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('902', 'سلام وعلیک با کسی داشتن', 'salām-o-`alayk bā kasi dāshtan', '124', 'سلام وعلیک با کسی ', 'سلام وعلیک با کسی داشت', 'سلام وعلیک با کسی دار', 'سلام وعلیک با کسی داشته ', 'سلام وعلیک با کسی داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('903', 'سلام وعلیک با کسی داشتن', 'salām-o-aleik bā kasi dāshtan', '124', 'سلام وعلیک با کسی ', 'سلام وعلیک با کسی داشت', 'سلام وعلیک با کسی دار', 'سلام وعلیک با کسی داشته ', 'سلام وعلیک با کسی داشته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('904', 'سلام وعلیک کردن', 'salām-o `alayk kardan', '215', 'سلام وعلیک ', 'سلام وعلیک کرد', 'سلام وعلیک کن', 'سلام وعلیک کرده ', 'سلام وعلیک کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('905', 'سلمانی شدن', 'salmāni shodan', '178', 'سلمانی ', 'سلمانی شد', 'سلمانی شو', 'سلمانی شده ', 'سلمانی شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('906', 'سلمونی شدن', 'salmuni shodan', '178', 'سلمونی ', 'سلمونی شد', 'سلمونی شو', 'سلمونی شده ', 'سلمونی شده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('907', 'سلمانی کردن', 'salmāni kardan', '215', 'سلمانی ', 'سلمانی کرد', 'سلمانی کن', 'سلمانی کرده ', 'سلمانی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('908', 'سلمونی کردن', 'salmuni kardan', '215', 'سلمونی ', 'سلمونی کرد', 'سلمونی کن', 'سلمونی کرده ', 'سلمونی کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('909', 'سوار شدن', 'savār shodan', '178', 'سوار ', 'سوار شد', 'سوار شو', 'سوار شده ', 'سوار شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('910', 'سوار کردن', 'savār kardan', '215', 'سوار ', 'سوار کرد', 'سوار کن', 'سوار کرده ', 'سوار کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('911', 'سوق دادن', 'sawq dādan', '123', 'سوق ', 'سوق داد', 'سوق ده', 'سوق داده ', 'سوق داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('912', 'سوق دادن', 'sowgh dādan', '123', 'سوق ', 'سوق داد', 'سوق ده', 'سوق داده ', 'سوق داده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('913', 'سیاحت کردن', 'siāhat kardan', '215', 'سیاحت ', 'سیاحت کرد', 'سیاحت کن', 'سیاحت کرده ', 'سیاحت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('914', 'سیاست کردن', 'siāsat kardan', '215', 'سیاست ', 'سیاست کرد', 'سیاست کن', 'سیاست کرده ', 'سیاست کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('915', 'سی جی زدن', 'si-ji zadan', '154', 'سی جی ', 'سی جی زد', 'سی جی زن', 'سی جی زده ', 'سی جی زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('916', 'سیگار کشیدن', 'sigār keshidan', '218', 'سیگار ', 'سیگار کشید', 'سیگار کش', 'سیگار کشیده ', 'سیگار کشیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('917', 'شام خوردن', 'shām khordan', '122', 'شام ', 'شام خورد', 'شام خور', 'شام خورده ', 'شام خورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('918', 'شانه زدن', 'shāne zadan', '154', 'شانه ', 'شانه زد', 'شانه زن', 'شانه زده ', 'شانه زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('919', 'شونه زدن', 'shune zadan', '154', 'شونه ', 'شونه زد', 'شونه زن', 'شونه زده ', 'شونه زده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('920', 'شانه کردن', 'shāne kardan', '215', 'شانه ', 'شانه کرد', 'شانه کن', 'شانه کرده ', 'شانه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('921', 'شونه کردن', 'shune kardan', '215', 'شونه ', 'شونه کرد', 'شونه کن', 'شونه کرده ', 'شونه کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('922', 'شتاب کردن', 'shetāb kardan', '215', 'شتاب ', 'شتاب کرد', 'شتاب کن', 'شتاب کرده ', 'شتاب کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('923', 'شرح دادن', 'sharh dādan', '123', 'شرح ', 'شرح داد', 'شرح ده', 'شرح داده ', 'شرح داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('924', 'شرح وبست دادن', 'sharh-o bast dādan', '123', 'شرح وبست ', 'شرح وبست داد', 'شرح وبست ده', 'شرح وبست داده ', 'شرح وبست داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('925', 'شرح وتفصیل دادن', 'sharh-o tafsil dādan', '123', 'شرح وتفصیل ', 'شرح وتفصیل داد', 'شرح وتفصیل ده', 'شرح وتفصیل داده ', 'شرح وتفصیل داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('926', 'شروع شدن', 'shoru` shodan', '178', 'شروع ', 'شروع شد', 'شروع شو', 'شروع شده ', 'شروع شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('927', 'شرو شدن', 'shoru shodan', '178', 'شرو ', 'شرو شد', 'شرو شو', 'شرو شده ', 'شرو شده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('928', 'شروع کردن', 'shoru` kardan', '215', 'شروع ', 'شروع کرد', 'شروع کن', 'شروع کرده ', 'شروع کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('929', 'شرو کردن', 'shoru kardan', '215', 'شرو ', 'شرو کرد', 'شرو کن', 'شرو کرده ', 'شرو کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('930', 'شریک کردن', 'sharik kardan', '215', 'شریک ', 'شریک کرد', 'شریک کن', 'شریک کرده ', 'شریک کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('931', 'شست و شو کردن', 'shost-o shu kardan', '215', 'شست و شو ', 'شست و شو کرد', 'شست و شو کن', 'شست و شو کرده ', 'شست و شو کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('932', 'شطرنج بازی کردن', 'shatranj bāzi kardan', '215', 'شطرنج بازی ', 'شطرنج بازی کرد', 'شطرنج بازی کن', 'شطرنج بازی کرده ', 'شطرنج بازی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('933', 'شفاعت کردن', 'shafā`at kardan', '215', 'شفاعت ', 'شفاعت کرد', 'شفاعت کن', 'شفاعت کرده ', 'شفاعت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('934', 'شفاعت کردن', 'shefā`at kardan', '215', 'شفاعت ', 'شفاعت کرد', 'شفاعت کن', 'شفاعت کرده ', 'شفاعت کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('935', 'شکست دادن', 'shekast dādan', '123', 'شکست ', 'شکست داد', 'شکست ده', 'شکست داده ', 'شکست داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('936', 'شکنجه دادن', 'shekanje dādan', '123', 'شکنجه ', 'شکنجه داد', 'شکنجه ده', 'شکنجه داده ', 'شکنجه داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('937', 'شلاق خوردن', 'shallāq khordan', '122', 'شلاق ', 'شلاق خورد', 'شلاق خور', 'شلاق خورده ', 'شلاق خورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('938', 'شلاق خوردن', 'shallāgh khordan', '122', 'شلاق ', 'شلاق خورد', 'شلاق خور', 'شلاق خورده ', 'شلاق خورده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('939', 'شلاق زدن', 'shallāq zadan', '154', 'شلاق ', 'شلاق زد', 'شلاق زن', 'شلاق زده ', 'شلاق زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('940', 'شلاق زدن', 'shallāgh zadan', '154', 'شلاق ', 'شلاق زد', 'شلاق زن', 'شلاق زده ', 'شلاق زده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('941', 'شلوغ شدن', 'sholugh shodan', '178', 'شلوغ ', 'شلوغ شد', 'شلوغ شو', 'شلوغ شده ', 'شلوغ شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('942', 'شمع زدن', 'sham` zadan', '154', 'شمع ', 'شمع زد', 'شمع زن', 'شمع زده ', 'شمع زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('943', 'شنا کردن', 'shenā kardan', '215', 'شنا ', 'شنا کرد', 'شنا کن', 'شنا کرده ', 'شنا کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('944', 'شناوری کردن', 'shenāvari kardan', '215', 'شناوری ', 'شناوری کرد', 'شناوری کن', 'شناوری کرده ', 'شناوری کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('945', 'شوخی کردن', 'shukhi kardan', '215', 'شوخی ', 'شوخی کرد', 'شوخی کن', 'شوخی کرده ', 'شوخی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('946', 'شوهر کردن', 'shawhar kardan', '215', 'شوهر ', 'شوهر کرد', 'شوهر کن', 'شوهر کرده ', 'شوهر کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('947', 'شوهر کردن', 'showhar kardan', '215', 'شوهر ', 'شوهر کرد', 'شوهر کن', 'شوهر کرده ', 'شوهر کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('948', 'صادر شدن', 'sāder shodan', '178', 'صادر ', 'صادر شد', 'صادر شو', 'صادر شده ', 'صادر شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('949', 'صادر کردن', 'sāder kardan', '215', 'صادر ', 'صادر کرد', 'صادر کن', 'صادر کرده ', 'صادر کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('950', 'صبحانه خوردن', 'sobhāne khordan', '122', 'صبحانه ', 'صبحانه خورد', 'صبحانه خور', 'صبحانه خورده ', 'صبحانه خورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('951', 'صبونه خوردن', 'sobune khordan', '122', 'صبونه ', 'صبونه خورد', 'صبونه خور', 'صبونه خورده ', 'صبونه خورده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('952', 'صحبت کردن', 'sohbat kardan', '215', 'صحبت ', 'صحبت کرد', 'صحبت کن', 'صحبت کرده ', 'صحبت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('953', 'صبت کردن', 'sobat kardan', '215', 'صبت ', 'صبت کرد', 'صبت کن', 'صبت کرده ', 'صبت کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('954', 'صخره نوردی کردن', 'sakhre-navardi kardan', '215', 'صخره نوردی ', 'صخره نوردی کرد', 'صخره نوردی کن', 'صخره نوردی کرده ', 'صخره نوردی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('955', 'صرف کردن', 'sarf kardan', '215', 'صرف ', 'صرف کرد', 'صرف کن', 'صرف کرده ', 'صرف کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('956', 'صف کشیدن', 'saff keshidan', '218', 'صف ', 'صف کشید', 'صف کش', 'صف کشیده ', 'صف کشیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('957', 'صف کشیدن', 'saf keshidan', '218', 'صف ', 'صف کشید', 'صف کش', 'صف کشیده ', 'صف کشیده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('958', 'ضائع شدن', 'zāe` shodan', '178', 'ضائع ', 'ضائع شد', 'ضائع شو', 'ضائع شده ', 'ضائع شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('959', 'ضائع شدن', 'zāye` shodan', '178', 'ضائع ', 'ضائع شد', 'ضائع شو', 'ضائع شده ', 'ضائع شده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('960', 'ضائع کردن', 'zāe` kardan', '215', 'ضائع ', 'ضائع کرد', 'ضائع کن', 'ضائع کرده ', 'ضائع کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('961', 'ضائع کردن', 'zāye` kardan', '215', 'ضائع ', 'ضائع کرد', 'ضائع کن', 'ضائع کرده ', 'ضائع کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('962', 'ضایع شدن', 'zāye` shodan', '178', 'ضایع ', 'ضایع شد', 'ضایع شو', 'ضایع شده ', 'ضایع شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('963', 'ضایع کردن', 'zāye` kardan', '215', 'ضایع ', 'ضایع کرد', 'ضایع کن', 'ضایع کرده ', 'ضایع کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('964', 'ضبط کردن', 'zabt kardan', '215', 'ضبط ', 'ضبط کرد', 'ضبط کن', 'ضبط کرده ', 'ضبط کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('965', 'ضعیف شدن', 'za`if shodan', '178', 'ضعیف ', 'ضعیف شد', 'ضعیف شو', 'ضعیف شده ', 'ضعیف شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('966', 'ضعیف شدن', 'zaif shodan', '178', 'ضعیف ', 'ضعیف شد', 'ضعیف شو', 'ضعیف شده ', 'ضعیف شده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('967', 'ضمیمه کردن', 'zamime kardan', '215', 'ضمیمه ', 'ضمیمه کرد', 'ضمیمه کن', 'ضمیمه کرده ', 'ضمیمه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('968', 'طرح ریزی کردن', 'tarh-rizi kardan', '215', 'طرح ریزی ', 'طرح ریزی کرد', 'طرح ریزی کن', 'طرح ریزی کرده ', 'طرح ریزی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('969', 'طناب بازی کردن', 'tanāb-bāzi kardan', '215', 'طناب بازی ', 'طناب بازی کرد', 'طناب بازی کن', 'طناب بازی کرده ', 'طناب بازی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('970', 'طول کشیدن', 'tul keshidan', '218', 'طول ', 'طول کشید', 'طول کش', 'طول کشیده ', 'طول کشیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('971', 'طی کردن', 'tayy kardan', '215', 'طی ', 'طی کرد', 'طی کن', 'طی کرده ', 'طی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('972', 'طی کردن', 'tei kardan', '215', 'طی ', 'طی کرد', 'طی کن', 'طی کرده ', 'طی کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('973', 'ظاهر شدن', 'zāher shodan', '178', 'ظاهر ', 'ظاهر شد', 'ظاهر شو', 'ظاهر شده ', 'ظاهر شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('974', 'ظرف شستن', 'zarf shostan', '179', 'ظرف ', 'ظرف شست', 'ظرف شو', 'ظرف شسته ', 'ظرف شسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('975', 'ظلم کردن', 'zolm kardan', '215', 'ظلم ', 'ظلم کرد', 'ظلم کن', 'ظلم کرده ', 'ظلم کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('976', 'عاشق کسی یا چیزی بودن', '`āsheq-e kasi yā chizi budan', '55', 'عاشق کسی یا چیزی ', 'عاشق کسی یا چیزی بود', 'عاشق کسی یا چیزی باش', 'عاشق کسی یا چیزی بوده ', 'عاشق کسی یا چیزی بوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('977', 'عاشق کسی یا چیزی بودن', 'āshegh-e kasi yā chizi budan', '55', 'عاشق کسی یا چیزی ', 'عاشق کسی یا چیزی بود', 'عاشق کسی یا چیزی باش', 'عاشق کسی یا چیزی بوده ', 'عاشق کسی یا چیزی بوده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('978', 'عاشق کسی یا چیزی شدن', '`āsheq-e kasi yā chizi shodan', '178', 'عاشق کسی یا چیزی ', 'عاشق کسی یا چیزی شد', 'عاشق کسی یا چیزی شو', 'عاشق کسی یا چیزی شده ', 'عاشق کسی یا چیزی شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('979', 'عاشق کسی یا چیزی شدن', 'āshegh-e kasi yā chizi shodan', '178', 'عاشق کسی یا چیزی ', 'عاشق کسی یا چیزی شد', 'عاشق کسی یا چیزی شو', 'عاشق کسی یا چیزی شده ', 'عاشق کسی یا چیزی شده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('980', 'عرق ریختن', '`araq rikhtan', '151', 'عرق ', 'عرق ریخت', 'عرق ریز', 'عرق ریخته ', 'عرق ریخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('981', 'عرق ریختن', 'aragh rikhtan', '151', 'عرق ', 'عرق ریخت', 'عرق ریز', 'عرق ریخته ', 'عرق ریخته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('982', 'عروسی کردن', '`arusi kardan', '215', 'عروسی ', 'عروسی کرد', 'عروسی کن', 'عروسی کرده ', 'عروسی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('983', 'عروسی کردن', 'arusi kardan', '215', 'عروسی ', 'عروسی کرد', 'عروسی کن', 'عروسی کرده ', 'عروسی کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('984', 'عطسه کردن', '`atse kardan', '215', 'عطسه ', 'عطسه کرد', 'عطسه کن', 'عطسه کرده ', 'عطسه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('985', 'عطسه کردن', 'atse kardan', '215', 'عطسه ', 'عطسه کرد', 'عطسه کن', 'عطسه کرده ', 'عطسه کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('986', 'عکاسی کردن', '`akkāsi kardan', '215', 'عکاسی ', 'عکاسی کرد', 'عکاسی کن', 'عکاسی کرده ', 'عکاسی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('987', 'عکاسی کردن', 'akkāsi kardan', '215', 'عکاسی ', 'عکاسی کرد', 'عکاسی کن', 'عکاسی کرده ', 'عکاسی کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('988', 'علاقه داشتن', '`alāqe dāshtan', '124', 'علاقه ', 'علاقه داشت', 'علاقه دار', 'علاقه داشته ', 'علاقه داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('989', 'علاقه داشتن', 'alāghe dāshtan', '124', 'علاقه ', 'علاقه داشت', 'علاقه دار', 'علاقه داشته ', 'علاقه داشته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('990', 'عوضی گرفتن', '`avazi gereftan', '228', 'عوضی ', 'عوضی گرفت', 'عوضی گیر', 'عوضی گرفته ', 'عوضی گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('991', 'عوضی گرفتن', 'avazi gereftan', '228', 'عوضی ', 'عوضی گرفت', 'عوضی گیر', 'عوضی گرفته ', 'عوضی گرفته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('992', 'عینک زدن', '`aynak zadan', '154', 'عینک ', 'عینک زد', 'عینک زن', 'عینک زده ', 'عینک زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('993', 'عینک زدن', 'einak zadan', '154', 'عینک ', 'عینک زد', 'عینک زن', 'عینک زده ', 'عینک زده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('994', 'غالب آمدن', 'ghāleb āmadan', '15', 'غالب ', 'غالب آمد', 'غالب آ', 'غالب آمده ', 'غالب آمده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('995', 'غالب اومدن', 'ghāleb umadan', '16', 'غالب ', 'غالب اومد', 'غالب یا', 'غالب اومده ', 'غالب اومده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('996', 'غالب شدن', 'ghāleb shodan', '178', 'غالب ', 'غالب شد', 'غالب شو', 'غالب شده ', 'غالب شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('997', 'غذا پختن', 'ghazā pokhtan', '58', 'غذا ', 'غذا پخت', 'غذا پز', 'غذا پخته ', 'غذا پخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('998', 'غذا خوردن', 'ghazā khordan', '122', 'غذا ', 'غذا خورد', 'غذا خور', 'غذا خورده ', 'غذا خورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('999', 'غسل کردن', 'ghosl kardan', '215', 'غسل ', 'غسل کرد', 'غسل کن', 'غسل کرده ', 'غسل کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1000', 'غصه خوردن', 'ghosse khordan', '122', 'غصه ', 'غصه خورد', 'غصه خور', 'غصه خورده ', 'غصه خورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1001', 'غمگین شدن', 'ghamgin shodan', '178', 'غمگین ', 'غمگین شد', 'غمگین شو', 'غمگین شده ', 'غمگین شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1002', 'غیر مجاز کردن', 'ghayr-e mojāz kardan', '215', 'غیر مجاز ', 'غیر مجاز کرد', 'غیر مجاز کن', 'غیر مجاز کرده ', 'غیر مجاز کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1003', 'غیر مجاز کردن', 'gheir-e mojāz kardan', '215', 'غیر مجاز ', 'غیر مجاز کرد', 'غیر مجاز کن', 'غیر مجاز کرده ', 'غیر مجاز کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1004', 'غیرتی شدن', 'ghayrati shodan', '178', 'غیرتی ', 'غیرتی شد', 'غیرتی شو', 'غیرتی شده ', 'غیرتی شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1005', 'غیرتی شدن', 'gheirati shodan', '178', 'غیرتی ', 'غیرتی شد', 'غیرتی شو', 'غیرتی شده ', 'غیرتی شده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1006', 'فارغ التحصیل شدن', 'fāregh ot-tahsil shodan', '178', 'فارغ التحصیل ', 'فارغ التحصیل شد', 'فارغ التحصیل شو', 'فارغ التحصیل شده ', 'فارغ التحصیل شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1007', 'فتوکپی کردن', 'fotokopi kardan', '215', 'فتوکپی ', 'فتوکپی کرد', 'فتوکپی کن', 'فتوکپی کرده ', 'فتوکپی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1008', 'فرا رسیدن', 'farā residan', '146', 'فرا ', 'فرا رسید', 'فرا رس', 'فرا رسیده ', 'فرا رسیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1009', 'فرا گرفتن', 'farā gereftan', '228', 'فرا ', 'فرا گرفت', 'فرا گیر', 'فرا گرفته ', 'فرا گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1010', 'فرار دادن', 'farār dādan', '123', 'فرار ', 'فرار داد', 'فرار ده', 'فرار داده ', 'فرار داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1011', 'فرار کردن', 'farār kardan', '215', 'فرار ', 'فرار کرد', 'فرار کن', 'فرار کرده ', 'فرار کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1012', 'فراری دادن', 'farāri dādan', '123', 'فراری ', 'فراری داد', 'فراری ده', 'فراری داده ', 'فراری داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1013', 'فراری شدن', 'farāri shodan', '178', 'فراری ', 'فراری شد', 'فراری شو', 'فراری شده ', 'فراری شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1014', 'فراموش کردن', 'farāmush kardan', '215', 'فراموش ', 'فراموش کرد', 'فراموش کن', 'فراموش کرده ', 'فراموش کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1015', 'فراهم کردن', 'farāham kardan', '215', 'فراهم ', 'فراهم کرد', 'فراهم کن', 'فراهم کرده ', 'فراهم کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1016', 'فشار آوردن', 'feshār āvardan', '19', 'فشار ', 'فشار آورد', 'فشار آور', 'فشار آورده ', 'فشار آورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1017', 'فشار آوردن', 'feshār āvordan', '20', 'فشار ', 'فشار آورد', 'فشار آور', 'فشار آورده ', 'فشار آورده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1018', 'فضولی کردن', 'fozuli kardan', '215', 'فضولی ', 'فضولی کرد', 'فضولی کن', 'فضولی کرده ', 'فضولی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1019', 'فکر کردن', 'fekr kardan', '215', 'فکر ', 'فکر کرد', 'فکر کن', 'فکر کرده ', 'فکر کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1020', 'فک کردن', 'fek kardan', '215', 'فک ', 'فک کرد', 'فک کن', 'فک کرده ', 'فک کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1021', 'فلفل نمکی شدن', 'felfel-namaki shodan', '178', 'فلفل نمکی ', 'فلفل نمکی شد', 'فلفل نمکی شو', 'فلفل نمکی شده ', 'فلفل نمکی شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1022', 'فلک کردن', 'falak kardan', '215', 'فلک ', 'فلک کرد', 'فلک کن', 'فلک کرده ', 'فلک کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1023', 'فوت کردن', 'fawt kardan', '215', 'فوت ', 'فوت کرد', 'فوت کن', 'فوت کرده ', 'فوت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1024', 'فوت کردن', 'fowt kardan', '215', 'فوت ', 'فوت کرد', 'فوت کن', 'فوت کرده ', 'فوت کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1025', 'فوت کردن', 'fut kardan', '215', 'فوت ', 'فوت کرد', 'فوت کن', 'فوت کرده ', 'فوت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1026', 'فوتبال آمریکایی بازی کردن', 'futbāl-e āmrikāi bāzi kardan', '215', 'فوتبال آمریکایی بازی ', 'فوتبال آمریکایی بازی کرد', 'فوتبال آمریکایی بازی کن', 'فوتبال آمریکایی بازی کرده ', 'فوتبال آمریکایی بازی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1027', 'فوتبال بازی کردن', 'futbāl bāzi kardan', '215', 'فوتبال بازی ', 'فوتبال بازی کرد', 'فوتبال بازی کن', 'فوتبال بازی کرده ', 'فوتبال بازی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1028', 'فوتسال بازی کردن', 'futsāl bāzi kardan', '215', 'فوتسال بازی ', 'فوتسال بازی کرد', 'فوتسال بازی کن', 'فوتسال بازی کرده ', 'فوتسال بازی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1029', 'فیلم بر داشتن', 'film bar dāshtan', '124', 'فیلم بر ', 'فیلم بر داشت', 'فیلم بر دار', 'فیلم بر داشته ', 'فیلم بر داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1030', 'فیلم برداری کردن', 'film-bar-dāri kardan', '215', 'فیلم برداری ', 'فیلم برداری کرد', 'فیلم برداری کن', 'فیلم برداری کرده ', 'فیلم برداری کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1031', 'قائل بودن', 'qāel budan', '55', 'قائل ', 'قائل بود', 'قائل باش', 'قائل بوده ', 'قائل بوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1032', 'قائل بودن', 'ghāel budan', '55', 'قائل ', 'قائل بود', 'قائل باش', 'قائل بوده ', 'قائل بوده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1033', 'قائل شدن', 'qāel shodan', '178', 'قائل ', 'قائل شد', 'قائل شو', 'قائل شده ', 'قائل شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1034', 'قائل شدن', 'ghāel shodan', '178', 'قائل ', 'قائل شد', 'قائل شو', 'قائل شده ', 'قائل شده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1035', 'قاطی شدن', 'qāti shodan', '178', 'قاطی ', 'قاطی شد', 'قاطی شو', 'قاطی شده ', 'قاطی شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1036', 'قاطی شدن', 'ghāti shodan', '178', 'قاطی ', 'قاطی شد', 'قاطی شو', 'قاطی شده ', 'قاطی شده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1037', 'قاطی کردن', 'qāti kardan', '215', 'قاطی ', 'قاطی کرد', 'قاطی کن', 'قاطی کرده ', 'قاطی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1038', 'قاطی کردن', 'ghāti kardan', '215', 'قاطی ', 'قاطی کرد', 'قاطی کن', 'قاطی کرده ', 'قاطی کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1039', 'قاطی پاطی شدن', 'qāti-pāti shodan', '178', 'قاطی پاطی ', 'قاطی پاطی شد', 'قاطی پاطی شو', 'قاطی پاطی شده ', 'قاطی پاطی شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1040', 'قاطی پاطی شدن', 'ghāti-pāti shodan', '178', 'قاطی پاطی ', 'قاطی پاطی شد', 'قاطی پاطی شو', 'قاطی پاطی شده ', 'قاطی پاطی شده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1041', 'قاطی پاطی کردن', 'qāti-pāti kardan', '215', 'قاطی پاطی ', 'قاطی پاطی کرد', 'قاطی پاطی کن', 'قاطی پاطی کرده ', 'قاطی پاطی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1042', 'قاطی پاطی کردن', 'ghāti-pāti kardan', '215', 'قاطی پاطی ', 'قاطی پاطی کرد', 'قاطی پاطی کن', 'قاطی پاطی کرده ', 'قاطی پاطی کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1043', 'قایق سواری کردن', 'qāeq-savāri kardan', '215', 'قایق سواری ', 'قایق سواری کرد', 'قایق سواری کن', 'قایق سواری کرده ', 'قایق سواری کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1044', 'قایق سواری کردن', 'ghāegh-savāri kardan', '215', 'قایق سواری ', 'قایق سواری کرد', 'قایق سواری کن', 'قایق سواری کرده ', 'قایق سواری کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1045', 'قایم موشک بازی کردن', 'qāem-mushak-bāzi kardan', '215', 'قایم موشک بازی ', 'قایم موشک بازی کرد', 'قایم موشک بازی کن', 'قایم موشک بازی کرده ', 'قایم موشک بازی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1046', 'قایم موشک بازی کردن', 'ghāem-mushak-bāzi kardan', '215', 'قایم موشک بازی ', 'قایم موشک بازی کرد', 'قایم موشک بازی کن', 'قایم موشک بازی کرده ', 'قایم موشک بازی کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1047', 'قدردانی کردن', 'qadr-dāni kardan', '215', 'قدردانی ', 'قدردانی کرد', 'قدردانی کن', 'قدردانی کرده ', 'قدردانی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1048', 'قدغن کردن', 'qadeghan kardan', '215', 'قدغن ', 'قدغن کرد', 'قدغن کن', 'قدغن کرده ', 'قدغن کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1049', 'قدغن کردن', 'ghadeghan kardan', '215', 'قدغن ', 'قدغن کرد', 'قدغن کن', 'قدغن کرده ', 'قدغن کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1050', 'قرض گرفتن', 'qarz gereftan', '228', 'قرض ', 'قرض گرفت', 'قرض گیر', 'قرض گرفته ', 'قرض گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1051', 'قرض گرفتن', 'gharz gereftan', '228', 'قرض ', 'قرض گرفت', 'قرض گیر', 'قرض گرفته ', 'قرض گرفته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1052', 'قصه گفتن', 'qesse goftan', '240', 'قصه ', 'قصه گفت', 'قصه گو', 'قصه گفته ', 'قصه گفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1053', 'قصه گفتن', 'ghesse goftan', '240', 'قصه ', 'قصه گفت', 'قصه گو', 'قصه گفته ', 'قصه گفته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1054', 'قطع شدن', 'qat` shodan', '178', 'قطع ', 'قطع شد', 'قطع شو', 'قطع شده ', 'قطع شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1055', 'قط شدن', 'ghat shodan', '178', 'قط ', 'قط شد', 'قط شو', 'قط شده ', 'قط شده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1056', 'قطع کردن', 'qat` kardan', '215', 'قطع ', 'قطع کرد', 'قطع کن', 'قطع کرده ', 'قطع کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1057', 'قط کردن', 'ghat kardan', '215', 'قط ', 'قط کرد', 'قط کن', 'قط کرده ', 'قط کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1058', 'قفل کردن', 'qofl kardan', '215', 'قفل ', 'قفل کرد', 'قفل کن', 'قفل کرده ', 'قفل کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1059', 'قفل کردن', 'ghofl kardan', '215', 'قفل ', 'قفل کرد', 'قفل کن', 'قفل کرده ', 'قفل کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1060', 'قیمت پرسیدن', 'ghaymat porsidan', '62', 'قیمت ', 'قیمت پرسید', 'قیمت پرس', 'قیمت پرسیده ', 'قیمت پرسیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1061', 'قیمت پرسیدن', 'gheimat porsidan', '62', 'قیمت ', 'قیمت پرسید', 'قیمت پرس', 'قیمت پرسیده ', 'قیمت پرسیده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1062', 'کار کردن', 'kār kardan', '215', 'کار ', 'کار کرد', 'کار کن', 'کار کرده ', 'کار کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1063', 'کامل شدن', 'kāmel shodan', '178', 'کامل ', 'کامل شد', 'کامل شو', 'کامل شده ', 'کامل شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1064', 'کاوش کردن', 'kāvesh kardan', '215', 'کاوش ', 'کاوش کرد', 'کاوش کن', 'کاوش کرده ', 'کاوش کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1065', 'کاوش کردن', 'kāvosh kardan', '215', 'کاوش ', 'کاوش کرد', 'کاوش کن', 'کاوش کرده ', 'کاوش کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1066', 'کتاب خواندن', 'ketāb khāndan', '120', 'کتاب ', 'کتاب خواند', 'کتاب خوان', 'کتاب خوانده ', 'کتاب خوانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1067', 'کتاب خوندن', 'ketāb khundan', '121', 'کتاب ', 'کتاب خوند', 'کتاب خون', 'کتاب خونده ', 'کتاب خونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1068', 'کراوات زدن', 'kerāvāt zadan', '154', 'کراوات ', 'کراوات زد', 'کراوات زن', 'کراوات زده ', 'کراوات زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1069', 'کشت کردن', 'kesht kardan', '215', 'کشت ', 'کشت کرد', 'کشت کن', 'کشت کرده ', 'کشت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1070', 'کشت و کار کردن', 'kesht-o kār kardan', '215', 'کشت و کار ', 'کشت و کار کرد', 'کشت و کار کن', 'کشت و کار کرده ', 'کشت و کار کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1071', 'کشتی گرفتن', 'koshti gereftan', '228', 'کشتی ', 'کشتی گرفت', 'کشتی گیر', 'کشتی گرفته ', 'کشتی گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1072', 'کلنجار رفتن', 'kalanjār raftan', '149', 'کلنجار ', 'کلنجار رفت', 'کلنجار رو', 'کلنجار رفته ', 'کلنجار رفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1073', 'کمک دادن', 'komak dādan', '123', 'کمک ', 'کمک داد', 'کمک ده', 'کمک داده ', 'کمک داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1074', 'کمک رساندن', 'komak resāndan', '142', 'کمک ', 'کمک رساند', 'کمک رسان', 'کمک رسانده ', 'کمک رسانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1075', 'کمک رسوندن', 'komak resundan', '143', 'کمک ', 'کمک رسوند', 'کمک رسون', 'کمک رسونده ', 'کمک رسونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1076', 'کمک کردن', 'komak kardan', '215', 'کمک ', 'کمک کرد', 'کمک کن', 'کمک کرده ', 'کمک کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1077', 'کوتاه کردن', 'kutāh kardan', '215', 'کوتاه ', 'کوتاه کرد', 'کوتاه کن', 'کوتاه کرده ', 'کوتاه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1078', 'کوچک شدن', 'kuchak shodan', '178', 'کوچک ', 'کوچک شد', 'کوچک شو', 'کوچک شده ', 'کوچک شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1079', 'کوچیک شدن', 'kuchik shodan', '178', 'کوچیک ', 'کوچیک شد', 'کوچیک شو', 'کوچیک شده ', 'کوچیک شده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1080', 'کود دادن', 'kud dādan', '123', 'کود ', 'کود داد', 'کود ده', 'کود داده ', 'کود داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1081', 'کوشش کردن', 'kushesh kardan', '215', 'کوشش ', 'کوشش کرد', 'کوشش کن', 'کوشش کرده ', 'کوشش کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1082', 'کیفر دادن', 'kayfar dādan', '123', 'کیفر ', 'کیفر داد', 'کیفر ده', 'کیفر داده ', 'کیفر داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1083', 'کیفر دادن', 'keifar dādan', '123', 'کیفر ', 'کیفر داد', 'کیفر ده', 'کیفر داده ', 'کیفر داده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1084', 'کیفر دیدن', 'kayfar didan', '138', 'کیفر ', 'کیفر دید', 'کیفر بین', 'کیفر دیده ', 'کیفر دیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1085', 'کیفر دیدن', 'keifar didan', '138', 'کیفر ', 'کیفر دید', 'کیفر بین', 'کیفر دیده ', 'کیفر دیده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1086', 'کینه ورزیدن', 'kine varzidan', '268', 'کینه ', 'کینه ورزید', 'کینه ورز', 'کینه ورزیده ', 'کینه ورزیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1087', 'گاز دادن', 'gāz dādan', '123', 'گاز ', 'گاز داد', 'گاز ده', 'گاز داده ', 'گاز داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1088', 'گاز زدن', 'gāz zadan', '154', 'گاز ', 'گاز زد', 'گاز زن', 'گاز زده ', 'گاز زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1089', 'گاز گرفتن', 'gāz gereftan', '228', 'گاز ', 'گاز گرفت', 'گاز گیر', 'گاز گرفته ', 'گاز گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1090', 'گپ زدن', 'gap zadan', '154', 'گپ ', 'گپ زد', 'گپ زن', 'گپ زده ', 'گپ زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1091', 'گردش کردن', 'gardesh kardan', '215', 'گردش ', 'گردش کرد', 'گردش کن', 'گردش کرده ', 'گردش کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1092', 'گرفتار شدن', 'gereftār shodan', '178', 'گرفتار ', 'گرفتار شد', 'گرفتار شو', 'گرفتار شده ', 'گرفتار شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1093', 'گرو گذاشتن', 'geraw gozāshtan', '224', 'گرو ', 'گرو گذاشت', 'گرو گذار', 'گرو گذاشته ', 'گرو گذاشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1094', 'گرو گذاشتن', 'gerow gozāshtan', '224', 'گرو ', 'گرو گذاشت', 'گرو گذار', 'گرو گذاشته ', 'گرو گذاشته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1095', 'گروگان گرفتن', 'gerawgān gereftan', '228', 'گروگان ', 'گروگان گرفت', 'گروگان گیر', 'گروگان گرفته ', 'گروگان گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1096', 'گروگان گرفتن', 'gerowgān gereftan', '228', 'گروگان ', 'گروگان گرفت', 'گروگان گیر', 'گروگان گرفته ', 'گروگان گرفته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1097', 'گریه کردن', 'gerye kardan', '215', 'گریه ', 'گریه کرد', 'گریه کن', 'گریه کرده ', 'گریه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1098', 'گزارش دادن', 'gozāresh dādan', '123', 'گزارش ', 'گزارش داد', 'گزارش ده', 'گزارش داده ', 'گزارش داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1099', 'گزاف گفتن', 'gazāf goftan', '240', 'گزاف ', 'گزاف گفت', 'گزاف گو', 'گزاف گفته ', 'گزاف گفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1100', 'گستاخی کردن', 'gostākhi kardan', '215', 'گستاخی ', 'گستاخی کرد', 'گستاخی کن', 'گستاخی کرده ', 'گستاخی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1101', 'گسترده کردن', 'gostarde kardan', '215', 'گسترده ', 'گسترده کرد', 'گسترده کن', 'گسترده کرده ', 'گسترده کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1102', 'گسترش دادن', 'gostaresh dādan', '123', 'گسترش ', 'گسترش داد', 'گسترش ده', 'گسترش داده ', 'گسترش داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1103', 'گفت و شنود کردن', 'goft-o shonud kardan', '215', 'گفت و شنود ', 'گفت و شنود کرد', 'گفت و شنود کن', 'گفت و شنود کرده ', 'گفت و شنود کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1104', 'گفت و گو کردن', 'goft-o gu kardan', '215', 'گفت و گو ', 'گفت و گو کرد', 'گفت و گو کن', 'گفت و گو کرده ', 'گفت و گو کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1105', 'گفته شدن', 'gofte shodan', '178', 'گفته ', 'گفته شد', 'گفته شو', 'گفته شده ', 'گفته شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1106', 'گل دادن', 'gol dādan', '123', 'گل ', 'گل داد', 'گل ده', 'گل داده ', 'گل داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1107', 'گل زدن', 'gol zadan', '154', 'گل ', 'گل زد', 'گل زن', 'گل زده ', 'گل زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1108', 'گل کردن', 'gol kardan', '215', 'گل ', 'گل کرد', 'گل کن', 'گل کرده ', 'گل کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1109', 'گل کوچیک بازی کردن', 'gol-kuchik bāzi kardan', '215', 'گل کوچیک بازی ', 'گل کوچیک بازی کرد', 'گل کوچیک بازی کن', 'گل کوچیک بازی کرده ', 'گل کوچیک بازی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1110', 'گم کردن', 'gom kardan', '215', 'گم ', 'گم کرد', 'گم کن', 'گم کرده ', 'گم کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1111', 'گمان کردن', 'gomān kardan', '215', 'گمان ', 'گمان کرد', 'گمان کن', 'گمان کرده ', 'گمان کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1112', 'گوش دادن', 'gush dādan', '123', 'گوش ', 'گوش داد', 'گوش ده', 'گوش داده ', 'گوش داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1113', 'گوش کردن', 'gush kardan', '215', 'گوش ', 'گوش کرد', 'گوش کن', 'گوش کرده ', 'گوش کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1114', 'گوش مالی دادن', 'gush-māli dādan', '123', 'گوش مالی ', 'گوش مالی داد', 'گوش مالی ده', 'گوش مالی داده ', 'گوش مالی داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1115', 'گیتار زدن', 'gitār zadan', '154', 'گیتار ', 'گیتار زد', 'گیتار زن', 'گیتار زده ', 'گیتار زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1116', 'گیج شدن', 'gij shodan', '178', 'گیج ', 'گیج شد', 'گیج شو', 'گیج شده ', 'گیج شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1117', 'گیر آمدن', 'gir āmadan', '15', 'گیر ', 'گیر آمد', 'گیر آ', 'گیر آمده ', 'گیر آمده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1118', 'گیر اومدن', 'gir umadan', '16', 'گیر ', 'گیر اومد', 'گیر یا', 'گیر اومده ', 'گیر اومده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1119', 'گیر آوردن', 'gir āvardan', '19', 'گیر ', 'گیر آورد', 'گیر آور', 'گیر آورده ', 'گیر آورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1120', 'گیر آوردن', 'gir āvordan', '20', 'گیر ', 'گیر آورد', 'گیر آور', 'گیر آورده ', 'گیر آورده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1121', 'لازم داشتن', 'lāzem dāshtan', '124', 'لازم ', 'لازم داشت', 'لازم دار', 'لازم داشته ', 'لازم داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1122', 'لاس زدن', 'lās zadan', '154', 'لاس ', 'لاس زد', 'لاس زن', 'لاس زده ', 'لاس زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1123', 'لاغر شدن', 'lāghar shodan', '178', 'لاغر ', 'لاغر شد', 'لاغر شو', 'لاغر شده ', 'لاغر شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1124', 'لباس پوشیدن', 'lebās pushidan', '72', 'لباس ', 'لباس پوشید', 'لباس پوش', 'لباس پوشیده ', 'لباس پوشیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1125', 'لیز خوردن', 'liz khordan', '122', 'لیز ', 'لیز خورد', 'لیز خور', 'لیز خورده ', 'لیز خورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1126', 'متحیر کردن', 'motahayyer kardan', '215', 'متحیر ', 'متحیر کرد', 'متحیر کن', 'متحیر کرده ', 'متحیر کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1127', 'متحیر کردن', 'motehayyer kardan', '215', 'متحیر ', 'متحیر کرد', 'متحیر کن', 'متحیر کرده ', 'متحیر کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1128', 'متوجه بودن', 'motavajjeh budan', '55', 'متوجه ', 'متوجه بود', 'متوجه باش', 'متوجه بوده ', 'متوجه بوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1129', 'متوجه بودن', 'motevajjeh budan', '55', 'متوجه ', 'متوجه بود', 'متوجه باش', 'متوجه بوده ', 'متوجه بوده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1130', 'متوجه شدن', 'motavajjeh shodan', '178', 'متوجه ', 'متوجه شد', 'متوجه شو', 'متوجه شده ', 'متوجه شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1131', 'متوجه شدن', 'motevajjeh shodan', '178', 'متوجه ', 'متوجه شد', 'متوجه شو', 'متوجه شده ', 'متوجه شده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1132', 'متوجه کردن', 'motavajjeh kardan', '215', 'متوجه ', 'متوجه کرد', 'متوجه کن', 'متوجه کرده ', 'متوجه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1133', 'متوجه کردن', 'motevajjeh kardan', '215', 'متوجه ', 'متوجه کرد', 'متوجه کن', 'متوجه کرده ', 'متوجه کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1134', 'متوقف شدن', 'motavaqqef shodan', '178', 'متوقف ', 'متوقف شد', 'متوقف شو', 'متوقف شده ', 'متوقف شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1135', 'متوقف شدن', 'motevaqqef shodan', '178', 'متوقف ', 'متوقف شد', 'متوقف شو', 'متوقف شده ', 'متوقف شده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1136', 'متوقف کردن', 'motavaqqef kardan', '215', 'متوقف ', 'متوقف کرد', 'متوقف کن', 'متوقف کرده ', 'متوقف کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1137', 'متوقف کردن', 'motevaqqef kardan', '215', 'متوقف ', 'متوقف کرد', 'متوقف کن', 'متوقف کرده ', 'متوقف کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1138', 'متولد شدن', 'motavalled shodan', '178', 'متولد ', 'متولد شد', 'متولد شو', 'متولد شده ', 'متولد شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1139', 'متولد شدن', 'motevalled shodan', '178', 'متولد ', 'متولد شد', 'متولد شو', 'متولد شده ', 'متولد شده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1140', 'مثل زدن', 'masal zadan', '154', 'مثل ', 'مثل زد', 'مثل زن', 'مثل زده ', 'مثل زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1141', 'مجازات کردن', 'mojāzāt kardan', '215', 'مجازات ', 'مجازات کرد', 'مجازات کن', 'مجازات کرده ', 'مجازات کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1142', 'محاوره کردن', 'mohāvere kardan', '215', 'محاوره ', 'محاوره کرد', 'محاوره کن', 'محاوره کرده ', 'محاوره کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1143', 'محول کردن', 'mohavval kardan', '215', 'محول ', 'محول کرد', 'محول کن', 'محول کرده ', 'محول کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1144', 'مخلوط شدن', 'makhlut shodan', '178', 'مخلوط ', 'مخلوط شد', 'مخلوط شو', 'مخلوط شده ', 'مخلوط شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1145', 'مخلوط کردن', 'makhlut kardan', '215', 'مخلوط ', 'مخلوط کرد', 'مخلوط کن', 'مخلوط کرده ', 'مخلوط کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1146', 'مداخله کردن', 'modākhele kardan', '215', 'مداخله ', 'مداخله کرد', 'مداخله کن', 'مداخله کرده ', 'مداخله کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1147', 'مدد کردن', 'madad kardan', '215', 'مدد ', 'مدد کرد', 'مدد کن', 'مدد کرده ', 'مدد کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1148', 'مدفوع کردن', 'madfu` kardan', '215', 'مدفوع ', 'مدفوع کرد', 'مدفوع کن', 'مدفوع کرده ', 'مدفوع کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1149', 'مدفو کردن', 'madfu kardan', '215', 'مدفو ', 'مدفو کرد', 'مدفو کن', 'مدفو کرده ', 'مدفو کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1150', 'مرکب بودن', 'morakkab budan', '55', 'مرکب ', 'مرکب بود', 'مرکب باش', 'مرکب بوده ', 'مرکب بوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1151', 'مرکب شدن', 'morakkab shodan', '178', 'مرکب ', 'مرکب شد', 'مرکب شو', 'مرکب شده ', 'مرکب شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1152', 'مرکب کردن', 'morakkab kardan', '215', 'مرکب ', 'مرکب کرد', 'مرکب کن', 'مرکب کرده ', 'مرکب کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1153', 'مرور کردن', 'morur kardan', '215', 'مرور ', 'مرور کرد', 'مرور کن', 'مرور کرده ', 'مرور کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1154', 'مریض بودن', 'mariz budan', '55', 'مریض ', 'مریض بود', 'مریض باش', 'مریض بوده ', 'مریض بوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1155', 'مریض شدن', 'mariz shodan', '178', 'مریض ', 'مریض شد', 'مریض شو', 'مریض شده ', 'مریض شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1156', 'مریض کردن', 'mariz kardan', '215', 'مریض ', 'مریض کرد', 'مریض کن', 'مریض کرده ', 'مریض کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1157', 'مسافرت کردن', 'mosāferat kardan', '215', 'مسافرت ', 'مسافرت کرد', 'مسافرت کن', 'مسافرت کرده ', 'مسافرت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1158', 'مسترح رفتن', 'mostarah raftan', '149', 'مسترح ', 'مسترح رفت', 'مسترح رو', 'مسترح رفته ', 'مسترح رفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1159', 'مسترد کردن', 'mostarad kardan', '215', 'مسترد ', 'مسترد کرد', 'مسترد کن', 'مسترد کرده ', 'مسترد کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1160', 'مسواک زدن', 'mesvāk zadan', '154', 'مسواک ', 'مسواک زد', 'مسواک زن', 'مسواک زده ', 'مسواک زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1161', 'مسواک کردن', 'mesvāk kardan', '215', 'مسواک ', 'مسواک کرد', 'مسواک کن', 'مسواک کرده ', 'مسواک کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1162', 'مصرف کردن', 'masraf kardan', '215', 'مصرف ', 'مصرف کرد', 'مصرف کن', 'مصرف کرده ', 'مصرف کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1163', 'مطالعه کردن', 'motāle`e kardan', '215', 'مطالعه ', 'مطالعه کرد', 'مطالعه کن', 'مطالعه کرده ', 'مطالعه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1164', 'مطاله کردن', 'motāle kardan', '215', 'مطاله ', 'مطاله کرد', 'مطاله کن', 'مطاله کرده ', 'مطاله کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1165', 'معاشرت کردن', 'mo`āsherat kardan', '215', 'معاشرت ', 'معاشرت کرد', 'معاشرت کن', 'معاشرت کرده ', 'معاشرت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1166', 'معذرت خواستن', 'ma`zerat khāstan', '119', 'معذرت ', 'معذرت خواست', 'معذرت خواه', 'معذرت خواسته ', 'معذرت خواسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1167', 'مذرت خواستن', 'mazerat khāstan', '119', 'مذرت ', 'مذرت خواست', 'مذرت خواه', 'مذرت خواسته ', 'مذرت خواسته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1168', 'معذرت طلبیدن', 'ma`zerat talabidan', '196', 'معذرت ', 'معذرت طلبید', 'معذرت طلب', 'معذرت طلبیده ', 'معذرت طلبیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1169', 'معرفی شدن', 'mo`arrefi shodan', '178', 'معرفی ', 'معرفی شد', 'معرفی شو', 'معرفی شده ', 'معرفی شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1170', 'معرفی کردن', 'mo`arrefi kardan', '215', 'معرفی ', 'معرفی کرد', 'معرفی کن', 'معرفی کرده ', 'معرفی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1171', 'معرکه گرفتن', 'ma`reke gereftan', '228', 'معرکه ', 'معرکه گرفت', 'معرکه گیر', 'معرکه گرفته ', 'معرکه گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1172', 'مرکه گرفتن', 'mareke gereftan', '228', 'مرکه ', 'مرکه گرفت', 'مرکه گیر', 'مرکه گرفته ', 'مرکه گرفته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1173', 'مغلوب کردن', 'maghlub kardan', '215', 'مغلوب ', 'مغلوب کرد', 'مغلوب کن', 'مغلوب کرده ', 'مغلوب کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1174', 'مقلوب کردن', 'maqlub kardan', '215', 'مقلوب ', 'مقلوب کرد', 'مقلوب کن', 'مقلوب کرده ', 'مقلوب کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1175', 'مقلوب کردن', 'maghlub kardan', '215', 'مقلوب ', 'مقلوب کرد', 'مقلوب کن', 'مقلوب کرده ', 'مقلوب کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1176', 'مکالمه کردن', 'mokāleme kardan', '215', 'مکالمه ', 'مکالمه کرد', 'مکالمه کن', 'مکالمه کرده ', 'مکالمه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1177', 'ممنوع کردن', 'mamnu` kardan', '215', 'ممنوع ', 'ممنوع کرد', 'ممنوع کن', 'ممنوع کرده ', 'ممنوع کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1178', 'منجمد شدن', 'monjamed shodan', '178', 'منجمد ', 'منجمد شد', 'منجمد شو', 'منجمد شده ', 'منجمد شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1179', 'منصرف شدن', 'monsaref shodan', '178', 'منصرف ', 'منصرف شد', 'منصرف شو', 'منصرف شده ', 'منصرف شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1180', 'منصرف کردن', 'monsaref kardan', '215', 'منصرف ', 'منصرف کرد', 'منصرف کن', 'منصرف کرده ', 'منصرف کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1181', 'منع کردن', 'man` kardan', '215', 'منع ', 'منع کرد', 'منع کن', 'منع کرده ', 'منع کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1182', 'منفجر شدن', 'monfajer shodan', '178', 'منفجر ', 'منفجر شد', 'منفجر شو', 'منفجر شده ', 'منفجر شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1183', 'منفجر کردن', 'monfajer kardan', '215', 'منفجر ', 'منفجر کرد', 'منفجر کن', 'منفجر کرده ', 'منفجر کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1184', 'منکوب ساختن', 'mankub sākhtan', '159', 'منکوب ', 'منکوب ساخت', 'منکوب ساز', 'منکوب ساخته ', 'منکوب ساخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1185', 'منکوب کردن', 'mankub kardan', '215', 'منکوب ', 'منکوب کرد', 'منکوب کن', 'منکوب کرده ', 'منکوب کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1186', 'منگ کردن', 'mang kardan', '215', 'منگ ', 'منگ کرد', 'منگ کن', 'منگ کرده ', 'منگ کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1187', 'منگنه کردن', 'mangane kardan', '215', 'منگنه ', 'منگنه کرد', 'منگنه کن', 'منگنه کرده ', 'منگنه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1188', 'منگنه کردن', 'mangene kardan', '215', 'منگنه ', 'منگنه کرد', 'منگنه کن', 'منگنه کرده ', 'منگنه کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1189', 'زیر منگنه گذاشتن', 'zir-e mangene gozāshtan', '224', 'زیر منگنه ', 'زیر منگنه گذاشت', 'زیر منگنه گذار', 'زیر منگنه گذاشته ', 'زیر منگنه گذاشته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1190', 'مو بریدن', 'mu boridan', '53', 'مو ', 'مو برید', 'مو بر', 'مو بریده ', 'مو بریده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1191', 'مو تراشیدن', 'mu tarāshidan', '82', 'مو ', 'مو تراشید', 'مو تراش', 'مو تراشیده ', 'مو تراشیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1192', 'مو کوتاه کردن', 'mu kutāh kardan', '215', 'مو کوتاه ', 'مو کوتاه کرد', 'مو کوتاه کن', 'مو کوتاه کرده ', 'مو کوتاه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1193', 'مورد تجاوز قرار دادن', 'mawred-e tajāvoz qarār dādan', '123', 'مورد تجاوز قرار ', 'مورد تجاوز قرار داد', 'مورد تجاوز قرار ده', 'مورد تجاوز قرار داده ', 'مورد تجاوز قرار داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1194', 'مورد تجاوز قرار دادن', 'mowred-e tajāvoz qarār dādan', '123', 'مورد تجاوز قرار ', 'مورد تجاوز قرار داد', 'مورد تجاوز قرار ده', 'مورد تجاوز قرار داده ', 'مورد تجاوز قرار داده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1195', 'میانجی گری کردن', 'miānji-gari kardan', '215', 'میانجی گری ', 'میانجی گری کرد', 'میانجی گری کن', 'میانجی گری کرده ', 'میانجی گری کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1196', 'میونجی گری کردن', 'miunji-gari kardan', '215', 'میونجی گری ', 'میونجی گری کرد', 'میونجی گری کن', 'میونجی گری کرده ', 'میونجی گری کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1197', 'میخ زدن', 'mikh zadan', '154', 'میخ ', 'میخ زد', 'میخ زن', 'میخ زده ', 'میخ زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1198', 'نابود شدن', 'nābud shodan', '178', 'نابود ', 'نابود شد', 'نابود شو', 'نابود شده ', 'نابود شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1199', 'نابود کردن', 'nābud kardan', '215', 'نابود ', 'نابود کرد', 'نابود کن', 'نابود کرده ', 'نابود کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1200', 'ناخن چیدن', 'nākhon chidan', '105', 'ناخن ', 'ناخن چید', 'ناخن چین', 'ناخن چیده ', 'ناخن چیده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1201', 'ناخوش بودن', 'nākhosh budan', '55', 'ناخوش ', 'ناخوش بود', 'ناخوش باش', 'ناخوش بوده ', 'ناخوش بوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1202', 'ناخوش شدن', 'nākhosh shodan', '178', 'ناخوش ', 'ناخوش شد', 'ناخوش شو', 'ناخوش شده ', 'ناخوش شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1203', 'ناخوش کردن', 'nākhosh kardan', '215', 'ناخوش ', 'ناخوش کرد', 'ناخوش کن', 'ناخوش کرده ', 'ناخوش کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1204', 'ناهار خوردن', 'nāhār khordan', '122', 'ناهار ', 'ناهار خورد', 'ناهار خور', 'ناهار خورده ', 'ناهار خورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1205', 'نجات پیدا کردن', 'nejāt paydā kardan', '215', 'نجات پیدا ', 'نجات پیدا کرد', 'نجات پیدا کن', 'نجات پیدا کرده ', 'نجات پیدا کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1206', 'نشان دادن', 'neshān dādan', '123', 'نشان ', 'نشان داد', 'نشان ده', 'نشان داده ', 'نشان داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1207', 'نشون دادن', 'neshun dādan', '123', 'نشون ', 'نشون داد', 'نشون ده', 'نشون داده ', 'نشون داده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1208', 'نصب کردن', 'nasb kardan', '215', 'نصب ', 'نصب کرد', 'نصب کن', 'نصب کرده ', 'نصب کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1209', 'نقاشی کردن', 'naqqāshi kardan', '215', 'نقاشی ', 'نقاشی کرد', 'نقاشی کن', 'نقاشی کرده ', 'نقاشی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1210', 'نقاشی کردن', 'naghghāshi kardan', '215', 'نقاشی ', 'نقاشی کرد', 'نقاشی کن', 'نقاشی کرده ', 'نقاشی کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1211', 'نگاه افکندن', 'negāh afkandan', '31', 'نگاه ', 'نگاه افکند', 'نگاه افکن', 'نگاه افکنده ', 'نگاه افکنده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1212', 'نگاه انداختن', 'negāh andākhtan', '34', 'نگاه ', 'نگاه انداخت', 'نگاه انداز', 'نگاه انداخته ', 'نگاه انداخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1213', 'نیگا انداختن', 'nigā andākhtan', '34', 'نیگا ', 'نیگا انداخت', 'نیگا انداز', 'نیگا انداخته ', 'نیگا انداخته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1214', 'نگاه کردن', 'negāh kardan', '215', 'نگاه ', 'نگاه کرد', 'نگاه کن', 'نگاه کرده ', 'نگاه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1215', 'نیگا کردن', 'nigā kardan', '215', 'نیگا ', 'نیگا کرد', 'نیگا کن', 'نیگا کرده ', 'نیگا کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1216', 'نهار خوردن', 'nahār khordan', '122', 'نهار ', 'نهار خورد', 'نهار خور', 'نهار خورده ', 'نهار خورده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1217', 'نیاز داشتن', 'niāz dāshtan', '124', 'نیاز ', 'نیاز داشت', 'نیاز دار', 'نیاز داشته ', 'نیاز داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1218', 'نیش زدن', 'nish zadan', '154', 'نیش ', 'نیش زد', 'نیش زن', 'نیش زده ', 'نیش زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1219', 'وارد شدن', 'vāred shodan', '178', 'وارد ', 'وارد شد', 'وارد شو', 'وارد شده ', 'وارد شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1220', 'وارونه کردن', 'vārune kardan', '215', 'وارونه ', 'وارونه کرد', 'وارونه کن', 'وارونه کرده ', 'وارونه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1221', 'واگذار کردن', 'vāgozār kardan', '215', 'واگذار ', 'واگذار کرد', 'واگذار کن', 'واگذار کرده ', 'واگذار کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1222', 'وام گرفتن', 'vām gereftan', '228', 'وام ', 'وام گرفت', 'وام گیر', 'وام گرفته ', 'وام گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1223', 'واهمه داشتن', 'vāheme dāshtan', '124', 'واهمه ', 'واهمه داشت', 'واهمه دار', 'واهمه داشته ', 'واهمه داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1224', 'واهمه کردن', 'vāheme kardan', '215', 'واهمه ', 'واهمه کرد', 'واهمه کن', 'واهمه کرده ', 'واهمه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1225', 'ور رفتن', 'var raftan', '149', 'ور ', 'ور رفت', 'ور رو', 'ور رفته ', 'ور رفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1226', 'ورزش کردن', 'varzesh kardan', '215', 'ورزش ', 'ورزش کرد', 'ورزش کن', 'ورزش کرده ', 'ورزش کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1227', 'وساطت کردن', 'vasātat kardan', '215', 'وساطت ', 'وساطت کرد', 'وساطت کن', 'وساطت کرده ', 'وساطت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1228', 'وساطت کردن', 'vesātat kardan', '215', 'وساطت ', 'وساطت کرد', 'وساطت کن', 'وساطت کرده ', 'وساطت کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1229', 'وسعت دادن', 'vos`at dādan', '123', 'وسعت ', 'وسعت داد', 'وسعت ده', 'وسعت داده ', 'وسعت داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1230', 'وسواس داشتن', 'vasvās dāshtan', '124', 'وسواس ', 'وسواس داشت', 'وسواس دار', 'وسواس داشته ', 'وسواس داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1231', 'وسوسه شدن', 'vasvase shodan', '178', 'وسوسه ', 'وسوسه شد', 'وسوسه شو', 'وسوسه شده ', 'وسوسه شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1232', 'وسوسه کردن', 'vasvase kardan', '215', 'وسوسه ', 'وسوسه کرد', 'وسوسه کن', 'وسوسه کرده ', 'وسوسه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1233', 'وصل کردن', 'vasl kardan', '215', 'وصل ', 'وصل کرد', 'وصل کن', 'وصل کرده ', 'وصل کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1234', 'وطن ساختن', 'vatan sākhtan', '159', 'وطن ', 'وطن ساخت', 'وطن ساز', 'وطن ساخته ', 'وطن ساخته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1235', 'وطن کردن', 'vatan kardan', '215', 'وطن ', 'وطن کرد', 'وطن کن', 'وطن کرده ', 'وطن کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1236', 'ویولن زدن', 'violon zadan', '154', 'ویولن ', 'ویولن زد', 'ویولن زن', 'ویولن زده ', 'ویولن زده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1237', 'هاکی کردن', 'hāki bāzi kardan', '215', 'هاکی ', 'هاکی کرد', 'هاکی کن', 'هاکی کرده ', 'هاکی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1238', 'هجی کردن', 'hejji kardan', '215', 'هجی ', 'هجی کرد', 'هجی کن', 'هجی کرده ', 'هجی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1239', 'هدایت کردن', 'hedāyat kardan', '215', 'هدایت ', 'هدایت کرد', 'هدایت کن', 'هدایت کرده ', 'هدایت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1240', 'هدر دادن', 'hadar dādan', '123', 'هدر ', 'هدر داد', 'هدر ده', 'هدر داده ', 'هدر داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1241', 'هدر رفتن', 'hadar raftan', '149', 'هدر ', 'هدر رفت', 'هدر رو', 'هدر رفته ', 'هدر رفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1242', 'هدیه دادن', 'hadiye dādan', '123', 'هدیه ', 'هدیه داد', 'هدیه ده', 'هدیه داده ', 'هدیه داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1243', 'هدیه دادن', 'hedye dādan', '123', 'هدیه ', 'هدیه داد', 'هدیه ده', 'هدیه داده ', 'هدیه داده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1244', 'هدیه کردن', 'hadiye kardan', '215', 'هدیه ', 'هدیه کرد', 'هدیه کن', 'هدیه کرده ', 'هدیه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1245', 'هدیه کردن', 'hedye kardan', '215', 'هدیه ', 'هدیه کرد', 'هدیه کن', 'هدیه کرده ', 'هدیه کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1246', 'هذیان گفتن', 'hazyān goftan', '240', 'هذیان ', 'هذیان گفت', 'هذیان گو', 'هذیان گفته ', 'هذیان گفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1247', 'هذیون گفتن', 'haziun goftan', '240', 'هذیون ', 'هذیون گفت', 'هذیون گو', 'هذیون گفته ', 'هذیون گفته شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1248', 'هراس داشتن', 'harās dāshtan', '124', 'هراس ', 'هراس داشت', 'هراس دار', 'هراس داشته ', 'هراس داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1249', 'هرزگی کردن', 'harzegi kardan', '215', 'هرزگی ', 'هرزگی کرد', 'هرزگی کن', 'هرزگی کرده ', 'هرزگی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1250', 'هزینه کردن', 'hazine kardan', '215', 'هزینه ', 'هزینه کرد', 'هزینه کن', 'هزینه کرده ', 'هزینه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1251', 'هش داشتن', 'hosh dāshtan', '124', 'هش ', 'هش داشت', 'هش دار', 'هش داشته ', 'هش داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1252', 'هش کردن', 'hosh kardan', '215', 'هش ', 'هش کرد', 'هش کن', 'هش کرده ', 'هش کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1253', 'هشیار بودن', 'hoshyār budan', '55', 'هشیار ', 'هشیار بود', 'هشیار باش', 'هشیار بوده ', 'هشیار بوده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1254', 'هل دادن', 'hol dādan', '123', 'هل ', 'هل داد', 'هل ده', 'هل داده ', 'هل داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1255', 'هم راه شدن', 'ham-rāh shodan', '178', 'هم راه ', 'هم راه شد', 'هم راه شو', 'هم راه شده ', 'هم راه شده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1256', 'هم راه کردن', 'ham-rāh kardan', '215', 'هم راه ', 'هم راه کرد', 'هم راه کن', 'هم راه کرده ', 'هم راه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1257', 'هم راهی کردن', 'ham-rāhi kardan', '215', 'هم راهی ', 'هم راهی کرد', 'هم راهی کن', 'هم راهی کرده ', 'هم راهی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1258', 'هم کاری کردن', 'ham-kāri kardan', '215', 'هم کاری ', 'هم کاری کرد', 'هم کاری کن', 'هم کاری کرده ', 'هم کاری کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1259', 'هنگ کردن', 'hang kardan', '215', 'هنگ ', 'هنگ کرد', 'هنگ کن', 'هنگ کرده ', 'هنگ کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1260', 'هی کردن', 'hay kardan', '215', 'هی ', 'هی کرد', 'هی کن', 'هی کرده ', 'هی کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1261', 'هی کردن', 'hei kardan', '215', 'هی ', 'هی کرد', 'هی کن', 'هی کرده ', 'هی کرده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1262', 'یاد آمدن', 'yād āmadan', '15', 'یاد ', 'یاد آمد', 'یاد آ', 'یاد آمده ', 'یاد آمده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1263', 'یاد اومدن', 'yād umadan', '16', 'یاد ', 'یاد اومد', 'یاد یا', 'یاد اومده ', 'یاد اومده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1264', 'یاد رفتن', 'yād raftan', '149', 'یاد ', 'یاد رفت', 'یاد رو', 'یاد رفته ', 'یاد رفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1265', 'یاد گرفتن', 'yād gereftan', '228', 'یاد ', 'یاد گرفت', 'یاد گیر', 'یاد گرفته ', 'یاد گرفته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1266', 'یادآوری کردن', 'yād-āvari kardan', '215', 'یادآوری ', 'یادآوری کرد', 'یادآوری کن', 'یادآوری کرده ', 'یادآوری کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1267', 'یاری رساندن', 'yāri resāndan', '142', 'یاری ', 'یاری رساند', 'یاری رسان', 'یاری رسانده ', 'یاری رسانده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1268', 'یاری رسوندن', 'yāri resundan', '143', 'یاری ', 'یاری رسوند', 'یاری رسون', 'یاری رسونده ', 'یاری رسونده شدن', 'SPOKEN');
INSERT INTO `infinitive` VALUES ('1269', 'یاری کردن', 'yāri kardan', '215', 'یاری ', 'یاری کرد', 'یاری کن', 'یاری کرده ', 'یاری کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1270', 'یاوری کردن', 'yāvari kardan', '215', 'یاوری ', 'یاوری کرد', 'یاوری کن', 'یاوری کرده ', 'یاوری کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1271', 'یخ بستن', 'yakh bastan', '54', 'یخ ', 'یخ بست', 'یخ بند', 'یخ بسته ', 'یخ بسته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1272', 'یخ کردن', 'yakh kardan', '215', 'یخ ', 'یخ کرد', 'یخ کن', 'یخ کرده ', 'یخ کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1273', 'یکپارچه کردن', 'yek-pārche kardan', '215', 'یکپارچه ', 'یکپارچه کرد', 'یکپارچه کن', 'یکپارچه کرده ', 'یکپارچه کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1278', 'تأمل کردن', 'ta\\\'ammol kardan', '215', 'تأمل ', 'تأمل کرد', 'تأمل کن', 'تأمل کرده ', 'تأمل کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1277', 'تأدیب کردن', 'ta\\\'adib kardan', '215', 'تأدیب ', 'تأدیب کرد', 'تأدیب کن', 'تأدیب کرده ', 'تأدیب کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1279', 'جرأت به خرج دادن', 'jor\\\'at be kharj dādan', '123', 'جرأت به خرج ', 'جرأت به خرج داد', 'جرأت به خرج ده', 'جرأت به خرج داده ', 'جرأت به خرج داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1280', 'جرأت داشتن', 'jor\\\'at dāshtan', '124', 'جرأت ', 'جرأت داشت', 'جرأت دار', 'جرأت داشته ', 'جرأت داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1281', 'جرأت کردن', 'jor\\\'at kardan', '215', 'جرأت ', 'جرأت کرد', 'جرأت کن', 'جرأت کرده ', 'جرأت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1282', 'جرئت به خرج دادن', 'jor\\\'at be kharj dādan', '123', 'جرئت به خرج ', 'جرئت به خرج داد', 'جرئت به خرج ده', 'جرئت به خرج داده ', 'جرئت به خرج داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1283', 'جرئت داشتن', 'jor\\\'at dāshtan', '124', 'جرئت ', 'جرئت داشت', 'جرئت دار', 'جرئت داشته ', 'جرئت داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1284', 'جرئت کردن', 'jor\\\'at kardan', '215', 'جرئت ', 'جرئت کرد', 'جرئت کن', 'جرئت کرده ', 'جرئت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1547', 'جرئت کردن', 'jor\\\'at kardan', '215', 'جرئت ', 'جرئت کرد', 'جرئت کن', 'جرئت کرده ', 'جرئت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1546', 'جرئت داشتن', 'jor\\\'at dāshtan', '124', 'جرئت ', 'جرئت داشت', 'جرئت دار', 'جرئت داشته ', 'جرئت داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1545', 'جرئت به خرج دادن', 'jor\\\'at be kharj dādan', '123', 'جرئت به خرج ', 'جرئت به خرج داد', 'جرئت به خرج ده', 'جرئت به خرج داده ', 'جرئت به خرج داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1544', 'جرأت کردن', 'jor\\\'at kardan', '215', 'جرأت ', 'جرأت کرد', 'جرأت کن', 'جرأت کرده ', 'جرأت کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1543', 'جرأت داشتن', 'jor\\\'at dāshtan', '124', 'جرأت ', 'جرأت داشت', 'جرأت دار', 'جرأت داشته ', 'جرأت داشته شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1542', 'جرأت به خرج دادن', 'jor\\\'at be kharj dādan', '123', 'جرأت به خرج ', 'جرأت به خرج داد', 'جرأت به خرج ده', 'جرأت به خرج داده ', 'جرأت به خرج داده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1541', 'تأمل کردن', 'ta\\\'ammol kardan', '215', 'تأمل ', 'تأمل کرد', 'تأمل کن', 'تأمل کرده ', 'تأمل کرده شدن', 'WRITTEN');
INSERT INTO `infinitive` VALUES ('1540', 'تأدیب کردن', 'ta\\\'adib kardan', '215', 'تأدیب ', 'تأدیب کرد', 'تأدیب کن', 'تأدیب کرده ', 'تأدیب کرده شدن', 'WRITTEN');
INSERT INTO `infinitive_english_translation` VALUES ('1', '1', 'to bore');
INSERT INTO `infinitive_english_translation` VALUES ('2', '1', ' to puncture');
INSERT INTO `infinitive_english_translation` VALUES ('3', '1', ' to lance');
INSERT INTO `infinitive_english_translation` VALUES ('4', '1', ' to prick');
INSERT INTO `infinitive_english_translation` VALUES ('5', '1', ' to perforate');
INSERT INTO `infinitive_english_translation` VALUES ('6', '1', ' to give a waffle pattern');
INSERT INTO `infinitive_english_translation` VALUES ('7', '1', ' to groove');
INSERT INTO `infinitive_english_translation` VALUES ('8', '1', ' to give a tread');
INSERT INTO `infinitive_english_translation` VALUES ('9', '1', ' to granulate');
INSERT INTO `infinitive_english_translation` VALUES ('10', '1', ' to embroider');
INSERT INTO `infinitive_english_translation` VALUES ('11', '2', 'to unsheathe (sword)');
INSERT INTO `infinitive_english_translation` VALUES ('12', '2', ' to draw');
INSERT INTO `infinitive_english_translation` VALUES ('13', '2', ' to extend');
INSERT INTO `infinitive_english_translation` VALUES ('14', '2', ' to raise');
INSERT INTO `infinitive_english_translation` VALUES ('15', '2', ' to hold in position for use (weapon');
INSERT INTO `infinitive_english_translation` VALUES ('16', '2', ' musical instrument)');
INSERT INTO `infinitive_english_translation` VALUES ('17', '3', 'to adorn');
INSERT INTO `infinitive_english_translation` VALUES ('18', '3', ' to decorate');
INSERT INTO `infinitive_english_translation` VALUES ('19', '3', ' to arrange');
INSERT INTO `infinitive_english_translation` VALUES ('20', '4', 'to annoy');
INSERT INTO `infinitive_english_translation` VALUES ('21', '4', ' to torment');
INSERT INTO `infinitive_english_translation` VALUES ('22', '5', 'to test');
INSERT INTO `infinitive_english_translation` VALUES ('23', '6', 'to rest');
INSERT INTO `infinitive_english_translation` VALUES ('24', '6', ' to relax');
INSERT INTO `infinitive_english_translation` VALUES ('25', '6', ' to stop');
INSERT INTO `infinitive_english_translation` VALUES ('26', '6', ' to live comfortably');
INSERT INTO `infinitive_english_translation` VALUES ('27', '6', ' to enjoy');
INSERT INTO `infinitive_english_translation` VALUES ('28', '7', 'to become angry');
INSERT INTO `infinitive_english_translation` VALUES ('29', '7', ' to be disturbed; obs. to disturb');
INSERT INTO `infinitive_english_translation` VALUES ('30', '7', ' to make chaotic');
INSERT INTO `infinitive_english_translation` VALUES ('31', '7', ' to agitate');
INSERT INTO `infinitive_english_translation` VALUES ('32', '7', ' to make angry');
INSERT INTO `infinitive_english_translation` VALUES ('33', '7', ' to riot');
INSERT INTO `infinitive_english_translation` VALUES ('34', '8', 'to dip');
INSERT INTO `infinitive_english_translation` VALUES ('35', '8', ' to mix');
INSERT INTO `infinitive_english_translation` VALUES ('36', '8', ' to smear');
INSERT INTO `infinitive_english_translation` VALUES ('37', '8', ' to macerate');
INSERT INTO `infinitive_english_translation` VALUES ('38', '8', ' to welter');
INSERT INTO `infinitive_english_translation` VALUES ('39', '8', ' to impregnate');
INSERT INTO `infinitive_english_translation` VALUES ('40', '8', ' to pollute');
INSERT INTO `infinitive_english_translation` VALUES ('41', '9', 'to impregnate');
INSERT INTO `infinitive_english_translation` VALUES ('42', '9', ' to mix');
INSERT INTO `infinitive_english_translation` VALUES ('43', '9', ' to taint');
INSERT INTO `infinitive_english_translation` VALUES ('44', '9', ' to pollute');
INSERT INTO `infinitive_english_translation` VALUES ('45', '9', ' to contaminate; obs. to become wet');
INSERT INTO `infinitive_english_translation` VALUES ('46', '10', 'to create');
INSERT INTO `infinitive_english_translation` VALUES ('47', '11', 'lit. to stuff');
INSERT INTO `infinitive_english_translation` VALUES ('48', '11', ' to fill');
INSERT INTO `infinitive_english_translation` VALUES ('49', '11', ' to pack; obs. to imbue');
INSERT INTO `infinitive_english_translation` VALUES ('50', '11', ' to collect');
INSERT INTO `infinitive_english_translation` VALUES ('51', '11', ' to bury');
INSERT INTO `infinitive_english_translation` VALUES ('52', '12', 'lit. to stuff');
INSERT INTO `infinitive_english_translation` VALUES ('53', '12', ' to fill');
INSERT INTO `infinitive_english_translation` VALUES ('54', '12', ' to pack; obs. to imbue');
INSERT INTO `infinitive_english_translation` VALUES ('55', '12', ' to collect');
INSERT INTO `infinitive_english_translation` VALUES ('56', '12', ' to bury (variant of āgandan)');
INSERT INTO `infinitive_english_translation` VALUES ('57', '13', 'to contaminate');
INSERT INTO `infinitive_english_translation` VALUES ('58', '14', 'not found');
INSERT INTO `infinitive_english_translation` VALUES ('59', '15', 'to come Basic');
INSERT INTO `infinitive_english_translation` VALUES ('60', '16', 'to come Basic');
INSERT INTO `infinitive_english_translation` VALUES ('61', '17', 'to learn');
INSERT INTO `infinitive_english_translation` VALUES ('62', '17', ' to teach');
INSERT INTO `infinitive_english_translation` VALUES ('63', '18', 'to mix');
INSERT INTO `infinitive_english_translation` VALUES ('64', '18', ' to associate');
INSERT INTO `infinitive_english_translation` VALUES ('65', '19', 'to bring Basic');
INSERT INTO `infinitive_english_translation` VALUES ('66', '20', 'to bring Basic');
INSERT INTO `infinitive_english_translation` VALUES ('67', '21', 'to hang');
INSERT INTO `infinitive_english_translation` VALUES ('68', '21', ' to suspend');
INSERT INTO `infinitive_english_translation` VALUES ('69', '22', 'obs. to unsheathe (sword)');
INSERT INTO `infinitive_english_translation` VALUES ('70', '22', ' to draw');
INSERT INTO `infinitive_english_translation` VALUES ('71', '22', ' to extend');
INSERT INTO `infinitive_english_translation` VALUES ('72', '22', ' to raise');
INSERT INTO `infinitive_english_translation` VALUES ('73', '22', ' to hold in position for use');
INSERT INTO `infinitive_english_translation` VALUES ('74', '22', ' to draw out');
INSERT INTO `infinitive_english_translation` VALUES ('75', '22', ' to pull off');
INSERT INTO `infinitive_english_translation` VALUES ('76', '22', ' to raise');
INSERT INTO `infinitive_english_translation` VALUES ('77', '23', 'to be worth');
INSERT INTO `infinitive_english_translation` VALUES ('78', '23', ' to cost');
INSERT INTO `infinitive_english_translation` VALUES ('79', '24', 'to fall Basic');
INSERT INTO `infinitive_english_translation` VALUES ('80', '25', 'to elevate');
INSERT INTO `infinitive_english_translation` VALUES ('81', '25', ' to hoist');
INSERT INTO `infinitive_english_translation` VALUES ('82', '25', ' to exalt');
INSERT INTO `infinitive_english_translation` VALUES ('83', '26', 'to elevate');
INSERT INTO `infinitive_english_translation` VALUES ('84', '26', ' hoist');
INSERT INTO `infinitive_english_translation` VALUES ('85', '26', ' exalt');
INSERT INTO `infinitive_english_translation` VALUES ('86', '27', 'kindle');
INSERT INTO `infinitive_english_translation` VALUES ('87', '28', 'to add');
INSERT INTO `infinitive_english_translation` VALUES ('88', '28', ' to increase');
INSERT INTO `infinitive_english_translation` VALUES ('89', '29', 'to become sad');
INSERT INTO `infinitive_english_translation` VALUES ('90', '29', ' to become depressed; obs. to freeze');
INSERT INTO `infinitive_english_translation` VALUES ('91', '30', 'to press');
INSERT INTO `infinitive_english_translation` VALUES ('92', '30', ' to squeeze');
INSERT INTO `infinitive_english_translation` VALUES ('93', '31', 'to throw');
INSERT INTO `infinitive_english_translation` VALUES ('94', '31', ' to project');
INSERT INTO `infinitive_english_translation` VALUES ('95', '32', 'to fill up');
INSERT INTO `infinitive_english_translation` VALUES ('96', '32', ' to store');
INSERT INTO `infinitive_english_translation` VALUES ('97', '32', ' to hoard');
INSERT INTO `infinitive_english_translation` VALUES ('98', '33', 'to result (in)');
INSERT INTO `infinitive_english_translation` VALUES ('99', '33', ' to end up (with)');
INSERT INTO `infinitive_english_translation` VALUES ('100', '33', ' to culminate (in)');
INSERT INTO `infinitive_english_translation` VALUES ('101', '33', ' to lead (to); obs. to end');
INSERT INTO `infinitive_english_translation` VALUES ('102', '33', ' to carry out');
INSERT INTO `infinitive_english_translation` VALUES ('103', '33', ' to complete');
INSERT INTO `infinitive_english_translation` VALUES ('104', '34', 'to cast');
INSERT INTO `infinitive_english_translation` VALUES ('105', '35', 'to amass');
INSERT INTO `infinitive_english_translation` VALUES ('106', '35', ' to accumulate');
INSERT INTO `infinitive_english_translation` VALUES ('107', '35', ' to save');
INSERT INTO `infinitive_english_translation` VALUES ('108', '36', 'to plaster');
INSERT INTO `infinitive_english_translation` VALUES ('109', '36', ' to coat');
INSERT INTO `infinitive_english_translation` VALUES ('110', '37', 'to think');
INSERT INTO `infinitive_english_translation` VALUES ('111', '37', ' to reflect');
INSERT INTO `infinitive_english_translation` VALUES ('112', '37', ' to fear');
INSERT INTO `infinitive_english_translation` VALUES ('113', '38', 'to think');
INSERT INTO `infinitive_english_translation` VALUES ('114', '38', ' to imagine');
INSERT INTO `infinitive_english_translation` VALUES ('115', '39', 'to provoke');
INSERT INTO `infinitive_english_translation` VALUES ('116', '39', ' to stimulate');
INSERT INTO `infinitive_english_translation` VALUES ('117', '39', ' to instigate');
INSERT INTO `infinitive_english_translation` VALUES ('118', '40', 'to stand');
INSERT INTO `infinitive_english_translation` VALUES ('119', '40', ' to stand up Basic');
INSERT INTO `infinitive_english_translation` VALUES ('120', '41', 'to lose');
INSERT INTO `infinitive_english_translation` VALUES ('121', '41', ' to play');
INSERT INTO `infinitive_english_translation` VALUES ('122', '42', 'to rain');
INSERT INTO `infinitive_english_translation` VALUES ('123', '43', 'to rain');
INSERT INTO `infinitive_english_translation` VALUES ('124', '44', 'to rain');
INSERT INTO `infinitive_english_translation` VALUES ('125', '45', 'to weave');
INSERT INTO `infinitive_english_translation` VALUES ('126', '45', ' to braid');
INSERT INTO `infinitive_english_translation` VALUES ('127', '45', ' to fabricate');
INSERT INTO `infinitive_english_translation` VALUES ('128', '46', 'to boast');
INSERT INTO `infinitive_english_translation` VALUES ('129', '46', ' to pride oneself');
INSERT INTO `infinitive_english_translation` VALUES ('130', '46', ' to grow');
INSERT INTO `infinitive_english_translation` VALUES ('131', '47', 'to have to');
INSERT INTO `infinitive_english_translation` VALUES ('132', '47', ' to need to');
INSERT INTO `infinitive_english_translation` VALUES ('133', '47', ' must');
INSERT INTO `infinitive_english_translation` VALUES ('134', '48', 'obs. to pity');
INSERT INTO `infinitive_english_translation` VALUES ('135', '48', ' to have mercy');
INSERT INTO `infinitive_english_translation` VALUES ('136', '49', 'obs. to pity');
INSERT INTO `infinitive_english_translation` VALUES ('137', '49', ' to have mercy');
INSERT INTO `infinitive_english_translation` VALUES ('138', '50', 'to grant');
INSERT INTO `infinitive_english_translation` VALUES ('139', '50', ' to grant forgiveness Basic');
INSERT INTO `infinitive_english_translation` VALUES ('140', '51', 'to become');
INSERT INTO `infinitive_english_translation` VALUES ('141', '51', ' to suit');
INSERT INTO `infinitive_english_translation` VALUES ('142', '51', ' to befit');
INSERT INTO `infinitive_english_translation` VALUES ('143', '52', 'to carry');
INSERT INTO `infinitive_english_translation` VALUES ('144', '52', ' to lead Basic');
INSERT INTO `infinitive_english_translation` VALUES ('145', '53', 'to cut Basic');
INSERT INTO `infinitive_english_translation` VALUES ('146', '54', 'to close');
INSERT INTO `infinitive_english_translation` VALUES ('147', '54', ' to tie Basic');
INSERT INTO `infinitive_english_translation` VALUES ('148', '55', 'to be');
INSERT INTO `infinitive_english_translation` VALUES ('149', '55', ' to exist Basic');
INSERT INTO `infinitive_english_translation` VALUES ('150', '56', 'to sift');
INSERT INTO `infinitive_english_translation` VALUES ('151', '56', ' to bolt');
INSERT INTO `infinitive_english_translation` VALUES ('152', '57', 'to filter');
INSERT INTO `infinitive_english_translation` VALUES ('153', '57', ' to refine');
INSERT INTO `infinitive_english_translation` VALUES ('154', '58', 'to cook Basic');
INSERT INTO `infinitive_english_translation` VALUES ('155', '59', 'to accept');
INSERT INTO `infinitive_english_translation` VALUES ('156', '59', ' to admit');
INSERT INTO `infinitive_english_translation` VALUES ('157', '59', ' to adopt');
INSERT INTO `infinitive_english_translation` VALUES ('158', '60', 'to scatter');
INSERT INTO `infinitive_english_translation` VALUES ('159', '60', ' to disperse');
INSERT INTO `infinitive_english_translation` VALUES ('160', '61', 'to polish');
INSERT INTO `infinitive_english_translation` VALUES ('161', '61', ' to pay');
INSERT INTO `infinitive_english_translation` VALUES ('162', '61', ' to proceed');
INSERT INTO `infinitive_english_translation` VALUES ('163', '62', 'to ask');
INSERT INTO `infinitive_english_translation` VALUES ('164', '62', ' to inquire');
INSERT INTO `infinitive_english_translation` VALUES ('165', '63', 'to rear');
INSERT INTO `infinitive_english_translation` VALUES ('166', '63', ' to foster');
INSERT INTO `infinitive_english_translation` VALUES ('167', '63', ' to cherish');
INSERT INTO `infinitive_english_translation` VALUES ('168', '64', 'obs. to abstain');
INSERT INTO `infinitive_english_translation` VALUES ('169', '64', ' to keep away');
INSERT INTO `infinitive_english_translation` VALUES ('170', '65', 'to abstain');
INSERT INTO `infinitive_english_translation` VALUES ('171', '65', ' to keep away');
INSERT INTO `infinitive_english_translation` VALUES ('172', '66', 'to fly');
INSERT INTO `infinitive_english_translation` VALUES ('173', '66', ' to jump Basic');
INSERT INTO `infinitive_english_translation` VALUES ('174', '67', 'to research');
INSERT INTO `infinitive_english_translation` VALUES ('175', '67', ' to search');
INSERT INTO `infinitive_english_translation` VALUES ('176', '67', ' to investigate');
INSERT INTO `infinitive_english_translation` VALUES ('177', '67', ' to inquire');
INSERT INTO `infinitive_english_translation` VALUES ('178', '68', 'to research');
INSERT INTO `infinitive_english_translation` VALUES ('179', '68', ' to search');
INSERT INTO `infinitive_english_translation` VALUES ('180', '68', ' to investigate');
INSERT INTO `infinitive_english_translation` VALUES ('181', '68', ' to inquire');
INSERT INTO `infinitive_english_translation` VALUES ('182', '69', 'to admire');
INSERT INTO `infinitive_english_translation` VALUES ('183', '69', ' to prefer');
INSERT INTO `infinitive_english_translation` VALUES ('184', '69', ' to choose');
INSERT INTO `infinitive_english_translation` VALUES ('185', '69', ' to select');
INSERT INTO `infinitive_english_translation` VALUES ('186', '70', 'obs. to suppose');
INSERT INTO `infinitive_english_translation` VALUES ('187', '70', ' imagine');
INSERT INTO `infinitive_english_translation` VALUES ('188', '70', ' think');
INSERT INTO `infinitive_english_translation` VALUES ('189', '70', ' to consider');
INSERT INTO `infinitive_english_translation` VALUES ('190', '70', ' to take for');
INSERT INTO `infinitive_english_translation` VALUES ('191', '71', 'lit. to suppose');
INSERT INTO `infinitive_english_translation` VALUES ('192', '71', ' imagine');
INSERT INTO `infinitive_english_translation` VALUES ('193', '71', ' think');
INSERT INTO `infinitive_english_translation` VALUES ('194', '71', ' to consider');
INSERT INTO `infinitive_english_translation` VALUES ('195', '71', ' to take for');
INSERT INTO `infinitive_english_translation` VALUES ('196', '72', 'to wear');
INSERT INTO `infinitive_english_translation` VALUES ('197', '72', ' to put on Basic');
INSERT INTO `infinitive_english_translation` VALUES ('198', '73', 'to wind');
INSERT INTO `infinitive_english_translation` VALUES ('199', '73', ' to wrap');
INSERT INTO `infinitive_english_translation` VALUES ('200', '73', ' to twist');
INSERT INTO `infinitive_english_translation` VALUES ('201', '73', ' to bend');
INSERT INTO `infinitive_english_translation` VALUES ('202', '73', ' to roll up');
INSERT INTO `infinitive_english_translation` VALUES ('203', '74', 'to trim');
INSERT INTO `infinitive_english_translation` VALUES ('204', '74', ' to decorate');
INSERT INTO `infinitive_english_translation` VALUES ('205', '75', 'to trim');
INSERT INTO `infinitive_english_translation` VALUES ('206', '75', ' to decorate');
INSERT INTO `infinitive_english_translation` VALUES ('207', '75', ' to dress up');
INSERT INTO `infinitive_english_translation` VALUES ('208', '76', 'to travel');
INSERT INTO `infinitive_english_translation` VALUES ('209', '76', ' to measure');
INSERT INTO `infinitive_english_translation` VALUES ('210', '77', 'to join');
INSERT INTO `infinitive_english_translation` VALUES ('211', '78', 'to gallop');
INSERT INTO `infinitive_english_translation` VALUES ('212', '78', ' to race');
INSERT INTO `infinitive_english_translation` VALUES ('213', '78', ' to hurry');
INSERT INTO `infinitive_english_translation` VALUES ('214', '78', ' to rush');
INSERT INTO `infinitive_english_translation` VALUES ('215', '78', ' to assault');
INSERT INTO `infinitive_english_translation` VALUES ('216', '79', 'to twist');
INSERT INTO `infinitive_english_translation` VALUES ('217', '79', ' to shine');
INSERT INTO `infinitive_english_translation` VALUES ('218', '79', ' to scorch');
INSERT INTO `infinitive_english_translation` VALUES ('219', '81', 'to plant');
INSERT INTO `infinitive_english_translation` VALUES ('220', '81', ' to seed');
INSERT INTO `infinitive_english_translation` VALUES ('221', '81', ' to scatter seeds');
INSERT INTO `infinitive_english_translation` VALUES ('222', '81', ' to sow');
INSERT INTO `infinitive_english_translation` VALUES ('223', '82', 'to shave');
INSERT INTO `infinitive_english_translation` VALUES ('224', '82', ' to scrape');
INSERT INTO `infinitive_english_translation` VALUES ('225', '82', ' to cut');
INSERT INTO `infinitive_english_translation` VALUES ('226', '82', ' to sharpen');
INSERT INTO `infinitive_english_translation` VALUES ('227', '82', ' to whittle');
INSERT INTO `infinitive_english_translation` VALUES ('228', '82', ' to hew');
INSERT INTO `infinitive_english_translation` VALUES ('229', '82', ' to carve');
INSERT INTO `infinitive_english_translation` VALUES ('230', '82', ' to erase');
INSERT INTO `infinitive_english_translation` VALUES ('231', '82', ' to pare');
INSERT INTO `infinitive_english_translation` VALUES ('232', '82', ' to abrade');
INSERT INTO `infinitive_english_translation` VALUES ('233', '82', ' to grind; colloq. fig. to wear down');
INSERT INTO `infinitive_english_translation` VALUES ('234', '82', ' to forge');
INSERT INTO `infinitive_english_translation` VALUES ('235', '82', ' to bring about');
INSERT INTO `infinitive_english_translation` VALUES ('236', '82', ' to create');
INSERT INTO `infinitive_english_translation` VALUES ('237', '83', 'to frighten');
INSERT INTO `infinitive_english_translation` VALUES ('238', '84', 'to frighten');
INSERT INTO `infinitive_english_translation` VALUES ('239', '85', 'to fear');
INSERT INTO `infinitive_english_translation` VALUES ('240', '86', 'to sit');
INSERT INTO `infinitive_english_translation` VALUES ('241', '86', ' to sit down (quietly)');
INSERT INTO `infinitive_english_translation` VALUES ('242', '87', 'to be able Basic');
INSERT INTO `infinitive_english_translation` VALUES ('243', '88', 'to be able Basic');
INSERT INTO `infinitive_english_translation` VALUES ('244', '89', 'obs. to perform');
INSERT INTO `infinitive_english_translation` VALUES ('245', '89', ' to repay');
INSERT INTO `infinitive_english_translation` VALUES ('246', '89', ' to wish');
INSERT INTO `infinitive_english_translation` VALUES ('247', '89', ' to search');
INSERT INTO `infinitive_english_translation` VALUES ('248', '89', ' to amass');
INSERT INTO `infinitive_english_translation` VALUES ('249', '89', ' to acquire');
INSERT INTO `infinitive_english_translation` VALUES ('250', '90', 'sl. to milk');
INSERT INTO `infinitive_english_translation` VALUES ('251', '90', ' to swindle');
INSERT INTO `infinitive_english_translation` VALUES ('252', '91', 'to jump');
INSERT INTO `infinitive_english_translation` VALUES ('253', '91', ' to leap');
INSERT INTO `infinitive_english_translation` VALUES ('254', '92', 'to seek');
INSERT INTO `infinitive_english_translation` VALUES ('255', '92', ' to find');
INSERT INTO `infinitive_english_translation` VALUES ('256', '93', 'to move');
INSERT INTO `infinitive_english_translation` VALUES ('257', '93', ' to shake');
INSERT INTO `infinitive_english_translation` VALUES ('258', '93', ' to nod');
INSERT INTO `infinitive_english_translation` VALUES ('259', '93', ' to wag');
INSERT INTO `infinitive_english_translation` VALUES ('260', '94', 'to move');
INSERT INTO `infinitive_english_translation` VALUES ('261', '94', ' to shake');
INSERT INTO `infinitive_english_translation` VALUES ('262', '94', ' to nod');
INSERT INTO `infinitive_english_translation` VALUES ('263', '94', ' to wag');
INSERT INTO `infinitive_english_translation` VALUES ('264', '95', 'to move');
INSERT INTO `infinitive_english_translation` VALUES ('265', '95', ' to shake');
INSERT INTO `infinitive_english_translation` VALUES ('266', '95', ' to get going');
INSERT INTO `infinitive_english_translation` VALUES ('267', '96', 'to war');
INSERT INTO `infinitive_english_translation` VALUES ('268', '96', ' to fight');
INSERT INTO `infinitive_english_translation` VALUES ('269', '96', ' to wage war');
INSERT INTO `infinitive_english_translation` VALUES ('270', '96', ' to quarrel; fig. to persevere');
INSERT INTO `infinitive_english_translation` VALUES ('271', '97', 'to boil');
INSERT INTO `infinitive_english_translation` VALUES ('272', '97', ' to bring to a boil');
INSERT INTO `infinitive_english_translation` VALUES ('273', '97', ' to simmer');
INSERT INTO `infinitive_english_translation` VALUES ('274', '98', 'to boil');
INSERT INTO `infinitive_english_translation` VALUES ('275', '98', ' to bring to a boil');
INSERT INTO `infinitive_english_translation` VALUES ('276', '98', ' to simmer');
INSERT INTO `infinitive_english_translation` VALUES ('277', '99', 'to boil');
INSERT INTO `infinitive_english_translation` VALUES ('278', '99', ' to come to a boil');
INSERT INTO `infinitive_english_translation` VALUES ('279', '99', ' to gurgle');
INSERT INTO `infinitive_english_translation` VALUES ('280', '99', ' to stew');
INSERT INTO `infinitive_english_translation` VALUES ('281', '99', ' to effervesce; fig. to become agitated');
INSERT INTO `infinitive_english_translation` VALUES ('282', '99', ' to fret');
INSERT INTO `infinitive_english_translation` VALUES ('283', '99', ' to fume');
INSERT INTO `infinitive_english_translation` VALUES ('284', '100', 'to chew');
INSERT INTO `infinitive_english_translation` VALUES ('285', '101', 'obs. to seek');
INSERT INTO `infinitive_english_translation` VALUES ('286', '101', ' to find');
INSERT INTO `infinitive_english_translation` VALUES ('287', '102', 'to stick');
INSERT INTO `infinitive_english_translation` VALUES ('288', '102', ' to glue');
INSERT INTO `infinitive_english_translation` VALUES ('289', '102', ' to paste');
INSERT INTO `infinitive_english_translation` VALUES ('290', '103', 'to stick');
INSERT INTO `infinitive_english_translation` VALUES ('291', '103', ' to glue');
INSERT INTO `infinitive_english_translation` VALUES ('292', '103', ' to paste');
INSERT INTO `infinitive_english_translation` VALUES ('293', '104', 'to adhere');
INSERT INTO `infinitive_english_translation` VALUES ('294', '104', ' to stick');
INSERT INTO `infinitive_english_translation` VALUES ('295', '104', ' to be stuck (to)');
INSERT INTO `infinitive_english_translation` VALUES ('296', '104', ' to cling');
INSERT INTO `infinitive_english_translation` VALUES ('297', '104', ' to grip');
INSERT INTO `infinitive_english_translation` VALUES ('298', '105', 'to pluck');
INSERT INTO `infinitive_english_translation` VALUES ('299', '106', 'to scratch');
INSERT INTO `infinitive_english_translation` VALUES ('300', '106', ' to scrape');
INSERT INTO `infinitive_english_translation` VALUES ('301', '107', 'to scratch');
INSERT INTO `infinitive_english_translation` VALUES ('302', '107', ' to scrape');
INSERT INTO `infinitive_english_translation` VALUES ('303', '108', 'to itch');
INSERT INTO `infinitive_english_translation` VALUES ('304', '109', 'to rise');
INSERT INTO `infinitive_english_translation` VALUES ('305', '110', 'obs. to chew');
INSERT INTO `infinitive_english_translation` VALUES ('306', '110', ' to slander');
INSERT INTO `infinitive_english_translation` VALUES ('307', '111', 'to scratch');
INSERT INTO `infinitive_english_translation` VALUES ('308', '111', ' to scrape');
INSERT INTO `infinitive_english_translation` VALUES ('309', '111', ' to rasp');
INSERT INTO `infinitive_english_translation` VALUES ('310', '112', 'to scratch');
INSERT INTO `infinitive_english_translation` VALUES ('311', '112', ' to scrape');
INSERT INTO `infinitive_english_translation` VALUES ('312', '112', ' to rasp');
INSERT INTO `infinitive_english_translation` VALUES ('313', '113', 'to strut');
INSERT INTO `infinitive_english_translation` VALUES ('314', '113', ' to walk gracefully; obs. to go');
INSERT INTO `infinitive_english_translation` VALUES ('315', '113', ' to come');
INSERT INTO `infinitive_english_translation` VALUES ('316', '114', 'to buy Basic');
INSERT INTO `infinitive_english_translation` VALUES ('317', '115', 'obs. to sleep');
INSERT INTO `infinitive_english_translation` VALUES ('318', '115', ' to settle down');
INSERT INTO `infinitive_english_translation` VALUES ('319', '116', 'obs. to sleep');
INSERT INTO `infinitive_english_translation` VALUES ('320', '117', 'to laugh');
INSERT INTO `infinitive_english_translation` VALUES ('321', '117', ' to smile; obs. to cheer up');
INSERT INTO `infinitive_english_translation` VALUES ('322', '117', ' to bloom');
INSERT INTO `infinitive_english_translation` VALUES ('323', '118', 'to sleep Basic');
INSERT INTO `infinitive_english_translation` VALUES ('324', '119', 'to want Basic');
INSERT INTO `infinitive_english_translation` VALUES ('325', '120', 'to read');
INSERT INTO `infinitive_english_translation` VALUES ('326', '120', ' to call');
INSERT INTO `infinitive_english_translation` VALUES ('327', '120', ' to recite Basic');
INSERT INTO `infinitive_english_translation` VALUES ('328', '121', 'to read');
INSERT INTO `infinitive_english_translation` VALUES ('329', '121', ' to call');
INSERT INTO `infinitive_english_translation` VALUES ('330', '121', ' to recite Basic');
INSERT INTO `infinitive_english_translation` VALUES ('331', '122', 'to eat');
INSERT INTO `infinitive_english_translation` VALUES ('332', '122', ' to drink Basic');
INSERT INTO `infinitive_english_translation` VALUES ('333', '123', 'to give Basic');
INSERT INTO `infinitive_english_translation` VALUES ('334', '124', 'to have Basic');
INSERT INTO `infinitive_english_translation` VALUES ('335', '125', 'to know');
INSERT INTO `infinitive_english_translation` VALUES ('336', '125', ' to find out Basic');
INSERT INTO `infinitive_english_translation` VALUES ('337', '126', 'to know');
INSERT INTO `infinitive_english_translation` VALUES ('338', '126', ' to find out Basic');
INSERT INTO `infinitive_english_translation` VALUES ('339', '127', 'sl. to stretch out');
INSERT INTO `infinitive_english_translation` VALUES ('340', '127', ' to lie down');
INSERT INTO `infinitive_english_translation` VALUES ('341', '128', 'obs. to reap');
INSERT INTO `infinitive_english_translation` VALUES ('342', '129', 'obs. to harvest');
INSERT INTO `infinitive_english_translation` VALUES ('343', '129', ' to cut the crops');
INSERT INTO `infinitive_english_translation` VALUES ('344', '130', 'to tear');
INSERT INTO `infinitive_english_translation` VALUES ('345', '131', 'to steal');
INSERT INTO `infinitive_english_translation` VALUES ('346', '132', 'to make run');
INSERT INTO `infinitive_english_translation` VALUES ('347', '132', ' to cause to run');
INSERT INTO `infinitive_english_translation` VALUES ('348', '133', 'to make run');
INSERT INTO `infinitive_english_translation` VALUES ('349', '133', ' to cause to run');
INSERT INTO `infinitive_english_translation` VALUES ('350', '134', 'obs. to milk');
INSERT INTO `infinitive_english_translation` VALUES ('351', '135', 'to milk; fig. to exploit');
INSERT INTO `infinitive_english_translation` VALUES ('352', '136', 'to run Basic');
INSERT INTO `infinitive_english_translation` VALUES ('353', '137', 'to run Basic');
INSERT INTO `infinitive_english_translation` VALUES ('354', '138', 'to see Basic');
INSERT INTO `infinitive_english_translation` VALUES ('355', '139', 'to drive Basic');
INSERT INTO `infinitive_english_translation` VALUES ('356', '140', 'to drive Basic');
INSERT INTO `infinitive_english_translation` VALUES ('357', '141', 'to seize');
INSERT INTO `infinitive_english_translation` VALUES ('358', '141', ' to snatch');
INSERT INTO `infinitive_english_translation` VALUES ('359', '142', 'to cause to arrive');
INSERT INTO `infinitive_english_translation` VALUES ('360', '142', ' to deliver');
INSERT INTO `infinitive_english_translation` VALUES ('361', '143', 'to cause to arrive');
INSERT INTO `infinitive_english_translation` VALUES ('362', '143', ' to deliver');
INSERT INTO `infinitive_english_translation` VALUES ('363', '144', 'to grow');
INSERT INTO `infinitive_english_translation` VALUES ('364', '145', 'to be delivered');
INSERT INTO `infinitive_english_translation` VALUES ('365', '145', ' to escape');
INSERT INTO `infinitive_english_translation` VALUES ('366', '146', 'to arrive');
INSERT INTO `infinitive_english_translation` VALUES ('367', '146', ' to reach Basic');
INSERT INTO `infinitive_english_translation` VALUES ('368', '147', 'to spin');
INSERT INTO `infinitive_english_translation` VALUES ('369', '148', 'to sweep');
INSERT INTO `infinitive_english_translation` VALUES ('370', '149', 'to go Basic');
INSERT INTO `infinitive_english_translation` VALUES ('371', '150', 'to grow');
INSERT INTO `infinitive_english_translation` VALUES ('372', '151', 'to pour');
INSERT INTO `infinitive_english_translation` VALUES ('373', '151', ' to throw');
INSERT INTO `infinitive_english_translation` VALUES ('374', '151', ' to shed Basic');
INSERT INTO `infinitive_english_translation` VALUES ('375', '152', 'vulg. to shit');
INSERT INTO `infinitive_english_translation` VALUES ('376', '153', 'to bring forth');
INSERT INTO `infinitive_english_translation` VALUES ('377', '153', ' to be born');
INSERT INTO `infinitive_english_translation` VALUES ('378', '154', 'to hit Basic');
INSERT INTO `infinitive_english_translation` VALUES ('379', '155', 'to rub off');
INSERT INTO `infinitive_english_translation` VALUES ('380', '155', ' to scour');
INSERT INTO `infinitive_english_translation` VALUES ('381', '156', 'sl. to phone');
INSERT INTO `infinitive_english_translation` VALUES ('382', '156', ' to call');
INSERT INTO `infinitive_english_translation` VALUES ('383', '157', 'to live');
INSERT INTO `infinitive_english_translation` VALUES ('384', '158', 'to become disheveled');
INSERT INTO `infinitive_english_translation` VALUES ('385', '158', ' to become chaotic');
INSERT INTO `infinitive_english_translation` VALUES ('386', '158', ' to become messed up; obs. to make disheveled');
INSERT INTO `infinitive_english_translation` VALUES ('387', '158', ' to upset');
INSERT INTO `infinitive_english_translation` VALUES ('388', '159', 'to construct Basic');
INSERT INTO `infinitive_english_translation` VALUES ('389', '160', 'to rub hard');
INSERT INTO `infinitive_english_translation` VALUES ('390', '160', ' to grind');
INSERT INTO `infinitive_english_translation` VALUES ('391', '160', ' to pulverize');
INSERT INTO `infinitive_english_translation` VALUES ('392', '160', ' to rasp');
INSERT INTO `infinitive_english_translation` VALUES ('393', '160', ' to wear away; obs. to become rubbed');
INSERT INTO `infinitive_english_translation` VALUES ('394', '160', ' to become ground');
INSERT INTO `infinitive_english_translation` VALUES ('395', '161', 'to entrust');
INSERT INTO `infinitive_english_translation` VALUES ('396', '161', ' to deposit');
INSERT INTO `infinitive_english_translation` VALUES ('397', '161', ' to order');
INSERT INTO `infinitive_english_translation` VALUES ('398', '162', 'obs. to traverse');
INSERT INTO `infinitive_english_translation` VALUES ('399', '162', ' to pass');
INSERT INTO `infinitive_english_translation` VALUES ('400', '163', 'not found');
INSERT INTO `infinitive_english_translation` VALUES ('401', '164', 'to take');
INSERT INTO `infinitive_english_translation` VALUES ('402', '165', 'obs. to clean; fig. obs. to obliterate; obs. to sh');
INSERT INTO `infinitive_english_translation` VALUES ('403', '166', 'to praise');
INSERT INTO `infinitive_english_translation` VALUES ('404', '167', 'to mix');
INSERT INTO `infinitive_english_translation` VALUES ('405', '167', ' to mold');
INSERT INTO `infinitive_english_translation` VALUES ('406', '167', ' to form; obs. fig. to create; obs. to knead');
INSERT INTO `infinitive_english_translation` VALUES ('407', '168', 'to sing');
INSERT INTO `infinitive_english_translation` VALUES ('408', '168', ' to compose');
INSERT INTO `infinitive_english_translation` VALUES ('409', '168', ' to recite');
INSERT INTO `infinitive_english_translation` VALUES ('410', '169', 'to slide');
INSERT INTO `infinitive_english_translation` VALUES ('411', '169', ' to skid');
INSERT INTO `infinitive_english_translation` VALUES ('412', '169', ' to slip');
INSERT INTO `infinitive_english_translation` VALUES ('413', '170', 'not found');
INSERT INTO `infinitive_english_translation` VALUES ('414', '171', 'obs. to think');
INSERT INTO `infinitive_english_translation` VALUES ('415', '171', ' to wish');
INSERT INTO `infinitive_english_translation` VALUES ('416', '171', ' to speak');
INSERT INTO `infinitive_english_translation` VALUES ('417', '171', ' to wish ill');
INSERT INTO `infinitive_english_translation` VALUES ('418', '171', ' to consult');
INSERT INTO `infinitive_english_translation` VALUES ('419', '171', ' to deliberate');
INSERT INTO `infinitive_english_translation` VALUES ('420', '172', 'to burn Basic');
INSERT INTO `infinitive_english_translation` VALUES ('421', '173', 'to rub');
INSERT INTO `infinitive_english_translation` VALUES ('422', '173', ' to grind');
INSERT INTO `infinitive_english_translation` VALUES ('423', '174', 'colloq. to piss');
INSERT INTO `infinitive_english_translation` VALUES ('424', '174', ' to pee');
INSERT INTO `infinitive_english_translation` VALUES ('425', '174', ' to urinate');
INSERT INTO `infinitive_english_translation` VALUES ('426', '175', 'obs. to befit');
INSERT INTO `infinitive_english_translation` VALUES ('427', '175', ' to merit');
INSERT INTO `infinitive_english_translation` VALUES ('428', '176', 'obs. to hurry');
INSERT INTO `infinitive_english_translation` VALUES ('429', '177', 'to hurry');
INSERT INTO `infinitive_english_translation` VALUES ('430', '178', 'to become Basic');
INSERT INTO `infinitive_english_translation` VALUES ('431', '179', 'to wash Basic');
INSERT INTO `infinitive_english_translation` VALUES ('432', '180', 'to split');
INSERT INTO `infinitive_english_translation` VALUES ('433', '180', ' to cleave');
INSERT INTO `infinitive_english_translation` VALUES ('434', '180', ' to unsew');
INSERT INTO `infinitive_english_translation` VALUES ('435', '180', ' to unstitch');
INSERT INTO `infinitive_english_translation` VALUES ('436', '180', ' to undo');
INSERT INTO `infinitive_english_translation` VALUES ('437', '180', ' to analyze');
INSERT INTO `infinitive_english_translation` VALUES ('438', '180', ' to be unstitched');
INSERT INTO `infinitive_english_translation` VALUES ('439', '181', 'obs. to split');
INSERT INTO `infinitive_english_translation` VALUES ('440', '181', ' to cleave');
INSERT INTO `infinitive_english_translation` VALUES ('441', '181', ' to unsew');
INSERT INTO `infinitive_english_translation` VALUES ('442', '181', ' to unstitch');
INSERT INTO `infinitive_english_translation` VALUES ('443', '181', ' to undo');
INSERT INTO `infinitive_english_translation` VALUES ('444', '181', ' to analyze');
INSERT INTO `infinitive_english_translation` VALUES ('445', '181', ' to be unstitched');
INSERT INTO `infinitive_english_translation` VALUES ('446', '182', 'to cause to break');
INSERT INTO `infinitive_english_translation` VALUES ('447', '182', ' to break');
INSERT INTO `infinitive_english_translation` VALUES ('448', '183', 'to cause to break');
INSERT INTO `infinitive_english_translation` VALUES ('449', '183', ' to break');
INSERT INTO `infinitive_english_translation` VALUES ('450', '184', 'to break');
INSERT INTO `infinitive_english_translation` VALUES ('451', '184', ' to become broken Basic');
INSERT INTO `infinitive_english_translation` VALUES ('452', '185', 'to open (flowers)');
INSERT INTO `infinitive_english_translation` VALUES ('453', '185', ' to cheer up');
INSERT INTO `infinitive_english_translation` VALUES ('454', '185', ' to smile');
INSERT INTO `infinitive_english_translation` VALUES ('455', '186', 'obs. to open (flowers)');
INSERT INTO `infinitive_english_translation` VALUES ('456', '186', ' to cheer up');
INSERT INTO `infinitive_english_translation` VALUES ('457', '186', ' to smile');
INSERT INTO `infinitive_english_translation` VALUES ('458', '187', 'obs. to open (flowers)');
INSERT INTO `infinitive_english_translation` VALUES ('459', '187', ' to cheer up');
INSERT INTO `infinitive_english_translation` VALUES ('460', '187', ' to smile');
INSERT INTO `infinitive_english_translation` VALUES ('461', '188', 'obs. to wait');
INSERT INTO `infinitive_english_translation` VALUES ('462', '188', ' to be patient');
INSERT INTO `infinitive_english_translation` VALUES ('463', '188', ' to tolerate');
INSERT INTO `infinitive_english_translation` VALUES ('464', '189', 'obs. to wait');
INSERT INTO `infinitive_english_translation` VALUES ('465', '189', ' to be patient');
INSERT INTO `infinitive_english_translation` VALUES ('466', '189', ' to tolerate');
INSERT INTO `infinitive_english_translation` VALUES ('467', '190', 'to count');
INSERT INTO `infinitive_english_translation` VALUES ('468', '190', ' to reckon');
INSERT INTO `infinitive_english_translation` VALUES ('469', '191', 'to be acquainted with');
INSERT INTO `infinitive_english_translation` VALUES ('470', '191', ' to recognize Basic');
INSERT INTO `infinitive_english_translation` VALUES ('471', '192', 'not found');
INSERT INTO `infinitive_english_translation` VALUES ('472', '193', 'obs. to hear');
INSERT INTO `infinitive_english_translation` VALUES ('473', '193', ' to listen');
INSERT INTO `infinitive_english_translation` VALUES ('474', '194', 'to hear Basic');
INSERT INTO `infinitive_english_translation` VALUES ('475', '195', 'colloq. to cost');
INSERT INTO `infinitive_english_translation` VALUES ('476', '195', ' to be worth');
INSERT INTO `infinitive_english_translation` VALUES ('477', '196', 'to ask');
INSERT INTO `infinitive_english_translation` VALUES ('478', '196', ' to need');
INSERT INTO `infinitive_english_translation` VALUES ('479', '196', ' to call');
INSERT INTO `infinitive_english_translation` VALUES ('480', '196', ' to invite');
INSERT INTO `infinitive_english_translation` VALUES ('481', '196', ' to summon; obs. to seek');
INSERT INTO `infinitive_english_translation` VALUES ('482', '196', ' to demand');
INSERT INTO `infinitive_english_translation` VALUES ('483', '197', 'obs. to sleep');
INSERT INTO `infinitive_english_translation` VALUES ('484', '198', 'to wear (out)');
INSERT INTO `infinitive_english_translation` VALUES ('485', '198', ' to rub (off)');
INSERT INTO `infinitive_english_translation` VALUES ('486', '198', ' to become worn');
INSERT INTO `infinitive_english_translation` VALUES ('487', '198', ' to obliterate; fig. to tire; fig. obs. to become ');
INSERT INTO `infinitive_english_translation` VALUES ('488', '199', 'to send');
INSERT INTO `infinitive_english_translation` VALUES ('489', '200', 'to wear (out)');
INSERT INTO `infinitive_english_translation` VALUES ('490', '200', ' to rub (off)');
INSERT INTO `infinitive_english_translation` VALUES ('491', '200', ' to become worn');
INSERT INTO `infinitive_english_translation` VALUES ('492', '200', ' to obliterate; fig. to tire; fig. obs. to become ');
INSERT INTO `infinitive_english_translation` VALUES ('493', '201', 'to command');
INSERT INTO `infinitive_english_translation` VALUES ('494', '202', 'to kindle');
INSERT INTO `infinitive_english_translation` VALUES ('495', '203', 'to sell Basic');
INSERT INTO `infinitive_english_translation` VALUES ('496', '204', 'to deceive');
INSERT INTO `infinitive_english_translation` VALUES ('497', '205', 'obs. to be extinguished');
INSERT INTO `infinitive_english_translation` VALUES ('498', '205', ' to be frozen');
INSERT INTO `infinitive_english_translation` VALUES ('499', '205', ' to freeze');
INSERT INTO `infinitive_english_translation` VALUES ('500', '205', ' to congeal');
INSERT INTO `infinitive_english_translation` VALUES ('501', '205', ' to grow numb');
INSERT INTO `infinitive_english_translation` VALUES ('502', '205', ' to become sad');
INSERT INTO `infinitive_english_translation` VALUES ('503', '205', ' to become depressed');
INSERT INTO `infinitive_english_translation` VALUES ('504', '206', 'to press');
INSERT INTO `infinitive_english_translation` VALUES ('505', '206', ' to squeeze Basic');
INSERT INTO `infinitive_english_translation` VALUES ('506', '207', 'to throw');
INSERT INTO `infinitive_english_translation` VALUES ('507', '207', ' to project');
INSERT INTO `infinitive_english_translation` VALUES ('508', '208', 'to make understand');
INSERT INTO `infinitive_english_translation` VALUES ('509', '208', ' to explain');
INSERT INTO `infinitive_english_translation` VALUES ('510', '209', 'to make understand');
INSERT INTO `infinitive_english_translation` VALUES ('511', '209', ' to explain');
INSERT INTO `infinitive_english_translation` VALUES ('512', '210', 'to understand Basic');
INSERT INTO `infinitive_english_translation` VALUES ('513', '211', 'to be decreased');
INSERT INTO `infinitive_english_translation` VALUES ('514', '211', ' to decrease');
INSERT INTO `infinitive_english_translation` VALUES ('515', '211', ' to diminish');
INSERT INTO `infinitive_english_translation` VALUES ('516', '212', 'to plant');
INSERT INTO `infinitive_english_translation` VALUES ('517', '212', ' to sow');
INSERT INTO `infinitive_english_translation` VALUES ('518', '213', 'obs. to split');
INSERT INTO `infinitive_english_translation` VALUES ('519', '213', ' to dig');
INSERT INTO `infinitive_english_translation` VALUES ('520', '213', ' to dig up');
INSERT INTO `infinitive_english_translation` VALUES ('521', '213', ' to excavate');
INSERT INTO `infinitive_english_translation` VALUES ('522', '214', 'to excavate');
INSERT INTO `infinitive_english_translation` VALUES ('523', '214', ' to dig');
INSERT INTO `infinitive_english_translation` VALUES ('524', '214', ' to burrow');
INSERT INTO `infinitive_english_translation` VALUES ('525', '214', ' to unearth');
INSERT INTO `infinitive_english_translation` VALUES ('526', '214', ' to search');
INSERT INTO `infinitive_english_translation` VALUES ('527', '214', ' to research');
INSERT INTO `infinitive_english_translation` VALUES ('528', '214', ' to explore');
INSERT INTO `infinitive_english_translation` VALUES ('529', '214', ' to ransack; obs. to annoy');
INSERT INTO `infinitive_english_translation` VALUES ('530', '214', ' to fiddle (with)');
INSERT INTO `infinitive_english_translation` VALUES ('531', '215', 'to do Basic');
INSERT INTO `infinitive_english_translation` VALUES ('532', '216', 'to kill Basic');
INSERT INTO `infinitive_english_translation` VALUES ('533', '217', 'obs. to plant');
INSERT INTO `infinitive_english_translation` VALUES ('534', '217', ' to sow');
INSERT INTO `infinitive_english_translation` VALUES ('535', '218', 'to draw Basic');
INSERT INTO `infinitive_english_translation` VALUES ('536', '219', 'to dig');
INSERT INTO `infinitive_english_translation` VALUES ('537', '219', ' to excavate');
INSERT INTO `infinitive_english_translation` VALUES ('538', '219', ' to pull off');
INSERT INTO `infinitive_english_translation` VALUES ('539', '220', 'to beat');
INSERT INTO `infinitive_english_translation` VALUES ('540', '220', ' to hammer');
INSERT INTO `infinitive_english_translation` VALUES ('541', '220', ' to pound');
INSERT INTO `infinitive_english_translation` VALUES ('542', '220', ' to stamp');
INSERT INTO `infinitive_english_translation` VALUES ('543', '221', 'to endeavour');
INSERT INTO `infinitive_english_translation` VALUES ('544', '221', ' to try');
INSERT INTO `infinitive_english_translation` VALUES ('545', '221', ' to make an effort; obs. to war');
INSERT INTO `infinitive_english_translation` VALUES ('546', '222', 'to knock');
INSERT INTO `infinitive_english_translation` VALUES ('547', '222', ' to strike');
INSERT INTO `infinitive_english_translation` VALUES ('548', '222', ' to beat');
INSERT INTO `infinitive_english_translation` VALUES ('549', '222', ' to trample');
INSERT INTO `infinitive_english_translation` VALUES ('550', '222', ' to shake');
INSERT INTO `infinitive_english_translation` VALUES ('551', '223', 'to melt');
INSERT INTO `infinitive_english_translation` VALUES ('552', '224', 'to put');
INSERT INTO `infinitive_english_translation` VALUES ('553', '224', ' to let Basic');
INSERT INTO `infinitive_english_translation` VALUES ('554', '225', 'to pass Basic');
INSERT INTO `infinitive_english_translation` VALUES ('555', '226', 'to take sightseeing');
INSERT INTO `infinitive_english_translation` VALUES ('556', '226', ' to circulate');
INSERT INTO `infinitive_english_translation` VALUES ('557', '226', ' to rotate');
INSERT INTO `infinitive_english_translation` VALUES ('558', '226', ' to spin');
INSERT INTO `infinitive_english_translation` VALUES ('559', '226', ' to wind; fig. to manage');
INSERT INTO `infinitive_english_translation` VALUES ('560', '226', ' to change');
INSERT INTO `infinitive_english_translation` VALUES ('561', '226', ' to transform; obs. fig. to drive away');
INSERT INTO `infinitive_english_translation` VALUES ('562', '226', ' to reject');
INSERT INTO `infinitive_english_translation` VALUES ('563', '226', ' to translate');
INSERT INTO `infinitive_english_translation` VALUES ('564', '227', 'to take sightseeing');
INSERT INTO `infinitive_english_translation` VALUES ('565', '227', ' to circulate');
INSERT INTO `infinitive_english_translation` VALUES ('566', '227', ' to rotate');
INSERT INTO `infinitive_english_translation` VALUES ('567', '227', ' to spin');
INSERT INTO `infinitive_english_translation` VALUES ('568', '227', ' to wind; fig. to manage');
INSERT INTO `infinitive_english_translation` VALUES ('569', '227', ' to change');
INSERT INTO `infinitive_english_translation` VALUES ('570', '227', ' to transform; obs. fig. to drive away');
INSERT INTO `infinitive_english_translation` VALUES ('571', '227', ' to reject');
INSERT INTO `infinitive_english_translation` VALUES ('572', '227', ' to translate');
INSERT INTO `infinitive_english_translation` VALUES ('573', '228', 'to take Basic');
INSERT INTO `infinitive_english_translation` VALUES ('574', '229', 'to flee');
INSERT INTO `infinitive_english_translation` VALUES ('575', '230', 'to weep');
INSERT INTO `infinitive_english_translation` VALUES ('576', '231', 'to carry out');
INSERT INTO `infinitive_english_translation` VALUES ('577', '231', ' to perform');
INSERT INTO `infinitive_english_translation` VALUES ('578', '232', 'to choose');
INSERT INTO `infinitive_english_translation` VALUES ('579', '232', ' to prefer');
INSERT INTO `infinitive_english_translation` VALUES ('580', '233', 'to bite');
INSERT INTO `infinitive_english_translation` VALUES ('581', '233', ' to sting');
INSERT INTO `infinitive_english_translation` VALUES ('582', '234', 'not found');
INSERT INTO `infinitive_english_translation` VALUES ('583', '235', 'to break off');
INSERT INTO `infinitive_english_translation` VALUES ('584', '235', ' to disconnect');
INSERT INTO `infinitive_english_translation` VALUES ('585', '236', 'to break (off)');
INSERT INTO `infinitive_english_translation` VALUES ('586', '236', ' to become torn');
INSERT INTO `infinitive_english_translation` VALUES ('587', '236', ' to tear; obs. to become broken');
INSERT INTO `infinitive_english_translation` VALUES ('588', '237', 'obs. to open');
INSERT INTO `infinitive_english_translation` VALUES ('589', '237', ' to become opened');
INSERT INTO `infinitive_english_translation` VALUES ('590', '238', 'to turn');
INSERT INTO `infinitive_english_translation` VALUES ('591', '238', ' to turn around');
INSERT INTO `infinitive_english_translation` VALUES ('592', '238', ' to circulate');
INSERT INTO `infinitive_english_translation` VALUES ('593', '238', ' to ramble');
INSERT INTO `infinitive_english_translation` VALUES ('594', '238', ' to search');
INSERT INTO `infinitive_english_translation` VALUES ('595', '238', ' to become');
INSERT INTO `infinitive_english_translation` VALUES ('596', '239', 'to open');
INSERT INTO `infinitive_english_translation` VALUES ('597', '239', ' to become opened');
INSERT INTO `infinitive_english_translation` VALUES ('598', '240', 'to say');
INSERT INTO `infinitive_english_translation` VALUES ('599', '240', ' to speak');
INSERT INTO `infinitive_english_translation` VALUES ('600', '240', ' to compose (poetry)');
INSERT INTO `infinitive_english_translation` VALUES ('601', '240', ' to tell; sl. to invite; fig. to understand; obs. ');
INSERT INTO `infinitive_english_translation` VALUES ('602', '241', 'to appoint');
INSERT INTO `infinitive_english_translation` VALUES ('603', '242', 'sl. to become thin');
INSERT INTO `infinitive_english_translation` VALUES ('604', '242', ' to lose weight');
INSERT INTO `infinitive_english_translation` VALUES ('605', '243', 'obs. to lick');
INSERT INTO `infinitive_english_translation` VALUES ('606', '244', 'obs. to lick');
INSERT INTO `infinitive_english_translation` VALUES ('607', '245', 'to slide');
INSERT INTO `infinitive_english_translation` VALUES ('608', '245', ' to slip');
INSERT INTO `infinitive_english_translation` VALUES ('609', '245', ' to skid');
INSERT INTO `infinitive_english_translation` VALUES ('610', '245', ' to trip');
INSERT INTO `infinitive_english_translation` VALUES ('611', '245', ' to stumble');
INSERT INTO `infinitive_english_translation` VALUES ('612', '245', ' to err');
INSERT INTO `infinitive_english_translation` VALUES ('613', '246', 'to lick');
INSERT INTO `infinitive_english_translation` VALUES ('614', '247', 'to rub');
INSERT INTO `infinitive_english_translation` VALUES ('615', '247', ' to make even');
INSERT INTO `infinitive_english_translation` VALUES ('616', '247', ' to clean; fig. to punish');
INSERT INTO `infinitive_english_translation` VALUES ('617', '248', 'to rub');
INSERT INTO `infinitive_english_translation` VALUES ('618', '248', ' to smear');
INSERT INTO `infinitive_english_translation` VALUES ('619', '248', ' to massage; sl. to bump; obs. to stomp on; fig. o');
INSERT INTO `infinitive_english_translation` VALUES ('620', '248', ' to clean');
INSERT INTO `infinitive_english_translation` VALUES ('621', '249', 'to remain Basic');
INSERT INTO `infinitive_english_translation` VALUES ('622', '250', 'to remain Basic');
INSERT INTO `infinitive_english_translation` VALUES ('623', '251', 'to resemble');
INSERT INTO `infinitive_english_translation` VALUES ('624', '252', 'to die Basic');
INSERT INTO `infinitive_english_translation` VALUES ('625', '253', 'obs. to rub');
INSERT INTO `infinitive_english_translation` VALUES ('626', '253', ' to knead');
INSERT INTO `infinitive_english_translation` VALUES ('627', '254', 'obs. to rub');
INSERT INTO `infinitive_english_translation` VALUES ('628', '255', 'obs. to lament');
INSERT INTO `infinitive_english_translation` VALUES ('629', '255', ' to mourn');
INSERT INTO `infinitive_english_translation` VALUES ('630', '255', ' to weep');
INSERT INTO `infinitive_english_translation` VALUES ('631', '256', 'to groan');
INSERT INTO `infinitive_english_translation` VALUES ('632', '256', ' to moan');
INSERT INTO `infinitive_english_translation` VALUES ('633', '256', ' to lament');
INSERT INTO `infinitive_english_translation` VALUES ('634', '256', ' to complain; obs. to become sick');
INSERT INTO `infinitive_english_translation` VALUES ('635', '257', 'not found');
INSERT INTO `infinitive_english_translation` VALUES ('636', '258', 'to sit Basic');
INSERT INTO `infinitive_english_translation` VALUES ('637', '259', 'to paint');
INSERT INTO `infinitive_english_translation` VALUES ('638', '259', ' to draw');
INSERT INTO `infinitive_english_translation` VALUES ('639', '259', ' to write');
INSERT INTO `infinitive_english_translation` VALUES ('640', '260', 'to look');
INSERT INTO `infinitive_english_translation` VALUES ('641', '260', ' to see');
INSERT INTO `infinitive_english_translation` VALUES ('642', '260', ' to view');
INSERT INTO `infinitive_english_translation` VALUES ('643', '261', 'to show');
INSERT INTO `infinitive_english_translation` VALUES ('644', '261', ' to appear');
INSERT INTO `infinitive_english_translation` VALUES ('645', '261', ' to seem');
INSERT INTO `infinitive_english_translation` VALUES ('646', '262', 'to caress');
INSERT INTO `infinitive_english_translation` VALUES ('647', '262', ' to play');
INSERT INTO `infinitive_english_translation` VALUES ('648', '263', 'obs. to traverse');
INSERT INTO `infinitive_english_translation` VALUES ('649', '263', ' to roam');
INSERT INTO `infinitive_english_translation` VALUES ('650', '263', ' to wander');
INSERT INTO `infinitive_english_translation` VALUES ('651', '263', ' to navigate');
INSERT INTO `infinitive_english_translation` VALUES ('652', '263', ' to roll up');
INSERT INTO `infinitive_english_translation` VALUES ('653', '263', ' to rub together');
INSERT INTO `infinitive_english_translation` VALUES ('654', '263', ' to put aside');
INSERT INTO `infinitive_english_translation` VALUES ('655', '263', ' to leave');
INSERT INTO `infinitive_english_translation` VALUES ('656', '264', 'to write Basic');
INSERT INTO `infinitive_english_translation` VALUES ('657', '265', 'to place');
INSERT INTO `infinitive_english_translation` VALUES ('658', '265', ' to lay');
INSERT INTO `infinitive_english_translation` VALUES ('659', '265', ' to store');
INSERT INTO `infinitive_english_translation` VALUES ('660', '266', 'to hide; obs. to bury');
INSERT INTO `infinitive_english_translation` VALUES ('661', '266', ' to become hidden');
INSERT INTO `infinitive_english_translation` VALUES ('662', '267', 'to transfer');
INSERT INTO `infinitive_english_translation` VALUES ('663', '267', ' to turn over');
INSERT INTO `infinitive_english_translation` VALUES ('664', '267', ' to hand over');
INSERT INTO `infinitive_english_translation` VALUES ('665', '267', ' to entrust');
INSERT INTO `infinitive_english_translation` VALUES ('666', '267', ' to cede');
INSERT INTO `infinitive_english_translation` VALUES ('667', '267', ' to leave');
INSERT INTO `infinitive_english_translation` VALUES ('668', '267', ' to abandon');
INSERT INTO `infinitive_english_translation` VALUES ('669', '268', 'to exercise');
INSERT INTO `infinitive_english_translation` VALUES ('670', '268', ' to train');
INSERT INTO `infinitive_english_translation` VALUES ('671', '268', ' to cultivate');
INSERT INTO `infinitive_english_translation` VALUES ('672', '268', ' to knead');
INSERT INTO `infinitive_english_translation` VALUES ('673', '269', 'to blow');
INSERT INTO `infinitive_english_translation` VALUES ('674', '270', 'to fear');
INSERT INTO `infinitive_english_translation` VALUES ('675', '270', ' to be terrified');
INSERT INTO `infinitive_english_translation` VALUES ('676', '271', 'obs. to put');
INSERT INTO `infinitive_english_translation` VALUES ('677', '271', ' to leave');
INSERT INTO `infinitive_english_translation` VALUES ('678', '271', ' to leave behind');
INSERT INTO `infinitive_english_translation` VALUES ('679', '272', 'obs. to reach for');
INSERT INTO `infinitive_english_translation` VALUES ('680', '272', ' to pick up');
INSERT INTO `infinitive_english_translation` VALUES ('681', '272', ' to raise');
INSERT INTO `infinitive_english_translation` VALUES ('682', '273', 'obs. to have the power or courage');
INSERT INTO `infinitive_english_translation` VALUES ('683', '273', ' to be able');
INSERT INTO `infinitive_english_translation` VALUES ('684', '274', 'obs. to hold up');
INSERT INTO `infinitive_english_translation` VALUES ('685', '274', ' to lift');
INSERT INTO `infinitive_english_translation` VALUES ('686', '274', ' to touch');
INSERT INTO `infinitive_english_translation` VALUES ('687', '274', ' to be held');
INSERT INTO `infinitive_english_translation` VALUES ('688', '274', ' to be hanging');
INSERT INTO `infinitive_english_translation` VALUES ('689', '274', ' to bend');
INSERT INTO `infinitive_english_translation` VALUES ('690', '274', ' to intend');
INSERT INTO `infinitive_english_translation` VALUES ('691', '275', 'to find');
INSERT INTO `infinitive_english_translation` VALUES ('692', '275', ' to obtain');
INSERT INTO `infinitive_english_translation` VALUES ('693', '277', 'to drink water');
INSERT INTO `infinitive_english_translation` VALUES ('694', '277', ' to drink; colloq. fig. to cost');
INSERT INTO `infinitive_english_translation` VALUES ('695', '277', ' to originate');
INSERT INTO `infinitive_english_translation` VALUES ('696', '278', 'to shrink');
INSERT INTO `infinitive_english_translation` VALUES ('697', '278', ' to become thin');
INSERT INTO `infinitive_english_translation` VALUES ('698', '279', 'to melt');
INSERT INTO `infinitive_english_translation` VALUES ('699', '279', ' to thaw');
INSERT INTO `infinitive_english_translation` VALUES ('700', '279', ' to liquefy');
INSERT INTO `infinitive_english_translation` VALUES ('701', '279', ' to liquify');
INSERT INTO `infinitive_english_translation` VALUES ('702', '279', ' to dissolve; colloq. fig. to be ashamed');
INSERT INTO `infinitive_english_translation` VALUES ('703', '279', ' to be mortified');
INSERT INTO `infinitive_english_translation` VALUES ('704', '279', ' to become gaunt');
INSERT INTO `infinitive_english_translation` VALUES ('705', '279', ' to disappear');
INSERT INTO `infinitive_english_translation` VALUES ('706', '279', ' to be liquidated (assets)');
INSERT INTO `infinitive_english_translation` VALUES ('707', '279', ' to be gotten rid of');
INSERT INTO `infinitive_english_translation` VALUES ('708', '279', ' to be married off');
INSERT INTO `infinitive_english_translation` VALUES ('709', '280', 'to melt');
INSERT INTO `infinitive_english_translation` VALUES ('710', '280', ' to thaw');
INSERT INTO `infinitive_english_translation` VALUES ('711', '280', ' to liquefy');
INSERT INTO `infinitive_english_translation` VALUES ('712', '280', ' to liquify');
INSERT INTO `infinitive_english_translation` VALUES ('713', '280', ' to fill with water');
INSERT INTO `infinitive_english_translation` VALUES ('714', '280', ' to mix with water');
INSERT INTO `infinitive_english_translation` VALUES ('715', '280', ' to water down; colloq. fig. to consume');
INSERT INTO `infinitive_english_translation` VALUES ('716', '280', ' to make gaunt');
INSERT INTO `infinitive_english_translation` VALUES ('717', '280', ' to liquidate (assets)');
INSERT INTO `infinitive_english_translation` VALUES ('718', '280', ' to cleverly sell off worthless property');
INSERT INTO `infinitive_english_translation` VALUES ('719', '280', ' to get rid of');
INSERT INTO `infinitive_english_translation` VALUES ('720', '280', ' to marry off');
INSERT INTO `infinitive_english_translation` VALUES ('721', '281', 'to take a dip');
INSERT INTO `infinitive_english_translation` VALUES ('722', '281', ' to go wading');
INSERT INTO `infinitive_english_translation` VALUES ('723', '281', ' to bathe');
INSERT INTO `infinitive_english_translation` VALUES ('724', '282', 'to puncture');
INSERT INTO `infinitive_english_translation` VALUES ('725', '282', ' to perforate');
INSERT INTO `infinitive_english_translation` VALUES ('726', '282', ' to embroider');
INSERT INTO `infinitive_english_translation` VALUES ('727', '282', ' to quilt');
INSERT INTO `infinitive_english_translation` VALUES ('728', '282', ' to give a tread');
INSERT INTO `infinitive_english_translation` VALUES ('729', '282', ' to groove');
INSERT INTO `infinitive_english_translation` VALUES ('730', '283', 'to become calm');
INSERT INTO `infinitive_english_translation` VALUES ('731', '283', ' to quiet down');
INSERT INTO `infinitive_english_translation` VALUES ('732', '283', ' to settle down');
INSERT INTO `infinitive_english_translation` VALUES ('733', '283', ' to rest');
INSERT INTO `infinitive_english_translation` VALUES ('734', '283', ' to become peaceful');
INSERT INTO `infinitive_english_translation` VALUES ('735', '284', 'to become calm');
INSERT INTO `infinitive_english_translation` VALUES ('736', '284', ' to quiet down');
INSERT INTO `infinitive_english_translation` VALUES ('737', '284', ' to settle down');
INSERT INTO `infinitive_english_translation` VALUES ('738', '284', ' to rest');
INSERT INTO `infinitive_english_translation` VALUES ('739', '284', ' to become peaceful');
INSERT INTO `infinitive_english_translation` VALUES ('740', '285', 'to become free');
INSERT INTO `infinitive_english_translation` VALUES ('741', '285', ' to be freed');
INSERT INTO `infinitive_english_translation` VALUES ('742', '285', ' to be released');
INSERT INTO `infinitive_english_translation` VALUES ('743', '286', 'to cook');
INSERT INTO `infinitive_english_translation` VALUES ('744', '286', ' to do cooking');
INSERT INTO `infinitive_english_translation` VALUES ('745', '286', ' to be a cook');
INSERT INTO `infinitive_english_translation` VALUES ('746', '287', 'to become acquainted');
INSERT INTO `infinitive_english_translation` VALUES ('747', '287', ' to become familiar');
INSERT INTO `infinitive_english_translation` VALUES ('748', '287', ' to get accumstomed');
INSERT INTO `infinitive_english_translation` VALUES ('749', '287', ' to get to know');
INSERT INTO `infinitive_english_translation` VALUES ('750', '288', 'to start');
INSERT INTO `infinitive_english_translation` VALUES ('751', '288', ' to begin');
INSERT INTO `infinitive_english_translation` VALUES ('752', '289', 'to start');
INSERT INTO `infinitive_english_translation` VALUES ('753', '289', ' to begin');
INSERT INTO `infinitive_english_translation` VALUES ('754', '290', 'to be mixed (with)');
INSERT INTO `infinitive_english_translation` VALUES ('755', '290', ' to get smeared (with)');
INSERT INTO `infinitive_english_translation` VALUES ('756', '290', ' to welter');
INSERT INTO `infinitive_english_translation` VALUES ('757', '290', ' to be soaked (with)');
INSERT INTO `infinitive_english_translation` VALUES ('758', '291', 'to mix (with)');
INSERT INTO `infinitive_english_translation` VALUES ('759', '291', ' to welter');
INSERT INTO `infinitive_english_translation` VALUES ('760', '291', ' to smear (with)');
INSERT INTO `infinitive_english_translation` VALUES ('761', '292', 'to stuff');
INSERT INTO `infinitive_english_translation` VALUES ('762', '292', ' to fill');
INSERT INTO `infinitive_english_translation` VALUES ('763', '292', ' to pack');
INSERT INTO `infinitive_english_translation` VALUES ('764', '292', ' to wad');
INSERT INTO `infinitive_english_translation` VALUES ('765', '292', ' to imbue');
INSERT INTO `infinitive_english_translation` VALUES ('766', '293', 'to be aware');
INSERT INTO `infinitive_english_translation` VALUES ('767', '293', ' to be informed');
INSERT INTO `infinitive_english_translation` VALUES ('768', '293', ' to be awake');
INSERT INTO `infinitive_english_translation` VALUES ('769', '294', 'to pollute');
INSERT INTO `infinitive_english_translation` VALUES ('770', '294', ' to contaminate');
INSERT INTO `infinitive_english_translation` VALUES ('771', '295', 'to sing');
INSERT INTO `infinitive_english_translation` VALUES ('772', '296', 'to sing');
INSERT INTO `infinitive_english_translation` VALUES ('773', '297', 'comp. to mirror; comp. PA. to create a mirror-site');
INSERT INTO `infinitive_english_translation` VALUES ('774', '297', ' to do mirroring');
INSERT INTO `infinitive_english_translation` VALUES ('775', '298', 'to ask permission');
INSERT INTO `infinitive_english_translation` VALUES ('776', '298', ' to beg leave');
INSERT INTO `infinitive_english_translation` VALUES ('777', '299', 'to permit');
INSERT INTO `infinitive_english_translation` VALUES ('778', '299', ' to allow');
INSERT INTO `infinitive_english_translation` VALUES ('779', '300', 'to carry out');
INSERT INTO `infinitive_english_translation` VALUES ('780', '300', ' to implement');
INSERT INTO `infinitive_english_translation` VALUES ('781', '300', ' to execute');
INSERT INTO `infinitive_english_translation` VALUES ('782', '300', ' to run');
INSERT INTO `infinitive_english_translation` VALUES ('783', '301', 'to need');
INSERT INTO `infinitive_english_translation` VALUES ('784', '301', ' to require');
INSERT INTO `infinitive_english_translation` VALUES ('785', '301', ' to want');
INSERT INTO `infinitive_english_translation` VALUES ('786', '301', ' to lack');
INSERT INTO `infinitive_english_translation` VALUES ('787', '302', 'to greet');
INSERT INTO `infinitive_english_translation` VALUES ('788', '302', ' to ask after someone\'s health');
INSERT INTO `infinitive_english_translation` VALUES ('789', '303', 'to greet');
INSERT INTO `infinitive_english_translation` VALUES ('790', '303', ' to ask after someone\'s health');
INSERT INTO `infinitive_english_translation` VALUES ('791', '304', 'to chat');
INSERT INTO `infinitive_english_translation` VALUES ('792', '304', ' to socialize');
INSERT INTO `infinitive_english_translation` VALUES ('793', '304', ' to mix; obs. to sleep together');
INSERT INTO `infinitive_english_translation` VALUES ('794', '305', 'to continue');
INSERT INTO `infinitive_english_translation` VALUES ('795', '306', 'to urinate');
INSERT INTO `infinitive_english_translation` VALUES ('796', '307', 'to claim');
INSERT INTO `infinitive_english_translation` VALUES ('797', '307', ' to boast');
INSERT INTO `infinitive_english_translation` VALUES ('798', '307', ' to allege');
INSERT INTO `infinitive_english_translation` VALUES ('799', '307', ' to litigate');
INSERT INTO `infinitive_english_translation` VALUES ('800', '308', 'to annoy');
INSERT INTO `infinitive_english_translation` VALUES ('801', '308', ' to irritate');
INSERT INTO `infinitive_english_translation` VALUES ('802', '308', ' to pick on');
INSERT INTO `infinitive_english_translation` VALUES ('803', '309', 'to annoy');
INSERT INTO `infinitive_english_translation` VALUES ('804', '309', ' to irritate');
INSERT INTO `infinitive_english_translation` VALUES ('805', '309', ' to pick on');
INSERT INTO `infinitive_english_translation` VALUES ('806', '310', 'to connect');
INSERT INTO `infinitive_english_translation` VALUES ('807', '310', ' to link');
INSERT INTO `infinitive_english_translation` VALUES ('808', '311', 'fig. to recite from memory');
INSERT INTO `infinitive_english_translation` VALUES ('809', '312', 'fig. to recite from memory');
INSERT INTO `infinitive_english_translation` VALUES ('810', '313', 'to be exhausted');
INSERT INTO `infinitive_english_translation` VALUES ('811', '313', ' to be ready to drop from exhaustion');
INSERT INTO `infinitive_english_translation` VALUES ('812', '314', 'to stop moving');
INSERT INTO `infinitive_english_translation` VALUES ('813', '314', ' to stop running');
INSERT INTO `infinitive_english_translation` VALUES ('814', '314', ' to stop working');
INSERT INTO `infinitive_english_translation` VALUES ('815', '314', ' to stop');
INSERT INTO `infinitive_english_translation` VALUES ('816', '314', ' to come to a stop');
INSERT INTO `infinitive_english_translation` VALUES ('817', '315', 'to stop moving');
INSERT INTO `infinitive_english_translation` VALUES ('818', '315', ' to stop running');
INSERT INTO `infinitive_english_translation` VALUES ('819', '315', ' to stop working');
INSERT INTO `infinitive_english_translation` VALUES ('820', '315', ' to stop');
INSERT INTO `infinitive_english_translation` VALUES ('821', '315', ' to come to a stop');
INSERT INTO `infinitive_english_translation` VALUES ('822', '316', 'to forget');
INSERT INTO `infinitive_english_translation` VALUES ('823', '317', 'fig. to lose');
INSERT INTO `infinitive_english_translation` VALUES ('824', '318', 'to become lost');
INSERT INTO `infinitive_english_translation` VALUES ('825', '319', 'to omit');
INSERT INTO `infinitive_english_translation` VALUES ('826', '319', ' to leave out');
INSERT INTO `infinitive_english_translation` VALUES ('827', '320', 'to omit');
INSERT INTO `infinitive_english_translation` VALUES ('828', '320', ' to leave out');
INSERT INTO `infinitive_english_translation` VALUES ('829', '321', 'to go out of fashion');
INSERT INTO `infinitive_english_translation` VALUES ('830', '322', 'to forget');
INSERT INTO `infinitive_english_translation` VALUES ('831', '323', 'to marry');
INSERT INTO `infinitive_english_translation` VALUES ('832', '323', ' to get married');
INSERT INTO `infinitive_english_translation` VALUES ('833', '324', 'to rest');
INSERT INTO `infinitive_english_translation` VALUES ('834', '324', ' to relax');
INSERT INTO `infinitive_english_translation` VALUES ('835', '324', ' to take a break');
INSERT INTO `infinitive_english_translation` VALUES ('836', '324', ' to lie down');
INSERT INTO `infinitive_english_translation` VALUES ('837', '324', ' to take a nap; sl. to go for a smoke');
INSERT INTO `infinitive_english_translation` VALUES ('838', '325', 'to be taken prisoner');
INSERT INTO `infinitive_english_translation` VALUES ('839', '325', ' to be captured');
INSERT INTO `infinitive_english_translation` VALUES ('840', '325', ' to become captive');
INSERT INTO `infinitive_english_translation` VALUES ('841', '325', ' to be apprehended');
INSERT INTO `infinitive_english_translation` VALUES ('842', '326', 'to take captive');
INSERT INTO `infinitive_english_translation` VALUES ('843', '326', ' to take prisoner');
INSERT INTO `infinitive_english_translation` VALUES ('844', '326', ' to capture');
INSERT INTO `infinitive_english_translation` VALUES ('845', '326', ' to apprehend');
INSERT INTO `infinitive_english_translation` VALUES ('846', '327', 'to turn out wrong');
INSERT INTO `infinitive_english_translation` VALUES ('847', '327', ' to turn out to be a mistake');
INSERT INTO `infinitive_english_translation` VALUES ('848', '328', 'to turn out wrong');
INSERT INTO `infinitive_english_translation` VALUES ('849', '328', ' to turn out to be a mistake');
INSERT INTO `infinitive_english_translation` VALUES ('850', '329', 'to make a mistake');
INSERT INTO `infinitive_english_translation` VALUES ('851', '329', ' to mistake');
INSERT INTO `infinitive_english_translation` VALUES ('852', '329', ' to stumble');
INSERT INTO `infinitive_english_translation` VALUES ('853', '329', ' to transgress');
INSERT INTO `infinitive_english_translation` VALUES ('854', '330', 'comp. PA. to debug');
INSERT INTO `infinitive_english_translation` VALUES ('855', '331', 'to reform');
INSERT INTO `infinitive_english_translation` VALUES ('856', '331', ' to correct');
INSERT INTO `infinitive_english_translation` VALUES ('857', '331', ' to trim (hair)');
INSERT INTO `infinitive_english_translation` VALUES ('858', '331', ' to shave (beard); obs. to make peace');
INSERT INTO `infinitive_english_translation` VALUES ('859', '331', ' to reconcile');
INSERT INTO `infinitive_english_translation` VALUES ('860', '332', 'to reform');
INSERT INTO `infinitive_english_translation` VALUES ('861', '332', ' to correct');
INSERT INTO `infinitive_english_translation` VALUES ('862', '332', ' to trim (hair)');
INSERT INTO `infinitive_english_translation` VALUES ('863', '332', ' to shave (beard); obs. to make peace');
INSERT INTO `infinitive_english_translation` VALUES ('864', '332', ' to reconcile');
INSERT INTO `infinitive_english_translation` VALUES ('865', '333', 'to grant');
INSERT INTO `infinitive_english_translation` VALUES ('866', '333', ' to reward');
INSERT INTO `infinitive_english_translation` VALUES ('867', '333', ' to bestow');
INSERT INTO `infinitive_english_translation` VALUES ('868', '333', ' to invest with');
INSERT INTO `infinitive_english_translation` VALUES ('869', '334', 'to stay');
INSERT INTO `infinitive_english_translation` VALUES ('870', '334', ' to dwell');
INSERT INTO `infinitive_english_translation` VALUES ('871', '334', ' to reside');
INSERT INTO `infinitive_english_translation` VALUES ('872', '334', ' to lodge');
INSERT INTO `infinitive_english_translation` VALUES ('873', '334', ' to put up');
INSERT INTO `infinitive_english_translation` VALUES ('874', '334', ' to live');
INSERT INTO `infinitive_english_translation` VALUES ('875', '335', 'to stay');
INSERT INTO `infinitive_english_translation` VALUES ('876', '335', ' to dwell');
INSERT INTO `infinitive_english_translation` VALUES ('877', '335', ' to reside');
INSERT INTO `infinitive_english_translation` VALUES ('878', '335', ' to lodge');
INSERT INTO `infinitive_english_translation` VALUES ('879', '335', ' to put up');
INSERT INTO `infinitive_english_translation` VALUES ('880', '335', ' to live');
INSERT INTO `infinitive_english_translation` VALUES ('881', '336', 'to stay');
INSERT INTO `infinitive_english_translation` VALUES ('882', '336', ' to dwell');
INSERT INTO `infinitive_english_translation` VALUES ('883', '336', ' to reside');
INSERT INTO `infinitive_english_translation` VALUES ('884', '336', ' to lodge');
INSERT INTO `infinitive_english_translation` VALUES ('885', '336', ' to put up');
INSERT INTO `infinitive_english_translation` VALUES ('886', '336', ' to live');
INSERT INTO `infinitive_english_translation` VALUES ('887', '337', 'to stay');
INSERT INTO `infinitive_english_translation` VALUES ('888', '337', ' to dwell');
INSERT INTO `infinitive_english_translation` VALUES ('889', '337', ' to reside');
INSERT INTO `infinitive_english_translation` VALUES ('890', '337', ' to lodge');
INSERT INTO `infinitive_english_translation` VALUES ('891', '337', ' to put up');
INSERT INTO `infinitive_english_translation` VALUES ('892', '337', ' to live');
INSERT INTO `infinitive_english_translation` VALUES ('893', '338', 'to entreat');
INSERT INTO `infinitive_english_translation` VALUES ('894', '338', ' to beseech');
INSERT INTO `infinitive_english_translation` VALUES ('895', '338', ' to supplicate');
INSERT INTO `infinitive_english_translation` VALUES ('896', '338', ' to adjure');
INSERT INTO `infinitive_english_translation` VALUES ('897', '338', ' to beg');
INSERT INTO `infinitive_english_translation` VALUES ('898', '339', 'to take a test');
INSERT INTO `infinitive_english_translation` VALUES ('899', '339', ' to take an examination');
INSERT INTO `infinitive_english_translation` VALUES ('900', '340', 'to give a test');
INSERT INTO `infinitive_english_translation` VALUES ('901', '340', ' to test');
INSERT INTO `infinitive_english_translation` VALUES ('902', '340', ' to try out');
INSERT INTO `infinitive_english_translation` VALUES ('903', '340', ' to try on');
INSERT INTO `infinitive_english_translation` VALUES ('904', '341', 'to give a test');
INSERT INTO `infinitive_english_translation` VALUES ('905', '341', ' to give an examination');
INSERT INTO `infinitive_english_translation` VALUES ('906', '341', ' to test');
INSERT INTO `infinitive_english_translation` VALUES ('907', '342', 'to pin one\'s hope (on)');
INSERT INTO `infinitive_english_translation` VALUES ('908', '342', ' to desire');
INSERT INTO `infinitive_english_translation` VALUES ('909', '343', 'to pin one\'s hope (on)');
INSERT INTO `infinitive_english_translation` VALUES ('910', '343', ' to desire');
INSERT INTO `infinitive_english_translation` VALUES ('911', '344', 'to choose');
INSERT INTO `infinitive_english_translation` VALUES ('912', '344', ' to select');
INSERT INTO `infinitive_english_translation` VALUES ('913', '344', ' to vote');
INSERT INTO `infinitive_english_translation` VALUES ('914', '345', 'to transfer');
INSERT INTO `infinitive_english_translation` VALUES ('915', '345', ' to pass on');
INSERT INTO `infinitive_english_translation` VALUES ('916', '345', ' to remove');
INSERT INTO `infinitive_english_translation` VALUES ('917', '346', 'to transfer');
INSERT INTO `infinitive_english_translation` VALUES ('918', '346', ' to pass on');
INSERT INTO `infinitive_english_translation` VALUES ('919', '346', ' to remove');
INSERT INTO `infinitive_english_translation` VALUES ('920', '347', 'to take revenge');
INSERT INTO `infinitive_english_translation` VALUES ('921', '348', 'to take revenge');
INSERT INTO `infinitive_english_translation` VALUES ('922', '349', 'to do');
INSERT INTO `infinitive_english_translation` VALUES ('923', '349', ' to carry out');
INSERT INTO `infinitive_english_translation` VALUES ('924', '349', ' to perform');
INSERT INTO `infinitive_english_translation` VALUES ('925', '349', ' to accomplish');
INSERT INTO `infinitive_english_translation` VALUES ('926', '349', ' to complete');
INSERT INTO `infinitive_english_translation` VALUES ('927', '350', 'to measure');
INSERT INTO `infinitive_english_translation` VALUES ('928', '351', 'to stand');
INSERT INTO `infinitive_english_translation` VALUES ('929', '351', ' to stand up');
INSERT INTO `infinitive_english_translation` VALUES ('930', '351', ' to stop');
INSERT INTO `infinitive_english_translation` VALUES ('931', '352', 'to stand');
INSERT INTO `infinitive_english_translation` VALUES ('932', '352', ' to stand up');
INSERT INTO `infinitive_english_translation` VALUES ('933', '352', ' to stop');
INSERT INTO `infinitive_english_translation` VALUES ('934', '353', 'to restrain');
INSERT INTO `infinitive_english_translation` VALUES ('935', '353', ' to prevent');
INSERT INTO `infinitive_english_translation` VALUES ('936', '353', ' to prohibit');
INSERT INTO `infinitive_english_translation` VALUES ('937', '353', ' to inhibit');
INSERT INTO `infinitive_english_translation` VALUES ('938', '353', ' to dissuade; obs. to withhold; obs. fig. to hide');
INSERT INTO `infinitive_english_translation` VALUES ('939', '354', 'to become open');
INSERT INTO `infinitive_english_translation` VALUES ('940', '354', ' to open');
INSERT INTO `infinitive_english_translation` VALUES ('941', '354', ' to become clear; comp. to load');
INSERT INTO `infinitive_english_translation` VALUES ('942', '355', 'to open');
INSERT INTO `infinitive_english_translation` VALUES ('943', '355', ' to open up');
INSERT INTO `infinitive_english_translation` VALUES ('944', '355', ' to turn on');
INSERT INTO `infinitive_english_translation` VALUES ('945', '355', ' to switch on');
INSERT INTO `infinitive_english_translation` VALUES ('946', '355', ' to remove; fig. to take apart');
INSERT INTO `infinitive_english_translation` VALUES ('947', '355', ' to unpack');
INSERT INTO `infinitive_english_translation` VALUES ('948', '355', ' to unpackage; obs. to shave or cut (hair)');
INSERT INTO `infinitive_english_translation` VALUES ('949', '355', ' to pluck (fruit)');
INSERT INTO `infinitive_english_translation` VALUES ('950', '355', ' to prune');
INSERT INTO `infinitive_english_translation` VALUES ('951', '355', ' to shoo away');
INSERT INTO `infinitive_english_translation` VALUES ('952', '355', ' to dig');
INSERT INTO `infinitive_english_translation` VALUES ('953', '355', ' to destroy');
INSERT INTO `infinitive_english_translation` VALUES ('954', '355', ' to take out');
INSERT INTO `infinitive_english_translation` VALUES ('955', '356', 'to open');
INSERT INTO `infinitive_english_translation` VALUES ('956', '356', ' to open up');
INSERT INTO `infinitive_english_translation` VALUES ('957', '356', ' to turn on');
INSERT INTO `infinitive_english_translation` VALUES ('958', '356', ' to switch on');
INSERT INTO `infinitive_english_translation` VALUES ('959', '356', ' to remove; fig. to take apart');
INSERT INTO `infinitive_english_translation` VALUES ('960', '356', ' to unpack');
INSERT INTO `infinitive_english_translation` VALUES ('961', '356', ' to unpackage; obs. to shave or cut (hair)');
INSERT INTO `infinitive_english_translation` VALUES ('962', '356', ' to pluck (fruit)');
INSERT INTO `infinitive_english_translation` VALUES ('963', '356', ' to prune');
INSERT INTO `infinitive_english_translation` VALUES ('964', '356', ' to shoo away');
INSERT INTO `infinitive_english_translation` VALUES ('965', '356', ' to dig');
INSERT INTO `infinitive_english_translation` VALUES ('966', '356', ' to destroy');
INSERT INTO `infinitive_english_translation` VALUES ('967', '356', ' to take out');
INSERT INTO `infinitive_english_translation` VALUES ('968', '357', 'to return');
INSERT INTO `infinitive_english_translation` VALUES ('969', '357', ' to send back');
INSERT INTO `infinitive_english_translation` VALUES ('970', '357', ' to take back');
INSERT INTO `infinitive_english_translation` VALUES ('971', '358', 'to return');
INSERT INTO `infinitive_english_translation` VALUES ('972', '358', ' to send back');
INSERT INTO `infinitive_english_translation` VALUES ('973', '358', ' to take back');
INSERT INTO `infinitive_english_translation` VALUES ('974', '359', 'to pay back');
INSERT INTO `infinitive_english_translation` VALUES ('975', '359', ' to reimburse');
INSERT INTO `infinitive_english_translation` VALUES ('976', '360', 'to play');
INSERT INTO `infinitive_english_translation` VALUES ('977', '361', 'to recycle');
INSERT INTO `infinitive_english_translation` VALUES ('978', '361', ' to retrieve');
INSERT INTO `infinitive_english_translation` VALUES ('979', '361', ' to recuperate');
INSERT INTO `infinitive_english_translation` VALUES ('980', '362', 'to carry up');
INSERT INTO `infinitive_english_translation` VALUES ('981', '362', ' to lift');
INSERT INTO `infinitive_english_translation` VALUES ('982', '362', ' to raise');
INSERT INTO `infinitive_english_translation` VALUES ('983', '362', ' to elevate');
INSERT INTO `infinitive_english_translation` VALUES ('984', '362', ' to hoist; fig. colloq. to augment');
INSERT INTO `infinitive_english_translation` VALUES ('985', '362', ' to enhance');
INSERT INTO `infinitive_english_translation` VALUES ('986', '362', ' to upgrade');
INSERT INTO `infinitive_english_translation` VALUES ('987', '362', ' to increase');
INSERT INTO `infinitive_english_translation` VALUES ('988', '362', ' to escalte');
INSERT INTO `infinitive_english_translation` VALUES ('989', '362', ' to up');
INSERT INTO `infinitive_english_translation` VALUES ('990', '363', 'to file');
INSERT INTO `infinitive_english_translation` VALUES ('991', '363', ' to archive');
INSERT INTO `infinitive_english_translation` VALUES ('992', '364', 'to discuss');
INSERT INTO `infinitive_english_translation` VALUES ('993', '364', ' to debate');
INSERT INTO `infinitive_english_translation` VALUES ('994', '364', ' to dispute');
INSERT INTO `infinitive_english_translation` VALUES ('995', '365', 'to speak ill (of)');
INSERT INTO `infinitive_english_translation` VALUES ('996', '366', 'to be irritated');
INSERT INTO `infinitive_english_translation` VALUES ('997', '366', ' to be angry');
INSERT INTO `infinitive_english_translation` VALUES ('998', '366', ' to irritate');
INSERT INTO `infinitive_english_translation` VALUES ('999', '366', ' to make angry');
INSERT INTO `infinitive_english_translation` VALUES ('1000', '367', 'fig. to be put on');
INSERT INTO `infinitive_english_translation` VALUES ('1001', '367', ' to be held');
INSERT INTO `infinitive_english_translation` VALUES ('1002', '367', ' to be organized');
INSERT INTO `infinitive_english_translation` VALUES ('1003', '367', ' to be set up');
INSERT INTO `infinitive_english_translation` VALUES ('1004', '368', 'fig. to put on');
INSERT INTO `infinitive_english_translation` VALUES ('1005', '368', ' to hold');
INSERT INTO `infinitive_english_translation` VALUES ('1006', '368', ' to organize');
INSERT INTO `infinitive_english_translation` VALUES ('1007', '368', ' to set up');
INSERT INTO `infinitive_english_translation` VALUES ('1008', '369', 'to gather');
INSERT INTO `infinitive_english_translation` VALUES ('1009', '369', ' to pick up');
INSERT INTO `infinitive_english_translation` VALUES ('1010', '369', ' to remove');
INSERT INTO `infinitive_english_translation` VALUES ('1011', '370', 'to rise');
INSERT INTO `infinitive_english_translation` VALUES ('1012', '371', 'to take up');
INSERT INTO `infinitive_english_translation` VALUES ('1013', '371', ' to take out');
INSERT INTO `infinitive_english_translation` VALUES ('1014', '372', 'to enumerate');
INSERT INTO `infinitive_english_translation` VALUES ('1015', '373', 'to eliminate');
INSERT INTO `infinitive_english_translation` VALUES ('1016', '374', 'to undertake');
INSERT INTO `infinitive_english_translation` VALUES ('1017', '374', ' to assume responsibility');
INSERT INTO `infinitive_english_translation` VALUES ('1018', '375', 'to undertake');
INSERT INTO `infinitive_english_translation` VALUES ('1019', '375', ' to assume responsibility');
INSERT INTO `infinitive_english_translation` VALUES ('1020', '376', 'to be established');
INSERT INTO `infinitive_english_translation` VALUES ('1021', '376', ' to be set up');
INSERT INTO `infinitive_english_translation` VALUES ('1022', '376', ' to be commissioned');
INSERT INTO `infinitive_english_translation` VALUES ('1023', '377', 'to be established');
INSERT INTO `infinitive_english_translation` VALUES ('1024', '377', ' to be set up');
INSERT INTO `infinitive_english_translation` VALUES ('1025', '377', ' to be commissioned');
INSERT INTO `infinitive_english_translation` VALUES ('1026', '378', 'to establish');
INSERT INTO `infinitive_english_translation` VALUES ('1027', '378', ' to set up');
INSERT INTO `infinitive_english_translation` VALUES ('1028', '378', ' to commission');
INSERT INTO `infinitive_english_translation` VALUES ('1029', '379', 'to establish');
INSERT INTO `infinitive_english_translation` VALUES ('1030', '379', ' to set up');
INSERT INTO `infinitive_english_translation` VALUES ('1031', '379', ' to commission');
INSERT INTO `infinitive_english_translation` VALUES ('1032', '380', 'to put on');
INSERT INTO `infinitive_english_translation` VALUES ('1033', '380', ' to hold');
INSERT INTO `infinitive_english_translation` VALUES ('1034', '380', ' to organize');
INSERT INTO `infinitive_english_translation` VALUES ('1035', '381', 'to put on');
INSERT INTO `infinitive_english_translation` VALUES ('1036', '381', ' to hold');
INSERT INTO `infinitive_english_translation` VALUES ('1037', '381', ' to organize');
INSERT INTO `infinitive_english_translation` VALUES ('1038', '382', 'to give back');
INSERT INTO `infinitive_english_translation` VALUES ('1039', '382', ' to return');
INSERT INTO `infinitive_english_translation` VALUES ('1040', '382', ' to remunerate');
INSERT INTO `infinitive_english_translation` VALUES ('1041', '382', ' to rewind');
INSERT INTO `infinitive_english_translation` VALUES ('1042', '382', ' to avert');
INSERT INTO `infinitive_english_translation` VALUES ('1043', '382', ' to turn');
INSERT INTO `infinitive_english_translation` VALUES ('1044', '382', ' to fold');
INSERT INTO `infinitive_english_translation` VALUES ('1045', '382', ' to vomit');
INSERT INTO `infinitive_english_translation` VALUES ('1046', '382', ' to translate');
INSERT INTO `infinitive_english_translation` VALUES ('1047', '382', ' to interpret');
INSERT INTO `infinitive_english_translation` VALUES ('1048', '382', ' to turn upside down');
INSERT INTO `infinitive_english_translation` VALUES ('1049', '383', 'to give back');
INSERT INTO `infinitive_english_translation` VALUES ('1050', '383', ' to return');
INSERT INTO `infinitive_english_translation` VALUES ('1051', '383', ' to remunerate');
INSERT INTO `infinitive_english_translation` VALUES ('1052', '383', ' to rewind');
INSERT INTO `infinitive_english_translation` VALUES ('1053', '383', ' to avert');
INSERT INTO `infinitive_english_translation` VALUES ('1054', '383', ' to turn');
INSERT INTO `infinitive_english_translation` VALUES ('1055', '383', ' to fold');
INSERT INTO `infinitive_english_translation` VALUES ('1056', '383', ' to vomit');
INSERT INTO `infinitive_english_translation` VALUES ('1057', '383', ' to translate');
INSERT INTO `infinitive_english_translation` VALUES ('1058', '383', ' to interpret');
INSERT INTO `infinitive_english_translation` VALUES ('1059', '383', ' to turn upside down');
INSERT INTO `infinitive_english_translation` VALUES ('1060', '384', 'to be put on');
INSERT INTO `infinitive_english_translation` VALUES ('1061', '384', ' to be held');
INSERT INTO `infinitive_english_translation` VALUES ('1062', '384', ' to be organized');
INSERT INTO `infinitive_english_translation` VALUES ('1063', '385', 'to choose');
INSERT INTO `infinitive_english_translation` VALUES ('1064', '385', ' to select');
INSERT INTO `infinitive_english_translation` VALUES ('1065', '386', 'to return');
INSERT INTO `infinitive_english_translation` VALUES ('1066', '386', ' to turn back');
INSERT INTO `infinitive_english_translation` VALUES ('1067', '386', ' to turn around');
INSERT INTO `infinitive_english_translation` VALUES ('1068', '387', 'to investigate');
INSERT INTO `infinitive_english_translation` VALUES ('1069', '387', ' to examine');
INSERT INTO `infinitive_english_translation` VALUES ('1070', '387', ' to check');
INSERT INTO `infinitive_english_translation` VALUES ('1071', '387', ' to consider');
INSERT INTO `infinitive_english_translation` VALUES ('1072', '388', 'to investigate');
INSERT INTO `infinitive_english_translation` VALUES ('1073', '388', ' to examine');
INSERT INTO `infinitive_english_translation` VALUES ('1074', '388', ' to check');
INSERT INTO `infinitive_english_translation` VALUES ('1075', '388', ' to consider');
INSERT INTO `infinitive_english_translation` VALUES ('1076', '389', 'to slice');
INSERT INTO `infinitive_english_translation` VALUES ('1077', '389', ' to cut');
INSERT INTO `infinitive_english_translation` VALUES ('1078', '389', ' to slit');
INSERT INTO `infinitive_english_translation` VALUES ('1079', '389', ' to make an incision');
INSERT INTO `infinitive_english_translation` VALUES ('1080', '390', 'to roast');
INSERT INTO `infinitive_english_translation` VALUES ('1081', '390', ' to toast');
INSERT INTO `infinitive_english_translation` VALUES ('1082', '390', ' to scorch');
INSERT INTO `infinitive_english_translation` VALUES ('1083', '391', 'to emerge');
INSERT INTO `infinitive_english_translation` VALUES ('1084', '391', ' to appear');
INSERT INTO `infinitive_english_translation` VALUES ('1085', '391', ' to manifest itself');
INSERT INTO `infinitive_english_translation` VALUES ('1086', '392', 'to grow');
INSERT INTO `infinitive_english_translation` VALUES ('1087', '392', ' to grow up');
INSERT INTO `infinitive_english_translation` VALUES ('1088', '392', ' to become large');
INSERT INTO `infinitive_english_translation` VALUES ('1089', '392', ' to get big');
INSERT INTO `infinitive_english_translation` VALUES ('1090', '393', 'to extort');
INSERT INTO `infinitive_english_translation` VALUES ('1091', '393', ' to commandeer');
INSERT INTO `infinitive_english_translation` VALUES ('1092', '394', 'to stop');
INSERT INTO `infinitive_english_translation` VALUES ('1093', '394', ' to put an end to');
INSERT INTO `infinitive_english_translation` VALUES ('1094', '394', ' to quit');
INSERT INTO `infinitive_english_translation` VALUES ('1095', '394', ' to call it enough');
INSERT INTO `infinitive_english_translation` VALUES ('1096', '394', ' to have enough of');
INSERT INTO `infinitive_english_translation` VALUES ('1097', '395', 'to become bed-ridden');
INSERT INTO `infinitive_english_translation` VALUES ('1098', '396', 'to wrap');
INSERT INTO `infinitive_english_translation` VALUES ('1099', '396', ' to package');
INSERT INTO `infinitive_english_translation` VALUES ('1100', '397', 'to exert oneself');
INSERT INTO `infinitive_english_translation` VALUES ('1101', '397', ' to work hard');
INSERT INTO `infinitive_english_translation` VALUES ('1102', '398', 'to exert oneself');
INSERT INTO `infinitive_english_translation` VALUES ('1103', '398', ' to work hard');
INSERT INTO `infinitive_english_translation` VALUES ('1104', '399', 'to box');
INSERT INTO `infinitive_english_translation` VALUES ('1105', '399', ' to do boxing');
INSERT INTO `infinitive_english_translation` VALUES ('1106', '400', 'to bicker');
INSERT INTO `infinitive_english_translation` VALUES ('1107', '400', ' to argue');
INSERT INTO `infinitive_english_translation` VALUES ('1108', '401', 'to know');
INSERT INTO `infinitive_english_translation` VALUES ('1109', '401', ' to know how');
INSERT INTO `infinitive_english_translation` VALUES ('1110', '402', 'to stand up');
INSERT INTO `infinitive_english_translation` VALUES ('1111', '402', ' to get up');
INSERT INTO `infinitive_english_translation` VALUES ('1112', '402', ' to rise');
INSERT INTO `infinitive_english_translation` VALUES ('1113', '402', ' to be lifted');
INSERT INTO `infinitive_english_translation` VALUES ('1114', '402', ' to be raised');
INSERT INTO `infinitive_english_translation` VALUES ('1115', '402', ' to become tall');
INSERT INTO `infinitive_english_translation` VALUES ('1116', '402', ' to become long');
INSERT INTO `infinitive_english_translation` VALUES ('1117', '402', ' to become high');
INSERT INTO `infinitive_english_translation` VALUES ('1118', '402', ' to become loud');
INSERT INTO `infinitive_english_translation` VALUES ('1119', '402', ' to become intense');
INSERT INTO `infinitive_english_translation` VALUES ('1120', '402', ' to come into existence');
INSERT INTO `infinitive_english_translation` VALUES ('1121', '402', ' to become erect');
INSERT INTO `infinitive_english_translation` VALUES ('1122', '403', 'to stand up');
INSERT INTO `infinitive_english_translation` VALUES ('1123', '403', ' to get up');
INSERT INTO `infinitive_english_translation` VALUES ('1124', '403', ' to rise');
INSERT INTO `infinitive_english_translation` VALUES ('1125', '403', ' to be lifted');
INSERT INTO `infinitive_english_translation` VALUES ('1126', '403', ' to be raised');
INSERT INTO `infinitive_english_translation` VALUES ('1127', '403', ' to become tall');
INSERT INTO `infinitive_english_translation` VALUES ('1128', '403', ' to become long');
INSERT INTO `infinitive_english_translation` VALUES ('1129', '403', ' to become high');
INSERT INTO `infinitive_english_translation` VALUES ('1130', '403', ' to become loud');
INSERT INTO `infinitive_english_translation` VALUES ('1131', '403', ' to become intense');
INSERT INTO `infinitive_english_translation` VALUES ('1132', '403', ' to come into existence');
INSERT INTO `infinitive_english_translation` VALUES ('1133', '403', ' to become erect');
INSERT INTO `infinitive_english_translation` VALUES ('1134', '404', 'to raise');
INSERT INTO `infinitive_english_translation` VALUES ('1135', '404', ' to elevate');
INSERT INTO `infinitive_english_translation` VALUES ('1136', '404', ' to erect');
INSERT INTO `infinitive_english_translation` VALUES ('1137', '404', ' to wake up');
INSERT INTO `infinitive_english_translation` VALUES ('1138', '404', ' to heighten; colloq. to remove');
INSERT INTO `infinitive_english_translation` VALUES ('1139', '404', ' to steal');
INSERT INTO `infinitive_english_translation` VALUES ('1140', '404', ' to pick up');
INSERT INTO `infinitive_english_translation` VALUES ('1141', '404', ' to seduce');
INSERT INTO `infinitive_english_translation` VALUES ('1142', '405', 'colloq. fig. to care for a sick person');
INSERT INTO `infinitive_english_translation` VALUES ('1143', '405', ' to act as a nurse');
INSERT INTO `infinitive_english_translation` VALUES ('1144', '406', 'to finish');
INSERT INTO `infinitive_english_translation` VALUES ('1145', '406', ' to complete');
INSERT INTO `infinitive_english_translation` VALUES ('1146', '406', ' to carry out');
INSERT INTO `infinitive_english_translation` VALUES ('1147', '407', 'to finish');
INSERT INTO `infinitive_english_translation` VALUES ('1148', '407', ' to complete');
INSERT INTO `infinitive_english_translation` VALUES ('1149', '407', ' to carry out');
INSERT INTO `infinitive_english_translation` VALUES ('1150', '408', 'to be finished');
INSERT INTO `infinitive_english_translation` VALUES ('1151', '408', ' to be completed');
INSERT INTO `infinitive_english_translation` VALUES ('1152', '408', ' to end');
INSERT INTO `infinitive_english_translation` VALUES ('1153', '408', ' to be carried out');
INSERT INTO `infinitive_english_translation` VALUES ('1154', '409', 'to plug in (an electrical cord)');
INSERT INTO `infinitive_english_translation` VALUES ('1155', '410', 'to plug in (an electrical cord)');
INSERT INTO `infinitive_english_translation` VALUES ('1156', '411', 'to plug in (an electrical cord)');
INSERT INTO `infinitive_english_translation` VALUES ('1157', '412', 'to plug in (an electrical cord)');
INSERT INTO `infinitive_english_translation` VALUES ('1158', '413', 'to end');
INSERT INTO `infinitive_english_translation` VALUES ('1159', '413', ' to be over');
INSERT INTO `infinitive_english_translation` VALUES ('1160', '413', ' to come to an end');
INSERT INTO `infinitive_english_translation` VALUES ('1161', '414', 'to plug in (an electrical cord)');
INSERT INTO `infinitive_english_translation` VALUES ('1162', '415', 'to take a hold of');
INSERT INTO `infinitive_english_translation` VALUES ('1163', '415', ' to seize');
INSERT INTO `infinitive_english_translation` VALUES ('1164', '416', 'to take a hold of');
INSERT INTO `infinitive_english_translation` VALUES ('1165', '416', ' to seize');
INSERT INTO `infinitive_english_translation` VALUES ('1166', '417', 'to put into motion');
INSERT INTO `infinitive_english_translation` VALUES ('1167', '417', ' to start');
INSERT INTO `infinitive_english_translation` VALUES ('1168', '417', ' to put into operation');
INSERT INTO `infinitive_english_translation` VALUES ('1169', '418', 'to memorize');
INSERT INTO `infinitive_english_translation` VALUES ('1170', '418', ' to commit to memory');
INSERT INTO `infinitive_english_translation` VALUES ('1171', '418', ' to learn by heart');
INSERT INTO `infinitive_english_translation` VALUES ('1172', '419', 'to show');
INSERT INTO `infinitive_english_translation` VALUES ('1173', '419', ' to display');
INSERT INTO `infinitive_english_translation` VALUES ('1174', '419', ' to demonstrate');
INSERT INTO `infinitive_english_translation` VALUES ('1175', '419', ' to use');
INSERT INTO `infinitive_english_translation` VALUES ('1176', '420', 'to cause pain');
INSERT INTO `infinitive_english_translation` VALUES ('1177', '420', ' to hurt');
INSERT INTO `infinitive_english_translation` VALUES ('1178', '422', 'to cause pain');
INSERT INTO `infinitive_english_translation` VALUES ('1179', '422', ' to hurt');
INSERT INTO `infinitive_english_translation` VALUES ('1180', '423', 'fig. to be useful');
INSERT INTO `infinitive_english_translation` VALUES ('1181', '423', ' to serve a purpose');
INSERT INTO `infinitive_english_translation` VALUES ('1182', '424', 'to obtain');
INSERT INTO `infinitive_english_translation` VALUES ('1183', '425', 'to obtain');
INSERT INTO `infinitive_english_translation` VALUES ('1184', '426', 'to be born');
INSERT INTO `infinitive_english_translation` VALUES ('1185', '426', ' to come into the world');
INSERT INTO `infinitive_english_translation` VALUES ('1186', '427', 'to be born');
INSERT INTO `infinitive_english_translation` VALUES ('1187', '427', ' to come into the world');
INSERT INTO `infinitive_english_translation` VALUES ('1188', '428', 'to mention');
INSERT INTO `infinitive_english_translation` VALUES ('1189', '428', ' to cause to speak');
INSERT INTO `infinitive_english_translation` VALUES ('1190', '429', 'to mention');
INSERT INTO `infinitive_english_translation` VALUES ('1191', '429', ' to cause to speak');
INSERT INTO `infinitive_english_translation` VALUES ('1192', '430', 'to punish');
INSERT INTO `infinitive_english_translation` VALUES ('1193', '431', 'to punish');
INSERT INTO `infinitive_english_translation` VALUES ('1194', '432', 'to be punished');
INSERT INTO `infinitive_english_translation` VALUES ('1195', '432', ' to receive punishment');
INSERT INTO `infinitive_english_translation` VALUES ('1196', '433', 'to go on a trip');
INSERT INTO `infinitive_english_translation` VALUES ('1197', '433', ' to take a trip');
INSERT INTO `infinitive_english_translation` VALUES ('1198', '434', 'to stand in line');
INSERT INTO `infinitive_english_translation` VALUES ('1199', '435', 'to stand in line');
INSERT INTO `infinitive_english_translation` VALUES ('1200', '436', 'to take long');
INSERT INTO `infinitive_english_translation` VALUES ('1201', '436', ' to take a long time');
INSERT INTO `infinitive_english_translation` VALUES ('1202', '437', 'to implement');
INSERT INTO `infinitive_english_translation` VALUES ('1203', '437', ' to grow');
INSERT INTO `infinitive_english_translation` VALUES ('1204', '438', 'to implement');
INSERT INTO `infinitive_english_translation` VALUES ('1205', '438', ' to grow');
INSERT INTO `infinitive_english_translation` VALUES ('1206', '439', 'to undertake');
INSERT INTO `infinitive_english_translation` VALUES ('1207', '439', ' to assume responsibility');
INSERT INTO `infinitive_english_translation` VALUES ('1208', '440', 'to undertake');
INSERT INTO `infinitive_english_translation` VALUES ('1209', '440', ' to assume responsibility');
INSERT INTO `infinitive_english_translation` VALUES ('1210', '441', 'to forget');
INSERT INTO `infinitive_english_translation` VALUES ('1211', '442', 'to go to the store');
INSERT INTO `infinitive_english_translation` VALUES ('1212', '442', ' to go to the market');
INSERT INTO `infinitive_english_translation` VALUES ('1213', '442', ' to go shopping');
INSERT INTO `infinitive_english_translation` VALUES ('1214', '443', 'to bastinado');
INSERT INTO `infinitive_english_translation` VALUES ('1215', '443', ' to flog the soles of the feet');
INSERT INTO `infinitive_english_translation` VALUES ('1216', '444', 'to kill');
INSERT INTO `infinitive_english_translation` VALUES ('1217', '445', 'to fall in love with someone or something');
INSERT INTO `infinitive_english_translation` VALUES ('1218', '446', 'to fall in love with someone or something');
INSERT INTO `infinitive_english_translation` VALUES ('1219', '447', 'to punish');
INSERT INTO `infinitive_english_translation` VALUES ('1220', '447', ' to exact retribution');
INSERT INTO `infinitive_english_translation` VALUES ('1221', '448', 'to punish');
INSERT INTO `infinitive_english_translation` VALUES ('1222', '448', ' to exact retribution');
INSERT INTO `infinitive_english_translation` VALUES ('1223', '449', 'to be punished');
INSERT INTO `infinitive_english_translation` VALUES ('1224', '450', 'to be punished');
INSERT INTO `infinitive_english_translation` VALUES ('1225', '451', 'to come into existence');
INSERT INTO `infinitive_english_translation` VALUES ('1226', '451', ' to appear');
INSERT INTO `infinitive_english_translation` VALUES ('1227', '452', 'to come into existence');
INSERT INTO `infinitive_english_translation` VALUES ('1228', '452', ' to appear');
INSERT INTO `infinitive_english_translation` VALUES ('1229', '453', 'to bring into existence');
INSERT INTO `infinitive_english_translation` VALUES ('1230', '453', ' to bring about');
INSERT INTO `infinitive_english_translation` VALUES ('1231', '453', ' to create');
INSERT INTO `infinitive_english_translation` VALUES ('1232', '453', ' to produce');
INSERT INTO `infinitive_english_translation` VALUES ('1233', '454', 'to bring into existence');
INSERT INTO `infinitive_english_translation` VALUES ('1234', '454', ' to bring about');
INSERT INTO `infinitive_english_translation` VALUES ('1235', '454', ' to create');
INSERT INTO `infinitive_english_translation` VALUES ('1236', '454', ' to produce');
INSERT INTO `infinitive_english_translation` VALUES ('1237', '455', 'to waste');
INSERT INTO `infinitive_english_translation` VALUES ('1238', '455', ' to squander');
INSERT INTO `infinitive_english_translation` VALUES ('1239', '456', 'to go to waste');
INSERT INTO `infinitive_english_translation` VALUES ('1240', '456', ' to be destroyed');
INSERT INTO `infinitive_english_translation` VALUES ('1241', '456', ' to be lost');
INSERT INTO `infinitive_english_translation` VALUES ('1242', '456', ' to disappear');
INSERT INTO `infinitive_english_translation` VALUES ('1243', '457', 'to bring around');
INSERT INTO `infinitive_english_translation` VALUES ('1244', '458', 'to bring around');
INSERT INTO `infinitive_english_translation` VALUES ('1245', '459', 'fig. to become excited');
INSERT INTO `infinitive_english_translation` VALUES ('1246', '459', ' to be provoked');
INSERT INTO `infinitive_english_translation` VALUES ('1247', '460', 'fig. to become excited');
INSERT INTO `infinitive_english_translation` VALUES ('1248', '460', ' to be provoked');
INSERT INTO `infinitive_english_translation` VALUES ('1249', '461', 'fig. to excite');
INSERT INTO `infinitive_english_translation` VALUES ('1250', '461', ' to agitate');
INSERT INTO `infinitive_english_translation` VALUES ('1251', '461', ' to thrill');
INSERT INTO `infinitive_english_translation` VALUES ('1252', '461', ' to move');
INSERT INTO `infinitive_english_translation` VALUES ('1253', '462', 'fig. to excite');
INSERT INTO `infinitive_english_translation` VALUES ('1254', '462', ' to agitate');
INSERT INTO `infinitive_english_translation` VALUES ('1255', '462', ' to thrill');
INSERT INTO `infinitive_english_translation` VALUES ('1256', '462', ' to move');
INSERT INTO `infinitive_english_translation` VALUES ('1257', '463', 'fig. to excite');
INSERT INTO `infinitive_english_translation` VALUES ('1258', '463', ' to agitate');
INSERT INTO `infinitive_english_translation` VALUES ('1259', '463', ' to thrill');
INSERT INTO `infinitive_english_translation` VALUES ('1260', '463', ' to move');
INSERT INTO `infinitive_english_translation` VALUES ('1261', '464', 'fig. to excite');
INSERT INTO `infinitive_english_translation` VALUES ('1262', '464', ' to agitate');
INSERT INTO `infinitive_english_translation` VALUES ('1263', '464', ' to thrill');
INSERT INTO `infinitive_english_translation` VALUES ('1264', '464', ' to move');
INSERT INTO `infinitive_english_translation` VALUES ('1265', '465', 'fig. to become excited');
INSERT INTO `infinitive_english_translation` VALUES ('1266', '465', ' to be provoked');
INSERT INTO `infinitive_english_translation` VALUES ('1267', '466', 'fig. to become excited');
INSERT INTO `infinitive_english_translation` VALUES ('1268', '466', ' to be provoked');
INSERT INTO `infinitive_english_translation` VALUES ('1269', '467', 'to remind');
INSERT INTO `infinitive_english_translation` VALUES ('1270', '468', 'to remind');
INSERT INTO `infinitive_english_translation` VALUES ('1271', '469', 'to spend time');
INSERT INTO `infinitive_english_translation` VALUES ('1272', '469', ' to live (in)');
INSERT INTO `infinitive_english_translation` VALUES ('1273', '469', ' to languish');
INSERT INTO `infinitive_english_translation` VALUES ('1274', '469', ' to endure');
INSERT INTO `infinitive_english_translation` VALUES ('1275', '470', 'to use');
INSERT INTO `infinitive_english_translation` VALUES ('1276', '471', 'to crash into one another');
INSERT INTO `infinitive_english_translation` VALUES ('1277', '471', ' to collide; fig. to to fall into disarray');
INSERT INTO `infinitive_english_translation` VALUES ('1278', '471', ' to become a mess');
INSERT INTO `infinitive_english_translation` VALUES ('1279', '471', ' to fall apart');
INSERT INTO `infinitive_english_translation` VALUES ('1280', '472', 'to become mixed together');
INSERT INTO `infinitive_english_translation` VALUES ('1281', '472', ' to become dissolved');
INSERT INTO `infinitive_english_translation` VALUES ('1282', '472', ' to fall apart');
INSERT INTO `infinitive_english_translation` VALUES ('1283', '472', ' to fall upon one another');
INSERT INTO `infinitive_english_translation` VALUES ('1284', '472', ' to fall into disorder');
INSERT INTO `infinitive_english_translation` VALUES ('1285', '472', ' to pour together');
INSERT INTO `infinitive_english_translation` VALUES ('1286', '472', ' to cancel');
INSERT INTO `infinitive_english_translation` VALUES ('1287', '472', ' to disrupt');
INSERT INTO `infinitive_english_translation` VALUES ('1288', '472', ' to cause to fall into disorder');
INSERT INTO `infinitive_english_translation` VALUES ('1289', '473', 'to cancel');
INSERT INTO `infinitive_english_translation` VALUES ('1290', '473', ' to disrupt');
INSERT INTO `infinitive_english_translation` VALUES ('1291', '473', ' to cause to fall into disorder');
INSERT INTO `infinitive_english_translation` VALUES ('1292', '474', 'to express');
INSERT INTO `infinitive_english_translation` VALUES ('1293', '474', ' to indicate');
INSERT INTO `infinitive_english_translation` VALUES ('1294', '474', ' to state');
INSERT INTO `infinitive_english_translation` VALUES ('1295', '474', ' to explain');
INSERT INTO `infinitive_english_translation` VALUES ('1296', '475', 'to act fearlessly');
INSERT INTO `infinitive_english_translation` VALUES ('1297', '475', ' to show dauntlessness');
INSERT INTO `infinitive_english_translation` VALUES ('1298', '475', ' to be daring; obs. to show indescretion');
INSERT INTO `infinitive_english_translation` VALUES ('1299', '476', 'to act fearlessly');
INSERT INTO `infinitive_english_translation` VALUES ('1300', '476', ' to show dauntlessness');
INSERT INTO `infinitive_english_translation` VALUES ('1301', '476', ' to be daring; obs. to show indescretion');
INSERT INTO `infinitive_english_translation` VALUES ('1302', '477', 'to wake up');
INSERT INTO `infinitive_english_translation` VALUES ('1303', '477', ' to awaken');
INSERT INTO `infinitive_english_translation` VALUES ('1304', '478', 'to wake up someone');
INSERT INTO `infinitive_english_translation` VALUES ('1305', '478', ' to get someone up');
INSERT INTO `infinitive_english_translation` VALUES ('1306', '478', ' to cause someone to awaken');
INSERT INTO `infinitive_english_translation` VALUES ('1307', '479', 'to jump out');
INSERT INTO `infinitive_english_translation` VALUES ('1308', '479', ' to fly out');
INSERT INTO `infinitive_english_translation` VALUES ('1309', '480', 'to be sick');
INSERT INTO `infinitive_english_translation` VALUES ('1310', '480', ' to be ill');
INSERT INTO `infinitive_english_translation` VALUES ('1311', '480', ' to be indisposed');
INSERT INTO `infinitive_english_translation` VALUES ('1312', '480', ' to be diseased');
INSERT INTO `infinitive_english_translation` VALUES ('1313', '481', 'to become ill');
INSERT INTO `infinitive_english_translation` VALUES ('1314', '481', ' to get sick');
INSERT INTO `infinitive_english_translation` VALUES ('1315', '481', ' to sicken');
INSERT INTO `infinitive_english_translation` VALUES ('1316', '482', 'to make sick');
INSERT INTO `infinitive_english_translation` VALUES ('1317', '482', ' to make ill');
INSERT INTO `infinitive_english_translation` VALUES ('1318', '482', ' to sicken');
INSERT INTO `infinitive_english_translation` VALUES ('1319', '483', 'fig. to be born');
INSERT INTO `infinitive_english_translation` VALUES ('1320', '483', ' to come into the world');
INSERT INTO `infinitive_english_translation` VALUES ('1321', '484', 'fig. to be born');
INSERT INTO `infinitive_english_translation` VALUES ('1322', '484', ' to come into the world');
INSERT INTO `infinitive_english_translation` VALUES ('1323', '485', 'fig. to be born');
INSERT INTO `infinitive_english_translation` VALUES ('1324', '485', ' to come into the world');
INSERT INTO `infinitive_english_translation` VALUES ('1325', '486', 'colloq. fig. to start getting old');
INSERT INTO `infinitive_english_translation` VALUES ('1326', '486', ' to reach middle-age');
INSERT INTO `infinitive_english_translation` VALUES ('1327', '487', 'fig. to be born');
INSERT INTO `infinitive_english_translation` VALUES ('1328', '487', ' to come into the world');
INSERT INTO `infinitive_english_translation` VALUES ('1329', '488', 'fig. to be born');
INSERT INTO `infinitive_english_translation` VALUES ('1330', '488', ' to come into the world');
INSERT INTO `infinitive_english_translation` VALUES ('1331', '489', 'to intercede');
INSERT INTO `infinitive_english_translation` VALUES ('1332', '489', ' to intervene');
INSERT INTO `infinitive_english_translation` VALUES ('1333', '489', ' to mediate');
INSERT INTO `infinitive_english_translation` VALUES ('1334', '490', 'to intercede');
INSERT INTO `infinitive_english_translation` VALUES ('1335', '490', ' to intervene');
INSERT INTO `infinitive_english_translation` VALUES ('1336', '490', ' to mediate');
INSERT INTO `infinitive_english_translation` VALUES ('1337', '491', 'colloq. fig. to go between');
INSERT INTO `infinitive_english_translation` VALUES ('1338', '491', ' to intercede');
INSERT INTO `infinitive_english_translation` VALUES ('1339', '491', ' to intervene');
INSERT INTO `infinitive_english_translation` VALUES ('1340', '491', ' to mediate');
INSERT INTO `infinitive_english_translation` VALUES ('1341', '491', ' to arbitrate');
INSERT INTO `infinitive_english_translation` VALUES ('1342', '492', 'colloq. fig. to go between');
INSERT INTO `infinitive_english_translation` VALUES ('1343', '492', ' to intercede');
INSERT INTO `infinitive_english_translation` VALUES ('1344', '492', ' to intervene');
INSERT INTO `infinitive_english_translation` VALUES ('1345', '492', ' to mediate');
INSERT INTO `infinitive_english_translation` VALUES ('1346', '492', ' to arbitrate');
INSERT INTO `infinitive_english_translation` VALUES ('1347', '493', 'to be torn');
INSERT INTO `infinitive_english_translation` VALUES ('1348', '493', ' to be ripped');
INSERT INTO `infinitive_english_translation` VALUES ('1349', '494', 'to tear');
INSERT INTO `infinitive_english_translation` VALUES ('1350', '494', ' to rip');
INSERT INTO `infinitive_english_translation` VALUES ('1351', '494', ' to tear to pieces');
INSERT INTO `infinitive_english_translation` VALUES ('1352', '494', ' to rip apart');
INSERT INTO `infinitive_english_translation` VALUES ('1353', '495', 'to keep watch');
INSERT INTO `infinitive_english_translation` VALUES ('1354', '495', ' to guard');
INSERT INTO `infinitive_english_translation` VALUES ('1355', '495', ' to pass');
INSERT INTO `infinitive_english_translation` VALUES ('1356', '496', 'to answer');
INSERT INTO `infinitive_english_translation` VALUES ('1357', '497', 'to clean');
INSERT INTO `infinitive_english_translation` VALUES ('1358', '497', ' to cleanse');
INSERT INTO `infinitive_english_translation` VALUES ('1359', '497', ' to purify');
INSERT INTO `infinitive_english_translation` VALUES ('1360', '497', ' to settle');
INSERT INTO `infinitive_english_translation` VALUES ('1361', '497', ' to wipe');
INSERT INTO `infinitive_english_translation` VALUES ('1362', '497', ' to erase');
INSERT INTO `infinitive_english_translation` VALUES ('1363', '498', 'to punch holes (in paper)');
INSERT INTO `infinitive_english_translation` VALUES ('1364', '498', ' to use a hole-punch');
INSERT INTO `infinitive_english_translation` VALUES ('1365', '499', 'to help');
INSERT INTO `infinitive_english_translation` VALUES ('1366', '499', ' to succor');
INSERT INTO `infinitive_english_translation` VALUES ('1367', '499', ' to support');
INSERT INTO `infinitive_english_translation` VALUES ('1368', '500', 'to bring down');
INSERT INTO `infinitive_english_translation` VALUES ('1369', '500', ' to lower');
INSERT INTO `infinitive_english_translation` VALUES ('1370', '501', 'to bring down');
INSERT INTO `infinitive_english_translation` VALUES ('1371', '501', ' to lower');
INSERT INTO `infinitive_english_translation` VALUES ('1372', '502', 'colloq. to cook');
INSERT INTO `infinitive_english_translation` VALUES ('1373', '503', 'to fill');
INSERT INTO `infinitive_english_translation` VALUES ('1374', '503', ' to fill up');
INSERT INTO `infinitive_english_translation` VALUES ('1375', '503', ' to pile up');
INSERT INTO `infinitive_english_translation` VALUES ('1376', '503', ' to tank up');
INSERT INTO `infinitive_english_translation` VALUES ('1377', '503', ' to lay in a store');
INSERT INTO `infinitive_english_translation` VALUES ('1378', '503', ' to do fully');
INSERT INTO `infinitive_english_translation` VALUES ('1379', '503', ' to do to the maximum extent');
INSERT INTO `infinitive_english_translation` VALUES ('1380', '503', ' to complete');
INSERT INTO `infinitive_english_translation` VALUES ('1381', '503', ' to saturate');
INSERT INTO `infinitive_english_translation` VALUES ('1382', '503', ' to make replete');
INSERT INTO `infinitive_english_translation` VALUES ('1383', '504', 'comp. to process (data)');
INSERT INTO `infinitive_english_translation` VALUES ('1384', '504', ' to crunch (numbers)');
INSERT INTO `infinitive_english_translation` VALUES ('1385', '505', 'to ask');
INSERT INTO `infinitive_english_translation` VALUES ('1386', '505', ' to inquire');
INSERT INTO `infinitive_english_translation` VALUES ('1387', '506', 'to catch butterflies; sl. to smoke (cigarettes');
INSERT INTO `infinitive_english_translation` VALUES ('1388', '506', ' etc.)');
INSERT INTO `infinitive_english_translation` VALUES ('1389', '507', 'to create a file');
INSERT INTO `infinitive_english_translation` VALUES ('1390', '507', ' to prepare a file');
INSERT INTO `infinitive_english_translation` VALUES ('1391', '508', 'to fabricate a case');
INSERT INTO `infinitive_english_translation` VALUES ('1392', '508', ' to frame');
INSERT INTO `infinitive_english_translation` VALUES ('1393', '509', 'to fabricate a case');
INSERT INTO `infinitive_english_translation` VALUES ('1394', '509', ' to frame');
INSERT INTO `infinitive_english_translation` VALUES ('1395', '510', 'to become disordered; obs. to become disheveled; f');
INSERT INTO `infinitive_english_translation` VALUES ('1396', '510', ' to become upset');
INSERT INTO `infinitive_english_translation` VALUES ('1397', '511', 'to put in disorder');
INSERT INTO `infinitive_english_translation` VALUES ('1398', '511', ' to dishevel; fig. to put in distress');
INSERT INTO `infinitive_english_translation` VALUES ('1399', '511', ' to upset');
INSERT INTO `infinitive_english_translation` VALUES ('1400', '512', 'to research');
INSERT INTO `infinitive_english_translation` VALUES ('1401', '512', ' to serach');
INSERT INTO `infinitive_english_translation` VALUES ('1402', '512', ' to investigate');
INSERT INTO `infinitive_english_translation` VALUES ('1403', '513', 'to research');
INSERT INTO `infinitive_english_translation` VALUES ('1404', '513', ' to serach');
INSERT INTO `infinitive_english_translation` VALUES ('1405', '513', ' to investigate');
INSERT INTO `infinitive_english_translation` VALUES ('1406', '514', 'to give back');
INSERT INTO `infinitive_english_translation` VALUES ('1407', '514', ' to return');
INSERT INTO `infinitive_english_translation` VALUES ('1408', '514', ' to leak');
INSERT INTO `infinitive_english_translation` VALUES ('1409', '514', ' to ooze out; colloq. to spit back');
INSERT INTO `infinitive_english_translation` VALUES ('1410', '514', ' to regurge (memorized info)');
INSERT INTO `infinitive_english_translation` VALUES ('1411', '515', 'to take back');
INSERT INTO `infinitive_english_translation` VALUES ('1412', '516', 'to debase');
INSERT INTO `infinitive_english_translation` VALUES ('1413', '516', ' to degrade');
INSERT INTO `infinitive_english_translation` VALUES ('1414', '516', ' to ruin');
INSERT INTO `infinitive_english_translation` VALUES ('1415', '516', ' to kill');
INSERT INTO `infinitive_english_translation` VALUES ('1416', '517', 'obs. to like');
INSERT INTO `infinitive_english_translation` VALUES ('1417', '517', ' to find pleasing');
INSERT INTO `infinitive_english_translation` VALUES ('1418', '518', 'obs to like; obs. to find pleasing');
INSERT INTO `infinitive_english_translation` VALUES ('1419', '519', 'to like');
INSERT INTO `infinitive_english_translation` VALUES ('1420', '519', ' to favor');
INSERT INTO `infinitive_english_translation` VALUES ('1421', '519', ' to admire');
INSERT INTO `infinitive_english_translation` VALUES ('1422', '519', ' to prefer; obs. to choose');
INSERT INTO `infinitive_english_translation` VALUES ('1423', '519', ' to select');
INSERT INTO `infinitive_english_translation` VALUES ('1424', '520', 'to trip');
INSERT INTO `infinitive_english_translation` VALUES ('1425', '520', ' to stumble');
INSERT INTO `infinitive_english_translation` VALUES ('1426', '520', ' to have an accident; fig. to be tripped up');
INSERT INTO `infinitive_english_translation` VALUES ('1427', '521', 'to trip; fig. to renounce');
INSERT INTO `infinitive_english_translation` VALUES ('1428', '521', ' to ruin');
INSERT INTO `infinitive_english_translation` VALUES ('1429', '522', 'to have stamina');
INSERT INTO `infinitive_english_translation` VALUES ('1430', '522', ' to have staying power');
INSERT INTO `infinitive_english_translation` VALUES ('1431', '522', ' to have drive');
INSERT INTO `infinitive_english_translation` VALUES ('1432', '522', ' to persevere');
INSERT INTO `infinitive_english_translation` VALUES ('1433', '522', ' to persist');
INSERT INTO `infinitive_english_translation` VALUES ('1434', '523', 'to gin');
INSERT INTO `infinitive_english_translation` VALUES ('1435', '523', ' to comb cotton');
INSERT INTO `infinitive_english_translation` VALUES ('1436', '523', ' to card cotton');
INSERT INTO `infinitive_english_translation` VALUES ('1437', '524', 'to gin');
INSERT INTO `infinitive_english_translation` VALUES ('1438', '524', ' to comb cotton');
INSERT INTO `infinitive_english_translation` VALUES ('1439', '524', ' to card cotton');
INSERT INTO `infinitive_english_translation` VALUES ('1440', '525', 'to skin; fig. to fleece');
INSERT INTO `infinitive_english_translation` VALUES ('1441', '525', ' to take to the cleaners');
INSERT INTO `infinitive_english_translation` VALUES ('1442', '526', 'to give a tip');
INSERT INTO `infinitive_english_translation` VALUES ('1443', '526', ' to tip');
INSERT INTO `infinitive_english_translation` VALUES ('1444', '527', 'to give a tip');
INSERT INTO `infinitive_english_translation` VALUES ('1445', '527', ' to tip');
INSERT INTO `infinitive_english_translation` VALUES ('1446', '528', 'to spend money');
INSERT INTO `infinitive_english_translation` VALUES ('1447', '529', 'to have change');
INSERT INTO `infinitive_english_translation` VALUES ('1448', '529', ' to have small bills');
INSERT INTO `infinitive_english_translation` VALUES ('1449', '530', 'to pay');
INSERT INTO `infinitive_english_translation` VALUES ('1450', '530', ' to pay money');
INSERT INTO `infinitive_english_translation` VALUES ('1451', '531', 'fig. to waste money');
INSERT INTO `infinitive_english_translation` VALUES ('1452', '531', ' to throw away good money');
INSERT INTO `infinitive_english_translation` VALUES ('1453', '532', 'to waste money');
INSERT INTO `infinitive_english_translation` VALUES ('1454', '533', 'to walk');
INSERT INTO `infinitive_english_translation` VALUES ('1455', '533', ' to go on foot');
INSERT INTO `infinitive_english_translation` VALUES ('1456', '534', 'to dismount');
INSERT INTO `infinitive_english_translation` VALUES ('1457', '534', ' to disembark');
INSERT INTO `infinitive_english_translation` VALUES ('1458', '534', ' to get off');
INSERT INTO `infinitive_english_translation` VALUES ('1459', '534', ' to get out');
INSERT INTO `infinitive_english_translation` VALUES ('1460', '534', ' to get down; colloq. fig. to be implemented');
INSERT INTO `infinitive_english_translation` VALUES ('1461', '534', ' to be carried out');
INSERT INTO `infinitive_english_translation` VALUES ('1462', '535', 'to unload');
INSERT INTO `infinitive_english_translation` VALUES ('1463', '535', ' to let off (passengers)');
INSERT INTO `infinitive_english_translation` VALUES ('1464', '535', ' to dismantle');
INSERT INTO `infinitive_english_translation` VALUES ('1465', '535', ' to disassemble');
INSERT INTO `infinitive_english_translation` VALUES ('1466', '535', ' to overhaul');
INSERT INTO `infinitive_english_translation` VALUES ('1467', '535', ' to carry out');
INSERT INTO `infinitive_english_translation` VALUES ('1468', '535', ' to implement');
INSERT INTO `infinitive_english_translation` VALUES ('1469', '536', 'to play the piano');
INSERT INTO `infinitive_english_translation` VALUES ('1470', '537', 'to find');
INSERT INTO `infinitive_english_translation` VALUES ('1471', '537', ' to acquire');
INSERT INTO `infinitive_english_translation` VALUES ('1472', '537', ' to obtain');
INSERT INTO `infinitive_english_translation` VALUES ('1473', '537', ' to get');
INSERT INTO `infinitive_english_translation` VALUES ('1474', '537', ' to develop; obs. to discover');
INSERT INTO `infinitive_english_translation` VALUES ('1475', '537', ' to reveal');
INSERT INTO `infinitive_english_translation` VALUES ('1476', '537', ' to cause to appear');
INSERT INTO `infinitive_english_translation` VALUES ('1477', '537', ' to show');
INSERT INTO `infinitive_english_translation` VALUES ('1478', '538', 'to find');
INSERT INTO `infinitive_english_translation` VALUES ('1479', '538', ' to acquire');
INSERT INTO `infinitive_english_translation` VALUES ('1480', '538', ' to obtain');
INSERT INTO `infinitive_english_translation` VALUES ('1481', '538', ' to get');
INSERT INTO `infinitive_english_translation` VALUES ('1482', '538', ' to develop; obs. to discover');
INSERT INTO `infinitive_english_translation` VALUES ('1483', '538', ' to reveal');
INSERT INTO `infinitive_english_translation` VALUES ('1484', '538', ' to cause to appear');
INSERT INTO `infinitive_english_translation` VALUES ('1485', '538', ' to show');
INSERT INTO `infinitive_english_translation` VALUES ('1486', '539', 'to raid');
INSERT INTO `infinitive_english_translation` VALUES ('1487', '539', ' to invade');
INSERT INTO `infinitive_english_translation` VALUES ('1488', '539', ' to attack');
INSERT INTO `infinitive_english_translation` VALUES ('1489', '539', ' to pillage');
INSERT INTO `infinitive_english_translation` VALUES ('1490', '540', 'to be whipped');
INSERT INTO `infinitive_english_translation` VALUES ('1491', '540', ' to receive lashes');
INSERT INTO `infinitive_english_translation` VALUES ('1492', '540', ' to get a flogging');
INSERT INTO `infinitive_english_translation` VALUES ('1493', '541', 'to whip');
INSERT INTO `infinitive_english_translation` VALUES ('1494', '541', ' to lash');
INSERT INTO `infinitive_english_translation` VALUES ('1495', '541', ' to flog');
INSERT INTO `infinitive_english_translation` VALUES ('1496', '542', 'to type');
INSERT INTO `infinitive_english_translation` VALUES ('1497', '543', 'to teach manners');
INSERT INTO `infinitive_english_translation` VALUES ('1498', '543', ' to instill with culture');
INSERT INTO `infinitive_english_translation` VALUES ('1499', '543', ' to punish');
INSERT INTO `infinitive_english_translation` VALUES ('1500', '543', ' to correct');
INSERT INTO `infinitive_english_translation` VALUES ('1501', '544', 'to think');
INSERT INTO `infinitive_english_translation` VALUES ('1502', '544', ' to deliberate');
INSERT INTO `infinitive_english_translation` VALUES ('1503', '544', ' to reflect');
INSERT INTO `infinitive_english_translation` VALUES ('1504', '544', ' to hesitate');
INSERT INTO `infinitive_english_translation` VALUES ('1505', '545', 'to become changed');
INSERT INTO `infinitive_english_translation` VALUES ('1506', '546', 'to change');
INSERT INTO `infinitive_english_translation` VALUES ('1507', '547', 'to research');
INSERT INTO `infinitive_english_translation` VALUES ('1508', '547', ' to investigate; lit. to imitate; obs. to follow');
INSERT INTO `infinitive_english_translation` VALUES ('1509', '548', 'to violate');
INSERT INTO `infinitive_english_translation` VALUES ('1510', '548', ' to infringe');
INSERT INTO `infinitive_english_translation` VALUES ('1511', '548', ' to transgress');
INSERT INTO `infinitive_english_translation` VALUES ('1512', '548', ' to transgress');
INSERT INTO `infinitive_english_translation` VALUES ('1513', '548', ' to attack');
INSERT INTO `infinitive_english_translation` VALUES ('1514', '548', ' to assault');
INSERT INTO `infinitive_english_translation` VALUES ('1515', '548', ' to rape');
INSERT INTO `infinitive_english_translation` VALUES ('1516', '549', 'to analyze');
INSERT INTO `infinitive_english_translation` VALUES ('1517', '549', ' to to examine');
INSERT INTO `infinitive_english_translation` VALUES ('1518', '549', ' to test');
INSERT INTO `infinitive_english_translation` VALUES ('1519', '549', ' to break down');
INSERT INTO `infinitive_english_translation` VALUES ('1520', '550', 'to analyze');
INSERT INTO `infinitive_english_translation` VALUES ('1521', '550', ' to perform an analysis');
INSERT INTO `infinitive_english_translation` VALUES ('1522', '551', 'to study');
INSERT INTO `infinitive_english_translation` VALUES ('1523', '551', ' to receive education');
INSERT INTO `infinitive_english_translation` VALUES ('1524', '551', ' to be educated');
INSERT INTO `infinitive_english_translation` VALUES ('1525', '551', ' to acquire');
INSERT INTO `infinitive_english_translation` VALUES ('1526', '551', ' to obtain');
INSERT INTO `infinitive_english_translation` VALUES ('1527', '552', 'to investigate');
INSERT INTO `infinitive_english_translation` VALUES ('1528', '552', ' to research');
INSERT INTO `infinitive_english_translation` VALUES ('1529', '552', ' to study');
INSERT INTO `infinitive_english_translation` VALUES ('1530', '552', ' to probe');
INSERT INTO `infinitive_english_translation` VALUES ('1531', '552', ' to verify');
INSERT INTO `infinitive_english_translation` VALUES ('1532', '552', ' to ascertain');
INSERT INTO `infinitive_english_translation` VALUES ('1533', '553', 'to investigate');
INSERT INTO `infinitive_english_translation` VALUES ('1534', '553', ' to research');
INSERT INTO `infinitive_english_translation` VALUES ('1535', '553', ' to study');
INSERT INTO `infinitive_english_translation` VALUES ('1536', '553', ' to probe');
INSERT INTO `infinitive_english_translation` VALUES ('1537', '553', ' to verify');
INSERT INTO `infinitive_english_translation` VALUES ('1538', '553', ' to ascertain');
INSERT INTO `infinitive_english_translation` VALUES ('1539', '554', 'to analyze');
INSERT INTO `infinitive_english_translation` VALUES ('1540', '554', ' to investigate');
INSERT INTO `infinitive_english_translation` VALUES ('1541', '554', ' to break down');
INSERT INTO `infinitive_english_translation` VALUES ('1542', '555', 'to hand over');
INSERT INTO `infinitive_english_translation` VALUES ('1543', '555', ' to deliver');
INSERT INTO `infinitive_english_translation` VALUES ('1544', '556', 'to give a discount');
INSERT INTO `infinitive_english_translation` VALUES ('1545', '556', ' to reduce');
INSERT INTO `infinitive_english_translation` VALUES ('1546', '556', ' to cut down');
INSERT INTO `infinitive_english_translation` VALUES ('1547', '557', 'to get a discount');
INSERT INTO `infinitive_english_translation` VALUES ('1548', '557', ' to receive a price reduction');
INSERT INTO `infinitive_english_translation` VALUES ('1549', '558', 'to become translated');
INSERT INTO `infinitive_english_translation` VALUES ('1550', '558', ' to be translated');
INSERT INTO `infinitive_english_translation` VALUES ('1551', '559', 'to translate');
INSERT INTO `infinitive_english_translation` VALUES ('1552', '560', 'to leave');
INSERT INTO `infinitive_english_translation` VALUES ('1553', '560', ' to quit');
INSERT INTO `infinitive_english_translation` VALUES ('1554', '560', ' to renounce');
INSERT INTO `infinitive_english_translation` VALUES ('1555', '560', ' to abandon');
INSERT INTO `infinitive_english_translation` VALUES ('1556', '561', 'to be mixed');
INSERT INTO `infinitive_english_translation` VALUES ('1557', '561', ' to be combined');
INSERT INTO `infinitive_english_translation` VALUES ('1558', '561', ' to mix');
INSERT INTO `infinitive_english_translation` VALUES ('1559', '561', ' to combine');
INSERT INTO `infinitive_english_translation` VALUES ('1560', '562', 'to mix');
INSERT INTO `infinitive_english_translation` VALUES ('1561', '562', ' to combine');
INSERT INTO `infinitive_english_translation` VALUES ('1562', '562', ' to compound');
INSERT INTO `infinitive_english_translation` VALUES ('1563', '562', ' to amalgamate');
INSERT INTO `infinitive_english_translation` VALUES ('1564', '562', ' to put together');
INSERT INTO `infinitive_english_translation` VALUES ('1565', '563', 'to describe');
INSERT INTO `infinitive_english_translation` VALUES ('1566', '563', ' to explain');
INSERT INTO `infinitive_english_translation` VALUES ('1567', '563', ' to analyze');
INSERT INTO `infinitive_english_translation` VALUES ('1568', '564', 'to come');
INSERT INTO `infinitive_english_translation` VALUES ('1569', '565', 'to come');
INSERT INTO `infinitive_english_translation` VALUES ('1570', '566', 'to thank');
INSERT INTO `infinitive_english_translation` VALUES ('1571', '567', 'to form');
INSERT INTO `infinitive_english_translation` VALUES ('1572', '567', ' to put together');
INSERT INTO `infinitive_english_translation` VALUES ('1573', '567', ' to organize');
INSERT INTO `infinitive_english_translation` VALUES ('1574', '568', 'to correct');
INSERT INTO `infinitive_english_translation` VALUES ('1575', '568', ' to edit');
INSERT INTO `infinitive_english_translation` VALUES ('1576', '568', ' to revise');
INSERT INTO `infinitive_english_translation` VALUES ('1577', '568', ' to proofread');
INSERT INTO `infinitive_english_translation` VALUES ('1578', '568', ' to establish the authenticity of a manuscript');
INSERT INTO `infinitive_english_translation` VALUES ('1579', '569', 'to correct');
INSERT INTO `infinitive_english_translation` VALUES ('1580', '569', ' to edit');
INSERT INTO `infinitive_english_translation` VALUES ('1581', '569', ' to revise');
INSERT INTO `infinitive_english_translation` VALUES ('1582', '569', ' to proofread');
INSERT INTO `infinitive_english_translation` VALUES ('1583', '569', ' to establish the authenticity of a manuscript');
INSERT INTO `infinitive_english_translation` VALUES ('1584', '570', 'to decide');
INSERT INTO `infinitive_english_translation` VALUES ('1585', '571', 'to decide');
INSERT INTO `infinitive_english_translation` VALUES ('1586', '572', 'obs. to decide');
INSERT INTO `infinitive_english_translation` VALUES ('1587', '573', 'to imagine');
INSERT INTO `infinitive_english_translation` VALUES ('1588', '573', ' to conceive');
INSERT INTO `infinitive_english_translation` VALUES ('1589', '573', ' to suppose');
INSERT INTO `infinitive_english_translation` VALUES ('1590', '573', ' to think');
INSERT INTO `infinitive_english_translation` VALUES ('1591', '574', 'to be polite');
INSERT INTO `infinitive_english_translation` VALUES ('1592', '574', ' to stand on ceremony');
INSERT INTO `infinitive_english_translation` VALUES ('1593', '574', ' to compliment');
INSERT INTO `infinitive_english_translation` VALUES ('1594', '574', ' to use flattery');
INSERT INTO `infinitive_english_translation` VALUES ('1595', '574', ' to act reserved');
INSERT INTO `infinitive_english_translation` VALUES ('1596', '574', ' to serve');
INSERT INTO `infinitive_english_translation` VALUES ('1597', '574', ' to offer');
INSERT INTO `infinitive_english_translation` VALUES ('1598', '574', ' to present gifts');
INSERT INTO `infinitive_english_translation` VALUES ('1599', '575', 'to be polite');
INSERT INTO `infinitive_english_translation` VALUES ('1600', '575', ' to stand on ceremony');
INSERT INTO `infinitive_english_translation` VALUES ('1601', '575', ' to compliment');
INSERT INTO `infinitive_english_translation` VALUES ('1602', '575', ' to use flattery');
INSERT INTO `infinitive_english_translation` VALUES ('1603', '575', ' to act reserved');
INSERT INTO `infinitive_english_translation` VALUES ('1604', '575', ' to serve');
INSERT INTO `infinitive_english_translation` VALUES ('1605', '575', ' to offer');
INSERT INTO `infinitive_english_translation` VALUES ('1606', '575', ' to present gifts');
INSERT INTO `infinitive_english_translation` VALUES ('1607', '576', 'to interpret');
INSERT INTO `infinitive_english_translation` VALUES ('1608', '576', ' to explain');
INSERT INTO `infinitive_english_translation` VALUES ('1609', '576', ' to construct');
INSERT INTO `infinitive_english_translation` VALUES ('1610', '577', 'to tyrannize');
INSERT INTO `infinitive_english_translation` VALUES ('1611', '577', ' to oppress');
INSERT INTO `infinitive_english_translation` VALUES ('1612', '577', ' to transgress');
INSERT INTO `infinitive_english_translation` VALUES ('1613', '577', ' to encroach');
INSERT INTO `infinitive_english_translation` VALUES ('1614', '577', ' to invade');
INSERT INTO `infinitive_english_translation` VALUES ('1615', '578', 'to change');
INSERT INTO `infinitive_english_translation` VALUES ('1616', '578', ' to vary');
INSERT INTO `infinitive_english_translation` VALUES ('1617', '579', 'to explain');
INSERT INTO `infinitive_english_translation` VALUES ('1618', '579', ' to explicate');
INSERT INTO `infinitive_english_translation` VALUES ('1619', '579', ' to interpret');
INSERT INTO `infinitive_english_translation` VALUES ('1620', '579', ' to give commentary');
INSERT INTO `infinitive_english_translation` VALUES ('1621', '580', 'to think');
INSERT INTO `infinitive_english_translation` VALUES ('1622', '580', ' to meditate');
INSERT INTO `infinitive_english_translation` VALUES ('1623', '580', ' to reflect');
INSERT INTO `infinitive_english_translation` VALUES ('1624', '581', 'to request');
INSERT INTO `infinitive_english_translation` VALUES ('1625', '581', ' to appeal');
INSERT INTO `infinitive_english_translation` VALUES ('1626', '581', ' to beseech');
INSERT INTO `infinitive_english_translation` VALUES ('1627', '581', ' to apply');
INSERT INTO `infinitive_english_translation` VALUES ('1628', '582', 'to request');
INSERT INTO `infinitive_english_translation` VALUES ('1629', '582', ' to appeal');
INSERT INTO `infinitive_english_translation` VALUES ('1630', '582', ' to beseech');
INSERT INTO `infinitive_english_translation` VALUES ('1631', '582', ' to apply');
INSERT INTO `infinitive_english_translation` VALUES ('1632', '583', 'to divide');
INSERT INTO `infinitive_english_translation` VALUES ('1633', '583', ' to distribute');
INSERT INTO `infinitive_english_translation` VALUES ('1634', '584', 'to divide');
INSERT INTO `infinitive_english_translation` VALUES ('1635', '584', ' to distribute');
INSERT INTO `infinitive_english_translation` VALUES ('1636', '585', 'colloq. to struggle');
INSERT INTO `infinitive_english_translation` VALUES ('1637', '585', ' to strive');
INSERT INTO `infinitive_english_translation` VALUES ('1638', '585', ' to scramble');
INSERT INTO `infinitive_english_translation` VALUES ('1639', '585', ' to flounder');
INSERT INTO `infinitive_english_translation` VALUES ('1640', '586', 'colloq. to struggle');
INSERT INTO `infinitive_english_translation` VALUES ('1641', '586', ' to strive');
INSERT INTO `infinitive_english_translation` VALUES ('1642', '586', ' to scramble');
INSERT INTO `infinitive_english_translation` VALUES ('1643', '586', ' to flounder');
INSERT INTO `infinitive_english_translation` VALUES ('1644', '587', 'to struggle');
INSERT INTO `infinitive_english_translation` VALUES ('1645', '587', ' to hustle and bustle');
INSERT INTO `infinitive_english_translation` VALUES ('1646', '587', ' to scramble');
INSERT INTO `infinitive_english_translation` VALUES ('1647', '588', 'to move');
INSERT INTO `infinitive_english_translation` VALUES ('1648', '588', ' to scare; fig. to give a jolt');
INSERT INTO `infinitive_english_translation` VALUES ('1649', '589', 'to move');
INSERT INTO `infinitive_english_translation` VALUES ('1650', '589', ' to scare; fig. to give a jolt');
INSERT INTO `infinitive_english_translation` VALUES ('1651', '590', 'to repeat');
INSERT INTO `infinitive_english_translation` VALUES ('1652', '591', 'to try');
INSERT INTO `infinitive_english_translation` VALUES ('1653', '591', ' to struggle');
INSERT INTO `infinitive_english_translation` VALUES ('1654', '591', ' to strive');
INSERT INTO `infinitive_english_translation` VALUES ('1655', '591', ' to endeavor');
INSERT INTO `infinitive_english_translation` VALUES ('1656', '591', ' to labor');
INSERT INTO `infinitive_english_translation` VALUES ('1657', '592', 'to pronounce');
INSERT INTO `infinitive_english_translation` VALUES ('1658', '592', ' to utter');
INSERT INTO `infinitive_english_translation` VALUES ('1659', '592', ' to enunciate');
INSERT INTO `infinitive_english_translation` VALUES ('1660', '592', ' to sound');
INSERT INTO `infinitive_english_translation` VALUES ('1661', '593', 'to telephone');
INSERT INTO `infinitive_english_translation` VALUES ('1662', '594', 'to telephone');
INSERT INTO `infinitive_english_translation` VALUES ('1663', '595', 'to watch; obs. to sightsee');
INSERT INTO `infinitive_english_translation` VALUES ('1664', '596', 'to become complete');
INSERT INTO `infinitive_english_translation` VALUES ('1665', '596', ' to be finished');
INSERT INTO `infinitive_english_translation` VALUES ('1666', '596', ' to end');
INSERT INTO `infinitive_english_translation` VALUES ('1667', '596', ' to become used up');
INSERT INTO `infinitive_english_translation` VALUES ('1668', '596', ' to become exhausted');
INSERT INTO `infinitive_english_translation` VALUES ('1669', '597', 'to become complete');
INSERT INTO `infinitive_english_translation` VALUES ('1670', '597', ' to be finished');
INSERT INTO `infinitive_english_translation` VALUES ('1671', '597', ' to end');
INSERT INTO `infinitive_english_translation` VALUES ('1672', '597', ' to become used up');
INSERT INTO `infinitive_english_translation` VALUES ('1673', '597', ' to become exhausted');
INSERT INTO `infinitive_english_translation` VALUES ('1674', '598', 'to practice');
INSERT INTO `infinitive_english_translation` VALUES ('1675', '598', ' to exercise');
INSERT INTO `infinitive_english_translation` VALUES ('1676', '598', ' to drill');
INSERT INTO `infinitive_english_translation` VALUES ('1677', '599', 'to entreat');
INSERT INTO `infinitive_english_translation` VALUES ('1678', '599', ' to supplicate');
INSERT INTO `infinitive_english_translation` VALUES ('1679', '599', ' to request; obs. to wish for');
INSERT INTO `infinitive_english_translation` VALUES ('1680', '599', ' to want');
INSERT INTO `infinitive_english_translation` VALUES ('1681', '600', 'to clean');
INSERT INTO `infinitive_english_translation` VALUES ('1682', '600', ' to dust');
INSERT INTO `infinitive_english_translation` VALUES ('1683', '600', ' to tidy');
INSERT INTO `infinitive_english_translation` VALUES ('1684', '600', ' to rinse');
INSERT INTO `infinitive_english_translation` VALUES ('1685', '600', ' to cleanse; obs. to discern');
INSERT INTO `infinitive_english_translation` VALUES ('1686', '601', 'to put on (clothing)');
INSERT INTO `infinitive_english_translation` VALUES ('1687', '601', ' to get dressed');
INSERT INTO `infinitive_english_translation` VALUES ('1688', '602', 'to punish; obs. to inform');
INSERT INTO `infinitive_english_translation` VALUES ('1689', '603', 'to punish; obs. to inform');
INSERT INTO `infinitive_english_translation` VALUES ('1690', '604', 'to bump (against)');
INSERT INTO `infinitive_english_translation` VALUES ('1691', '604', ' to hit');
INSERT INTO `infinitive_english_translation` VALUES ('1692', '604', ' to jostle');
INSERT INTO `infinitive_english_translation` VALUES ('1693', '605', 'to play tennis');
INSERT INTO `infinitive_english_translation` VALUES ('1694', '606', 'euph. to have to go to the bathroom');
INSERT INTO `infinitive_english_translation` VALUES ('1695', '606', ' to need to use the toilet');
INSERT INTO `infinitive_english_translation` VALUES ('1696', '606', ' to need to use the restroom');
INSERT INTO `infinitive_english_translation` VALUES ('1697', '607', 'euph. to go to the bathroom');
INSERT INTO `infinitive_english_translation` VALUES ('1698', '607', ' to use the toilet');
INSERT INTO `infinitive_english_translation` VALUES ('1699', '607', ' to use the restroom');
INSERT INTO `infinitive_english_translation` VALUES ('1700', '608', 'to put on make-up');
INSERT INTO `infinitive_english_translation` VALUES ('1701', '608', ' to put on cosmetics');
INSERT INTO `infinitive_english_translation` VALUES ('1702', '609', 'to pay attention');
INSERT INTO `infinitive_english_translation` VALUES ('1703', '609', ' to be attentive');
INSERT INTO `infinitive_english_translation` VALUES ('1704', '609', ' to concentrate');
INSERT INTO `infinitive_english_translation` VALUES ('1705', '609', ' to care');
INSERT INTO `infinitive_english_translation` VALUES ('1706', '609', ' to see to the needs (of)');
INSERT INTO `infinitive_english_translation` VALUES ('1707', '609', ' to show favor');
INSERT INTO `infinitive_english_translation` VALUES ('1708', '610', 'to justify');
INSERT INTO `infinitive_english_translation` VALUES ('1709', '610', ' to explain away');
INSERT INTO `infinitive_english_translation` VALUES ('1710', '610', ' to explain');
INSERT INTO `infinitive_english_translation` VALUES ('1711', '611', 'to justify');
INSERT INTO `infinitive_english_translation` VALUES ('1712', '611', ' to explain away');
INSERT INTO `infinitive_english_translation` VALUES ('1713', '611', ' to explain');
INSERT INTO `infinitive_english_translation` VALUES ('1714', '612', 'to be distributed');
INSERT INTO `infinitive_english_translation` VALUES ('1715', '612', ' to be passed out');
INSERT INTO `infinitive_english_translation` VALUES ('1716', '612', ' to be handed out');
INSERT INTO `infinitive_english_translation` VALUES ('1717', '613', 'to be distributed');
INSERT INTO `infinitive_english_translation` VALUES ('1718', '613', ' to be passed out');
INSERT INTO `infinitive_english_translation` VALUES ('1719', '613', ' to be handed out');
INSERT INTO `infinitive_english_translation` VALUES ('1720', '614', 'to distribute');
INSERT INTO `infinitive_english_translation` VALUES ('1721', '614', ' to pass out');
INSERT INTO `infinitive_english_translation` VALUES ('1722', '614', ' to hand out');
INSERT INTO `infinitive_english_translation` VALUES ('1723', '615', 'to distribute');
INSERT INTO `infinitive_english_translation` VALUES ('1724', '615', ' to pass out');
INSERT INTO `infinitive_english_translation` VALUES ('1725', '615', ' to hand out');
INSERT INTO `infinitive_english_translation` VALUES ('1726', '616', 'to suffer a beating on the head; fig. to be subjec');
INSERT INTO `infinitive_english_translation` VALUES ('1727', '616', ' to be the object of humiliation');
INSERT INTO `infinitive_english_translation` VALUES ('1728', '617', 'to hit someone on the head; fig. to demean');
INSERT INTO `infinitive_english_translation` VALUES ('1729', '617', ' to put down');
INSERT INTO `infinitive_english_translation` VALUES ('1730', '617', ' to humiliate');
INSERT INTO `infinitive_english_translation` VALUES ('1731', '618', 'to widen');
INSERT INTO `infinitive_english_translation` VALUES ('1732', '618', ' to expand');
INSERT INTO `infinitive_english_translation` VALUES ('1733', '618', ' to develop');
INSERT INTO `infinitive_english_translation` VALUES ('1734', '619', 'to widen');
INSERT INTO `infinitive_english_translation` VALUES ('1735', '619', ' to expand');
INSERT INTO `infinitive_english_translation` VALUES ('1736', '619', ' to develop');
INSERT INTO `infinitive_english_translation` VALUES ('1737', '620', 'to describe');
INSERT INTO `infinitive_english_translation` VALUES ('1738', '621', 'to describe');
INSERT INTO `infinitive_english_translation` VALUES ('1739', '622', 'to recommend');
INSERT INTO `infinitive_english_translation` VALUES ('1740', '622', ' to advise');
INSERT INTO `infinitive_english_translation` VALUES ('1741', '622', ' to counsel');
INSERT INTO `infinitive_english_translation` VALUES ('1742', '623', 'to recommend');
INSERT INTO `infinitive_english_translation` VALUES ('1743', '623', ' to advise');
INSERT INTO `infinitive_english_translation` VALUES ('1744', '623', ' to counsel');
INSERT INTO `infinitive_english_translation` VALUES ('1745', '624', 'to explain');
INSERT INTO `infinitive_english_translation` VALUES ('1746', '625', 'to explain');
INSERT INTO `infinitive_english_translation` VALUES ('1747', '626', 'to produce');
INSERT INTO `infinitive_english_translation` VALUES ('1748', '626', ' to generate');
INSERT INTO `infinitive_english_translation` VALUES ('1749', '626', ' to give rise (to)');
INSERT INTO `infinitive_english_translation` VALUES ('1750', '626', ' to bring about');
INSERT INTO `infinitive_english_translation` VALUES ('1751', '627', 'to produce');
INSERT INTO `infinitive_english_translation` VALUES ('1752', '627', ' to generate');
INSERT INTO `infinitive_english_translation` VALUES ('1753', '627', ' to give rise (to)');
INSERT INTO `infinitive_english_translation` VALUES ('1754', '627', ' to bring about');
INSERT INTO `infinitive_english_translation` VALUES ('1755', '628', 'to have illusions');
INSERT INTO `infinitive_english_translation` VALUES ('1756', '628', ' to suffer from delusions');
INSERT INTO `infinitive_english_translation` VALUES ('1757', '628', ' to hallucinate; obs. to fear');
INSERT INTO `infinitive_english_translation` VALUES ('1758', '629', 'obs. to imagine to hear or see things');
INSERT INTO `infinitive_english_translation` VALUES ('1759', '629', ' to see illusions');
INSERT INTO `infinitive_english_translation` VALUES ('1760', '629', ' to delude oneself');
INSERT INTO `infinitive_english_translation` VALUES ('1761', '629', ' to hallucinate');
INSERT INTO `infinitive_english_translation` VALUES ('1762', '630', 'to insult');
INSERT INTO `infinitive_english_translation` VALUES ('1763', '630', ' to offend; obs. to bring down');
INSERT INTO `infinitive_english_translation` VALUES ('1764', '630', ' to weaken');
INSERT INTO `infinitive_english_translation` VALUES ('1765', '631', 'to insult');
INSERT INTO `infinitive_english_translation` VALUES ('1766', '631', ' to offend; obs. to bring down');
INSERT INTO `infinitive_english_translation` VALUES ('1767', '631', ' to weaken');
INSERT INTO `infinitive_english_translation` VALUES ('1768', '632', 'to become used up');
INSERT INTO `infinitive_english_translation` VALUES ('1769', '632', ' to get consumed');
INSERT INTO `infinitive_english_translation` VALUES ('1770', '632', ' to be over');
INSERT INTO `infinitive_english_translation` VALUES ('1771', '632', ' to be out of');
INSERT INTO `infinitive_english_translation` VALUES ('1772', '632', ' to be exhausted');
INSERT INTO `infinitive_english_translation` VALUES ('1773', '632', ' to be spent');
INSERT INTO `infinitive_english_translation` VALUES ('1774', '633', 'to become empty');
INSERT INTO `infinitive_english_translation` VALUES ('1775', '633', ' to run out');
INSERT INTO `infinitive_english_translation` VALUES ('1776', '633', ' to get used up');
INSERT INTO `infinitive_english_translation` VALUES ('1777', '633', ' to become exhausted');
INSERT INTO `infinitive_english_translation` VALUES ('1778', '634', 'to become empty');
INSERT INTO `infinitive_english_translation` VALUES ('1779', '634', ' to run out');
INSERT INTO `infinitive_english_translation` VALUES ('1780', '634', ' to get used up');
INSERT INTO `infinitive_english_translation` VALUES ('1781', '634', ' to become exhausted');
INSERT INTO `infinitive_english_translation` VALUES ('1782', '635', 'to strike with a sword; fig. to milk');
INSERT INTO `infinitive_english_translation` VALUES ('1783', '635', ' to swindle');
INSERT INTO `infinitive_english_translation` VALUES ('1784', '636', 'to prove');
INSERT INTO `infinitive_english_translation` VALUES ('1785', '636', ' to establish');
INSERT INTO `infinitive_english_translation` VALUES ('1786', '636', ' to fix');
INSERT INTO `infinitive_english_translation` VALUES ('1787', '636', ' to stabilize');
INSERT INTO `infinitive_english_translation` VALUES ('1788', '637', 'to be steady');
INSERT INTO `infinitive_english_translation` VALUES ('1789', '637', ' to exhibit constancy');
INSERT INTO `infinitive_english_translation` VALUES ('1790', '637', ' to remain steadfast');
INSERT INTO `infinitive_english_translation` VALUES ('1791', '638', 'to be steady');
INSERT INTO `infinitive_english_translation` VALUES ('1792', '638', ' to exhibit constancy');
INSERT INTO `infinitive_english_translation` VALUES ('1793', '638', ' to remain steadfast');
INSERT INTO `infinitive_english_translation` VALUES ('1794', '639', 'to register');
INSERT INTO `infinitive_english_translation` VALUES ('1795', '639', ' to enlist');
INSERT INTO `infinitive_english_translation` VALUES ('1796', '640', 'to leave behind');
INSERT INTO `infinitive_english_translation` VALUES ('1797', '640', ' to forget');
INSERT INTO `infinitive_english_translation` VALUES ('1798', '640', ' to outdistance');
INSERT INTO `infinitive_english_translation` VALUES ('1799', '640', ' to leave some space');
INSERT INTO `infinitive_english_translation` VALUES ('1800', '640', ' to skip a space');
INSERT INTO `infinitive_english_translation` VALUES ('1801', '640', ' to indent');
INSERT INTO `infinitive_english_translation` VALUES ('1802', '641', 'to move');
INSERT INTO `infinitive_english_translation` VALUES ('1803', '641', ' to shift');
INSERT INTO `infinitive_english_translation` VALUES ('1804', '641', ' to reposition');
INSERT INTO `infinitive_english_translation` VALUES ('1805', '642', 'to sweep');
INSERT INTO `infinitive_english_translation` VALUES ('1806', '642', ' to clean');
INSERT INTO `infinitive_english_translation` VALUES ('1807', '643', 'to be separated');
INSERT INTO `infinitive_english_translation` VALUES ('1808', '643', ' to depart');
INSERT INTO `infinitive_english_translation` VALUES ('1809', '643', ' to separate');
INSERT INTO `infinitive_english_translation` VALUES ('1810', '643', ' to get divorced');
INSERT INTO `infinitive_english_translation` VALUES ('1811', '644', 'to separate');
INSERT INTO `infinitive_english_translation` VALUES ('1812', '644', ' to disconnect');
INSERT INTO `infinitive_english_translation` VALUES ('1813', '644', ' to sever');
INSERT INTO `infinitive_english_translation` VALUES ('1814', '644', ' to divide');
INSERT INTO `infinitive_english_translation` VALUES ('1815', '644', ' to seclude');
INSERT INTO `infinitive_english_translation` VALUES ('1816', '645', 'to try');
INSERT INTO `infinitive_english_translation` VALUES ('1817', '645', ' to struggle');
INSERT INTO `infinitive_english_translation` VALUES ('1818', '645', ' to strive');
INSERT INTO `infinitive_english_translation` VALUES ('1819', '645', ' to endeavor');
INSERT INTO `infinitive_english_translation` VALUES ('1820', '645', ' to labor');
INSERT INTO `infinitive_english_translation` VALUES ('1821', '646', 'to try');
INSERT INTO `infinitive_english_translation` VALUES ('1822', '646', ' to struggle');
INSERT INTO `infinitive_english_translation` VALUES ('1823', '646', ' to strive');
INSERT INTO `infinitive_english_translation` VALUES ('1824', '646', ' to endeavor');
INSERT INTO `infinitive_english_translation` VALUES ('1825', '646', ' to labor');
INSERT INTO `infinitive_english_translation` VALUES ('1826', '647', 'to summon up the courage needed');
INSERT INTO `infinitive_english_translation` VALUES ('1827', '647', ' to brave');
INSERT INTO `infinitive_english_translation` VALUES ('1828', '647', ' to dare');
INSERT INTO `infinitive_english_translation` VALUES ('1829', '648', 'to have courage');
INSERT INTO `infinitive_english_translation` VALUES ('1830', '648', ' to be daring');
INSERT INTO `infinitive_english_translation` VALUES ('1831', '649', 'to summon up the courage needed');
INSERT INTO `infinitive_english_translation` VALUES ('1832', '649', ' to brave');
INSERT INTO `infinitive_english_translation` VALUES ('1833', '649', ' to dare');
INSERT INTO `infinitive_english_translation` VALUES ('1834', '650', 'to summon up the courage needed');
INSERT INTO `infinitive_english_translation` VALUES ('1835', '650', ' to brave');
INSERT INTO `infinitive_english_translation` VALUES ('1836', '650', ' to dare');
INSERT INTO `infinitive_english_translation` VALUES ('1837', '651', 'to have courage');
INSERT INTO `infinitive_english_translation` VALUES ('1838', '651', ' to be daring');
INSERT INTO `infinitive_english_translation` VALUES ('1839', '652', 'to summon up the courage needed');
INSERT INTO `infinitive_english_translation` VALUES ('1840', '652', ' to brave');
INSERT INTO `infinitive_english_translation` VALUES ('1841', '652', ' to dare');
INSERT INTO `infinitive_english_translation` VALUES ('1842', '653', 'to fine');
INSERT INTO `infinitive_english_translation` VALUES ('1843', '653', ' to penalize');
INSERT INTO `infinitive_english_translation` VALUES ('1844', '653', ' to punish');
INSERT INTO `infinitive_english_translation` VALUES ('1845', '654', 'to search');
INSERT INTO `infinitive_english_translation` VALUES ('1846', '654', ' to look for');
INSERT INTO `infinitive_english_translation` VALUES ('1847', '655', 'to confront someone');
INSERT INTO `infinitive_english_translation` VALUES ('1848', '656', 'to confront someone');
INSERT INTO `infinitive_english_translation` VALUES ('1849', '657', 'to prevent');
INSERT INTO `infinitive_english_translation` VALUES ('1850', '657', ' to keep; colloq. to be using birth control');
INSERT INTO `infinitive_english_translation` VALUES ('1851', '658', 'to prevent');
INSERT INTO `infinitive_english_translation` VALUES ('1852', '658', ' to keep; colloq. to be using birth control');
INSERT INTO `infinitive_english_translation` VALUES ('1853', '659', 'to get together');
INSERT INTO `infinitive_english_translation` VALUES ('1854', '659', ' to assemble');
INSERT INTO `infinitive_english_translation` VALUES ('1855', '659', ' to aggregate');
INSERT INTO `infinitive_english_translation` VALUES ('1856', '660', 'to get together');
INSERT INTO `infinitive_english_translation` VALUES ('1857', '660', ' to assemble');
INSERT INTO `infinitive_english_translation` VALUES ('1858', '660', ' to aggregate');
INSERT INTO `infinitive_english_translation` VALUES ('1859', '661', 'to gather together');
INSERT INTO `infinitive_english_translation` VALUES ('1860', '661', ' to convene');
INSERT INTO `infinitive_english_translation` VALUES ('1861', '661', ' to collect');
INSERT INTO `infinitive_english_translation` VALUES ('1862', '661', ' to pack up');
INSERT INTO `infinitive_english_translation` VALUES ('1863', '661', ' to add');
INSERT INTO `infinitive_english_translation` VALUES ('1864', '662', 'to gather together');
INSERT INTO `infinitive_english_translation` VALUES ('1865', '662', ' to convene');
INSERT INTO `infinitive_english_translation` VALUES ('1866', '662', ' to collect');
INSERT INTO `infinitive_english_translation` VALUES ('1867', '662', ' to pack up');
INSERT INTO `infinitive_english_translation` VALUES ('1868', '662', ' to add');
INSERT INTO `infinitive_english_translation` VALUES ('1869', '663', 'to gather together');
INSERT INTO `infinitive_english_translation` VALUES ('1870', '663', ' to pile up');
INSERT INTO `infinitive_english_translation` VALUES ('1871', '663', ' to amass');
INSERT INTO `infinitive_english_translation` VALUES ('1872', '663', ' to compile');
INSERT INTO `infinitive_english_translation` VALUES ('1873', '663', ' to tidy');
INSERT INTO `infinitive_english_translation` VALUES ('1874', '664', 'to gather together');
INSERT INTO `infinitive_english_translation` VALUES ('1875', '664', ' to pile up');
INSERT INTO `infinitive_english_translation` VALUES ('1876', '664', ' to amass');
INSERT INTO `infinitive_english_translation` VALUES ('1877', '664', ' to compile');
INSERT INTO `infinitive_english_translation` VALUES ('1878', '664', ' to tidy');
INSERT INTO `infinitive_english_translation` VALUES ('1879', '665', 'to put together');
INSERT INTO `infinitive_english_translation` VALUES ('1880', '665', ' to gather');
INSERT INTO `infinitive_english_translation` VALUES ('1881', '665', ' to rally');
INSERT INTO `infinitive_english_translation` VALUES ('1882', '665', ' to organize');
INSERT INTO `infinitive_english_translation` VALUES ('1883', '665', ' to tidy');
INSERT INTO `infinitive_english_translation` VALUES ('1884', '665', ' to compact');
INSERT INTO `infinitive_english_translation` VALUES ('1885', '666', 'to put together');
INSERT INTO `infinitive_english_translation` VALUES ('1886', '666', ' to gather');
INSERT INTO `infinitive_english_translation` VALUES ('1887', '666', ' to rally');
INSERT INTO `infinitive_english_translation` VALUES ('1888', '666', ' to organize');
INSERT INTO `infinitive_english_translation` VALUES ('1889', '666', ' to tidy');
INSERT INTO `infinitive_english_translation` VALUES ('1890', '666', ' to compact');
INSERT INTO `infinitive_english_translation` VALUES ('1891', '667', 'to answer');
INSERT INTO `infinitive_english_translation` VALUES ('1892', '667', ' to have an answer (for)');
INSERT INTO `infinitive_english_translation` VALUES ('1893', '667', ' to be answerable');
INSERT INTO `infinitive_english_translation` VALUES ('1894', '667', ' to be accountable');
INSERT INTO `infinitive_english_translation` VALUES ('1895', '668', 'to answer');
INSERT INTO `infinitive_english_translation` VALUES ('1896', '669', 'to return a greeting');
INSERT INTO `infinitive_english_translation` VALUES ('1897', '669', ' to say \'hi\' back');
INSERT INTO `infinitive_english_translation` VALUES ('1898', '669', ' to return someone\'s \'hello\'');
INSERT INTO `infinitive_english_translation` VALUES ('1899', '670', 'to sort');
INSERT INTO `infinitive_english_translation` VALUES ('1900', '670', ' to arrange');
INSERT INTO `infinitive_english_translation` VALUES ('1901', '670', ' to organize');
INSERT INTO `infinitive_english_translation` VALUES ('1902', '670', ' to prepare');
INSERT INTO `infinitive_english_translation` VALUES ('1903', '671', 'to tyrannize');
INSERT INTO `infinitive_english_translation` VALUES ('1904', '671', ' to act with cruelty');
INSERT INTO `infinitive_english_translation` VALUES ('1905', '672', 'to tyrannize');
INSERT INTO `infinitive_english_translation` VALUES ('1906', '672', ' to act with cruelty');
INSERT INTO `infinitive_english_translation` VALUES ('1907', '673', 'to come to a boil');
INSERT INTO `infinitive_english_translation` VALUES ('1908', '673', ' to boil');
INSERT INTO `infinitive_english_translation` VALUES ('1909', '674', 'to come to a boil');
INSERT INTO `infinitive_english_translation` VALUES ('1910', '674', ' to boil');
INSERT INTO `infinitive_english_translation` VALUES ('1911', '675', 'colloq. to boil');
INSERT INTO `infinitive_english_translation` VALUES ('1912', '675', ' to bring to a boil');
INSERT INTO `infinitive_english_translation` VALUES ('1913', '675', ' to boil over');
INSERT INTO `infinitive_english_translation` VALUES ('1914', '675', ' to overheat; fig. to become agitated');
INSERT INTO `infinitive_english_translation` VALUES ('1915', '675', ' to become angry');
INSERT INTO `infinitive_english_translation` VALUES ('1916', '676', 'colloq. to boil');
INSERT INTO `infinitive_english_translation` VALUES ('1917', '676', ' to bring to a boil');
INSERT INTO `infinitive_english_translation` VALUES ('1918', '676', ' to boil over');
INSERT INTO `infinitive_english_translation` VALUES ('1919', '676', ' to overheat; fig. to become agitated');
INSERT INTO `infinitive_english_translation` VALUES ('1920', '676', ' to become angry');
INSERT INTO `infinitive_english_translation` VALUES ('1921', '677', 'to heal');
INSERT INTO `infinitive_english_translation` VALUES ('1922', '677', ' to mend');
INSERT INTO `infinitive_english_translation` VALUES ('1923', '677', ' to close');
INSERT INTO `infinitive_english_translation` VALUES ('1924', '677', ' to knit');
INSERT INTO `infinitive_english_translation` VALUES ('1925', '677', ' to fuse');
INSERT INTO `infinitive_english_translation` VALUES ('1926', '677', ' to get fused together');
INSERT INTO `infinitive_english_translation` VALUES ('1927', '677', ' to be soldered');
INSERT INTO `infinitive_english_translation` VALUES ('1928', '677', ' to get welded together; colloq. fig. to come toge');
INSERT INTO `infinitive_english_translation` VALUES ('1929', '677', ' to work out');
INSERT INTO `infinitive_english_translation` VALUES ('1930', '677', ' to feel irritated');
INSERT INTO `infinitive_english_translation` VALUES ('1931', '677', ' to feel angry');
INSERT INTO `infinitive_english_translation` VALUES ('1932', '678', 'to fuse');
INSERT INTO `infinitive_english_translation` VALUES ('1933', '678', ' to join');
INSERT INTO `infinitive_english_translation` VALUES ('1934', '678', ' to weld');
INSERT INTO `infinitive_english_translation` VALUES ('1935', '678', ' to solder');
INSERT INTO `infinitive_english_translation` VALUES ('1936', '678', ' to transplant');
INSERT INTO `infinitive_english_translation` VALUES ('1937', '678', ' to knit');
INSERT INTO `infinitive_english_translation` VALUES ('1938', '678', ' to boil; colloq. to bond');
INSERT INTO `infinitive_english_translation` VALUES ('1939', '678', ' to mend');
INSERT INTO `infinitive_english_translation` VALUES ('1940', '678', ' to conciliate; fig. colloq. to reunite');
INSERT INTO `infinitive_english_translation` VALUES ('1941', '678', ' to put together');
INSERT INTO `infinitive_english_translation` VALUES ('1942', '678', ' to pull off');
INSERT INTO `infinitive_english_translation` VALUES ('1943', '679', 'to boil');
INSERT INTO `infinitive_english_translation` VALUES ('1944', '679', ' to bubble');
INSERT INTO `infinitive_english_translation` VALUES ('1945', '679', ' to weld');
INSERT INTO `infinitive_english_translation` VALUES ('1946', '679', ' to get pimples');
INSERT INTO `infinitive_english_translation` VALUES ('1947', '679', ' to have rashes; colloq. fig. to to become agitate');
INSERT INTO `infinitive_english_translation` VALUES ('1948', '679', ' to become ennervated');
INSERT INTO `infinitive_english_translation` VALUES ('1949', '679', ' to fuss');
INSERT INTO `infinitive_english_translation` VALUES ('1950', '679', ' to strive');
INSERT INTO `infinitive_english_translation` VALUES ('1951', '680', 'child. to need to pee');
INSERT INTO `infinitive_english_translation` VALUES ('1952', '680', ' to need to go (to the bathroom)');
INSERT INTO `infinitive_english_translation` VALUES ('1953', '681', 'child. to pee');
INSERT INTO `infinitive_english_translation` VALUES ('1954', '681', ' to go wee-wee');
INSERT INTO `infinitive_english_translation` VALUES ('1955', '681', ' to go (to the bathroom)');
INSERT INTO `infinitive_english_translation` VALUES ('1956', '682', 'to print; colloq. fig. to make up stories');
INSERT INTO `infinitive_english_translation` VALUES ('1957', '682', ' to tell lies');
INSERT INTO `infinitive_english_translation` VALUES ('1958', '683', 'to print');
INSERT INTO `infinitive_english_translation` VALUES ('1959', '683', ' to make a print-out');
INSERT INTO `infinitive_english_translation` VALUES ('1960', '683', ' to publish');
INSERT INTO `infinitive_english_translation` VALUES ('1961', '684', 'to pitch a tent');
INSERT INTO `infinitive_english_translation` VALUES ('1962', '684', ' to put up a tent');
INSERT INTO `infinitive_english_translation` VALUES ('1963', '685', 'to bargain');
INSERT INTO `infinitive_english_translation` VALUES ('1964', '685', ' to haggle');
INSERT INTO `infinitive_english_translation` VALUES ('1965', '686', 'to bargain');
INSERT INTO `infinitive_english_translation` VALUES ('1966', '686', ' to haggle');
INSERT INTO `infinitive_english_translation` VALUES ('1967', '687', 'comp. to chat');
INSERT INTO `infinitive_english_translation` VALUES ('1968', '688', 'to say \'whoa\'');
INSERT INTO `infinitive_english_translation` VALUES ('1969', '688', ' to command a horse or livestock to halt');
INSERT INTO `infinitive_english_translation` VALUES ('1970', '689', 'to have fun');
INSERT INTO `infinitive_english_translation` VALUES ('1971', '690', 'to get it');
INSERT INTO `infinitive_english_translation` VALUES ('1972', '690', ' to understand');
INSERT INTO `infinitive_english_translation` VALUES ('1973', '691', 'to make understand');
INSERT INTO `infinitive_english_translation` VALUES ('1974', '691', ' to cause to understand');
INSERT INTO `infinitive_english_translation` VALUES ('1975', '691', ' to explain');
INSERT INTO `infinitive_english_translation` VALUES ('1976', '692', 'to delete');
INSERT INTO `infinitive_english_translation` VALUES ('1977', '692', ' to cross out');
INSERT INTO `infinitive_english_translation` VALUES ('1978', '692', ' to omit');
INSERT INTO `infinitive_english_translation` VALUES ('1979', '693', 'to annoy');
INSERT INTO `infinitive_english_translation` VALUES ('1980', '693', ' to irritate');
INSERT INTO `infinitive_english_translation` VALUES ('1981', '694', 'to talk');
INSERT INTO `infinitive_english_translation` VALUES ('1982', '695', 'to move');
INSERT INTO `infinitive_english_translation` VALUES ('1983', '695', ' to shift');
INSERT INTO `infinitive_english_translation` VALUES ('1984', '695', ' to displace');
INSERT INTO `infinitive_english_translation` VALUES ('1985', '695', ' to mobilize');
INSERT INTO `infinitive_english_translation` VALUES ('1986', '696', 'to move');
INSERT INTO `infinitive_english_translation` VALUES ('1987', '696', ' to shift');
INSERT INTO `infinitive_english_translation` VALUES ('1988', '696', ' to displace');
INSERT INTO `infinitive_english_translation` VALUES ('1989', '696', ' to mobilize');
INSERT INTO `infinitive_english_translation` VALUES ('1990', '697', 'to move');
INSERT INTO `infinitive_english_translation` VALUES ('1991', '697', ' to start');
INSERT INTO `infinitive_english_translation` VALUES ('1992', '697', ' to set out');
INSERT INTO `infinitive_english_translation` VALUES ('1993', '697', ' to proceed');
INSERT INTO `infinitive_english_translation` VALUES ('1994', '697', ' to leave; fig. to act');
INSERT INTO `infinitive_english_translation` VALUES ('1995', '698', 'to move');
INSERT INTO `infinitive_english_translation` VALUES ('1996', '698', ' to start');
INSERT INTO `infinitive_english_translation` VALUES ('1997', '698', ' to set out');
INSERT INTO `infinitive_english_translation` VALUES ('1998', '698', ' to proceed');
INSERT INTO `infinitive_english_translation` VALUES ('1999', '698', ' to leave; fig. to act');
INSERT INTO `infinitive_english_translation` VALUES ('2000', '699', 'to preserve');
INSERT INTO `infinitive_english_translation` VALUES ('2001', '699', ' to protect');
INSERT INTO `infinitive_english_translation` VALUES ('2002', '699', ' to memorize; PA. to save');
INSERT INTO `infinitive_english_translation` VALUES ('2003', '700', 'to preserve');
INSERT INTO `infinitive_english_translation` VALUES ('2004', '700', ' to protect');
INSERT INTO `infinitive_english_translation` VALUES ('2005', '700', ' to memorize; PA. to save');
INSERT INTO `infinitive_english_translation` VALUES ('2006', '701', 'to gin');
INSERT INTO `infinitive_english_translation` VALUES ('2007', '701', ' to card (cotton)');
INSERT INTO `infinitive_english_translation` VALUES ('2008', '701', ' to comb (cotton)');
INSERT INTO `infinitive_english_translation` VALUES ('2009', '701', ' to comb (through details)');
INSERT INTO `infinitive_english_translation` VALUES ('2010', '701', ' to analyze');
INSERT INTO `infinitive_english_translation` VALUES ('2011', '701', ' to study');
INSERT INTO `infinitive_english_translation` VALUES ('2012', '702', 'to bathe');
INSERT INTO `infinitive_english_translation` VALUES ('2013', '702', ' to take a bath');
INSERT INTO `infinitive_english_translation` VALUES ('2014', '702', ' to shower');
INSERT INTO `infinitive_english_translation` VALUES ('2015', '703', 'to bathe');
INSERT INTO `infinitive_english_translation` VALUES ('2016', '703', ' to take a bath');
INSERT INTO `infinitive_english_translation` VALUES ('2017', '703', ' to shower');
INSERT INTO `infinitive_english_translation` VALUES ('2018', '704', 'to attack');
INSERT INTO `infinitive_english_translation` VALUES ('2019', '704', ' to assault');
INSERT INTO `infinitive_english_translation` VALUES ('2020', '704', ' to charge');
INSERT INTO `infinitive_english_translation` VALUES ('2021', '704', ' to strike');
INSERT INTO `infinitive_english_translation` VALUES ('2022', '705', 'to go out');
INSERT INTO `infinitive_english_translation` VALUES ('2023', '705', ' to exit');
INSERT INTO `infinitive_english_translation` VALUES ('2024', '705', ' to emerge');
INSERT INTO `infinitive_english_translation` VALUES ('2025', '705', ' to escape');
INSERT INTO `infinitive_english_translation` VALUES ('2026', '705', ' to exude');
INSERT INTO `infinitive_english_translation` VALUES ('2027', '706', 'to tattoo');
INSERT INTO `infinitive_english_translation` VALUES ('2028', '707', 'to tattoo');
INSERT INTO `infinitive_english_translation` VALUES ('2029', '708', 'to become empty');
INSERT INTO `infinitive_english_translation` VALUES ('2030', '708', ' to be exhausted');
INSERT INTO `infinitive_english_translation` VALUES ('2031', '709', 'to empty');
INSERT INTO `infinitive_english_translation` VALUES ('2032', '709', ' to unload');
INSERT INTO `infinitive_english_translation` VALUES ('2033', '709', ' to unpack');
INSERT INTO `infinitive_english_translation` VALUES ('2034', '709', ' to exhaust');
INSERT INTO `infinitive_english_translation` VALUES ('2035', '710', 'to be extinguished');
INSERT INTO `infinitive_english_translation` VALUES ('2036', '710', ' to go out');
INSERT INTO `infinitive_english_translation` VALUES ('2037', '710', ' to get switched off');
INSERT INTO `infinitive_english_translation` VALUES ('2038', '710', ' to become quiet');
INSERT INTO `infinitive_english_translation` VALUES ('2039', '710', ' to fall silent; fig. to die down');
INSERT INTO `infinitive_english_translation` VALUES ('2040', '711', 'to turn off');
INSERT INTO `infinitive_english_translation` VALUES ('2041', '711', ' to switch off');
INSERT INTO `infinitive_english_translation` VALUES ('2042', '711', ' to extinguish');
INSERT INTO `infinitive_english_translation` VALUES ('2043', '711', ' to suppress');
INSERT INTO `infinitive_english_translation` VALUES ('2044', '711', ' to make quiet');
INSERT INTO `infinitive_english_translation` VALUES ('2045', '712', 'to be informed');
INSERT INTO `infinitive_english_translation` VALUES ('2046', '712', ' to have news (of)');
INSERT INTO `infinitive_english_translation` VALUES ('2047', '712', ' to know (of)');
INSERT INTO `infinitive_english_translation` VALUES ('2048', '712', ' to be aware (of)');
INSERT INTO `infinitive_english_translation` VALUES ('2049', '712', ' to have a clue');
INSERT INTO `infinitive_english_translation` VALUES ('2050', '713', 'to circumcise');
INSERT INTO `infinitive_english_translation` VALUES ('2051', '714', 'to feel ashamed');
INSERT INTO `infinitive_english_translation` VALUES ('2052', '715', 'to say good-bye');
INSERT INTO `infinitive_english_translation` VALUES ('2053', '715', ' to bid farewell');
INSERT INTO `infinitive_english_translation` VALUES ('2054', '716', 'to say good-bye');
INSERT INTO `infinitive_english_translation` VALUES ('2055', '716', ' to bid farewell');
INSERT INTO `infinitive_english_translation` VALUES ('2056', '717', 'to scratch');
INSERT INTO `infinitive_english_translation` VALUES ('2057', '717', ' to scrape');
INSERT INTO `infinitive_english_translation` VALUES ('2058', '718', 'to lathe');
INSERT INTO `infinitive_english_translation` VALUES ('2059', '718', ' to do woodworking');
INSERT INTO `infinitive_english_translation` VALUES ('2060', '719', 'onom. to snore');
INSERT INTO `infinitive_english_translation` VALUES ('2061', '719', ' to growl');
INSERT INTO `infinitive_english_translation` VALUES ('2062', '719', ' to purr');
INSERT INTO `infinitive_english_translation` VALUES ('2063', '720', 'to buy');
INSERT INTO `infinitive_english_translation` VALUES ('2064', '720', ' to purchase');
INSERT INTO `infinitive_english_translation` VALUES ('2065', '721', 'to go shopping');
INSERT INTO `infinitive_english_translation` VALUES ('2066', '721', ' to do the shopping');
INSERT INTO `infinitive_english_translation` VALUES ('2067', '722', 'to be tired; obs. to be wounded');
INSERT INTO `infinitive_english_translation` VALUES ('2068', '723', 'to become tired');
INSERT INTO `infinitive_english_translation` VALUES ('2069', '724', 'to make tired');
INSERT INTO `infinitive_english_translation` VALUES ('2070', '725', 'to cross out');
INSERT INTO `infinitive_english_translation` VALUES ('2071', '725', ' to draw a line through');
INSERT INTO `infinitive_english_translation` VALUES ('2072', '726', 'to cross out');
INSERT INTO `infinitive_english_translation` VALUES ('2073', '726', ' to draw a line through');
INSERT INTO `infinitive_english_translation` VALUES ('2074', '727', 'to draw a line');
INSERT INTO `infinitive_english_translation` VALUES ('2075', '727', ' to mark');
INSERT INTO `infinitive_english_translation` VALUES ('2076', '727', ' to cross out');
INSERT INTO `infinitive_english_translation` VALUES ('2077', '727', ' to strike out');
INSERT INTO `infinitive_english_translation` VALUES ('2078', '728', 'to draw a line');
INSERT INTO `infinitive_english_translation` VALUES ('2079', '728', ' to mark');
INSERT INTO `infinitive_english_translation` VALUES ('2080', '728', ' to cross out');
INSERT INTO `infinitive_english_translation` VALUES ('2081', '728', ' to strike out');
INSERT INTO `infinitive_english_translation` VALUES ('2082', '729', 'colloq.euph. to go to the bathroom');
INSERT INTO `infinitive_english_translation` VALUES ('2083', '729', ' to go to the toilet');
INSERT INTO `infinitive_english_translation` VALUES ('2084', '729', ' to use the restroom');
INSERT INTO `infinitive_english_translation` VALUES ('2085', '730', 'to summarize');
INSERT INTO `infinitive_english_translation` VALUES ('2086', '731', 'to commit an infraction');
INSERT INTO `infinitive_english_translation` VALUES ('2087', '731', ' to break the law');
INSERT INTO `infinitive_english_translation` VALUES ('2088', '732', 'to finely chop');
INSERT INTO `infinitive_english_translation` VALUES ('2089', '732', ' to mince');
INSERT INTO `infinitive_english_translation` VALUES ('2090', '732', ' to clean the teeth with a toothpick');
INSERT INTO `infinitive_english_translation` VALUES ('2091', '733', 'to make into dough');
INSERT INTO `infinitive_english_translation` VALUES ('2092', '733', ' to turn into pulp');
INSERT INTO `infinitive_english_translation` VALUES ('2093', '733', ' to mash');
INSERT INTO `infinitive_english_translation` VALUES ('2094', '734', 'to prepare dough');
INSERT INTO `infinitive_english_translation` VALUES ('2095', '734', ' to make dough');
INSERT INTO `infinitive_english_translation` VALUES ('2096', '735', 'to knead');
INSERT INTO `infinitive_english_translation` VALUES ('2097', '735', ' to knead dough');
INSERT INTO `infinitive_english_translation` VALUES ('2098', '736', 'to neutralize');
INSERT INTO `infinitive_english_translation` VALUES ('2099', '737', 'to get used to');
INSERT INTO `infinitive_english_translation` VALUES ('2100', '738', 'to request');
INSERT INTO `infinitive_english_translation` VALUES ('2101', '738', ' to entreat');
INSERT INTO `infinitive_english_translation` VALUES ('2102', '738', ' to demand');
INSERT INTO `infinitive_english_translation` VALUES ('2103', '738', ' to plead');
INSERT INTO `infinitive_english_translation` VALUES ('2104', '738', ' to implore');
INSERT INTO `infinitive_english_translation` VALUES ('2105', '739', 'to refrain (from)');
INSERT INTO `infinitive_english_translation` VALUES ('2106', '739', ' to restrain oneself');
INSERT INTO `infinitive_english_translation` VALUES ('2107', '740', 'to make conversation');
INSERT INTO `infinitive_english_translation` VALUES ('2108', '740', ' to make small-talk');
INSERT INTO `infinitive_english_translation` VALUES ('2109', '740', ' to chat');
INSERT INTO `infinitive_english_translation` VALUES ('2110', '740', ' to exchange pleasantries');
INSERT INTO `infinitive_english_translation` VALUES ('2111', '741', 'to fear');
INSERT INTO `infinitive_english_translation` VALUES ('2112', '741', ' to be afraid');
INSERT INTO `infinitive_english_translation` VALUES ('2113', '741', ' to be scared');
INSERT INTO `infinitive_english_translation` VALUES ('2114', '742', 'to fear');
INSERT INTO `infinitive_english_translation` VALUES ('2115', '742', ' to be afraid');
INSERT INTO `infinitive_english_translation` VALUES ('2116', '742', ' to be scared');
INSERT INTO `infinitive_english_translation` VALUES ('2117', '743', 'to do tailoring');
INSERT INTO `infinitive_english_translation` VALUES ('2118', '743', ' to be a tailor');
INSERT INTO `infinitive_english_translation` VALUES ('2119', '744', 'to reflect');
INSERT INTO `infinitive_english_translation` VALUES ('2120', '744', ' to think');
INSERT INTO `infinitive_english_translation` VALUES ('2121', '744', ' to imagine');
INSERT INTO `infinitive_english_translation` VALUES ('2122', '744', ' to suppose');
INSERT INTO `infinitive_english_translation` VALUES ('2123', '744', ' to take as if');
INSERT INTO `infinitive_english_translation` VALUES ('2124', '745', 'to obtain');
INSERT INTO `infinitive_english_translation` VALUES ('2125', '745', ' to acquire');
INSERT INTO `infinitive_english_translation` VALUES ('2126', '746', 'to interfere');
INSERT INTO `infinitive_english_translation` VALUES ('2127', '746', ' to mix');
INSERT INTO `infinitive_english_translation` VALUES ('2128', '746', ' to introduce');
INSERT INTO `infinitive_english_translation` VALUES ('2129', '746', ' to butt in');
INSERT INTO `infinitive_english_translation` VALUES ('2130', '747', 'to embrace');
INSERT INTO `infinitive_english_translation` VALUES ('2131', '748', 'to comprise');
INSERT INTO `infinitive_english_translation` VALUES ('2132', '748', ' to entail');
INSERT INTO `infinitive_english_translation` VALUES ('2133', '748', ' to wear');
INSERT INTO `infinitive_english_translation` VALUES ('2134', '749', 'to wrap up');
INSERT INTO `infinitive_english_translation` VALUES ('2135', '749', ' to bundle up completely');
INSERT INTO `infinitive_english_translation` VALUES ('2136', '750', 'to flee');
INSERT INTO `infinitive_english_translation` VALUES ('2137', '750', ' to take off');
INSERT INTO `infinitive_english_translation` VALUES ('2138', '751', 'to knock');
INSERT INTO `infinitive_english_translation` VALUES ('2139', '752', 'to let loose');
INSERT INTO `infinitive_english_translation` VALUES ('2140', '752', ' to discharge');
INSERT INTO `infinitive_english_translation` VALUES ('2141', '753', 'to overlook');
INSERT INTO `infinitive_english_translation` VALUES ('2142', '753', ' to forgive; obs. to die');
INSERT INTO `infinitive_english_translation` VALUES ('2143', '754', 'to start');
INSERT INTO `infinitive_english_translation` VALUES ('2144', '754', ' to ignite');
INSERT INTO `infinitive_english_translation` VALUES ('2145', '755', 'to become helpless');
INSERT INTO `infinitive_english_translation` VALUES ('2146', '755', ' to be stuck');
INSERT INTO `infinitive_english_translation` VALUES ('2147', '756', 'to become helpless');
INSERT INTO `infinitive_english_translation` VALUES ('2148', '756', ' to be stuck');
INSERT INTO `infinitive_english_translation` VALUES ('2149', '757', 'fig. to consider');
INSERT INTO `infinitive_english_translation` VALUES ('2150', '757', ' to plan');
INSERT INTO `infinitive_english_translation` VALUES ('2151', '757', ' to have in mind');
INSERT INTO `infinitive_english_translation` VALUES ('2152', '757', ' to designate');
INSERT INTO `infinitive_english_translation` VALUES ('2153', '758', 'to traverse; obs. to ply');
INSERT INTO `infinitive_english_translation` VALUES ('2154', '758', ' to leave behind');
INSERT INTO `infinitive_english_translation` VALUES ('2155', '759', 'to stretch out');
INSERT INTO `infinitive_english_translation` VALUES ('2156', '759', ' to lie down');
INSERT INTO `infinitive_english_translation` VALUES ('2157', '760', 'to request');
INSERT INTO `infinitive_english_translation` VALUES ('2158', '760', ' to apply');
INSERT INTO `infinitive_english_translation` VALUES ('2159', '760', ' to invite');
INSERT INTO `infinitive_english_translation` VALUES ('2160', '760', ' to bid');
INSERT INTO `infinitive_english_translation` VALUES ('2161', '761', 'obs. to request');
INSERT INTO `infinitive_english_translation` VALUES ('2162', '761', ' to demand');
INSERT INTO `infinitive_english_translation` VALUES ('2163', '761', ' to bid');
INSERT INTO `infinitive_english_translation` VALUES ('2164', '762', 'to be painful');
INSERT INTO `infinitive_english_translation` VALUES ('2165', '762', ' to hurt');
INSERT INTO `infinitive_english_translation` VALUES ('2166', '763', 'to annoy');
INSERT INTO `infinitive_english_translation` VALUES ('2167', '763', ' to give trouble');
INSERT INTO `infinitive_english_translation` VALUES ('2168', '764', 'to recite a lesson');
INSERT INTO `infinitive_english_translation` VALUES ('2169', '765', 'to study');
INSERT INTO `infinitive_english_translation` VALUES ('2170', '765', ' to learn');
INSERT INTO `infinitive_english_translation` VALUES ('2171', '765', ' to get an education');
INSERT INTO `infinitive_english_translation` VALUES ('2172', '766', 'to study');
INSERT INTO `infinitive_english_translation` VALUES ('2173', '766', ' to learn');
INSERT INTO `infinitive_english_translation` VALUES ('2174', '766', ' to get an education');
INSERT INTO `infinitive_english_translation` VALUES ('2175', '767', 'to teach');
INSERT INTO `infinitive_english_translation` VALUES ('2176', '768', 'to be correct');
INSERT INTO `infinitive_english_translation` VALUES ('2177', '768', ' to be true');
INSERT INTO `infinitive_english_translation` VALUES ('2178', '768', ' to be exact');
INSERT INTO `infinitive_english_translation` VALUES ('2179', '768', ' to be right');
INSERT INTO `infinitive_english_translation` VALUES ('2180', '768', ' to be honest');
INSERT INTO `infinitive_english_translation` VALUES ('2181', '768', ' to be upright');
INSERT INTO `infinitive_english_translation` VALUES ('2182', '769', 'to become correct');
INSERT INTO `infinitive_english_translation` VALUES ('2183', '769', ' to be fixed');
INSERT INTO `infinitive_english_translation` VALUES ('2184', '769', ' to be made');
INSERT INTO `infinitive_english_translation` VALUES ('2185', '769', ' to become ready');
INSERT INTO `infinitive_english_translation` VALUES ('2186', '769', ' to be prepared');
INSERT INTO `infinitive_english_translation` VALUES ('2187', '770', 'to correct');
INSERT INTO `infinitive_english_translation` VALUES ('2188', '770', ' to fix');
INSERT INTO `infinitive_english_translation` VALUES ('2189', '770', ' to make');
INSERT INTO `infinitive_english_translation` VALUES ('2190', '770', ' to prepare');
INSERT INTO `infinitive_english_translation` VALUES ('2191', '770', ' to adjust');
INSERT INTO `infinitive_english_translation` VALUES ('2192', '770', ' to forge');
INSERT INTO `infinitive_english_translation` VALUES ('2193', '770', ' to fabricate');
INSERT INTO `infinitive_english_translation` VALUES ('2194', '771', 'to perceive');
INSERT INTO `infinitive_english_translation` VALUES ('2195', '771', ' to comprehend');
INSERT INTO `infinitive_english_translation` VALUES ('2196', '771', ' to realize');
INSERT INTO `infinitive_english_translation` VALUES ('2197', '772', 'fig. to become entangled (in)');
INSERT INTO `infinitive_english_translation` VALUES ('2198', '772', ' to become busy (with)');
INSERT INTO `infinitive_english_translation` VALUES ('2199', '773', 'to harvest');
INSERT INTO `infinitive_english_translation` VALUES ('2200', '773', ' to reap; colloq. fig. to mow down (the opponents)');
INSERT INTO `infinitive_english_translation` VALUES ('2201', '773', ' to tackle');
INSERT INTO `infinitive_english_translation` VALUES ('2202', '773', ' to kill (food)');
INSERT INTO `infinitive_english_translation` VALUES ('2203', '773', ' to polish off (food)');
INSERT INTO `infinitive_english_translation` VALUES ('2204', '774', 'to harvest');
INSERT INTO `infinitive_english_translation` VALUES ('2205', '774', ' to reap; colloq. fig. to mow down (the opponents)');
INSERT INTO `infinitive_english_translation` VALUES ('2206', '774', ' to tackle');
INSERT INTO `infinitive_english_translation` VALUES ('2207', '774', ' to kill (food)');
INSERT INTO `infinitive_english_translation` VALUES ('2208', '774', ' to polish off (food)');
INSERT INTO `infinitive_english_translation` VALUES ('2209', '775', 'to fabricate lies');
INSERT INTO `infinitive_english_translation` VALUES ('2210', '775', ' to lie');
INSERT INTO `infinitive_english_translation` VALUES ('2211', '776', 'to lie');
INSERT INTO `infinitive_english_translation` VALUES ('2212', '776', ' to deceive');
INSERT INTO `infinitive_english_translation` VALUES ('2213', '777', 'to take on an upset or worried appearance');
INSERT INTO `infinitive_english_translation` VALUES ('2214', '777', ' to become downcast');
INSERT INTO `infinitive_english_translation` VALUES ('2215', '777', ' to become distressed');
INSERT INTO `infinitive_english_translation` VALUES ('2216', '777', ' to get upset');
INSERT INTO `infinitive_english_translation` VALUES ('2217', '778', 'to throw into confusion');
INSERT INTO `infinitive_english_translation` VALUES ('2218', '778', ' to throw into disorder');
INSERT INTO `infinitive_english_translation` VALUES ('2219', '778', ' to scramble');
INSERT INTO `infinitive_english_translation` VALUES ('2220', '779', 'to be mixed');
INSERT INTO `infinitive_english_translation` VALUES ('2221', '779', ' to be mixed up');
INSERT INTO `infinitive_english_translation` VALUES ('2222', '779', ' be become chaotic');
INSERT INTO `infinitive_english_translation` VALUES ('2223', '779', ' to be messed up');
INSERT INTO `infinitive_english_translation` VALUES ('2224', '779', ' to be jumbled');
INSERT INTO `infinitive_english_translation` VALUES ('2225', '779', ' to be scrambled');
INSERT INTO `infinitive_english_translation` VALUES ('2226', '780', 'to mix');
INSERT INTO `infinitive_english_translation` VALUES ('2227', '780', ' to mix up');
INSERT INTO `infinitive_english_translation` VALUES ('2228', '781', 'to confuse');
INSERT INTO `infinitive_english_translation` VALUES ('2229', '781', ' to mess');
INSERT INTO `infinitive_english_translation` VALUES ('2230', '781', ' to mess up');
INSERT INTO `infinitive_english_translation` VALUES ('2231', '781', ' to unsettle');
INSERT INTO `infinitive_english_translation` VALUES ('2232', '781', ' to make chaotic');
INSERT INTO `infinitive_english_translation` VALUES ('2233', '782', 'to confuse');
INSERT INTO `infinitive_english_translation` VALUES ('2234', '782', ' to mess');
INSERT INTO `infinitive_english_translation` VALUES ('2235', '782', ' to mess up');
INSERT INTO `infinitive_english_translation` VALUES ('2236', '782', ' to unsettle');
INSERT INTO `infinitive_english_translation` VALUES ('2237', '782', ' to make chaotic');
INSERT INTO `infinitive_english_translation` VALUES ('2238', '783', 'to receive');
INSERT INTO `infinitive_english_translation` VALUES ('2239', '783', ' to get');
INSERT INTO `infinitive_english_translation` VALUES ('2240', '783', ' to perceive');
INSERT INTO `infinitive_english_translation` VALUES ('2241', '783', ' to understand');
INSERT INTO `infinitive_english_translation` VALUES ('2242', '784', 'to let go of something');
INSERT INTO `infinitive_english_translation` VALUES ('2243', '784', ' to stop doing something');
INSERT INTO `infinitive_english_translation` VALUES ('2244', '785', 'to place one\'s hand somewhere; colloq. to tease');
INSERT INTO `infinitive_english_translation` VALUES ('2245', '785', ' to pull (someone\'s) leg');
INSERT INTO `infinitive_english_translation` VALUES ('2246', '786', 'to shake hands; fig. to present itself (opportunit');
INSERT INTO `infinitive_english_translation` VALUES ('2247', '786', ' to come about');
INSERT INTO `infinitive_english_translation` VALUES ('2248', '786', ' to join');
INSERT INTO `infinitive_english_translation` VALUES ('2249', '786', ' to lend itself to');
INSERT INTO `infinitive_english_translation` VALUES ('2250', '786', ' to be useful; colloq. to deal (cards); obs. fig. ');
INSERT INTO `infinitive_english_translation` VALUES ('2251', '786', ' to become possible');
INSERT INTO `infinitive_english_translation` VALUES ('2252', '786', ' to dominate');
INSERT INTO `infinitive_english_translation` VALUES ('2253', '787', 'to appropriate');
INSERT INTO `infinitive_english_translation` VALUES ('2254', '787', ' to take unfair possession of');
INSERT INTO `infinitive_english_translation` VALUES ('2255', '787', ' to lay one\'s hands on');
INSERT INTO `infinitive_english_translation` VALUES ('2256', '787', ' to grab');
INSERT INTO `infinitive_english_translation` VALUES ('2257', '788', 'to become flustered');
INSERT INTO `infinitive_english_translation` VALUES ('2258', '788', ' to be in a great rush');
INSERT INTO `infinitive_english_translation` VALUES ('2259', '789', 'to rustle up');
INSERT INTO `infinitive_english_translation` VALUES ('2260', '789', ' to get');
INSERT INTO `infinitive_english_translation` VALUES ('2261', '790', 'to help');
INSERT INTO `infinitive_english_translation` VALUES ('2262', '790', ' to assist');
INSERT INTO `infinitive_english_translation` VALUES ('2263', '791', 'to quarrel');
INSERT INTO `infinitive_english_translation` VALUES ('2264', '791', ' to act belligerently');
INSERT INTO `infinitive_english_translation` VALUES ('2265', '791', ' to litigate');
INSERT INTO `infinitive_english_translation` VALUES ('2266', '792', 'to claim');
INSERT INTO `infinitive_english_translation` VALUES ('2267', '792', ' to exaggerate');
INSERT INTO `infinitive_english_translation` VALUES ('2268', '793', 'to offend');
INSERT INTO `infinitive_english_translation` VALUES ('2269', '794', 'to grow teeth');
INSERT INTO `infinitive_english_translation` VALUES ('2270', '794', ' to teethe');
INSERT INTO `infinitive_english_translation` VALUES ('2271', '795', 'to grow teeth');
INSERT INTO `infinitive_english_translation` VALUES ('2272', '795', ' to teethe');
INSERT INTO `infinitive_english_translation` VALUES ('2273', '796', 'colloq. to go Dutch');
INSERT INTO `infinitive_english_translation` VALUES ('2274', '796', ' to pay for one\'s own meal');
INSERT INTO `infinitive_english_translation` VALUES ('2275', '796', ' etc');
INSERT INTO `infinitive_english_translation` VALUES ('2276', '797', 'to last (long)');
INSERT INTO `infinitive_english_translation` VALUES ('2277', '797', ' to be long-lived');
INSERT INTO `infinitive_english_translation` VALUES ('2278', '797', ' to endure');
INSERT INTO `infinitive_english_translation` VALUES ('2279', '797', ' to continue');
INSERT INTO `infinitive_english_translation` VALUES ('2280', '797', ' to go on');
INSERT INTO `infinitive_english_translation` VALUES ('2281', '797', ' to have a long shelf-life');
INSERT INTO `infinitive_english_translation` VALUES ('2282', '798', 'to double');
INSERT INTO `infinitive_english_translation` VALUES ('2283', '798', ' to make twice as much');
INSERT INTO `infinitive_english_translation` VALUES ('2284', '799', 'colloq. fig. to create a rift between two people');
INSERT INTO `infinitive_english_translation` VALUES ('2285', '799', ' to set people against one another');
INSERT INTO `infinitive_english_translation` VALUES ('2286', '799', ' to cause enmity');
INSERT INTO `infinitive_english_translation` VALUES ('2287', '799', ' to cause discord');
INSERT INTO `infinitive_english_translation` VALUES ('2288', '800', 'to produce smoke');
INSERT INTO `infinitive_english_translation` VALUES ('2289', '800', ' to burn');
INSERT INTO `infinitive_english_translation` VALUES ('2290', '800', ' to give off exhaust; colloq. to smoke (cigarettes');
INSERT INTO `infinitive_english_translation` VALUES ('2291', '800', ' etc.)');
INSERT INTO `infinitive_english_translation` VALUES ('2292', '800', ' to destroy');
INSERT INTO `infinitive_english_translation` VALUES ('2293', '801', 'to become distant');
INSERT INTO `infinitive_english_translation` VALUES ('2294', '801', ' to get separated');
INSERT INTO `infinitive_english_translation` VALUES ('2295', '801', ' to remain apart');
INSERT INTO `infinitive_english_translation` VALUES ('2296', '801', ' to be thrown away');
INSERT INTO `infinitive_english_translation` VALUES ('2297', '801', ' to be discarded');
INSERT INTO `infinitive_english_translation` VALUES ('2298', '801', ' to be abandoned; obs. to misunderstand');
INSERT INTO `infinitive_english_translation` VALUES ('2299', '802', 'to throw out');
INSERT INTO `infinitive_english_translation` VALUES ('2300', '802', ' to discard');
INSERT INTO `infinitive_english_translation` VALUES ('2301', '803', 'to throw out');
INSERT INTO `infinitive_english_translation` VALUES ('2302', '803', ' to discard');
INSERT INTO `infinitive_english_translation` VALUES ('2303', '804', 'to review');
INSERT INTO `infinitive_english_translation` VALUES ('2304', '804', ' to restudy');
INSERT INTO `infinitive_english_translation` VALUES ('2305', '804', ' to reread');
INSERT INTO `infinitive_english_translation` VALUES ('2306', '804', ' to surround');
INSERT INTO `infinitive_english_translation` VALUES ('2307', '805', 'to review');
INSERT INTO `infinitive_english_translation` VALUES ('2308', '805', ' to restudy');
INSERT INTO `infinitive_english_translation` VALUES ('2309', '805', ' to reread');
INSERT INTO `infinitive_english_translation` VALUES ('2310', '805', ' to surround');
INSERT INTO `infinitive_english_translation` VALUES ('2311', '806', 'to like');
INSERT INTO `infinitive_english_translation` VALUES ('2312', '806', ' to love');
INSERT INTO `infinitive_english_translation` VALUES ('2313', '807', 'to like');
INSERT INTO `infinitive_english_translation` VALUES ('2314', '807', ' to love');
INSERT INTO `infinitive_english_translation` VALUES ('2315', '808', 'to take a shower');
INSERT INTO `infinitive_english_translation` VALUES ('2316', '809', 'to save');
INSERT INTO `infinitive_english_translation` VALUES ('2317', '809', ' to store');
INSERT INTO `infinitive_english_translation` VALUES ('2318', '810', 'to mention');
INSERT INTO `infinitive_english_translation` VALUES ('2319', '810', ' to cite');
INSERT INTO `infinitive_english_translation` VALUES ('2320', '810', ' to say rosary prayers');
INSERT INTO `infinitive_english_translation` VALUES ('2321', '811', 'to mention');
INSERT INTO `infinitive_english_translation` VALUES ('2322', '811', ' to cite');
INSERT INTO `infinitive_english_translation` VALUES ('2323', '811', ' to say rosary prayers');
INSERT INTO `infinitive_english_translation` VALUES ('2324', '812', 'to say rosary prayers');
INSERT INTO `infinitive_english_translation` VALUES ('2325', '812', ' to chant prayers');
INSERT INTO `infinitive_english_translation` VALUES ('2326', '812', ' to repeat a word or phrase');
INSERT INTO `infinitive_english_translation` VALUES ('2327', '813', 'to tell the truth');
INSERT INTO `infinitive_english_translation` VALUES ('2328', '813', ' to be truthful');
INSERT INTO `infinitive_english_translation` VALUES ('2329', '814', 'to tell the truth');
INSERT INTO `infinitive_english_translation` VALUES ('2330', '814', ' to be truthful');
INSERT INTO `infinitive_english_translation` VALUES ('2331', '815', 'to be satisfied');
INSERT INTO `infinitive_english_translation` VALUES ('2332', '815', ' to be pleased');
INSERT INTO `infinitive_english_translation` VALUES ('2333', '815', ' to be content');
INSERT INTO `infinitive_english_translation` VALUES ('2334', '815', ' to be willing');
INSERT INTO `infinitive_english_translation` VALUES ('2335', '816', 'to become satisfied');
INSERT INTO `infinitive_english_translation` VALUES ('2336', '816', ' to become pleased');
INSERT INTO `infinitive_english_translation` VALUES ('2337', '816', ' to agree');
INSERT INTO `infinitive_english_translation` VALUES ('2338', '816', ' to consent');
INSERT INTO `infinitive_english_translation` VALUES ('2339', '817', 'to satisfy');
INSERT INTO `infinitive_english_translation` VALUES ('2340', '817', ' to please');
INSERT INTO `infinitive_english_translation` VALUES ('2341', '817', ' to persuade');
INSERT INTO `infinitive_english_translation` VALUES ('2342', '818', 'to drive');
INSERT INTO `infinitive_english_translation` VALUES ('2343', '819', 'to begin moving');
INSERT INTO `infinitive_english_translation` VALUES ('2344', '819', ' to leave');
INSERT INTO `infinitive_english_translation` VALUES ('2345', '819', ' to set out');
INSERT INTO `infinitive_english_translation` VALUES ('2346', '819', ' to get underway; fig. to begin operating');
INSERT INTO `infinitive_english_translation` VALUES ('2347', '819', ' to start functioning; colloq. fig. to become good');
INSERT INTO `infinitive_english_translation` VALUES ('2348', '820', 'to put into motion');
INSERT INTO `infinitive_english_translation` VALUES ('2349', '820', ' to start');
INSERT INTO `infinitive_english_translation` VALUES ('2350', '820', ' to get running');
INSERT INTO `infinitive_english_translation` VALUES ('2351', '820', ' to crank');
INSERT INTO `infinitive_english_translation` VALUES ('2352', '820', ' to escort; fig. to commission');
INSERT INTO `infinitive_english_translation` VALUES ('2353', '820', ' to raise funds');
INSERT INTO `infinitive_english_translation` VALUES ('2354', '820', ' to set up');
INSERT INTO `infinitive_english_translation` VALUES ('2355', '820', ' to prepare');
INSERT INTO `infinitive_english_translation` VALUES ('2356', '820', ' to fix');
INSERT INTO `infinitive_english_translation` VALUES ('2357', '821', 'to travel');
INSERT INTO `infinitive_english_translation` VALUES ('2358', '821', ' to go');
INSERT INTO `infinitive_english_translation` VALUES ('2359', '822', 'to walk');
INSERT INTO `infinitive_english_translation` VALUES ('2360', '822', ' to go');
INSERT INTO `infinitive_english_translation` VALUES ('2361', '823', 'obs. to lead');
INSERT INTO `infinitive_english_translation` VALUES ('2362', '823', ' to guide');
INSERT INTO `infinitive_english_translation` VALUES ('2363', '824', 'to hike');
INSERT INTO `infinitive_english_translation` VALUES ('2364', '824', ' to walk');
INSERT INTO `infinitive_english_translation` VALUES ('2365', '824', ' to trek');
INSERT INTO `infinitive_english_translation` VALUES ('2366', '824', ' to stroll');
INSERT INTO `infinitive_english_translation` VALUES ('2367', '824', ' to march');
INSERT INTO `infinitive_english_translation` VALUES ('2368', '825', 'to hike');
INSERT INTO `infinitive_english_translation` VALUES ('2369', '825', ' to walk');
INSERT INTO `infinitive_english_translation` VALUES ('2370', '825', ' to trek');
INSERT INTO `infinitive_english_translation` VALUES ('2371', '825', ' to stroll');
INSERT INTO `infinitive_english_translation` VALUES ('2372', '825', ' to march');
INSERT INTO `infinitive_english_translation` VALUES ('2373', '826', 'to lead');
INSERT INTO `infinitive_english_translation` VALUES ('2374', '826', ' to guide');
INSERT INTO `infinitive_english_translation` VALUES ('2375', '826', ' to instruct');
INSERT INTO `infinitive_english_translation` VALUES ('2376', '827', 'to ask permission');
INSERT INTO `infinitive_english_translation` VALUES ('2377', '827', ' to beg leave');
INSERT INTO `infinitive_english_translation` VALUES ('2378', '828', 'to give back');
INSERT INTO `infinitive_english_translation` VALUES ('2379', '828', ' to return');
INSERT INTO `infinitive_english_translation` VALUES ('2380', '828', ' to reject');
INSERT INTO `infinitive_english_translation` VALUES ('2381', '828', ' to decline');
INSERT INTO `infinitive_english_translation` VALUES ('2382', '828', ' to allow');
INSERT INTO `infinitive_english_translation` VALUES ('2383', '828', ' to pass');
INSERT INTO `infinitive_english_translation` VALUES ('2384', '828', ' to have transfered');
INSERT INTO `infinitive_english_translation` VALUES ('2385', '828', ' to hand over');
INSERT INTO `infinitive_english_translation` VALUES ('2386', '828', ' to smuggle');
INSERT INTO `infinitive_english_translation` VALUES ('2387', '829', 'to give back');
INSERT INTO `infinitive_english_translation` VALUES ('2388', '829', ' to return');
INSERT INTO `infinitive_english_translation` VALUES ('2389', '829', ' to reject');
INSERT INTO `infinitive_english_translation` VALUES ('2390', '829', ' to decline');
INSERT INTO `infinitive_english_translation` VALUES ('2391', '829', ' to allow');
INSERT INTO `infinitive_english_translation` VALUES ('2392', '829', ' to pass');
INSERT INTO `infinitive_english_translation` VALUES ('2393', '829', ' to have transfered');
INSERT INTO `infinitive_english_translation` VALUES ('2394', '829', ' to hand over');
INSERT INTO `infinitive_english_translation` VALUES ('2395', '829', ' to smuggle');
INSERT INTO `infinitive_english_translation` VALUES ('2396', '830', 'to diet');
INSERT INTO `infinitive_english_translation` VALUES ('2397', '830', ' to be on a diet');
INSERT INTO `infinitive_english_translation` VALUES ('2398', '831', 'to grow');
INSERT INTO `infinitive_english_translation` VALUES ('2399', '832', 'to remedy; comp. to debug');
INSERT INTO `infinitive_english_translation` VALUES ('2400', '833', 'to remedy; comp. to debug');
INSERT INTO `infinitive_english_translation` VALUES ('2401', '834', 'to turn pale');
INSERT INTO `infinitive_english_translation` VALUES ('2402', '834', ' to pale');
INSERT INTO `infinitive_english_translation` VALUES ('2403', '834', ' to lose color');
INSERT INTO `infinitive_english_translation` VALUES ('2404', '834', ' to fade');
INSERT INTO `infinitive_english_translation` VALUES ('2405', '835', 'to paint');
INSERT INTO `infinitive_english_translation` VALUES ('2406', '835', ' to color');
INSERT INTO `infinitive_english_translation` VALUES ('2407', '835', ' to stain');
INSERT INTO `infinitive_english_translation` VALUES ('2408', '835', ' to dye');
INSERT INTO `infinitive_english_translation` VALUES ('2409', '836', 'to turn (to)');
INSERT INTO `infinitive_english_translation` VALUES ('2410', '836', ' to direct one\'s attention (to)');
INSERT INTO `infinitive_english_translation` VALUES ('2411', '836', ' to take up');
INSERT INTO `infinitive_english_translation` VALUES ('2412', '836', ' to resort (to)');
INSERT INTO `infinitive_english_translation` VALUES ('2413', '836', ' to appeal (to)');
INSERT INTO `infinitive_english_translation` VALUES ('2414', '837', 'to turn (to)');
INSERT INTO `infinitive_english_translation` VALUES ('2415', '837', ' to turn (towards)');
INSERT INTO `infinitive_english_translation` VALUES ('2416', '837', ' to face');
INSERT INTO `infinitive_english_translation` VALUES ('2417', '837', ' to look (at)');
INSERT INTO `infinitive_english_translation` VALUES ('2418', '838', 'to turn away (from)');
INSERT INTO `infinitive_english_translation` VALUES ('2419', '838', ' to turn one\'s back (on)');
INSERT INTO `infinitive_english_translation` VALUES ('2420', '838', ' to reject');
INSERT INTO `infinitive_english_translation` VALUES ('2421', '838', ' to refuse');
INSERT INTO `infinitive_english_translation` VALUES ('2422', '838', ' to pass on');
INSERT INTO `infinitive_english_translation` VALUES ('2423', '838', ' to leave');
INSERT INTO `infinitive_english_translation` VALUES ('2424', '839', 'to allow');
INSERT INTO `infinitive_english_translation` VALUES ('2425', '839', ' to permit');
INSERT INTO `infinitive_english_translation` VALUES ('2426', '839', ' to consider allowable');
INSERT INTO `infinitive_english_translation` VALUES ('2427', '839', ' to hold permissible');
INSERT INTO `infinitive_english_translation` VALUES ('2428', '840', 'to be prevalent');
INSERT INTO `infinitive_english_translation` VALUES ('2429', '840', ' to be current');
INSERT INTO `infinitive_english_translation` VALUES ('2430', '840', ' to be in circulation');
INSERT INTO `infinitive_english_translation` VALUES ('2431', '841', 'to proceed');
INSERT INTO `infinitive_english_translation` VALUES ('2432', '841', ' to go');
INSERT INTO `infinitive_english_translation` VALUES ('2433', '841', ' to run');
INSERT INTO `infinitive_english_translation` VALUES ('2434', '841', ' to flow');
INSERT INTO `infinitive_english_translation` VALUES ('2435', '842', 'to set out');
INSERT INTO `infinitive_english_translation` VALUES ('2436', '842', ' to start');
INSERT INTO `infinitive_english_translation` VALUES ('2437', '842', ' to leave (for)');
INSERT INTO `infinitive_english_translation` VALUES ('2438', '842', ' to proceed');
INSERT INTO `infinitive_english_translation` VALUES ('2439', '842', ' to embark');
INSERT INTO `infinitive_english_translation` VALUES ('2440', '842', ' to get going');
INSERT INTO `infinitive_english_translation` VALUES ('2441', '843', 'to send');
INSERT INTO `infinitive_english_translation` VALUES ('2442', '843', ' to send off');
INSERT INTO `infinitive_english_translation` VALUES ('2443', '843', ' to set in motion');
INSERT INTO `infinitive_english_translation` VALUES ('2444', '843', ' to dispatch');
INSERT INTO `infinitive_english_translation` VALUES ('2445', '843', ' to dismiss');
INSERT INTO `infinitive_english_translation` VALUES ('2446', '844', 'to be faced (with)');
INSERT INTO `infinitive_english_translation` VALUES ('2447', '844', ' to face');
INSERT INTO `infinitive_english_translation` VALUES ('2448', '844', ' to be up (against)');
INSERT INTO `infinitive_english_translation` VALUES ('2449', '844', ' to come face to face (with)');
INSERT INTO `infinitive_english_translation` VALUES ('2450', '845', 'to bring face-to-face');
INSERT INTO `infinitive_english_translation` VALUES ('2451', '845', ' to cause a confrontation');
INSERT INTO `infinitive_english_translation` VALUES ('2452', '846', 'to fast');
INSERT INTO `infinitive_english_translation` VALUES ('2453', '847', 'to become brisk');
INSERT INTO `infinitive_english_translation` VALUES ('2454', '847', ' to flourish');
INSERT INTO `infinitive_english_translation` VALUES ('2455', '847', ' to become successful');
INSERT INTO `infinitive_english_translation` VALUES ('2456', '847', ' to prosper');
INSERT INTO `infinitive_english_translation` VALUES ('2457', '847', ' to become animated');
INSERT INTO `infinitive_english_translation` VALUES ('2458', '847', ' to pick up speed');
INSERT INTO `infinitive_english_translation` VALUES ('2459', '847', ' to get busy');
INSERT INTO `infinitive_english_translation` VALUES ('2460', '848', 'to become free');
INSERT INTO `infinitive_english_translation` VALUES ('2461', '848', ' to be released');
INSERT INTO `infinitive_english_translation` VALUES ('2462', '848', ' to be dropped');
INSERT INTO `infinitive_english_translation` VALUES ('2463', '849', 'to lead');
INSERT INTO `infinitive_english_translation` VALUES ('2464', '849', ' to guide');
INSERT INTO `infinitive_english_translation` VALUES ('2465', '850', 'to mortgage');
INSERT INTO `infinitive_english_translation` VALUES ('2466', '850', ' to pledge');
INSERT INTO `infinitive_english_translation` VALUES ('2467', '850', ' to pawn');
INSERT INTO `infinitive_english_translation` VALUES ('2468', '851', 'to put down roots');
INSERT INTO `infinitive_english_translation` VALUES ('2469', '851', ' to send out roots');
INSERT INTO `infinitive_english_translation` VALUES ('2470', '851', ' to grow roots');
INSERT INTO `infinitive_english_translation` VALUES ('2471', '852', 'to put down roots');
INSERT INTO `infinitive_english_translation` VALUES ('2472', '852', ' to send out roots');
INSERT INTO `infinitive_english_translation` VALUES ('2473', '852', ' to grow roots');
INSERT INTO `infinitive_english_translation` VALUES ('2474', '853', 'to suffer');
INSERT INTO `infinitive_english_translation` VALUES ('2475', '853', ' to be tortured');
INSERT INTO `infinitive_english_translation` VALUES ('2476', '853', ' to be tormented');
INSERT INTO `infinitive_english_translation` VALUES ('2477', '853', ' to be in agony');
INSERT INTO `infinitive_english_translation` VALUES ('2478', '854', 'to try hard');
INSERT INTO `infinitive_english_translation` VALUES ('2479', '854', ' to make great effort');
INSERT INTO `infinitive_english_translation` VALUES ('2480', '855', 'to turn yellow');
INSERT INTO `infinitive_english_translation` VALUES ('2481', '855', ' to become pale');
INSERT INTO `infinitive_english_translation` VALUES ('2482', '855', ' to become weak');
INSERT INTO `infinitive_english_translation` VALUES ('2483', '855', ' to become sick');
INSERT INTO `infinitive_english_translation` VALUES ('2484', '856', 'to trip');
INSERT INTO `infinitive_english_translation` VALUES ('2485', '856', ' to fall; colloq. to fare badly');
INSERT INTO `infinitive_english_translation` VALUES ('2486', '856', ' to go down');
INSERT INTO `infinitive_english_translation` VALUES ('2487', '856', ' to decline');
INSERT INTO `infinitive_english_translation` VALUES ('2488', '856', ' to drop');
INSERT INTO `infinitive_english_translation` VALUES ('2489', '857', 'to take a wife');
INSERT INTO `infinitive_english_translation` VALUES ('2490', '857', ' to marry');
INSERT INTO `infinitive_english_translation` VALUES ('2491', '857', ' to get married');
INSERT INTO `infinitive_english_translation` VALUES ('2492', '858', 'to wed');
INSERT INTO `infinitive_english_translation` VALUES ('2493', '858', ' to get married');
INSERT INTO `infinitive_english_translation` VALUES ('2494', '858', ' to marry');
INSERT INTO `infinitive_english_translation` VALUES ('2495', '859', 'to live');
INSERT INTO `infinitive_english_translation` VALUES ('2496', '859', ' to exist');
INSERT INTO `infinitive_english_translation` VALUES ('2497', '859', ' to reside');
INSERT INTO `infinitive_english_translation` VALUES ('2498', '859', ' to inhabit');
INSERT INTO `infinitive_english_translation` VALUES ('2499', '860', 'to ring');
INSERT INTO `infinitive_english_translation` VALUES ('2500', '860', ' to ring up');
INSERT INTO `infinitive_english_translation` VALUES ('2501', '860', ' to telephone');
INSERT INTO `infinitive_english_translation` VALUES ('2502', '860', ' to chime');
INSERT INTO `infinitive_english_translation` VALUES ('2503', '860', ' to rust');
INSERT INTO `infinitive_english_translation` VALUES ('2504', '861', 'to use force');
INSERT INTO `infinitive_english_translation` VALUES ('2505', '861', ' to force');
INSERT INTO `infinitive_english_translation` VALUES ('2506', '862', 'to burst out laughing');
INSERT INTO `infinitive_english_translation` VALUES ('2507', '863', 'colloq. fig. to put (someone) under pressure (to d');
INSERT INTO `infinitive_english_translation` VALUES ('2508', '864', 'to pose');
INSERT INTO `infinitive_english_translation` VALUES ('2509', '864', ' to put on an act');
INSERT INTO `infinitive_english_translation` VALUES ('2510', '865', 'to apply hair-styling gel');
INSERT INTO `infinitive_english_translation` VALUES ('2511', '866', 'to become tattered');
INSERT INTO `infinitive_english_translation` VALUES ('2512', '866', ' to become worn');
INSERT INTO `infinitive_english_translation` VALUES ('2513', '867', 'to become disheveled');
INSERT INTO `infinitive_english_translation` VALUES ('2514', '867', ' to become ragged');
INSERT INTO `infinitive_english_translation` VALUES ('2515', '868', 'to do gymnastics');
INSERT INTO `infinitive_english_translation` VALUES ('2516', '869', 'to do gymnastics');
INSERT INTO `infinitive_english_translation` VALUES ('2517', '870', 'to be n years old');
INSERT INTO `infinitive_english_translation` VALUES ('2518', '870', ' to be age n');
INSERT INTO `infinitive_english_translation` VALUES ('2519', '871', 'to ask a question');
INSERT INTO `infinitive_english_translation` VALUES ('2520', '872', 'to have a question');
INSERT INTO `infinitive_english_translation` VALUES ('2521', '873', 'to ask');
INSERT INTO `infinitive_english_translation` VALUES ('2522', '873', ' to inquire');
INSERT INTO `infinitive_english_translation` VALUES ('2523', '873', ' to question');
INSERT INTO `infinitive_english_translation` VALUES ('2524', '874', 'to grow');
INSERT INTO `infinitive_english_translation` VALUES ('2525', '874', ' to sprout');
INSERT INTO `infinitive_english_translation` VALUES ('2526', '875', 'to thank');
INSERT INTO `infinitive_english_translation` VALUES ('2527', '876', 'to pass');
INSERT INTO `infinitive_english_translation` VALUES ('2528', '876', ' to traverse');
INSERT INTO `infinitive_english_translation` VALUES ('2529', '877', 'to suffer oppression');
INSERT INTO `infinitive_english_translation` VALUES ('2530', '877', ' to be oppressed');
INSERT INTO `infinitive_english_translation` VALUES ('2531', '877', ' to suffer');
INSERT INTO `infinitive_english_translation` VALUES ('2532', '878', 'to oppress');
INSERT INTO `infinitive_english_translation` VALUES ('2533', '878', ' to persecute');
INSERT INTO `infinitive_english_translation` VALUES ('2534', '878', ' to tyranize');
INSERT INTO `infinitive_english_translation` VALUES ('2535', '878', ' to make suffer');
INSERT INTO `infinitive_english_translation` VALUES ('2536', '879', 'to be oppressed');
INSERT INTO `infinitive_english_translation` VALUES ('2537', '879', ' to suffer persecution');
INSERT INTO `infinitive_english_translation` VALUES ('2538', '879', ' to be tyrannized');
INSERT INTO `infinitive_english_translation` VALUES ('2539', '880', 'to oppress');
INSERT INTO `infinitive_english_translation` VALUES ('2540', '880', ' to persecute');
INSERT INTO `infinitive_english_translation` VALUES ('2541', '880', ' to tyranize');
INSERT INTO `infinitive_english_translation` VALUES ('2542', '880', ' to make suffer');
INSERT INTO `infinitive_english_translation` VALUES ('2543', '881', 'to oppress');
INSERT INTO `infinitive_english_translation` VALUES ('2544', '881', ' to persecute');
INSERT INTO `infinitive_english_translation` VALUES ('2545', '881', ' to tyranize');
INSERT INTO `infinitive_english_translation` VALUES ('2546', '881', ' to make suffer');
INSERT INTO `infinitive_english_translation` VALUES ('2547', '881', ' to act cruelly');
INSERT INTO `infinitive_english_translation` VALUES ('2548', '882', 'to talk');
INSERT INTO `infinitive_english_translation` VALUES ('2549', '882', ' to converse');
INSERT INTO `infinitive_english_translation` VALUES ('2550', '882', ' to discuss');
INSERT INTO `infinitive_english_translation` VALUES ('2551', '883', 'to build a dam');
INSERT INTO `infinitive_english_translation` VALUES ('2552', '883', ' to construct a dam');
INSERT INTO `infinitive_english_translation` VALUES ('2553', '883', ' to build a dike');
INSERT INTO `infinitive_english_translation` VALUES ('2554', '883', ' to dam');
INSERT INTO `infinitive_english_translation` VALUES ('2555', '884', 'to build a dam');
INSERT INTO `infinitive_english_translation` VALUES ('2556', '884', ' to construct a dam');
INSERT INTO `infinitive_english_translation` VALUES ('2557', '884', ' to build a dike');
INSERT INTO `infinitive_english_translation` VALUES ('2558', '884', ' to dam');
INSERT INTO `infinitive_english_translation` VALUES ('2559', '885', 'lit. to stave off hunger');
INSERT INTO `infinitive_english_translation` VALUES ('2560', '885', ' to have a bite');
INSERT INTO `infinitive_english_translation` VALUES ('2561', '885', ' to have a snack');
INSERT INTO `infinitive_english_translation` VALUES ('2562', '885', ' to eat');
INSERT INTO `infinitive_english_translation` VALUES ('2563', '886', 'to block');
INSERT INTO `infinitive_english_translation` VALUES ('2564', '886', ' to blockade');
INSERT INTO `infinitive_english_translation` VALUES ('2565', '886', ' to obstruct');
INSERT INTO `infinitive_english_translation` VALUES ('2566', '886', ' to bar');
INSERT INTO `infinitive_english_translation` VALUES ('2567', '887', 'to block');
INSERT INTO `infinitive_english_translation` VALUES ('2568', '887', ' to blockade');
INSERT INTO `infinitive_english_translation` VALUES ('2569', '887', ' to obstruct');
INSERT INTO `infinitive_english_translation` VALUES ('2570', '887', ' to bar');
INSERT INTO `infinitive_english_translation` VALUES ('2571', '888', 'to slide');
INSERT INTO `infinitive_english_translation` VALUES ('2572', '888', ' to slip');
INSERT INTO `infinitive_english_translation` VALUES ('2573', '888', ' to skid');
INSERT INTO `infinitive_english_translation` VALUES ('2574', '888', ' to glissade');
INSERT INTO `infinitive_english_translation` VALUES ('2575', '889', 'to pop up');
INSERT INTO `infinitive_english_translation` VALUES ('2576', '889', ' to come out');
INSERT INTO `infinitive_english_translation` VALUES ('2577', '889', ' to appear');
INSERT INTO `infinitive_english_translation` VALUES ('2578', '889', ' to figure out');
INSERT INTO `infinitive_english_translation` VALUES ('2579', '889', ' to get');
INSERT INTO `infinitive_english_translation` VALUES ('2580', '890', 'to pop up');
INSERT INTO `infinitive_english_translation` VALUES ('2581', '890', ' to come out');
INSERT INTO `infinitive_english_translation` VALUES ('2582', '890', ' to appear');
INSERT INTO `infinitive_english_translation` VALUES ('2583', '890', ' to figure out');
INSERT INTO `infinitive_english_translation` VALUES ('2584', '890', ' to get');
INSERT INTO `infinitive_english_translation` VALUES ('2585', '891', 'to pay a visit');
INSERT INTO `infinitive_english_translation` VALUES ('2586', '891', ' to drop in');
INSERT INTO `infinitive_english_translation` VALUES ('2587', '891', ' to pop in');
INSERT INTO `infinitive_english_translation` VALUES ('2588', '891', ' to reach a mark');
INSERT INTO `infinitive_english_translation` VALUES ('2589', '891', ' to hit with the head');
INSERT INTO `infinitive_english_translation` VALUES ('2590', '891', ' to decapitate; fig. to dawn');
INSERT INTO `infinitive_english_translation` VALUES ('2591', '891', ' to rise');
INSERT INTO `infinitive_english_translation` VALUES ('2592', '891', ' to grow');
INSERT INTO `infinitive_english_translation` VALUES ('2593', '891', ' to appear');
INSERT INTO `infinitive_english_translation` VALUES ('2594', '892', 'to be proud');
INSERT INTO `infinitive_english_translation` VALUES ('2595', '892', ' to feel pride');
INSERT INTO `infinitive_english_translation` VALUES ('2596', '893', 'to be proud');
INSERT INTO `infinitive_english_translation` VALUES ('2597', '893', ' to feel pride');
INSERT INTO `infinitive_english_translation` VALUES ('2598', '894', 'to tease');
INSERT INTO `infinitive_english_translation` VALUES ('2599', '894', ' to bother');
INSERT INTO `infinitive_english_translation` VALUES ('2600', '894', ' to harrass');
INSERT INTO `infinitive_english_translation` VALUES ('2601', '894', ' to annoy');
INSERT INTO `infinitive_english_translation` VALUES ('2602', '895', 'fig. to suppress');
INSERT INTO `infinitive_english_translation` VALUES ('2603', '895', ' to oppress');
INSERT INTO `infinitive_english_translation` VALUES ('2604', '895', ' to crush');
INSERT INTO `infinitive_english_translation` VALUES ('2605', '896', 'colloq. to check up on something');
INSERT INTO `infinitive_english_translation` VALUES ('2606', '896', ' to check something');
INSERT INTO `infinitive_english_translation` VALUES ('2607', '897', 'to try');
INSERT INTO `infinitive_english_translation` VALUES ('2608', '897', ' to struggle');
INSERT INTO `infinitive_english_translation` VALUES ('2609', '897', ' to strive');
INSERT INTO `infinitive_english_translation` VALUES ('2610', '897', ' to endeavor');
INSERT INTO `infinitive_english_translation` VALUES ('2611', '897', ' to labor');
INSERT INTO `infinitive_english_translation` VALUES ('2612', '898', 'to order');
INSERT INTO `infinitive_english_translation` VALUES ('2613', '899', 'to travel');
INSERT INTO `infinitive_english_translation` VALUES ('2614', '899', ' to take a trip');
INSERT INTO `infinitive_english_translation` VALUES ('2615', '899', ' to go on a journey');
INSERT INTO `infinitive_english_translation` VALUES ('2616', '900', 'to convey greetings');
INSERT INTO `infinitive_english_translation` VALUES ('2617', '900', ' to pass on someone\'s greetings');
INSERT INTO `infinitive_english_translation` VALUES ('2618', '900', ' to send one\'s \'hello\'');
INSERT INTO `infinitive_english_translation` VALUES ('2619', '901', 'to greet');
INSERT INTO `infinitive_english_translation` VALUES ('2620', '901', ' to say \'hi\'');
INSERT INTO `infinitive_english_translation` VALUES ('2621', '901', ' to say \'hello\'');
INSERT INTO `infinitive_english_translation` VALUES ('2622', '902', 'to be acquainted with someone');
INSERT INTO `infinitive_english_translation` VALUES ('2623', '902', ' to have a mutual acquaintance with someone');
INSERT INTO `infinitive_english_translation` VALUES ('2624', '903', 'to be acquainted with someone');
INSERT INTO `infinitive_english_translation` VALUES ('2625', '903', ' to have a mutual acquaintance with someone');
INSERT INTO `infinitive_english_translation` VALUES ('2626', '904', 'to greet');
INSERT INTO `infinitive_english_translation` VALUES ('2627', '904', ' to exchange greetings');
INSERT INTO `infinitive_english_translation` VALUES ('2628', '904', ' to say \'hello\'');
INSERT INTO `infinitive_english_translation` VALUES ('2629', '905', 'to be cut (hair)');
INSERT INTO `infinitive_english_translation` VALUES ('2630', '906', 'to be cut (hair)');
INSERT INTO `infinitive_english_translation` VALUES ('2631', '907', 'to cut hair');
INSERT INTO `infinitive_english_translation` VALUES ('2632', '907', ' to give haircuts');
INSERT INTO `infinitive_english_translation` VALUES ('2633', '908', 'to cut hair');
INSERT INTO `infinitive_english_translation` VALUES ('2634', '908', ' to give haircuts');
INSERT INTO `infinitive_english_translation` VALUES ('2635', '909', 'to get on a horse');
INSERT INTO `infinitive_english_translation` VALUES ('2636', '909', ' to mount');
INSERT INTO `infinitive_english_translation` VALUES ('2637', '909', ' to get on');
INSERT INTO `infinitive_english_translation` VALUES ('2638', '909', ' to climb aboard');
INSERT INTO `infinitive_english_translation` VALUES ('2639', '909', ' to get in (vehicle)');
INSERT INTO `infinitive_english_translation` VALUES ('2640', '909', ' to board');
INSERT INTO `infinitive_english_translation` VALUES ('2641', '909', ' to become installed; fig. to become predominant');
INSERT INTO `infinitive_english_translation` VALUES ('2642', '910', 'to put on a horse');
INSERT INTO `infinitive_english_translation` VALUES ('2643', '910', ' to mount');
INSERT INTO `infinitive_english_translation` VALUES ('2644', '910', ' to take on board');
INSERT INTO `infinitive_english_translation` VALUES ('2645', '910', ' to pick up (passengers)');
INSERT INTO `infinitive_english_translation` VALUES ('2646', '910', ' to install');
INSERT INTO `infinitive_english_translation` VALUES ('2647', '910', ' to assemble');
INSERT INTO `infinitive_english_translation` VALUES ('2648', '910', ' to erect; colloq. to plan');
INSERT INTO `infinitive_english_translation` VALUES ('2649', '910', ' to manage');
INSERT INTO `infinitive_english_translation` VALUES ('2650', '910', ' to stage-manage');
INSERT INTO `infinitive_english_translation` VALUES ('2651', '910', ' to engineer');
INSERT INTO `infinitive_english_translation` VALUES ('2652', '911', 'to push in a certain direction');
INSERT INTO `infinitive_english_translation` VALUES ('2653', '911', ' to pull (towards)');
INSERT INTO `infinitive_english_translation` VALUES ('2654', '911', ' to steer');
INSERT INTO `infinitive_english_translation` VALUES ('2655', '911', ' to guide');
INSERT INTO `infinitive_english_translation` VALUES ('2656', '912', 'to push in a certain direction');
INSERT INTO `infinitive_english_translation` VALUES ('2657', '912', ' to pull (towards)');
INSERT INTO `infinitive_english_translation` VALUES ('2658', '912', ' to steer');
INSERT INTO `infinitive_english_translation` VALUES ('2659', '912', ' to guide');
INSERT INTO `infinitive_english_translation` VALUES ('2660', '913', 'to travel');
INSERT INTO `infinitive_english_translation` VALUES ('2661', '913', ' to explore');
INSERT INTO `infinitive_english_translation` VALUES ('2662', '913', ' to journey');
INSERT INTO `infinitive_english_translation` VALUES ('2663', '913', ' to tour');
INSERT INTO `infinitive_english_translation` VALUES ('2664', '914', 'to punish');
INSERT INTO `infinitive_english_translation` VALUES ('2665', '914', ' to correct');
INSERT INTO `infinitive_english_translation` VALUES ('2666', '915', 'sl. to smoke cigarettes');
INSERT INTO `infinitive_english_translation` VALUES ('2667', '915', ' to have a cig');
INSERT INTO `infinitive_english_translation` VALUES ('2668', '916', 'to smoke (cigarettes); colloq.vulg. to sleep with ');
INSERT INTO `infinitive_english_translation` VALUES ('2669', '917', 'to eat dinner');
INSERT INTO `infinitive_english_translation` VALUES ('2670', '917', ' to dine');
INSERT INTO `infinitive_english_translation` VALUES ('2671', '917', ' to have dinner');
INSERT INTO `infinitive_english_translation` VALUES ('2672', '917', ' to take dinner');
INSERT INTO `infinitive_english_translation` VALUES ('2673', '918', 'to comb');
INSERT INTO `infinitive_english_translation` VALUES ('2674', '919', 'to comb');
INSERT INTO `infinitive_english_translation` VALUES ('2675', '920', 'to comb');
INSERT INTO `infinitive_english_translation` VALUES ('2676', '921', 'to comb');
INSERT INTO `infinitive_english_translation` VALUES ('2677', '922', 'to hurry');
INSERT INTO `infinitive_english_translation` VALUES ('2678', '922', ' to make haste');
INSERT INTO `infinitive_english_translation` VALUES ('2679', '923', 'to describe');
INSERT INTO `infinitive_english_translation` VALUES ('2680', '923', ' to explain');
INSERT INTO `infinitive_english_translation` VALUES ('2681', '923', ' to expound');
INSERT INTO `infinitive_english_translation` VALUES ('2682', '924', 'to describe');
INSERT INTO `infinitive_english_translation` VALUES ('2683', '924', ' to explain');
INSERT INTO `infinitive_english_translation` VALUES ('2684', '924', ' to expound');
INSERT INTO `infinitive_english_translation` VALUES ('2685', '924', ' to give a detailed account');
INSERT INTO `infinitive_english_translation` VALUES ('2686', '925', 'to describe');
INSERT INTO `infinitive_english_translation` VALUES ('2687', '925', ' to explain');
INSERT INTO `infinitive_english_translation` VALUES ('2688', '925', ' to expound');
INSERT INTO `infinitive_english_translation` VALUES ('2689', '925', ' to give a detailed account');
INSERT INTO `infinitive_english_translation` VALUES ('2690', '926', 'to start');
INSERT INTO `infinitive_english_translation` VALUES ('2691', '926', ' to begin');
INSERT INTO `infinitive_english_translation` VALUES ('2692', '927', 'to start');
INSERT INTO `infinitive_english_translation` VALUES ('2693', '927', ' to begin');
INSERT INTO `infinitive_english_translation` VALUES ('2694', '928', 'to start');
INSERT INTO `infinitive_english_translation` VALUES ('2695', '928', ' to begin');
INSERT INTO `infinitive_english_translation` VALUES ('2696', '929', 'to start');
INSERT INTO `infinitive_english_translation` VALUES ('2697', '929', ' to begin');
INSERT INTO `infinitive_english_translation` VALUES ('2698', '930', 'to make a partner');
INSERT INTO `infinitive_english_translation` VALUES ('2699', '930', ' to involve');
INSERT INTO `infinitive_english_translation` VALUES ('2700', '930', ' to include');
INSERT INTO `infinitive_english_translation` VALUES ('2701', '931', 'to wash');
INSERT INTO `infinitive_english_translation` VALUES ('2702', '931', ' to bathe');
INSERT INTO `infinitive_english_translation` VALUES ('2703', '931', ' to rinse');
INSERT INTO `infinitive_english_translation` VALUES ('2704', '932', 'to play chess');
INSERT INTO `infinitive_english_translation` VALUES ('2705', '933', 'to intercede');
INSERT INTO `infinitive_english_translation` VALUES ('2706', '933', ' to mediate');
INSERT INTO `infinitive_english_translation` VALUES ('2707', '933', ' to advocate');
INSERT INTO `infinitive_english_translation` VALUES ('2708', '934', 'to intercede');
INSERT INTO `infinitive_english_translation` VALUES ('2709', '934', ' to mediate');
INSERT INTO `infinitive_english_translation` VALUES ('2710', '934', ' to advocate');
INSERT INTO `infinitive_english_translation` VALUES ('2711', '935', 'to defeat');
INSERT INTO `infinitive_english_translation` VALUES ('2712', '936', 'to torture');
INSERT INTO `infinitive_english_translation` VALUES ('2713', '936', ' to torment');
INSERT INTO `infinitive_english_translation` VALUES ('2714', '936', ' to agonize');
INSERT INTO `infinitive_english_translation` VALUES ('2715', '937', 'to be whipped');
INSERT INTO `infinitive_english_translation` VALUES ('2716', '937', ' to be flogged');
INSERT INTO `infinitive_english_translation` VALUES ('2717', '938', 'to be whipped');
INSERT INTO `infinitive_english_translation` VALUES ('2718', '938', ' to be flogged');
INSERT INTO `infinitive_english_translation` VALUES ('2719', '939', 'to whip');
INSERT INTO `infinitive_english_translation` VALUES ('2720', '939', ' to flog');
INSERT INTO `infinitive_english_translation` VALUES ('2721', '940', 'to whip');
INSERT INTO `infinitive_english_translation` VALUES ('2722', '940', ' to flog');
INSERT INTO `infinitive_english_translation` VALUES ('2723', '941', 'to become crowded');
INSERT INTO `infinitive_english_translation` VALUES ('2724', '941', ' to become busy');
INSERT INTO `infinitive_english_translation` VALUES ('2725', '942', 'to buttress');
INSERT INTO `infinitive_english_translation` VALUES ('2726', '942', ' to truss');
INSERT INTO `infinitive_english_translation` VALUES ('2727', '942', ' to shore up');
INSERT INTO `infinitive_english_translation` VALUES ('2728', '942', ' to reinforce');
INSERT INTO `infinitive_english_translation` VALUES ('2729', '942', ' to prop up');
INSERT INTO `infinitive_english_translation` VALUES ('2730', '943', 'to swim');
INSERT INTO `infinitive_english_translation` VALUES ('2731', '944', 'to swim');
INSERT INTO `infinitive_english_translation` VALUES ('2732', '944', ' to float');
INSERT INTO `infinitive_english_translation` VALUES ('2733', '945', 'to joke');
INSERT INTO `infinitive_english_translation` VALUES ('2734', '945', ' to jest');
INSERT INTO `infinitive_english_translation` VALUES ('2735', '946', 'to marry');
INSERT INTO `infinitive_english_translation` VALUES ('2736', '946', ' to marry a husband');
INSERT INTO `infinitive_english_translation` VALUES ('2737', '946', ' to get married');
INSERT INTO `infinitive_english_translation` VALUES ('2738', '947', 'to marry');
INSERT INTO `infinitive_english_translation` VALUES ('2739', '947', ' to marry a husband');
INSERT INTO `infinitive_english_translation` VALUES ('2740', '947', ' to get married');
INSERT INTO `infinitive_english_translation` VALUES ('2741', '948', 'to be issued');
INSERT INTO `infinitive_english_translation` VALUES ('2742', '948', ' to be exported; obs. to come forth');
INSERT INTO `infinitive_english_translation` VALUES ('2743', '949', 'to issue');
INSERT INTO `infinitive_english_translation` VALUES ('2744', '949', ' to export');
INSERT INTO `infinitive_english_translation` VALUES ('2745', '949', ' to send out');
INSERT INTO `infinitive_english_translation` VALUES ('2746', '949', ' to emit');
INSERT INTO `infinitive_english_translation` VALUES ('2747', '950', 'to have breakfast');
INSERT INTO `infinitive_english_translation` VALUES ('2748', '950', ' to eat breakfast');
INSERT INTO `infinitive_english_translation` VALUES ('2749', '950', ' to take breakfast');
INSERT INTO `infinitive_english_translation` VALUES ('2750', '950', ' to breakfast');
INSERT INTO `infinitive_english_translation` VALUES ('2751', '951', 'to have breakfast');
INSERT INTO `infinitive_english_translation` VALUES ('2752', '951', ' to eat breakfast');
INSERT INTO `infinitive_english_translation` VALUES ('2753', '951', ' to take breakfast');
INSERT INTO `infinitive_english_translation` VALUES ('2754', '951', ' to breakfast');
INSERT INTO `infinitive_english_translation` VALUES ('2755', '952', 'to talk');
INSERT INTO `infinitive_english_translation` VALUES ('2756', '952', ' to converse; obs. to associate (with)');
INSERT INTO `infinitive_english_translation` VALUES ('2757', '953', 'to talk');
INSERT INTO `infinitive_english_translation` VALUES ('2758', '953', ' to converse; obs. to associate (with)');
INSERT INTO `infinitive_english_translation` VALUES ('2759', '954', 'to hike');
INSERT INTO `infinitive_english_translation` VALUES ('2760', '954', ' to trek');
INSERT INTO `infinitive_english_translation` VALUES ('2761', '954', ' to go bouldering');
INSERT INTO `infinitive_english_translation` VALUES ('2762', '954', ' to mountain climb');
INSERT INTO `infinitive_english_translation` VALUES ('2763', '955', 'to conjugate (verbs)');
INSERT INTO `infinitive_english_translation` VALUES ('2764', '955', ' to inflect');
INSERT INTO `infinitive_english_translation` VALUES ('2765', '955', ' to expend');
INSERT INTO `infinitive_english_translation` VALUES ('2766', '955', ' to use');
INSERT INTO `infinitive_english_translation` VALUES ('2767', '955', ' to consume');
INSERT INTO `infinitive_english_translation` VALUES ('2768', '955', ' to eat');
INSERT INTO `infinitive_english_translation` VALUES ('2769', '956', 'to line up');
INSERT INTO `infinitive_english_translation` VALUES ('2770', '956', ' to get in a queue');
INSERT INTO `infinitive_english_translation` VALUES ('2771', '957', 'to line up');
INSERT INTO `infinitive_english_translation` VALUES ('2772', '957', ' to get in a queue');
INSERT INTO `infinitive_english_translation` VALUES ('2773', '958', 'to be lost');
INSERT INTO `infinitive_english_translation` VALUES ('2774', '958', ' to be ruined');
INSERT INTO `infinitive_english_translation` VALUES ('2775', '958', ' to be destroyed');
INSERT INTO `infinitive_english_translation` VALUES ('2776', '958', ' to be wasted');
INSERT INTO `infinitive_english_translation` VALUES ('2777', '959', 'to be lost');
INSERT INTO `infinitive_english_translation` VALUES ('2778', '959', ' to be ruined');
INSERT INTO `infinitive_english_translation` VALUES ('2779', '959', ' to be destroyed');
INSERT INTO `infinitive_english_translation` VALUES ('2780', '959', ' to be wasted');
INSERT INTO `infinitive_english_translation` VALUES ('2781', '960', 'to waste');
INSERT INTO `infinitive_english_translation` VALUES ('2782', '960', ' to destroy');
INSERT INTO `infinitive_english_translation` VALUES ('2783', '960', ' to squander');
INSERT INTO `infinitive_english_translation` VALUES ('2784', '961', 'to waste');
INSERT INTO `infinitive_english_translation` VALUES ('2785', '961', ' to destroy');
INSERT INTO `infinitive_english_translation` VALUES ('2786', '961', ' to squander');
INSERT INTO `infinitive_english_translation` VALUES ('2787', '962', 'to be lost');
INSERT INTO `infinitive_english_translation` VALUES ('2788', '962', ' to be ruined');
INSERT INTO `infinitive_english_translation` VALUES ('2789', '962', ' to be destroyed');
INSERT INTO `infinitive_english_translation` VALUES ('2790', '962', ' to be wasted');
INSERT INTO `infinitive_english_translation` VALUES ('2791', '963', 'to waste');
INSERT INTO `infinitive_english_translation` VALUES ('2792', '963', ' to destroy');
INSERT INTO `infinitive_english_translation` VALUES ('2793', '963', ' to squander');
INSERT INTO `infinitive_english_translation` VALUES ('2794', '964', 'to confiscate');
INSERT INTO `infinitive_english_translation` VALUES ('2795', '964', ' to seize');
INSERT INTO `infinitive_english_translation` VALUES ('2796', '964', ' to repossess');
INSERT INTO `infinitive_english_translation` VALUES ('2797', '964', ' to record');
INSERT INTO `infinitive_english_translation` VALUES ('2798', '964', ' to register');
INSERT INTO `infinitive_english_translation` VALUES ('2799', '965', 'to become weak');
INSERT INTO `infinitive_english_translation` VALUES ('2800', '965', ' to grow feeble');
INSERT INTO `infinitive_english_translation` VALUES ('2801', '966', 'to become weak');
INSERT INTO `infinitive_english_translation` VALUES ('2802', '966', ' to grow feeble');
INSERT INTO `infinitive_english_translation` VALUES ('2803', '967', 'to attach');
INSERT INTO `infinitive_english_translation` VALUES ('2804', '967', ' to join');
INSERT INTO `infinitive_english_translation` VALUES ('2805', '967', ' to enclose');
INSERT INTO `infinitive_english_translation` VALUES ('2806', '968', 'to plan');
INSERT INTO `infinitive_english_translation` VALUES ('2807', '968', ' to plan out');
INSERT INTO `infinitive_english_translation` VALUES ('2808', '969', 'to jump rope');
INSERT INTO `infinitive_english_translation` VALUES ('2809', '969', ' to skip rope');
INSERT INTO `infinitive_english_translation` VALUES ('2810', '970', 'to take a long time');
INSERT INTO `infinitive_english_translation` VALUES ('2811', '971', 'to pass');
INSERT INTO `infinitive_english_translation` VALUES ('2812', '971', ' to traverse');
INSERT INTO `infinitive_english_translation` VALUES ('2813', '971', ' to cover; colloq. fig. to reach an agreement on a');
INSERT INTO `infinitive_english_translation` VALUES ('2814', '971', ' to bargain down to a price');
INSERT INTO `infinitive_english_translation` VALUES ('2815', '972', 'to pass');
INSERT INTO `infinitive_english_translation` VALUES ('2816', '972', ' to traverse');
INSERT INTO `infinitive_english_translation` VALUES ('2817', '972', ' to cover; colloq. fig. to reach an agreement on a');
INSERT INTO `infinitive_english_translation` VALUES ('2818', '972', ' to bargain down to a price');
INSERT INTO `infinitive_english_translation` VALUES ('2819', '973', 'to appear');
INSERT INTO `infinitive_english_translation` VALUES ('2820', '973', ' to be developed (film)');
INSERT INTO `infinitive_english_translation` VALUES ('2821', '974', 'to wash dishes');
INSERT INTO `infinitive_english_translation` VALUES ('2822', '974', ' to do the dishes');
INSERT INTO `infinitive_english_translation` VALUES ('2823', '975', 'to tyranize');
INSERT INTO `infinitive_english_translation` VALUES ('2824', '975', ' to persecute');
INSERT INTO `infinitive_english_translation` VALUES ('2825', '975', ' to treat with injustice');
INSERT INTO `infinitive_english_translation` VALUES ('2826', '975', ' to act cruelly');
INSERT INTO `infinitive_english_translation` VALUES ('2827', '976', 'to be in love with someone or something');
INSERT INTO `infinitive_english_translation` VALUES ('2828', '976', ' to like someone or something');
INSERT INTO `infinitive_english_translation` VALUES ('2829', '977', 'to be in love with someone or something');
INSERT INTO `infinitive_english_translation` VALUES ('2830', '977', ' to like someone or something');
INSERT INTO `infinitive_english_translation` VALUES ('2831', '978', 'to fall in love with someone or something');
INSERT INTO `infinitive_english_translation` VALUES ('2832', '979', 'to fall in love with someone or something');
INSERT INTO `infinitive_english_translation` VALUES ('2833', '980', 'to sweat');
INSERT INTO `infinitive_english_translation` VALUES ('2834', '980', ' to perspire; fig. to struggle');
INSERT INTO `infinitive_english_translation` VALUES ('2835', '980', ' to toil');
INSERT INTO `infinitive_english_translation` VALUES ('2836', '980', ' to labor');
INSERT INTO `infinitive_english_translation` VALUES ('2837', '981', 'to sweat');
INSERT INTO `infinitive_english_translation` VALUES ('2838', '981', ' to perspire; fig. to struggle');
INSERT INTO `infinitive_english_translation` VALUES ('2839', '981', ' to toil');
INSERT INTO `infinitive_english_translation` VALUES ('2840', '981', ' to labor');
INSERT INTO `infinitive_english_translation` VALUES ('2841', '982', 'to web');
INSERT INTO `infinitive_english_translation` VALUES ('2842', '982', ' to marry');
INSERT INTO `infinitive_english_translation` VALUES ('2843', '982', ' to get married');
INSERT INTO `infinitive_english_translation` VALUES ('2844', '983', 'to web');
INSERT INTO `infinitive_english_translation` VALUES ('2845', '983', ' to marry');
INSERT INTO `infinitive_english_translation` VALUES ('2846', '983', ' to get married');
INSERT INTO `infinitive_english_translation` VALUES ('2847', '984', 'to sneeze');
INSERT INTO `infinitive_english_translation` VALUES ('2848', '985', 'to sneeze');
INSERT INTO `infinitive_english_translation` VALUES ('2849', '986', 'to do photography');
INSERT INTO `infinitive_english_translation` VALUES ('2850', '986', ' to be a photographer');
INSERT INTO `infinitive_english_translation` VALUES ('2851', '987', 'to do photography');
INSERT INTO `infinitive_english_translation` VALUES ('2852', '987', ' to be a photographer');
INSERT INTO `infinitive_english_translation` VALUES ('2853', '988', 'to have an interest');
INSERT INTO `infinitive_english_translation` VALUES ('2854', '988', ' to have a fancy');
INSERT INTO `infinitive_english_translation` VALUES ('2855', '988', ' to have a hobby');
INSERT INTO `infinitive_english_translation` VALUES ('2856', '989', 'to have an interest');
INSERT INTO `infinitive_english_translation` VALUES ('2857', '989', ' to have a fancy');
INSERT INTO `infinitive_english_translation` VALUES ('2858', '989', ' to have a hobby');
INSERT INTO `infinitive_english_translation` VALUES ('2859', '990', 'colloq. to mistake');
INSERT INTO `infinitive_english_translation` VALUES ('2860', '990', ' to confuse');
INSERT INTO `infinitive_english_translation` VALUES ('2861', '991', 'colloq. to mistake');
INSERT INTO `infinitive_english_translation` VALUES ('2862', '991', ' to confuse');
INSERT INTO `infinitive_english_translation` VALUES ('2863', '992', 'to put on glasses');
INSERT INTO `infinitive_english_translation` VALUES ('2864', '992', ' to put on spectacles');
INSERT INTO `infinitive_english_translation` VALUES ('2865', '993', 'to put on glasses');
INSERT INTO `infinitive_english_translation` VALUES ('2866', '993', ' to put on spectacles');
INSERT INTO `infinitive_english_translation` VALUES ('2867', '994', 'to overcome');
INSERT INTO `infinitive_english_translation` VALUES ('2868', '994', ' to triumph');
INSERT INTO `infinitive_english_translation` VALUES ('2869', '994', ' to win');
INSERT INTO `infinitive_english_translation` VALUES ('2870', '994', ' to become victorious');
INSERT INTO `infinitive_english_translation` VALUES ('2871', '995', 'to overcome');
INSERT INTO `infinitive_english_translation` VALUES ('2872', '995', ' to triumph');
INSERT INTO `infinitive_english_translation` VALUES ('2873', '995', ' to win');
INSERT INTO `infinitive_english_translation` VALUES ('2874', '995', ' to become victorious');
INSERT INTO `infinitive_english_translation` VALUES ('2875', '996', 'to become victorious');
INSERT INTO `infinitive_english_translation` VALUES ('2876', '996', ' to overpower');
INSERT INTO `infinitive_english_translation` VALUES ('2877', '996', ' to predominate');
INSERT INTO `infinitive_english_translation` VALUES ('2878', '996', ' to prevail');
INSERT INTO `infinitive_english_translation` VALUES ('2879', '996', ' to dominate');
INSERT INTO `infinitive_english_translation` VALUES ('2880', '997', 'to cook');
INSERT INTO `infinitive_english_translation` VALUES ('2881', '997', ' to cook food');
INSERT INTO `infinitive_english_translation` VALUES ('2882', '998', 'to eat');
INSERT INTO `infinitive_english_translation` VALUES ('2883', '999', 'to wash ceremoniously');
INSERT INTO `infinitive_english_translation` VALUES ('2884', '999', ' to baptize');
INSERT INTO `infinitive_english_translation` VALUES ('2885', '999', ' to wash a corpse');
INSERT INTO `infinitive_english_translation` VALUES ('2886', '1000', 'to be sad');
INSERT INTO `infinitive_english_translation` VALUES ('2887', '1000', ' to worry');
INSERT INTO `infinitive_english_translation` VALUES ('2888', '1000', ' to be anxious');
INSERT INTO `infinitive_english_translation` VALUES ('2889', '1001', 'to become sorrowful');
INSERT INTO `infinitive_english_translation` VALUES ('2890', '1001', ' to sadden');
INSERT INTO `infinitive_english_translation` VALUES ('2891', '1002', 'to forbid');
INSERT INTO `infinitive_english_translation` VALUES ('2892', '1002', ' to prohibit');
INSERT INTO `infinitive_english_translation` VALUES ('2893', '1002', ' to disallow');
INSERT INTO `infinitive_english_translation` VALUES ('2894', '1002', ' to make illegal');
INSERT INTO `infinitive_english_translation` VALUES ('2895', '1003', 'to forbid');
INSERT INTO `infinitive_english_translation` VALUES ('2896', '1003', ' to prohibit');
INSERT INTO `infinitive_english_translation` VALUES ('2897', '1003', ' to disallow');
INSERT INTO `infinitive_english_translation` VALUES ('2898', '1003', ' to make illegal');
INSERT INTO `infinitive_english_translation` VALUES ('2899', '1004', 'to become defensive or protective (of family honor');
INSERT INTO `infinitive_english_translation` VALUES ('2900', '1004', ' to become an upholder of ghayrat; colloq. to beco');
INSERT INTO `infinitive_english_translation` VALUES ('2901', '1004', ' to be particular (about)');
INSERT INTO `infinitive_english_translation` VALUES ('2902', '1005', 'to become defensive or protective (of family honor');
INSERT INTO `infinitive_english_translation` VALUES ('2903', '1005', ' to become an upholder of ghayrat; colloq. to beco');
INSERT INTO `infinitive_english_translation` VALUES ('2904', '1005', ' to be particular (about)');
INSERT INTO `infinitive_english_translation` VALUES ('2905', '1006', 'to graduate');
INSERT INTO `infinitive_english_translation` VALUES ('2906', '1007', 'to photoopy');
INSERT INTO `infinitive_english_translation` VALUES ('2907', '1007', ' to xerox');
INSERT INTO `infinitive_english_translation` VALUES ('2908', '1008', 'to arrive');
INSERT INTO `infinitive_english_translation` VALUES ('2909', '1008', ' to descend');
INSERT INTO `infinitive_english_translation` VALUES ('2910', '1009', 'to learn');
INSERT INTO `infinitive_english_translation` VALUES ('2911', '1009', ' to surround');
INSERT INTO `infinitive_english_translation` VALUES ('2912', '1009', ' to absorb');
INSERT INTO `infinitive_english_translation` VALUES ('2913', '1010', 'to scare away');
INSERT INTO `infinitive_english_translation` VALUES ('2914', '1010', ' to cause to flee');
INSERT INTO `infinitive_english_translation` VALUES ('2915', '1011', 'to escape');
INSERT INTO `infinitive_english_translation` VALUES ('2916', '1011', ' to run away');
INSERT INTO `infinitive_english_translation` VALUES ('2917', '1012', 'to scare away');
INSERT INTO `infinitive_english_translation` VALUES ('2918', '1012', ' to cause to flee');
INSERT INTO `infinitive_english_translation` VALUES ('2919', '1013', 'to escape');
INSERT INTO `infinitive_english_translation` VALUES ('2920', '1013', ' to run away');
INSERT INTO `infinitive_english_translation` VALUES ('2921', '1014', 'to forget');
INSERT INTO `infinitive_english_translation` VALUES ('2922', '1015', 'to provide');
INSERT INTO `infinitive_english_translation` VALUES ('2923', '1015', ' to come up with');
INSERT INTO `infinitive_english_translation` VALUES ('2924', '1016', 'to apply pressure');
INSERT INTO `infinitive_english_translation` VALUES ('2925', '1016', ' to press');
INSERT INTO `infinitive_english_translation` VALUES ('2926', '1017', 'to apply pressure');
INSERT INTO `infinitive_english_translation` VALUES ('2927', '1017', ' to press');
INSERT INTO `infinitive_english_translation` VALUES ('2928', '1018', 'to meddle');
INSERT INTO `infinitive_english_translation` VALUES ('2929', '1018', ' to pry');
INSERT INTO `infinitive_english_translation` VALUES ('2930', '1018', ' to butt in');
INSERT INTO `infinitive_english_translation` VALUES ('2931', '1018', ' to be nosy');
INSERT INTO `infinitive_english_translation` VALUES ('2932', '1018', ' to be a busybody');
INSERT INTO `infinitive_english_translation` VALUES ('2933', '1019', 'to think');
INSERT INTO `infinitive_english_translation` VALUES ('2934', '1020', 'to think');
INSERT INTO `infinitive_english_translation` VALUES ('2935', '1021', 'to gray');
INSERT INTO `infinitive_english_translation` VALUES ('2936', '1021', ' to turn grey');
INSERT INTO `infinitive_english_translation` VALUES ('2937', '1021', ' to turn grizzly');
INSERT INTO `infinitive_english_translation` VALUES ('2938', '1021', ' to become salt-and-pepper colored');
INSERT INTO `infinitive_english_translation` VALUES ('2939', '1022', 'to bastinado');
INSERT INTO `infinitive_english_translation` VALUES ('2940', '1022', ' to flog the soles of the feet');
INSERT INTO `infinitive_english_translation` VALUES ('2941', '1023', 'to die');
INSERT INTO `infinitive_english_translation` VALUES ('2942', '1023', ' to pass away');
INSERT INTO `infinitive_english_translation` VALUES ('2943', '1023', ' to expire');
INSERT INTO `infinitive_english_translation` VALUES ('2944', '1024', 'to die');
INSERT INTO `infinitive_english_translation` VALUES ('2945', '1024', ' to pass away');
INSERT INTO `infinitive_english_translation` VALUES ('2946', '1024', ' to expire');
INSERT INTO `infinitive_english_translation` VALUES ('2947', '1025', 'onom. to blow (out)');
INSERT INTO `infinitive_english_translation` VALUES ('2948', '1025', ' to blow (on)');
INSERT INTO `infinitive_english_translation` VALUES ('2949', '1025', ' to puff');
INSERT INTO `infinitive_english_translation` VALUES ('2950', '1025', ' to breathe on');
INSERT INTO `infinitive_english_translation` VALUES ('2951', '1026', 'to play football');
INSERT INTO `infinitive_english_translation` VALUES ('2952', '1027', 'to play soccer');
INSERT INTO `infinitive_english_translation` VALUES ('2953', '1028', 'to play indoor soccer');
INSERT INTO `infinitive_english_translation` VALUES ('2954', '1029', 'to film');
INSERT INTO `infinitive_english_translation` VALUES ('2955', '1029', ' to shoot a movie');
INSERT INTO `infinitive_english_translation` VALUES ('2956', '1029', ' to video');
INSERT INTO `infinitive_english_translation` VALUES ('2957', '1029', ' to videotape');
INSERT INTO `infinitive_english_translation` VALUES ('2958', '1030', 'to film');
INSERT INTO `infinitive_english_translation` VALUES ('2959', '1030', ' to shoot a movie');
INSERT INTO `infinitive_english_translation` VALUES ('2960', '1030', ' to video');
INSERT INTO `infinitive_english_translation` VALUES ('2961', '1030', ' to videotape');
INSERT INTO `infinitive_english_translation` VALUES ('2962', '1031', 'to believe');
INSERT INTO `infinitive_english_translation` VALUES ('2963', '1031', ' to be a believer');
INSERT INTO `infinitive_english_translation` VALUES ('2964', '1032', 'to believe');
INSERT INTO `infinitive_english_translation` VALUES ('2965', '1032', ' to be a believer');
INSERT INTO `infinitive_english_translation` VALUES ('2966', '1033', 'to believe');
INSERT INTO `infinitive_english_translation` VALUES ('2967', '1033', ' to be a believer');
INSERT INTO `infinitive_english_translation` VALUES ('2968', '1034', 'to believe');
INSERT INTO `infinitive_english_translation` VALUES ('2969', '1034', ' to be a believer');
INSERT INTO `infinitive_english_translation` VALUES ('2970', '1035', 'to be mixed');
INSERT INTO `infinitive_english_translation` VALUES ('2971', '1035', ' to be mixed up');
INSERT INTO `infinitive_english_translation` VALUES ('2972', '1035', ' to become mingled');
INSERT INTO `infinitive_english_translation` VALUES ('2973', '1035', ' to mix');
INSERT INTO `infinitive_english_translation` VALUES ('2974', '1035', ' to blend');
INSERT INTO `infinitive_english_translation` VALUES ('2975', '1036', 'to be mixed');
INSERT INTO `infinitive_english_translation` VALUES ('2976', '1036', ' to be mixed up');
INSERT INTO `infinitive_english_translation` VALUES ('2977', '1036', ' to become mingled');
INSERT INTO `infinitive_english_translation` VALUES ('2978', '1036', ' to mix');
INSERT INTO `infinitive_english_translation` VALUES ('2979', '1036', ' to blend');
INSERT INTO `infinitive_english_translation` VALUES ('2980', '1037', 'to mix');
INSERT INTO `infinitive_english_translation` VALUES ('2981', '1037', ' to combine');
INSERT INTO `infinitive_english_translation` VALUES ('2982', '1037', ' to blend');
INSERT INTO `infinitive_english_translation` VALUES ('2983', '1037', ' to intermingle');
INSERT INTO `infinitive_english_translation` VALUES ('2984', '1037', ' to mix up');
INSERT INTO `infinitive_english_translation` VALUES ('2985', '1037', ' to confuse');
INSERT INTO `infinitive_english_translation` VALUES ('2986', '1037', ' to get confused');
INSERT INTO `infinitive_english_translation` VALUES ('2987', '1037', ' to mistake');
INSERT INTO `infinitive_english_translation` VALUES ('2988', '1038', 'to mix');
INSERT INTO `infinitive_english_translation` VALUES ('2989', '1038', ' to combine');
INSERT INTO `infinitive_english_translation` VALUES ('2990', '1038', ' to blend');
INSERT INTO `infinitive_english_translation` VALUES ('2991', '1038', ' to intermingle');
INSERT INTO `infinitive_english_translation` VALUES ('2992', '1038', ' to mix up');
INSERT INTO `infinitive_english_translation` VALUES ('2993', '1038', ' to confuse');
INSERT INTO `infinitive_english_translation` VALUES ('2994', '1038', ' to get confused');
INSERT INTO `infinitive_english_translation` VALUES ('2995', '1038', ' to mistake');
INSERT INTO `infinitive_english_translation` VALUES ('2996', '1039', 'colloq. to become mixed');
INSERT INTO `infinitive_english_translation` VALUES ('2997', '1039', ' to be jumbled');
INSERT INTO `infinitive_english_translation` VALUES ('2998', '1039', ' to be mixed up');
INSERT INTO `infinitive_english_translation` VALUES ('2999', '1039', ' to be messed up');
INSERT INTO `infinitive_english_translation` VALUES ('3000', '1040', 'colloq. to become mixed');
INSERT INTO `infinitive_english_translation` VALUES ('3001', '1040', ' to be jumbled');
INSERT INTO `infinitive_english_translation` VALUES ('3002', '1040', ' to be mixed up');
INSERT INTO `infinitive_english_translation` VALUES ('3003', '1040', ' to be messed up');
INSERT INTO `infinitive_english_translation` VALUES ('3004', '1041', 'colloq. to mix up');
INSERT INTO `infinitive_english_translation` VALUES ('3005', '1041', ' to jumble');
INSERT INTO `infinitive_english_translation` VALUES ('3006', '1041', ' to scramble');
INSERT INTO `infinitive_english_translation` VALUES ('3007', '1041', ' to confuse');
INSERT INTO `infinitive_english_translation` VALUES ('3008', '1041', ' to mess up');
INSERT INTO `infinitive_english_translation` VALUES ('3009', '1042', 'colloq. to mix up');
INSERT INTO `infinitive_english_translation` VALUES ('3010', '1042', ' to jumble');
INSERT INTO `infinitive_english_translation` VALUES ('3011', '1042', ' to scramble');
INSERT INTO `infinitive_english_translation` VALUES ('3012', '1042', ' to confuse');
INSERT INTO `infinitive_english_translation` VALUES ('3013', '1042', ' to mess up');
INSERT INTO `infinitive_english_translation` VALUES ('3014', '1043', 'to go boating');
INSERT INTO `infinitive_english_translation` VALUES ('3015', '1044', 'to go boating');
INSERT INTO `infinitive_english_translation` VALUES ('3016', '1045', 'to play hide-and seek');
INSERT INTO `infinitive_english_translation` VALUES ('3017', '1045', ' to play hide-and-go-seek');
INSERT INTO `infinitive_english_translation` VALUES ('3018', '1046', 'to play hide-and seek');
INSERT INTO `infinitive_english_translation` VALUES ('3019', '1046', ' to play hide-and-go-seek');
INSERT INTO `infinitive_english_translation` VALUES ('3020', '1047', 'to appreciate');
INSERT INTO `infinitive_english_translation` VALUES ('3021', '1047', ' to acknowledge');
INSERT INTO `infinitive_english_translation` VALUES ('3022', '1047', ' to thank');
INSERT INTO `infinitive_english_translation` VALUES ('3023', '1048', 'to forbid');
INSERT INTO `infinitive_english_translation` VALUES ('3024', '1048', ' to prohibit');
INSERT INTO `infinitive_english_translation` VALUES ('3025', '1048', ' to bar; obs. to order');
INSERT INTO `infinitive_english_translation` VALUES ('3026', '1048', ' to command');
INSERT INTO `infinitive_english_translation` VALUES ('3027', '1049', 'to forbid');
INSERT INTO `infinitive_english_translation` VALUES ('3028', '1049', ' to prohibit');
INSERT INTO `infinitive_english_translation` VALUES ('3029', '1049', ' to bar; obs. to order');
INSERT INTO `infinitive_english_translation` VALUES ('3030', '1049', ' to command');
INSERT INTO `infinitive_english_translation` VALUES ('3031', '1050', 'to borrow');
INSERT INTO `infinitive_english_translation` VALUES ('3032', '1051', 'to borrow');
INSERT INTO `infinitive_english_translation` VALUES ('3033', '1052', 'to tell a story');
INSERT INTO `infinitive_english_translation` VALUES ('3034', '1053', 'to tell a story');
INSERT INTO `infinitive_english_translation` VALUES ('3035', '1054', 'to be cut');
INSERT INTO `infinitive_english_translation` VALUES ('3036', '1054', ' to get disconnected');
INSERT INTO `infinitive_english_translation` VALUES ('3037', '1055', 'to be cut');
INSERT INTO `infinitive_english_translation` VALUES ('3038', '1055', ' to get disconnected');
INSERT INTO `infinitive_english_translation` VALUES ('3039', '1056', 'to cut');
INSERT INTO `infinitive_english_translation` VALUES ('3040', '1056', ' to interrupt');
INSERT INTO `infinitive_english_translation` VALUES ('3041', '1056', ' to amputate');
INSERT INTO `infinitive_english_translation` VALUES ('3042', '1056', ' to crop');
INSERT INTO `infinitive_english_translation` VALUES ('3043', '1057', 'to cut');
INSERT INTO `infinitive_english_translation` VALUES ('3044', '1057', ' to interrupt');
INSERT INTO `infinitive_english_translation` VALUES ('3045', '1057', ' to amputate');
INSERT INTO `infinitive_english_translation` VALUES ('3046', '1057', ' to crop');
INSERT INTO `infinitive_english_translation` VALUES ('3047', '1058', 'to lock');
INSERT INTO `infinitive_english_translation` VALUES ('3048', '1058', ' to bolt');
INSERT INTO `infinitive_english_translation` VALUES ('3049', '1058', ' to secure');
INSERT INTO `infinitive_english_translation` VALUES ('3050', '1058', ' to close');
INSERT INTO `infinitive_english_translation` VALUES ('3051', '1058', ' to fasten');
INSERT INTO `infinitive_english_translation` VALUES ('3052', '1059', 'to lock');
INSERT INTO `infinitive_english_translation` VALUES ('3053', '1059', ' to bolt');
INSERT INTO `infinitive_english_translation` VALUES ('3054', '1059', ' to secure');
INSERT INTO `infinitive_english_translation` VALUES ('3055', '1059', ' to close');
INSERT INTO `infinitive_english_translation` VALUES ('3056', '1059', ' to fasten');
INSERT INTO `infinitive_english_translation` VALUES ('3057', '1060', 'to ask the price');
INSERT INTO `infinitive_english_translation` VALUES ('3058', '1061', 'to ask the price');
INSERT INTO `infinitive_english_translation` VALUES ('3059', '1062', 'to work');
INSERT INTO `infinitive_english_translation` VALUES ('3060', '1062', ' to labor');
INSERT INTO `infinitive_english_translation` VALUES ('3061', '1062', ' to act');
INSERT INTO `infinitive_english_translation` VALUES ('3062', '1062', ' to behave');
INSERT INTO `infinitive_english_translation` VALUES ('3063', '1062', ' to operate');
INSERT INTO `infinitive_english_translation` VALUES ('3064', '1063', 'to become complete');
INSERT INTO `infinitive_english_translation` VALUES ('3065', '1063', ' to become perfect');
INSERT INTO `infinitive_english_translation` VALUES ('3066', '1063', ' to be completed');
INSERT INTO `infinitive_english_translation` VALUES ('3067', '1064', 'to excavate');
INSERT INTO `infinitive_english_translation` VALUES ('3068', '1064', ' to dig');
INSERT INTO `infinitive_english_translation` VALUES ('3069', '1064', ' to root');
INSERT INTO `infinitive_english_translation` VALUES ('3070', '1064', ' to explore');
INSERT INTO `infinitive_english_translation` VALUES ('3071', '1064', ' to investigate');
INSERT INTO `infinitive_english_translation` VALUES ('3072', '1064', ' to research');
INSERT INTO `infinitive_english_translation` VALUES ('3073', '1065', 'to excavate');
INSERT INTO `infinitive_english_translation` VALUES ('3074', '1065', ' to dig');
INSERT INTO `infinitive_english_translation` VALUES ('3075', '1065', ' to root');
INSERT INTO `infinitive_english_translation` VALUES ('3076', '1065', ' to explore');
INSERT INTO `infinitive_english_translation` VALUES ('3077', '1065', ' to investigate');
INSERT INTO `infinitive_english_translation` VALUES ('3078', '1065', ' to research');
INSERT INTO `infinitive_english_translation` VALUES ('3079', '1066', 'to read');
INSERT INTO `infinitive_english_translation` VALUES ('3080', '1066', ' to read books');
INSERT INTO `infinitive_english_translation` VALUES ('3081', '1067', 'to read');
INSERT INTO `infinitive_english_translation` VALUES ('3082', '1067', ' to read books');
INSERT INTO `infinitive_english_translation` VALUES ('3083', '1068', 'to put on a tie');
INSERT INTO `infinitive_english_translation` VALUES ('3084', '1068', ' to wear a tie');
INSERT INTO `infinitive_english_translation` VALUES ('3085', '1069', 'to plant');
INSERT INTO `infinitive_english_translation` VALUES ('3086', '1069', ' to sow');
INSERT INTO `infinitive_english_translation` VALUES ('3087', '1070', 'to plant');
INSERT INTO `infinitive_english_translation` VALUES ('3088', '1070', ' to sow');
INSERT INTO `infinitive_english_translation` VALUES ('3089', '1071', 'to wrestle; fig to grapple');
INSERT INTO `infinitive_english_translation` VALUES ('3090', '1072', 'colloq. fig. to wrestle');
INSERT INTO `infinitive_english_translation` VALUES ('3091', '1072', ' to spar');
INSERT INTO `infinitive_english_translation` VALUES ('3092', '1072', ' to grapple');
INSERT INTO `infinitive_english_translation` VALUES ('3093', '1072', ' to bicker');
INSERT INTO `infinitive_english_translation` VALUES ('3094', '1072', ' to squabble');
INSERT INTO `infinitive_english_translation` VALUES ('3095', '1073', 'to help');
INSERT INTO `infinitive_english_translation` VALUES ('3096', '1074', 'to help');
INSERT INTO `infinitive_english_translation` VALUES ('3097', '1075', 'to help');
INSERT INTO `infinitive_english_translation` VALUES ('3098', '1076', 'to help');
INSERT INTO `infinitive_english_translation` VALUES ('3099', '1076', ' to aid');
INSERT INTO `infinitive_english_translation` VALUES ('3100', '1076', ' to assit');
INSERT INTO `infinitive_english_translation` VALUES ('3101', '1076', ' to support');
INSERT INTO `infinitive_english_translation` VALUES ('3102', '1077', 'to shorten');
INSERT INTO `infinitive_english_translation` VALUES ('3103', '1077', ' to make short');
INSERT INTO `infinitive_english_translation` VALUES ('3104', '1077', ' to crop');
INSERT INTO `infinitive_english_translation` VALUES ('3105', '1077', ' to abridge');
INSERT INTO `infinitive_english_translation` VALUES ('3106', '1078', 'to become small');
INSERT INTO `infinitive_english_translation` VALUES ('3107', '1078', ' to shrink');
INSERT INTO `infinitive_english_translation` VALUES ('3108', '1079', 'to become small');
INSERT INTO `infinitive_english_translation` VALUES ('3109', '1079', ' to shrink');
INSERT INTO `infinitive_english_translation` VALUES ('3110', '1080', 'to fertilize');
INSERT INTO `infinitive_english_translation` VALUES ('3111', '1080', ' to manure');
INSERT INTO `infinitive_english_translation` VALUES ('3112', '1081', 'to try');
INSERT INTO `infinitive_english_translation` VALUES ('3113', '1081', ' to struggle');
INSERT INTO `infinitive_english_translation` VALUES ('3114', '1081', ' to strive');
INSERT INTO `infinitive_english_translation` VALUES ('3115', '1081', ' to endeavor');
INSERT INTO `infinitive_english_translation` VALUES ('3116', '1081', ' to labor');
INSERT INTO `infinitive_english_translation` VALUES ('3117', '1082', 'to punish');
INSERT INTO `infinitive_english_translation` VALUES ('3118', '1083', 'to punish');
INSERT INTO `infinitive_english_translation` VALUES ('3119', '1084', 'to be punished');
INSERT INTO `infinitive_english_translation` VALUES ('3120', '1084', ' to suffer punishment');
INSERT INTO `infinitive_english_translation` VALUES ('3121', '1085', 'to be punished');
INSERT INTO `infinitive_english_translation` VALUES ('3122', '1085', ' to suffer punishment');
INSERT INTO `infinitive_english_translation` VALUES ('3123', '1086', 'to be vengeful');
INSERT INTO `infinitive_english_translation` VALUES ('3124', '1086', ' to hate');
INSERT INTO `infinitive_english_translation` VALUES ('3125', '1087', 'to step on the gas');
INSERT INTO `infinitive_english_translation` VALUES ('3126', '1087', ' to give it some gas');
INSERT INTO `infinitive_english_translation` VALUES ('3127', '1087', ' to speed up');
INSERT INTO `infinitive_english_translation` VALUES ('3128', '1088', 'to bite');
INSERT INTO `infinitive_english_translation` VALUES ('3129', '1089', 'to bite');
INSERT INTO `infinitive_english_translation` VALUES ('3130', '1090', 'to chat; obs. to talk nonsensically');
INSERT INTO `infinitive_english_translation` VALUES ('3131', '1091', 'to stroll');
INSERT INTO `infinitive_english_translation` VALUES ('3132', '1091', ' to take a walk');
INSERT INTO `infinitive_english_translation` VALUES ('3133', '1091', ' to move along a path');
INSERT INTO `infinitive_english_translation` VALUES ('3134', '1091', ' to course');
INSERT INTO `infinitive_english_translation` VALUES ('3135', '1092', 'to be caught; fig. to be caught up (in)');
INSERT INTO `infinitive_english_translation` VALUES ('3136', '1092', ' to be trapped');
INSERT INTO `infinitive_english_translation` VALUES ('3137', '1092', ' to be busy');
INSERT INTO `infinitive_english_translation` VALUES ('3138', '1093', 'to pawn');
INSERT INTO `infinitive_english_translation` VALUES ('3139', '1093', ' to pledge');
INSERT INTO `infinitive_english_translation` VALUES ('3140', '1093', ' to mortgage');
INSERT INTO `infinitive_english_translation` VALUES ('3141', '1093', ' to pledge');
INSERT INTO `infinitive_english_translation` VALUES ('3142', '1094', 'to pawn');
INSERT INTO `infinitive_english_translation` VALUES ('3143', '1094', ' to pledge');
INSERT INTO `infinitive_english_translation` VALUES ('3144', '1094', ' to mortgage');
INSERT INTO `infinitive_english_translation` VALUES ('3145', '1094', ' to pledge');
INSERT INTO `infinitive_english_translation` VALUES ('3146', '1095', 'to take hostage');
INSERT INTO `infinitive_english_translation` VALUES ('3147', '1095', ' to keep as surety');
INSERT INTO `infinitive_english_translation` VALUES ('3148', '1096', 'to take hostage');
INSERT INTO `infinitive_english_translation` VALUES ('3149', '1096', ' to keep as surety');
INSERT INTO `infinitive_english_translation` VALUES ('3150', '1097', 'to cry');
INSERT INTO `infinitive_english_translation` VALUES ('3151', '1097', ' to weep');
INSERT INTO `infinitive_english_translation` VALUES ('3152', '1098', 'to report');
INSERT INTO `infinitive_english_translation` VALUES ('3153', '1098', ' to give a report');
INSERT INTO `infinitive_english_translation` VALUES ('3154', '1099', 'to exaggerate');
INSERT INTO `infinitive_english_translation` VALUES ('3155', '1100', 'to behave rudely');
INSERT INTO `infinitive_english_translation` VALUES ('3156', '1100', ' to show incivility');
INSERT INTO `infinitive_english_translation` VALUES ('3157', '1100', ' to be irreverent');
INSERT INTO `infinitive_english_translation` VALUES ('3158', '1100', ' to be insolent');
INSERT INTO `infinitive_english_translation` VALUES ('3159', '1100', ' to be strident; obs. to be audacious');
INSERT INTO `infinitive_english_translation` VALUES ('3160', '1101', 'to widen');
INSERT INTO `infinitive_english_translation` VALUES ('3161', '1101', ' to broaden');
INSERT INTO `infinitive_english_translation` VALUES ('3162', '1101', ' to extend');
INSERT INTO `infinitive_english_translation` VALUES ('3163', '1101', ' to spread out');
INSERT INTO `infinitive_english_translation` VALUES ('3164', '1102', 'to expand');
INSERT INTO `infinitive_english_translation` VALUES ('3165', '1102', ' to develop');
INSERT INTO `infinitive_english_translation` VALUES ('3166', '1102', ' to make popular');
INSERT INTO `infinitive_english_translation` VALUES ('3167', '1103', 'to talk');
INSERT INTO `infinitive_english_translation` VALUES ('3168', '1103', ' to converse');
INSERT INTO `infinitive_english_translation` VALUES ('3169', '1103', ' to discuss');
INSERT INTO `infinitive_english_translation` VALUES ('3170', '1104', 'to talk');
INSERT INTO `infinitive_english_translation` VALUES ('3171', '1104', ' to converse');
INSERT INTO `infinitive_english_translation` VALUES ('3172', '1104', ' to discuss; obs. to bad-mouth');
INSERT INTO `infinitive_english_translation` VALUES ('3173', '1105', 'to be said');
INSERT INTO `infinitive_english_translation` VALUES ('3174', '1106', 'to put out flowers');
INSERT INTO `infinitive_english_translation` VALUES ('3175', '1106', ' to flower');
INSERT INTO `infinitive_english_translation` VALUES ('3176', '1106', ' to bloom');
INSERT INTO `infinitive_english_translation` VALUES ('3177', '1107', 'to hit a goal');
INSERT INTO `infinitive_english_translation` VALUES ('3178', '1107', ' to score a goal');
INSERT INTO `infinitive_english_translation` VALUES ('3179', '1108', 'to flower');
INSERT INTO `infinitive_english_translation` VALUES ('3180', '1108', ' to bloom; fig. to flourish');
INSERT INTO `infinitive_english_translation` VALUES ('3181', '1109', 'to play back-alley soccer');
INSERT INTO `infinitive_english_translation` VALUES ('3182', '1109', ' to play informal soccer');
INSERT INTO `infinitive_english_translation` VALUES ('3183', '1110', 'to lose');
INSERT INTO `infinitive_english_translation` VALUES ('3184', '1111', 'to believe');
INSERT INTO `infinitive_english_translation` VALUES ('3185', '1111', ' to think');
INSERT INTO `infinitive_english_translation` VALUES ('3186', '1111', ' to be of the opinion');
INSERT INTO `infinitive_english_translation` VALUES ('3187', '1112', 'to listen');
INSERT INTO `infinitive_english_translation` VALUES ('3188', '1112', ' to obey');
INSERT INTO `infinitive_english_translation` VALUES ('3189', '1113', 'to listen');
INSERT INTO `infinitive_english_translation` VALUES ('3190', '1113', ' to obey');
INSERT INTO `infinitive_english_translation` VALUES ('3191', '1114', 'to castigate');
INSERT INTO `infinitive_english_translation` VALUES ('3192', '1114', ' to chastise');
INSERT INTO `infinitive_english_translation` VALUES ('3193', '1114', ' to punish');
INSERT INTO `infinitive_english_translation` VALUES ('3194', '1114', ' to discipline');
INSERT INTO `infinitive_english_translation` VALUES ('3195', '1115', 'to play the guitar');
INSERT INTO `infinitive_english_translation` VALUES ('3196', '1116', 'to become dizzy');
INSERT INTO `infinitive_english_translation` VALUES ('3197', '1116', ' to get confused');
INSERT INTO `infinitive_english_translation` VALUES ('3198', '1117', 'to be available');
INSERT INTO `infinitive_english_translation` VALUES ('3199', '1117', ' to be found');
INSERT INTO `infinitive_english_translation` VALUES ('3200', '1118', 'to be available');
INSERT INTO `infinitive_english_translation` VALUES ('3201', '1118', ' to be found');
INSERT INTO `infinitive_english_translation` VALUES ('3202', '1119', 'to find');
INSERT INTO `infinitive_english_translation` VALUES ('3203', '1119', ' to obtain');
INSERT INTO `infinitive_english_translation` VALUES ('3204', '1119', ' to get');
INSERT INTO `infinitive_english_translation` VALUES ('3205', '1120', 'to find');
INSERT INTO `infinitive_english_translation` VALUES ('3206', '1120', ' to obtain');
INSERT INTO `infinitive_english_translation` VALUES ('3207', '1120', ' to get');
INSERT INTO `infinitive_english_translation` VALUES ('3208', '1121', 'to need');
INSERT INTO `infinitive_english_translation` VALUES ('3209', '1121', ' to require');
INSERT INTO `infinitive_english_translation` VALUES ('3210', '1121', ' to want');
INSERT INTO `infinitive_english_translation` VALUES ('3211', '1121', ' to lack');
INSERT INTO `infinitive_english_translation` VALUES ('3212', '1122', 'colloq. to flirt');
INSERT INTO `infinitive_english_translation` VALUES ('3213', '1123', 'to become thin');
INSERT INTO `infinitive_english_translation` VALUES ('3214', '1123', ' to lose weight');
INSERT INTO `infinitive_english_translation` VALUES ('3215', '1124', 'to get dressed');
INSERT INTO `infinitive_english_translation` VALUES ('3216', '1124', ' to put on clothes');
INSERT INTO `infinitive_english_translation` VALUES ('3217', '1125', 'to slide');
INSERT INTO `infinitive_english_translation` VALUES ('3218', '1125', ' to skid');
INSERT INTO `infinitive_english_translation` VALUES ('3219', '1125', ' to stumble');
INSERT INTO `infinitive_english_translation` VALUES ('3220', '1126', 'to surprise');
INSERT INTO `infinitive_english_translation` VALUES ('3221', '1126', ' to astonish');
INSERT INTO `infinitive_english_translation` VALUES ('3222', '1126', ' to amaze');
INSERT INTO `infinitive_english_translation` VALUES ('3223', '1127', 'to surprise');
INSERT INTO `infinitive_english_translation` VALUES ('3224', '1127', ' to astonish');
INSERT INTO `infinitive_english_translation` VALUES ('3225', '1127', ' to amaze');
INSERT INTO `infinitive_english_translation` VALUES ('3226', '1128', 'to be directed (at)');
INSERT INTO `infinitive_english_translation` VALUES ('3227', '1128', ' to be focused');
INSERT INTO `infinitive_english_translation` VALUES ('3228', '1128', ' to be attentive');
INSERT INTO `infinitive_english_translation` VALUES ('3229', '1128', ' to get');
INSERT INTO `infinitive_english_translation` VALUES ('3230', '1128', ' to understand');
INSERT INTO `infinitive_english_translation` VALUES ('3231', '1129', 'to be directed (at)');
INSERT INTO `infinitive_english_translation` VALUES ('3232', '1129', ' to be focused');
INSERT INTO `infinitive_english_translation` VALUES ('3233', '1129', ' to be attentive');
INSERT INTO `infinitive_english_translation` VALUES ('3234', '1129', ' to get');
INSERT INTO `infinitive_english_translation` VALUES ('3235', '1129', ' to understand');
INSERT INTO `infinitive_english_translation` VALUES ('3236', '1130', 'to notice');
INSERT INTO `infinitive_english_translation` VALUES ('3237', '1130', ' to catch');
INSERT INTO `infinitive_english_translation` VALUES ('3238', '1130', ' to understand');
INSERT INTO `infinitive_english_translation` VALUES ('3239', '1131', 'to notice');
INSERT INTO `infinitive_english_translation` VALUES ('3240', '1131', ' to catch');
INSERT INTO `infinitive_english_translation` VALUES ('3241', '1131', ' to understand');
INSERT INTO `infinitive_english_translation` VALUES ('3242', '1132', 'to direct');
INSERT INTO `infinitive_english_translation` VALUES ('3243', '1132', ' to aim');
INSERT INTO `infinitive_english_translation` VALUES ('3244', '1132', ' to focus');
INSERT INTO `infinitive_english_translation` VALUES ('3245', '1132', ' to alert');
INSERT INTO `infinitive_english_translation` VALUES ('3246', '1133', 'to direct');
INSERT INTO `infinitive_english_translation` VALUES ('3247', '1133', ' to aim');
INSERT INTO `infinitive_english_translation` VALUES ('3248', '1133', ' to focus');
INSERT INTO `infinitive_english_translation` VALUES ('3249', '1133', ' to alert');
INSERT INTO `infinitive_english_translation` VALUES ('3250', '1134', 'to stop');
INSERT INTO `infinitive_english_translation` VALUES ('3251', '1134', ' to stand still');
INSERT INTO `infinitive_english_translation` VALUES ('3252', '1134', ' to cease');
INSERT INTO `infinitive_english_translation` VALUES ('3253', '1135', 'to stop');
INSERT INTO `infinitive_english_translation` VALUES ('3254', '1135', ' to stand still');
INSERT INTO `infinitive_english_translation` VALUES ('3255', '1135', ' to cease');
INSERT INTO `infinitive_english_translation` VALUES ('3256', '1136', 'to stop');
INSERT INTO `infinitive_english_translation` VALUES ('3257', '1136', ' to bring to a stop');
INSERT INTO `infinitive_english_translation` VALUES ('3258', '1136', ' to cease');
INSERT INTO `infinitive_english_translation` VALUES ('3259', '1137', 'to stop');
INSERT INTO `infinitive_english_translation` VALUES ('3260', '1137', ' to bring to a stop');
INSERT INTO `infinitive_english_translation` VALUES ('3261', '1137', ' to cease');
INSERT INTO `infinitive_english_translation` VALUES ('3262', '1138', 'to be born');
INSERT INTO `infinitive_english_translation` VALUES ('3263', '1138', ' to be given birth to');
INSERT INTO `infinitive_english_translation` VALUES ('3264', '1139', 'to be born');
INSERT INTO `infinitive_english_translation` VALUES ('3265', '1139', ' to be given birth to');
INSERT INTO `infinitive_english_translation` VALUES ('3266', '1140', 'to give an example');
INSERT INTO `infinitive_english_translation` VALUES ('3267', '1140', ' to cite an example');
INSERT INTO `infinitive_english_translation` VALUES ('3268', '1141', 'to punish');
INSERT INTO `infinitive_english_translation` VALUES ('3269', '1141', ' to penalize');
INSERT INTO `infinitive_english_translation` VALUES ('3270', '1142', 'to talk');
INSERT INTO `infinitive_english_translation` VALUES ('3271', '1142', ' to converse');
INSERT INTO `infinitive_english_translation` VALUES ('3272', '1142', ' to discuss');
INSERT INTO `infinitive_english_translation` VALUES ('3273', '1143', 'to transfer');
INSERT INTO `infinitive_english_translation` VALUES ('3274', '1143', ' to hand over');
INSERT INTO `infinitive_english_translation` VALUES ('3275', '1144', 'to be mixed');
INSERT INTO `infinitive_english_translation` VALUES ('3276', '1144', ' to be mingled');
INSERT INTO `infinitive_english_translation` VALUES ('3277', '1144', ' to intermix');
INSERT INTO `infinitive_english_translation` VALUES ('3278', '1144', ' to intermingle');
INSERT INTO `infinitive_english_translation` VALUES ('3279', '1144', ' to emulsify');
INSERT INTO `infinitive_english_translation` VALUES ('3280', '1145', 'to mix');
INSERT INTO `infinitive_english_translation` VALUES ('3281', '1145', ' to blend');
INSERT INTO `infinitive_english_translation` VALUES ('3282', '1145', ' to merge');
INSERT INTO `infinitive_english_translation` VALUES ('3283', '1145', ' to emulsify');
INSERT INTO `infinitive_english_translation` VALUES ('3284', '1145', ' to compound');
INSERT INTO `infinitive_english_translation` VALUES ('3285', '1145', ' to mill');
INSERT INTO `infinitive_english_translation` VALUES ('3286', '1145', ' to stir');
INSERT INTO `infinitive_english_translation` VALUES ('3287', '1146', 'to interfere');
INSERT INTO `infinitive_english_translation` VALUES ('3288', '1146', ' to interevene');
INSERT INTO `infinitive_english_translation` VALUES ('3289', '1146', ' to intrude');
INSERT INTO `infinitive_english_translation` VALUES ('3290', '1146', ' to meddle');
INSERT INTO `infinitive_english_translation` VALUES ('3291', '1146', ' to butt in');
INSERT INTO `infinitive_english_translation` VALUES ('3292', '1147', 'lit. to help');
INSERT INTO `infinitive_english_translation` VALUES ('3293', '1148', 'to defecate');
INSERT INTO `infinitive_english_translation` VALUES ('3294', '1149', 'to defecate');
INSERT INTO `infinitive_english_translation` VALUES ('3295', '1150', 'to consist (of)');
INSERT INTO `infinitive_english_translation` VALUES ('3296', '1150', ' to include');
INSERT INTO `infinitive_english_translation` VALUES ('3297', '1150', ' to contain');
INSERT INTO `infinitive_english_translation` VALUES ('3298', '1150', ' to comprise');
INSERT INTO `infinitive_english_translation` VALUES ('3299', '1150', ' to be composed (of)');
INSERT INTO `infinitive_english_translation` VALUES ('3300', '1150', ' to be compounded of');
INSERT INTO `infinitive_english_translation` VALUES ('3301', '1151', 'to consist (of)');
INSERT INTO `infinitive_english_translation` VALUES ('3302', '1151', ' to include');
INSERT INTO `infinitive_english_translation` VALUES ('3303', '1151', ' to contain');
INSERT INTO `infinitive_english_translation` VALUES ('3304', '1151', ' to comprise');
INSERT INTO `infinitive_english_translation` VALUES ('3305', '1151', ' to be composed (of)');
INSERT INTO `infinitive_english_translation` VALUES ('3306', '1151', ' to be compounded of');
INSERT INTO `infinitive_english_translation` VALUES ('3307', '1152', 'to compose (of)');
INSERT INTO `infinitive_english_translation` VALUES ('3308', '1152', ' to form (of)');
INSERT INTO `infinitive_english_translation` VALUES ('3309', '1152', ' to incorporate');
INSERT INTO `infinitive_english_translation` VALUES ('3310', '1153', 'to peruse');
INSERT INTO `infinitive_english_translation` VALUES ('3311', '1153', ' to review');
INSERT INTO `infinitive_english_translation` VALUES ('3312', '1153', ' to run through again');
INSERT INTO `infinitive_english_translation` VALUES ('3313', '1153', ' to recall');
INSERT INTO `infinitive_english_translation` VALUES ('3314', '1153', ' to revise');
INSERT INTO `infinitive_english_translation` VALUES ('3315', '1153', ' to rehearse');
INSERT INTO `infinitive_english_translation` VALUES ('3316', '1153', ' to survey');
INSERT INTO `infinitive_english_translation` VALUES ('3317', '1153', ' to travel');
INSERT INTO `infinitive_english_translation` VALUES ('3318', '1154', 'to be sick');
INSERT INTO `infinitive_english_translation` VALUES ('3319', '1154', ' to be ill');
INSERT INTO `infinitive_english_translation` VALUES ('3320', '1154', ' to be indisposed');
INSERT INTO `infinitive_english_translation` VALUES ('3321', '1154', ' to be diseased');
INSERT INTO `infinitive_english_translation` VALUES ('3322', '1155', 'to become ill');
INSERT INTO `infinitive_english_translation` VALUES ('3323', '1155', ' to get sick');
INSERT INTO `infinitive_english_translation` VALUES ('3324', '1155', ' to sicken');
INSERT INTO `infinitive_english_translation` VALUES ('3325', '1156', 'to make sick');
INSERT INTO `infinitive_english_translation` VALUES ('3326', '1156', ' to make ill');
INSERT INTO `infinitive_english_translation` VALUES ('3327', '1156', ' to sicken');
INSERT INTO `infinitive_english_translation` VALUES ('3328', '1157', 'to travel');
INSERT INTO `infinitive_english_translation` VALUES ('3329', '1157', ' to go on a trip');
INSERT INTO `infinitive_english_translation` VALUES ('3330', '1157', ' to voyage');
INSERT INTO `infinitive_english_translation` VALUES ('3331', '1157', ' to peregrinate');
INSERT INTO `infinitive_english_translation` VALUES ('3332', '1158', 'euph. to go to the toilet');
INSERT INTO `infinitive_english_translation` VALUES ('3333', '1158', ' to use the restroom');
INSERT INTO `infinitive_english_translation` VALUES ('3334', '1158', ' to go to the bathroom');
INSERT INTO `infinitive_english_translation` VALUES ('3335', '1159', 'lit. to return');
INSERT INTO `infinitive_english_translation` VALUES ('3336', '1159', ' to give back');
INSERT INTO `infinitive_english_translation` VALUES ('3337', '1159', ' to restore');
INSERT INTO `infinitive_english_translation` VALUES ('3338', '1159', ' to reimburse');
INSERT INTO `infinitive_english_translation` VALUES ('3339', '1160', 'to brush (one\'s teeth)');
INSERT INTO `infinitive_english_translation` VALUES ('3340', '1161', 'to brush (one\'s teeth)');
INSERT INTO `infinitive_english_translation` VALUES ('3341', '1162', 'to use');
INSERT INTO `infinitive_english_translation` VALUES ('3342', '1162', ' to consume');
INSERT INTO `infinitive_english_translation` VALUES ('3343', '1162', ' to eat');
INSERT INTO `infinitive_english_translation` VALUES ('3344', '1162', ' to spend');
INSERT INTO `infinitive_english_translation` VALUES ('3345', '1163', 'to study');
INSERT INTO `infinitive_english_translation` VALUES ('3346', '1163', ' to read');
INSERT INTO `infinitive_english_translation` VALUES ('3347', '1163', ' to research');
INSERT INTO `infinitive_english_translation` VALUES ('3348', '1163', ' to examine; obs. to observe');
INSERT INTO `infinitive_english_translation` VALUES ('3349', '1164', 'to study');
INSERT INTO `infinitive_english_translation` VALUES ('3350', '1164', ' to read');
INSERT INTO `infinitive_english_translation` VALUES ('3351', '1164', ' to research');
INSERT INTO `infinitive_english_translation` VALUES ('3352', '1164', ' to examine; obs. to observe');
INSERT INTO `infinitive_english_translation` VALUES ('3353', '1165', 'to socialize');
INSERT INTO `infinitive_english_translation` VALUES ('3354', '1165', ' to get together (with)');
INSERT INTO `infinitive_english_translation` VALUES ('3355', '1165', ' to spend time (with)');
INSERT INTO `infinitive_english_translation` VALUES ('3356', '1165', ' to associate (with)');
INSERT INTO `infinitive_english_translation` VALUES ('3357', '1166', 'to apologize');
INSERT INTO `infinitive_english_translation` VALUES ('3358', '1166', ' to seek pardon');
INSERT INTO `infinitive_english_translation` VALUES ('3359', '1166', ' to excuse oneself');
INSERT INTO `infinitive_english_translation` VALUES ('3360', '1167', 'to apologize');
INSERT INTO `infinitive_english_translation` VALUES ('3361', '1167', ' to seek pardon');
INSERT INTO `infinitive_english_translation` VALUES ('3362', '1167', ' to excuse oneself');
INSERT INTO `infinitive_english_translation` VALUES ('3363', '1168', 'to apologize');
INSERT INTO `infinitive_english_translation` VALUES ('3364', '1168', ' to seek pardon');
INSERT INTO `infinitive_english_translation` VALUES ('3365', '1168', ' to excuse oneself');
INSERT INTO `infinitive_english_translation` VALUES ('3366', '1169', 'to be introduced');
INSERT INTO `infinitive_english_translation` VALUES ('3367', '1169', ' to be presented');
INSERT INTO `infinitive_english_translation` VALUES ('3368', '1169', ' to be announced');
INSERT INTO `infinitive_english_translation` VALUES ('3369', '1169', ' to be reported');
INSERT INTO `infinitive_english_translation` VALUES ('3370', '1169', ' to be recommended');
INSERT INTO `infinitive_english_translation` VALUES ('3371', '1169', ' to be mentioned');
INSERT INTO `infinitive_english_translation` VALUES ('3372', '1170', 'to introduce');
INSERT INTO `infinitive_english_translation` VALUES ('3373', '1170', ' to present');
INSERT INTO `infinitive_english_translation` VALUES ('3374', '1170', ' to recommend');
INSERT INTO `infinitive_english_translation` VALUES ('3375', '1170', ' to report');
INSERT INTO `infinitive_english_translation` VALUES ('3376', '1170', ' to announce');
INSERT INTO `infinitive_english_translation` VALUES ('3377', '1170', ' to mention');
INSERT INTO `infinitive_english_translation` VALUES ('3378', '1171', 'to stage a performance');
INSERT INTO `infinitive_english_translation` VALUES ('3379', '1171', ' to put on a show; colloq. fig. to make a scene');
INSERT INTO `infinitive_english_translation` VALUES ('3380', '1171', ' to become the center of attention');
INSERT INTO `infinitive_english_translation` VALUES ('3381', '1172', 'to stage a performance');
INSERT INTO `infinitive_english_translation` VALUES ('3382', '1172', ' to put on a show; colloq. fig. to make a scene');
INSERT INTO `infinitive_english_translation` VALUES ('3383', '1172', ' to become the center of attention');
INSERT INTO `infinitive_english_translation` VALUES ('3384', '1173', 'to overcome');
INSERT INTO `infinitive_english_translation` VALUES ('3385', '1173', ' to defeat');
INSERT INTO `infinitive_english_translation` VALUES ('3386', '1174', 'to invert');
INSERT INTO `infinitive_english_translation` VALUES ('3387', '1174', ' to turn upside down');
INSERT INTO `infinitive_english_translation` VALUES ('3388', '1174', ' to reverse');
INSERT INTO `infinitive_english_translation` VALUES ('3389', '1175', 'to invert');
INSERT INTO `infinitive_english_translation` VALUES ('3390', '1175', ' to turn upside down');
INSERT INTO `infinitive_english_translation` VALUES ('3391', '1175', ' to reverse');
INSERT INTO `infinitive_english_translation` VALUES ('3392', '1176', 'to talk');
INSERT INTO `infinitive_english_translation` VALUES ('3393', '1176', ' to converse');
INSERT INTO `infinitive_english_translation` VALUES ('3394', '1176', ' to discuss');
INSERT INTO `infinitive_english_translation` VALUES ('3395', '1177', 'to prohibit');
INSERT INTO `infinitive_english_translation` VALUES ('3396', '1177', ' to forbid');
INSERT INTO `infinitive_english_translation` VALUES ('3397', '1178', 'to freeze');
INSERT INTO `infinitive_english_translation` VALUES ('3398', '1178', ' to become frozen');
INSERT INTO `infinitive_english_translation` VALUES ('3399', '1178', ' to congeal');
INSERT INTO `infinitive_english_translation` VALUES ('3400', '1178', ' to curdle; colloq. fig. to become motionless');
INSERT INTO `infinitive_english_translation` VALUES ('3401', '1179', 'to change one\'s mind');
INSERT INTO `infinitive_english_translation` VALUES ('3402', '1179', ' to decide not to');
INSERT INTO `infinitive_english_translation` VALUES ('3403', '1179', ' to give up an idea');
INSERT INTO `infinitive_english_translation` VALUES ('3404', '1179', ' to think better of');
INSERT INTO `infinitive_english_translation` VALUES ('3405', '1179', ' to reconsider');
INSERT INTO `infinitive_english_translation` VALUES ('3406', '1180', 'to dissuade');
INSERT INTO `infinitive_english_translation` VALUES ('3407', '1180', ' to discourage');
INSERT INTO `infinitive_english_translation` VALUES ('3408', '1180', ' to deter');
INSERT INTO `infinitive_english_translation` VALUES ('3409', '1180', ' to steer away');
INSERT INTO `infinitive_english_translation` VALUES ('3410', '1180', ' to wean');
INSERT INTO `infinitive_english_translation` VALUES ('3411', '1181', 'to prevent');
INSERT INTO `infinitive_english_translation` VALUES ('3412', '1181', ' to check');
INSERT INTO `infinitive_english_translation` VALUES ('3413', '1181', ' to forbid');
INSERT INTO `infinitive_english_translation` VALUES ('3414', '1181', ' to prohibit');
INSERT INTO `infinitive_english_translation` VALUES ('3415', '1181', ' to inhibit');
INSERT INTO `infinitive_english_translation` VALUES ('3416', '1181', ' to disallow');
INSERT INTO `infinitive_english_translation` VALUES ('3417', '1181', ' to ban; obs. to discourage');
INSERT INTO `infinitive_english_translation` VALUES ('3418', '1181', ' to dissuade');
INSERT INTO `infinitive_english_translation` VALUES ('3419', '1182', 'to explode');
INSERT INTO `infinitive_english_translation` VALUES ('3420', '1182', ' to burst');
INSERT INTO `infinitive_english_translation` VALUES ('3421', '1182', ' to blow up');
INSERT INTO `infinitive_english_translation` VALUES ('3422', '1183', 'to  blow up');
INSERT INTO `infinitive_english_translation` VALUES ('3423', '1183', ' to detonate');
INSERT INTO `infinitive_english_translation` VALUES ('3424', '1184', 'lit. to repress');
INSERT INTO `infinitive_english_translation` VALUES ('3425', '1184', ' to conquer');
INSERT INTO `infinitive_english_translation` VALUES ('3426', '1184', ' to defeat');
INSERT INTO `infinitive_english_translation` VALUES ('3427', '1184', ' to oppress');
INSERT INTO `infinitive_english_translation` VALUES ('3428', '1184', ' to overbear');
INSERT INTO `infinitive_english_translation` VALUES ('3429', '1184', ' to subdue');
INSERT INTO `infinitive_english_translation` VALUES ('3430', '1184', ' to quash');
INSERT INTO `infinitive_english_translation` VALUES ('3431', '1184', ' to checkmate');
INSERT INTO `infinitive_english_translation` VALUES ('3432', '1185', 'lit. to repress');
INSERT INTO `infinitive_english_translation` VALUES ('3433', '1185', ' to conquer');
INSERT INTO `infinitive_english_translation` VALUES ('3434', '1185', ' to defeat');
INSERT INTO `infinitive_english_translation` VALUES ('3435', '1185', ' to oppress');
INSERT INTO `infinitive_english_translation` VALUES ('3436', '1185', ' to overbear');
INSERT INTO `infinitive_english_translation` VALUES ('3437', '1185', ' to subdue');
INSERT INTO `infinitive_english_translation` VALUES ('3438', '1185', ' to quash');
INSERT INTO `infinitive_english_translation` VALUES ('3439', '1185', ' to checkmate');
INSERT INTO `infinitive_english_translation` VALUES ('3440', '1186', 'to daze');
INSERT INTO `infinitive_english_translation` VALUES ('3441', '1186', ' to boggle');
INSERT INTO `infinitive_english_translation` VALUES ('3442', '1186', ' to stupefy');
INSERT INTO `infinitive_english_translation` VALUES ('3443', '1186', ' to dumbfound');
INSERT INTO `infinitive_english_translation` VALUES ('3444', '1187', 'to staple');
INSERT INTO `infinitive_english_translation` VALUES ('3445', '1188', 'to staple');
INSERT INTO `infinitive_english_translation` VALUES ('3446', '1189', 'to staple');
INSERT INTO `infinitive_english_translation` VALUES ('3447', '1190', 'to shave one\'s head in mourning');
INSERT INTO `infinitive_english_translation` VALUES ('3448', '1190', ' to give a ritual haircut');
INSERT INTO `infinitive_english_translation` VALUES ('3449', '1191', 'to shave one\'s hair');
INSERT INTO `infinitive_english_translation` VALUES ('3450', '1192', 'to get a hair cut');
INSERT INTO `infinitive_english_translation` VALUES ('3451', '1192', ' to trim one\'s hair');
INSERT INTO `infinitive_english_translation` VALUES ('3452', '1193', 'to violate');
INSERT INTO `infinitive_english_translation` VALUES ('3453', '1193', ' to infringe');
INSERT INTO `infinitive_english_translation` VALUES ('3454', '1193', ' to transgress');
INSERT INTO `infinitive_english_translation` VALUES ('3455', '1193', ' to transgress');
INSERT INTO `infinitive_english_translation` VALUES ('3456', '1193', ' to attack');
INSERT INTO `infinitive_english_translation` VALUES ('3457', '1193', ' to assault');
INSERT INTO `infinitive_english_translation` VALUES ('3458', '1193', ' to rape');
INSERT INTO `infinitive_english_translation` VALUES ('3459', '1194', 'to violate');
INSERT INTO `infinitive_english_translation` VALUES ('3460', '1194', ' to infringe');
INSERT INTO `infinitive_english_translation` VALUES ('3461', '1194', ' to transgress');
INSERT INTO `infinitive_english_translation` VALUES ('3462', '1194', ' to transgress');
INSERT INTO `infinitive_english_translation` VALUES ('3463', '1194', ' to attack');
INSERT INTO `infinitive_english_translation` VALUES ('3464', '1194', ' to assault');
INSERT INTO `infinitive_english_translation` VALUES ('3465', '1194', ' to rape');
INSERT INTO `infinitive_english_translation` VALUES ('3466', '1195', 'to act as a go-between');
INSERT INTO `infinitive_english_translation` VALUES ('3467', '1195', ' to mediate');
INSERT INTO `infinitive_english_translation` VALUES ('3468', '1195', ' to intercede');
INSERT INTO `infinitive_english_translation` VALUES ('3469', '1196', 'to act as a go-between');
INSERT INTO `infinitive_english_translation` VALUES ('3470', '1196', ' to mediate');
INSERT INTO `infinitive_english_translation` VALUES ('3471', '1196', ' to intercede');
INSERT INTO `infinitive_english_translation` VALUES ('3472', '1197', 'to nail');
INSERT INTO `infinitive_english_translation` VALUES ('3473', '1197', ' to hammer');
INSERT INTO `infinitive_english_translation` VALUES ('3474', '1198', 'to be obliterated');
INSERT INTO `infinitive_english_translation` VALUES ('3475', '1198', ' to be destroyed');
INSERT INTO `infinitive_english_translation` VALUES ('3476', '1198', ' to be annihilated');
INSERT INTO `infinitive_english_translation` VALUES ('3477', '1199', 'to destroy');
INSERT INTO `infinitive_english_translation` VALUES ('3478', '1199', ' to do away with');
INSERT INTO `infinitive_english_translation` VALUES ('3479', '1200', 'to trim one\'s nails');
INSERT INTO `infinitive_english_translation` VALUES ('3480', '1200', ' to clip nails');
INSERT INTO `infinitive_english_translation` VALUES ('3481', '1201', 'to be sick');
INSERT INTO `infinitive_english_translation` VALUES ('3482', '1201', ' to be ill');
INSERT INTO `infinitive_english_translation` VALUES ('3483', '1201', ' to be indisposed');
INSERT INTO `infinitive_english_translation` VALUES ('3484', '1201', ' to be diseased');
INSERT INTO `infinitive_english_translation` VALUES ('3485', '1202', 'to become ill');
INSERT INTO `infinitive_english_translation` VALUES ('3486', '1202', ' to get sick');
INSERT INTO `infinitive_english_translation` VALUES ('3487', '1202', ' to sicken');
INSERT INTO `infinitive_english_translation` VALUES ('3488', '1203', 'to make sick');
INSERT INTO `infinitive_english_translation` VALUES ('3489', '1203', ' to make ill');
INSERT INTO `infinitive_english_translation` VALUES ('3490', '1203', ' to sicken');
INSERT INTO `infinitive_english_translation` VALUES ('3491', '1204', 'to have lunch');
INSERT INTO `infinitive_english_translation` VALUES ('3492', '1204', ' to eat lunch');
INSERT INTO `infinitive_english_translation` VALUES ('3493', '1204', ' to take lunch');
INSERT INTO `infinitive_english_translation` VALUES ('3494', '1204', ' to have dinner');
INSERT INTO `infinitive_english_translation` VALUES ('3495', '1204', ' to dine');
INSERT INTO `infinitive_english_translation` VALUES ('3496', '1205', 'to obtain liberty');
INSERT INTO `infinitive_english_translation` VALUES ('3497', '1205', ' to be delivered');
INSERT INTO `infinitive_english_translation` VALUES ('3498', '1205', ' to find salvation');
INSERT INTO `infinitive_english_translation` VALUES ('3499', '1205', ' to escape');
INSERT INTO `infinitive_english_translation` VALUES ('3500', '1206', 'to show');
INSERT INTO `infinitive_english_translation` VALUES ('3501', '1206', ' to demonstrate');
INSERT INTO `infinitive_english_translation` VALUES ('3502', '1206', ' to indicate');
INSERT INTO `infinitive_english_translation` VALUES ('3503', '1206', ' to give a medal (to)');
INSERT INTO `infinitive_english_translation` VALUES ('3504', '1207', 'to show');
INSERT INTO `infinitive_english_translation` VALUES ('3505', '1207', ' to demonstrate');
INSERT INTO `infinitive_english_translation` VALUES ('3506', '1207', ' to indicate');
INSERT INTO `infinitive_english_translation` VALUES ('3507', '1207', ' to give a medal (to)');
INSERT INTO `infinitive_english_translation` VALUES ('3508', '1208', 'to install');
INSERT INTO `infinitive_english_translation` VALUES ('3509', '1208', ' to affix');
INSERT INTO `infinitive_english_translation` VALUES ('3510', '1208', ' to pin up');
INSERT INTO `infinitive_english_translation` VALUES ('3511', '1208', ' to post');
INSERT INTO `infinitive_english_translation` VALUES ('3512', '1208', ' to appoint');
INSERT INTO `infinitive_english_translation` VALUES ('3513', '1209', 'to paint');
INSERT INTO `infinitive_english_translation` VALUES ('3514', '1210', 'to paint');
INSERT INTO `infinitive_english_translation` VALUES ('3515', '1211', 'to glance at');
INSERT INTO `infinitive_english_translation` VALUES ('3516', '1211', ' to take a look at');
INSERT INTO `infinitive_english_translation` VALUES ('3517', '1212', 'to glance at');
INSERT INTO `infinitive_english_translation` VALUES ('3518', '1212', ' to take a look at');
INSERT INTO `infinitive_english_translation` VALUES ('3519', '1213', 'to glance at');
INSERT INTO `infinitive_english_translation` VALUES ('3520', '1213', ' to take a look at');
INSERT INTO `infinitive_english_translation` VALUES ('3521', '1214', 'to look');
INSERT INTO `infinitive_english_translation` VALUES ('3522', '1214', ' to glance');
INSERT INTO `infinitive_english_translation` VALUES ('3523', '1214', ' to watch');
INSERT INTO `infinitive_english_translation` VALUES ('3524', '1214', ' to observe');
INSERT INTO `infinitive_english_translation` VALUES ('3525', '1214', ' to check; obs. to think');
INSERT INTO `infinitive_english_translation` VALUES ('3526', '1214', ' to reflect');
INSERT INTO `infinitive_english_translation` VALUES ('3527', '1214', ' to find');
INSERT INTO `infinitive_english_translation` VALUES ('3528', '1215', 'to look');
INSERT INTO `infinitive_english_translation` VALUES ('3529', '1215', ' to glance');
INSERT INTO `infinitive_english_translation` VALUES ('3530', '1215', ' to watch');
INSERT INTO `infinitive_english_translation` VALUES ('3531', '1215', ' to observe');
INSERT INTO `infinitive_english_translation` VALUES ('3532', '1215', ' to check; obs. to think');
INSERT INTO `infinitive_english_translation` VALUES ('3533', '1215', ' to reflect');
INSERT INTO `infinitive_english_translation` VALUES ('3534', '1215', ' to find');
INSERT INTO `infinitive_english_translation` VALUES ('3535', '1216', 'to have lunch');
INSERT INTO `infinitive_english_translation` VALUES ('3536', '1216', ' to eat lunch');
INSERT INTO `infinitive_english_translation` VALUES ('3537', '1216', ' to take lunch');
INSERT INTO `infinitive_english_translation` VALUES ('3538', '1216', ' to have dinner');
INSERT INTO `infinitive_english_translation` VALUES ('3539', '1216', ' to dine');
INSERT INTO `infinitive_english_translation` VALUES ('3540', '1217', 'to need');
INSERT INTO `infinitive_english_translation` VALUES ('3541', '1217', ' to require');
INSERT INTO `infinitive_english_translation` VALUES ('3542', '1217', ' to want');
INSERT INTO `infinitive_english_translation` VALUES ('3543', '1217', ' to lack');
INSERT INTO `infinitive_english_translation` VALUES ('3544', '1218', 'to sting');
INSERT INTO `infinitive_english_translation` VALUES ('3545', '1218', ' to bite');
INSERT INTO `infinitive_english_translation` VALUES ('3546', '1219', 'to enter');
INSERT INTO `infinitive_english_translation` VALUES ('3547', '1219', ' to get inside');
INSERT INTO `infinitive_english_translation` VALUES ('3548', '1220', 'to invert');
INSERT INTO `infinitive_english_translation` VALUES ('3549', '1220', ' to turn upside down');
INSERT INTO `infinitive_english_translation` VALUES ('3550', '1220', ' to reverse');
INSERT INTO `infinitive_english_translation` VALUES ('3551', '1220', ' to turn inside out');
INSERT INTO `infinitive_english_translation` VALUES ('3552', '1221', 'to hand over');
INSERT INTO `infinitive_english_translation` VALUES ('3553', '1221', ' to transfer');
INSERT INTO `infinitive_english_translation` VALUES ('3554', '1221', ' to leave');
INSERT INTO `infinitive_english_translation` VALUES ('3555', '1221', ' to give');
INSERT INTO `infinitive_english_translation` VALUES ('3556', '1222', 'to borrow');
INSERT INTO `infinitive_english_translation` VALUES ('3557', '1223', 'to fear');
INSERT INTO `infinitive_english_translation` VALUES ('3558', '1223', ' to dread');
INSERT INTO `infinitive_english_translation` VALUES ('3559', '1224', 'to fear');
INSERT INTO `infinitive_english_translation` VALUES ('3560', '1224', ' to dread');
INSERT INTO `infinitive_english_translation` VALUES ('3561', '1225', 'colloq. to fiddle (with)');
INSERT INTO `infinitive_english_translation` VALUES ('3562', '1225', ' to toy (with) to finger');
INSERT INTO `infinitive_english_translation` VALUES ('3563', '1225', ' to tinker');
INSERT INTO `infinitive_english_translation` VALUES ('3564', '1226', 'to exercise');
INSERT INTO `infinitive_english_translation` VALUES ('3565', '1226', ' to do physical activity');
INSERT INTO `infinitive_english_translation` VALUES ('3566', '1226', ' to do sports');
INSERT INTO `infinitive_english_translation` VALUES ('3567', '1227', 'to go between');
INSERT INTO `infinitive_english_translation` VALUES ('3568', '1227', ' to intercede');
INSERT INTO `infinitive_english_translation` VALUES ('3569', '1227', ' to mediate');
INSERT INTO `infinitive_english_translation` VALUES ('3570', '1227', ' to arbitrate');
INSERT INTO `infinitive_english_translation` VALUES ('3571', '1228', 'to go between');
INSERT INTO `infinitive_english_translation` VALUES ('3572', '1228', ' to intercede');
INSERT INTO `infinitive_english_translation` VALUES ('3573', '1228', ' to mediate');
INSERT INTO `infinitive_english_translation` VALUES ('3574', '1228', ' to arbitrate');
INSERT INTO `infinitive_english_translation` VALUES ('3575', '1229', 'to widen');
INSERT INTO `infinitive_english_translation` VALUES ('3576', '1229', ' to expand');
INSERT INTO `infinitive_english_translation` VALUES ('3577', '1230', 'to be obsessed');
INSERT INTO `infinitive_english_translation` VALUES ('3578', '1230', ' to have an obsession');
INSERT INTO `infinitive_english_translation` VALUES ('3579', '1230', ' to be particular');
INSERT INTO `infinitive_english_translation` VALUES ('3580', '1230', ' to be scrupulous');
INSERT INTO `infinitive_english_translation` VALUES ('3581', '1231', 'to be tempted');
INSERT INTO `infinitive_english_translation` VALUES ('3582', '1231', ' to be enticed');
INSERT INTO `infinitive_english_translation` VALUES ('3583', '1232', 'to tempt');
INSERT INTO `infinitive_english_translation` VALUES ('3584', '1232', ' to entice');
INSERT INTO `infinitive_english_translation` VALUES ('3585', '1233', 'to connect');
INSERT INTO `infinitive_english_translation` VALUES ('3586', '1233', ' to fasten');
INSERT INTO `infinitive_english_translation` VALUES ('3587', '1234', 'to settle (in)');
INSERT INTO `infinitive_english_translation` VALUES ('3588', '1234', ' to reside (in)');
INSERT INTO `infinitive_english_translation` VALUES ('3589', '1234', ' to take up residence (in)');
INSERT INTO `infinitive_english_translation` VALUES ('3590', '1234', ' to make one\'s permanent place of residence');
INSERT INTO `infinitive_english_translation` VALUES ('3591', '1235', 'to settle (in)');
INSERT INTO `infinitive_english_translation` VALUES ('3592', '1235', ' to reside (in)');
INSERT INTO `infinitive_english_translation` VALUES ('3593', '1235', ' to take up residence (in)');
INSERT INTO `infinitive_english_translation` VALUES ('3594', '1235', ' to make one\'s permanent place of residence');
INSERT INTO `infinitive_english_translation` VALUES ('3595', '1236', 'to play the violin');
INSERT INTO `infinitive_english_translation` VALUES ('3596', '1237', 'to play hockey');
INSERT INTO `infinitive_english_translation` VALUES ('3597', '1238', 'to spell out');
INSERT INTO `infinitive_english_translation` VALUES ('3598', '1238', ' to read out syllable-by-syllable');
INSERT INTO `infinitive_english_translation` VALUES ('3599', '1238', ' to sound out words');
INSERT INTO `infinitive_english_translation` VALUES ('3600', '1238', ' to enunciate each syllable');
INSERT INTO `infinitive_english_translation` VALUES ('3601', '1239', 'to lead');
INSERT INTO `infinitive_english_translation` VALUES ('3602', '1239', ' to guide');
INSERT INTO `infinitive_english_translation` VALUES ('3603', '1240', 'to waste');
INSERT INTO `infinitive_english_translation` VALUES ('3604', '1240', ' to squander');
INSERT INTO `infinitive_english_translation` VALUES ('3605', '1241', 'to go to waste');
INSERT INTO `infinitive_english_translation` VALUES ('3606', '1241', ' to be destroyed');
INSERT INTO `infinitive_english_translation` VALUES ('3607', '1241', ' to be lost');
INSERT INTO `infinitive_english_translation` VALUES ('3608', '1241', ' to disappear');
INSERT INTO `infinitive_english_translation` VALUES ('3609', '1242', 'to give a gift');
INSERT INTO `infinitive_english_translation` VALUES ('3610', '1242', ' to make a gift');
INSERT INTO `infinitive_english_translation` VALUES ('3611', '1243', 'to give a gift');
INSERT INTO `infinitive_english_translation` VALUES ('3612', '1243', ' to make a gift');
INSERT INTO `infinitive_english_translation` VALUES ('3613', '1244', 'to give a gift');
INSERT INTO `infinitive_english_translation` VALUES ('3614', '1244', ' to make a gift');
INSERT INTO `infinitive_english_translation` VALUES ('3615', '1245', 'to give a gift');
INSERT INTO `infinitive_english_translation` VALUES ('3616', '1245', ' to make a gift');
INSERT INTO `infinitive_english_translation` VALUES ('3617', '1246', 'to speak incoherently');
INSERT INTO `infinitive_english_translation` VALUES ('3618', '1246', ' to speak deliriously');
INSERT INTO `infinitive_english_translation` VALUES ('3619', '1246', ' to speak nonsense');
INSERT INTO `infinitive_english_translation` VALUES ('3620', '1247', 'to speak incoherently');
INSERT INTO `infinitive_english_translation` VALUES ('3621', '1247', ' to speak deliriously');
INSERT INTO `infinitive_english_translation` VALUES ('3622', '1247', ' to speak nonsense');
INSERT INTO `infinitive_english_translation` VALUES ('3623', '1248', 'to fear');
INSERT INTO `infinitive_english_translation` VALUES ('3624', '1248', ' to dread');
INSERT INTO `infinitive_english_translation` VALUES ('3625', '1248', ' to panic');
INSERT INTO `infinitive_english_translation` VALUES ('3626', '1249', 'to commit immoral acts');
INSERT INTO `infinitive_english_translation` VALUES ('3627', '1249', ' to be rude');
INSERT INTO `infinitive_english_translation` VALUES ('3628', '1250', 'to pay');
INSERT INTO `infinitive_english_translation` VALUES ('3629', '1250', ' to supply the funds');
INSERT INTO `infinitive_english_translation` VALUES ('3630', '1250', ' to fund');
INSERT INTO `infinitive_english_translation` VALUES ('3631', '1250', ' to expend');
INSERT INTO `infinitive_english_translation` VALUES ('3632', '1250', ' to shoulder (costs)');
INSERT INTO `infinitive_english_translation` VALUES ('3633', '1250', ' to bear (costs)');
INSERT INTO `infinitive_english_translation` VALUES ('3634', '1251', 'lit. to be conscious');
INSERT INTO `infinitive_english_translation` VALUES ('3635', '1251', ' to be aware');
INSERT INTO `infinitive_english_translation` VALUES ('3636', '1251', ' to be awake');
INSERT INTO `infinitive_english_translation` VALUES ('3637', '1252', 'onom. to say \'whoa\'');
INSERT INTO `infinitive_english_translation` VALUES ('3638', '1252', ' to command a horse or livestock to halt');
INSERT INTO `infinitive_english_translation` VALUES ('3639', '1253', 'to be alert');
INSERT INTO `infinitive_english_translation` VALUES ('3640', '1253', ' to be sober');
INSERT INTO `infinitive_english_translation` VALUES ('3641', '1253', ' to be careful');
INSERT INTO `infinitive_english_translation` VALUES ('3642', '1254', 'to shove');
INSERT INTO `infinitive_english_translation` VALUES ('3643', '1254', ' to push');
INSERT INTO `infinitive_english_translation` VALUES ('3644', '1254', ' to jostle; fig. to nudge (someone) in the right d');
INSERT INTO `infinitive_english_translation` VALUES ('3645', '1255', 'to travel (with)');
INSERT INTO `infinitive_english_translation` VALUES ('3646', '1255', ' to go along (with)');
INSERT INTO `infinitive_english_translation` VALUES ('3647', '1255', ' to join up (with)');
INSERT INTO `infinitive_english_translation` VALUES ('3648', '1255', ' to fall in (with)');
INSERT INTO `infinitive_english_translation` VALUES ('3649', '1255', ' to collaborate');
INSERT INTO `infinitive_english_translation` VALUES ('3650', '1256', 'to send along');
INSERT INTO `infinitive_english_translation` VALUES ('3651', '1256', ' to include');
INSERT INTO `infinitive_english_translation` VALUES ('3652', '1256', ' to attach');
INSERT INTO `infinitive_english_translation` VALUES ('3653', '1256', ' to set alongside; fig. to bring into the fold');
INSERT INTO `infinitive_english_translation` VALUES ('3654', '1256', ' to bring around');
INSERT INTO `infinitive_english_translation` VALUES ('3655', '1257', 'to accompany');
INSERT INTO `infinitive_english_translation` VALUES ('3656', '1257', ' to collaborate; fig. to help');
INSERT INTO `infinitive_english_translation` VALUES ('3657', '1258', 'to work together');
INSERT INTO `infinitive_english_translation` VALUES ('3658', '1258', ' to collaborate');
INSERT INTO `infinitive_english_translation` VALUES ('3659', '1258', ' to cooperate');
INSERT INTO `infinitive_english_translation` VALUES ('3660', '1259', 'comp. to hang; colloq. sl. to freeze (in surprise)');
INSERT INTO `infinitive_english_translation` VALUES ('3661', '1260', 'to shout \'giddyap\'');
INSERT INTO `infinitive_english_translation` VALUES ('3662', '1260', ' to command a horse or livestock to go forward');
INSERT INTO `infinitive_english_translation` VALUES ('3663', '1260', ' to urge on');
INSERT INTO `infinitive_english_translation` VALUES ('3664', '1260', ' to spur on; obs. to shout');
INSERT INTO `infinitive_english_translation` VALUES ('3665', '1261', 'to shout \'giddyap\'');
INSERT INTO `infinitive_english_translation` VALUES ('3666', '1261', ' to command a horse or livestock to go forward');
INSERT INTO `infinitive_english_translation` VALUES ('3667', '1261', ' to urge on');
INSERT INTO `infinitive_english_translation` VALUES ('3668', '1261', ' to spur on; obs. to shout');
INSERT INTO `infinitive_english_translation` VALUES ('3669', '1262', 'to remember');
INSERT INTO `infinitive_english_translation` VALUES ('3670', '1263', 'to remember');
INSERT INTO `infinitive_english_translation` VALUES ('3671', '1264', 'to forget');
INSERT INTO `infinitive_english_translation` VALUES ('3672', '1265', 'to learn');
INSERT INTO `infinitive_english_translation` VALUES ('3673', '1266', 'to remind');
INSERT INTO `infinitive_english_translation` VALUES ('3674', '1267', 'to help');
INSERT INTO `infinitive_english_translation` VALUES ('3675', '1268', 'to help');
INSERT INTO `infinitive_english_translation` VALUES ('3676', '1269', 'to help');
INSERT INTO `infinitive_english_translation` VALUES ('3677', '1269', ' to cooperate');
INSERT INTO `infinitive_english_translation` VALUES ('3678', '1270', 'to help');
INSERT INTO `infinitive_english_translation` VALUES ('3679', '1271', 'to freeze');
INSERT INTO `infinitive_english_translation` VALUES ('3680', '1271', ' to turn into ice');
INSERT INTO `infinitive_english_translation` VALUES ('3681', '1272', 'fig. colloq. to feel cold');
INSERT INTO `infinitive_english_translation` VALUES ('3682', '1272', ' to be freezing cold');
INSERT INTO `infinitive_english_translation` VALUES ('3683', '1273', 'to consolidate');
INSERT INTO `infinitive_english_translation` VALUES ('3684', '1273', ' to coalesce');
INSERT INTO `infinitive_english_translation` VALUES ('3685', '1273', ' to integrate');
INSERT INTO `infinitive_english_translation` VALUES ('3686', '1277', 'to teach manners');
INSERT INTO `infinitive_english_translation` VALUES ('3687', '1277', ' to instill with culture');
INSERT INTO `infinitive_english_translation` VALUES ('3688', '1277', ' to punish');
INSERT INTO `infinitive_english_translation` VALUES ('3689', '1277', ' to correct');
INSERT INTO `infinitive_english_translation` VALUES ('3690', '1278', 'to think');
INSERT INTO `infinitive_english_translation` VALUES ('3691', '1278', ' to deliberate');
INSERT INTO `infinitive_english_translation` VALUES ('3692', '1278', ' to reflect');
INSERT INTO `infinitive_english_translation` VALUES ('3693', '1278', ' to hesitate');
INSERT INTO `infinitive_english_translation` VALUES ('3694', '1279', 'to summon up the courage needed');
INSERT INTO `infinitive_english_translation` VALUES ('3695', '1279', ' to brave');
INSERT INTO `infinitive_english_translation` VALUES ('3696', '1279', ' to dare');
INSERT INTO `infinitive_english_translation` VALUES ('3697', '1280', 'to have courage');
INSERT INTO `infinitive_english_translation` VALUES ('3698', '1280', ' to be daring');
INSERT INTO `infinitive_english_translation` VALUES ('3699', '1281', 'to summon up the courage needed');
INSERT INTO `infinitive_english_translation` VALUES ('3700', '1281', ' to brave');
INSERT INTO `infinitive_english_translation` VALUES ('3701', '1281', ' to dare');
INSERT INTO `infinitive_english_translation` VALUES ('3702', '1282', 'to summon up the courage needed');
INSERT INTO `infinitive_english_translation` VALUES ('3703', '1282', ' to brave');
INSERT INTO `infinitive_english_translation` VALUES ('3704', '1282', ' to dare');
INSERT INTO `infinitive_english_translation` VALUES ('3705', '1283', 'to have courage');
INSERT INTO `infinitive_english_translation` VALUES ('3706', '1283', ' to be daring');
INSERT INTO `infinitive_english_translation` VALUES ('3707', '1284', 'to summon up the courage needed');
INSERT INTO `infinitive_english_translation` VALUES ('3708', '1284', ' to brave');
INSERT INTO `infinitive_english_translation` VALUES ('3709', '1284', ' to dare');
INSERT INTO `infinitive_english_translation` VALUES ('3710', '1540', 'to teach manners');
INSERT INTO `infinitive_english_translation` VALUES ('3711', '1540', ' to instill with culture');
INSERT INTO `infinitive_english_translation` VALUES ('3712', '1540', ' to punish');
INSERT INTO `infinitive_english_translation` VALUES ('3713', '1540', ' to correct');
INSERT INTO `infinitive_english_translation` VALUES ('3714', '1541', 'to think');
INSERT INTO `infinitive_english_translation` VALUES ('3715', '1541', ' to deliberate');
INSERT INTO `infinitive_english_translation` VALUES ('3716', '1541', ' to reflect');
INSERT INTO `infinitive_english_translation` VALUES ('3717', '1541', ' to hesitate');
INSERT INTO `infinitive_english_translation` VALUES ('3718', '1542', 'to summon up the courage needed');
INSERT INTO `infinitive_english_translation` VALUES ('3719', '1542', ' to brave');
INSERT INTO `infinitive_english_translation` VALUES ('3720', '1542', ' to dare');
INSERT INTO `infinitive_english_translation` VALUES ('3721', '1543', 'to have courage');
INSERT INTO `infinitive_english_translation` VALUES ('3722', '1543', ' to be daring');
INSERT INTO `infinitive_english_translation` VALUES ('3723', '1544', 'to summon up the courage needed');
INSERT INTO `infinitive_english_translation` VALUES ('3724', '1544', ' to brave');
INSERT INTO `infinitive_english_translation` VALUES ('3725', '1544', ' to dare');
INSERT INTO `infinitive_english_translation` VALUES ('3726', '1545', 'to summon up the courage needed');
INSERT INTO `infinitive_english_translation` VALUES ('3727', '1545', ' to brave');
INSERT INTO `infinitive_english_translation` VALUES ('3728', '1545', ' to dare');
INSERT INTO `infinitive_english_translation` VALUES ('3729', '1546', 'to have courage');
INSERT INTO `infinitive_english_translation` VALUES ('3730', '1546', ' to be daring');
INSERT INTO `infinitive_english_translation` VALUES ('3731', '1547', 'to summon up the courage needed');
INSERT INTO `infinitive_english_translation` VALUES ('3732', '1547', ' to brave');
INSERT INTO `infinitive_english_translation` VALUES ('3733', '1547', ' to dare');
INSERT INTO `verb` VALUES ('آجیدم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاجیدم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آجیدی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاجیدی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آجید', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاجید', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آجیدیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاجیدیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آجیدید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاجیدید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آجیدند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاجیدند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('می آجیدم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیدم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیدی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیدی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجید', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجید', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیدیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیدیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیدید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیدید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیدند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیدند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشتم', '124', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نداشتم', '124', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('داشتی', '124', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نداشتی', '124', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('داشت', '124', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نداشت', '124', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('داشتیم', '124', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نداشتیم', '124', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('داشتید', '124', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نداشتید', '124', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('داشتند', '124', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نداشتند', '124', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('داشتم می آجیدم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتی می آجیدی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشت می آجید', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتیم می آجیدیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتید می آجیدید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتند می آجیدند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('آجیده ام', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده ام', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده ای', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده ای', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده ', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده ', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده است', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده است', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده ایم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده ایم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده اید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده اید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده اند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده اند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('می آجیده ام', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده ام', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده ای', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده ای', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده ', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده ', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده است', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده است', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده ایم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده ایم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده اید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده اید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده اند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده اند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشته ام', '124', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نداشته ام', '124', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('داشته ای', '124', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نداشته ای', '124', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('داشته ', '124', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نداشته ', '124', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('داشته است', '124', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نداشته است', '124', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('داشته ایم', '124', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نداشته ایم', '124', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('داشته اید', '124', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نداشته اید', '124', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('داشته اند', '124', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نداشته اند', '124', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('داشته ام می آجیده ام', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ای می آجیده ای', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته  می آجیده ', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته است می آجیده است', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ایم می آجیده ایم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اید می آجیده اید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اند می آجیده اند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('بودم', '55', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نبودم', '55', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بودی', '55', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نبودی', '55', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بود', '55', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نبود', '55', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بودیم', '55', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نبودیم', '55', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بودید', '55', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نبودید', '55', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بودند', '55', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نبودند', '55', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آجیده بودم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاجیده بودم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آجیده بودی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاجیده بودی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آجیده بود', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاجیده بود', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آجیده بودیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاجیده بودیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آجیده بودید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاجیده بودید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آجیده بودند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاجیده بودند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('می آجیده بودم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده بودم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده بودی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده بودی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده بود', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده بود', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده بودیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده بودیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده بودید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده بودید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده بودند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده بودند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشتم می آجیده بودم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتی می آجیده بودی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشت می آجیده بود', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتیم می آجیده بودیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتید می آجیده بودید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتند می آجیده بودند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('بوده ام', '55', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نبوده ام', '55', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('بوده ای', '55', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نبوده ای', '55', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('بوده ', '55', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نبوده ', '55', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('بوده است', '55', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نبوده است', '55', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('بوده ایم', '55', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نبوده ایم', '55', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('بوده اید', '55', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نبوده اید', '55', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('بوده اند', '55', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نبوده اند', '55', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده بوده ام', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده بوده ام', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده بوده ای', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده بوده ای', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده بوده ', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده بوده ', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده بوده است', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده بوده است', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده بوده ایم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده بوده ایم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده بوده اید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده بوده اید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده بوده اند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده بوده اند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('می آجیده بوده ام', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده بوده ام', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده بوده ای', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده بوده ای', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده بوده ', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده بوده ', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده بوده است', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده بوده است', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده بوده ایم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده بوده ایم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده بوده اید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده بوده اید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده بوده اند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده بوده اند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشته ام می آجیده بوده ام', '1', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ای می آجیده بوده ای', '1', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته  می آجیده بوده ', '1', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته است می آجیده بوده است', '1', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ایم می آجیده بوده ایم', '1', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اید می آجیده بوده اید', '1', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اند می آجیده بوده اند', '1', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آجم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاجم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آجی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاجی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آجد', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاجد', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آجیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاجیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آجید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاجید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آجند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاجند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('می آجم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجد', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجد', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('دارم', '124', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('ندارم', '124', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('داری', '124', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نداری', '124', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('دارد', '124', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('ندارد', '124', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('داریم', '124', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نداریم', '124', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('دارید', '124', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('ندارید', '124', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('دارند', '124', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('ندارند', '124', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('دارم می آجم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داری می آجی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارد می آجد', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داریم می آجیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارید می آجید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارند می آجند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('خواهم', '119', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهم', '119', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهی', '119', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهی', '119', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهد', '119', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهد', '119', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهیم', '119', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهیم', '119', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهید', '119', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهید', '119', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهند', '119', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهند', '119', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهم آجید', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهم آجید', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهی آجید', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهی آجید', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهد آجید', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهد آجید', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهیم آجید', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهیم آجید', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهید آجید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهید آجید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهند آجید', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهند آجید', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاجم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاجم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاجی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاجی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاجد', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاجد', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاجیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاجیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاجید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاجید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاجند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاجند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('باشم', '55', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نباشم', '55', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('باشی', '55', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نباشی', '55', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('باشد', '55', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نباشد', '55', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('باشیم', '55', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نباشیم', '55', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('باشید', '55', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نباشید', '55', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('باشند', '55', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نباشند', '55', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آجیده باشم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده باشم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده باشی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده باشی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده باشد', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده باشد', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده باشیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده باشیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده باشید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده باشید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده باشند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده باشند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('می آجیده باشم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده باشم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده باشی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده باشی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده باشد', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده باشد', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده باشیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده باشیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده باشید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده باشید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده باشند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده باشند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('بوده باشم', '55', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نبوده باشم', '55', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('بوده باشی', '55', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نبوده باشی', '55', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('بوده باشد', '55', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نبوده باشد', '55', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('بوده باشیم', '55', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نبوده باشیم', '55', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('بوده باشید', '55', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نبوده باشید', '55', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('بوده باشند', '55', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نبوده باشند', '55', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده بوده باشم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده بوده باشم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده بوده باشی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده بوده باشی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده بوده باشد', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده بوده باشد', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده بوده باشیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده بوده باشیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده بوده باشید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده بوده باشید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده بوده باشند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده بوده باشند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('می آجیده بوده باشم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده بوده باشم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده بوده باشی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده بوده باشی', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده بوده باشد', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده بوده باشد', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده بوده باشیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده بوده باشیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده بوده باشید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده بوده باشید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آجیده بوده باشند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آجیده بوده باشند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('بیاجم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاجم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاج', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاج', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاجد', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاجد', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاجیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاجیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاجید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاجید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاجند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاجند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('باشم', '55', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نباشم', '55', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('باش', '55', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نباش', '55', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('باشد', '55', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نباشد', '55', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('باشیم', '55', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نباشیم', '55', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('باشید', '55', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نباشید', '55', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('باشند', '55', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نباشند', '55', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آجیده باشم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده باشم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده باش', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده باش', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده باشد', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده باشد', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده باشیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده باشیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده باشید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده باشید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده باشند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده باشند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('بوده باشم', '55', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نبوده باشم', '55', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('بوده باش', '55', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نبوده باش', '55', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('بوده باشد', '55', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نبوده باشد', '55', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('بوده باشیم', '55', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نبوده باشیم', '55', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('بوده باشید', '55', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نبوده باشید', '55', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('بوده باشند', '55', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نبوده باشند', '55', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده بوده باشم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده بوده باشم', '1', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده بوده باش', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده بوده باش', '1', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده بوده باشد', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده بوده باشد', '1', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده بوده باشیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده بوده باشیم', '1', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده بوده باشید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده بوده باشید', '1', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آجیده بوده باشند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاجیده بوده باشند', '1', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آختم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاختم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آختی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاختی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آخت', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاخت', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آختیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاختیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آختید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاختید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آختند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاختند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('می آختم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آختم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آختی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آختی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخت', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخت', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آختیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آختیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آختید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آختید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آختند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آختند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشتم می آختم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتی می آختی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشت می آخت', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتیم می آختیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتید می آختید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتند می آختند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('آخته ام', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته ام', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آخته ای', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته ای', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آخته ', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته ', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آخته است', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته است', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آخته ایم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته ایم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آخته اید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته اید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آخته اند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته اند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('می آخته ام', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته ام', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته ای', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته ای', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته ', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته ', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته است', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته است', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته ایم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته ایم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته اید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته اید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته اند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته اند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشته ام می آخته ام', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ای می آخته ای', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته  می آخته ', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته است می آخته است', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ایم می آخته ایم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اید می آخته اید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اند می آخته اند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آخته بودم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاخته بودم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آخته بودی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاخته بودی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آخته بود', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاخته بود', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آخته بودیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاخته بودیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آخته بودید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاخته بودید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آخته بودند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاخته بودند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('می آخته بودم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته بودم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته بودی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته بودی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته بود', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته بود', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته بودیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته بودیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته بودید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته بودید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته بودند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته بودند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشتم می آخته بودم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتی می آخته بودی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشت می آخته بود', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتیم می آخته بودیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتید می آخته بودید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتند می آخته بودند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آخته بوده ام', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته بوده ام', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آخته بوده ای', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته بوده ای', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آخته بوده ', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته بوده ', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آخته بوده است', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته بوده است', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آخته بوده ایم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته بوده ایم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آخته بوده اید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته بوده اید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آخته بوده اند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته بوده اند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('می آخته بوده ام', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته بوده ام', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته بوده ای', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته بوده ای', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته بوده ', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته بوده ', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته بوده است', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته بوده است', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته بوده ایم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته بوده ایم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته بوده اید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته بوده اید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته بوده اند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته بوده اند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشته ام می آخته بوده ام', '2', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ای می آخته بوده ای', '2', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته  می آخته بوده ', '2', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته است می آخته بوده است', '2', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ایم می آخته بوده ایم', '2', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اید می آخته بوده اید', '2', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اند می آخته بوده اند', '2', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آزم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزد', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازد', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('می آزم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزد', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزد', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('دارم می آزم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داری می آزی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارد می آزد', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داریم می آزیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارید می آزید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارند می آزند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('خواهم آخت', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهم آخت', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهی آخت', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهی آخت', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهد آخت', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهد آخت', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهیم آخت', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهیم آخت', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهید آخت', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهید آخت', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهند آخت', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهند آخت', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازد', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازد', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آخته باشم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته باشم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آخته باشی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته باشی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آخته باشد', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته باشد', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آخته باشیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته باشیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آخته باشید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته باشید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آخته باشند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته باشند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('می آخته باشم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته باشم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته باشی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته باشی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته باشد', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته باشد', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته باشیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته باشیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته باشید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته باشید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته باشند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته باشند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('آخته بوده باشم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته بوده باشم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آخته بوده باشی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته بوده باشی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آخته بوده باشد', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته بوده باشد', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آخته بوده باشیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته بوده باشیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آخته بوده باشید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته بوده باشید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آخته بوده باشند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته بوده باشند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('می آخته بوده باشم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته بوده باشم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته بوده باشی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته بوده باشی', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته بوده باشد', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته بوده باشد', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته بوده باشیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته بوده باشیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته بوده باشید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته بوده باشید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آخته بوده باشند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آخته بوده باشند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('بیازم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاز', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاز', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازد', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازد', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آخته باشم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته باشم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آخته باش', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته باش', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آخته باشد', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته باشد', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آخته باشیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته باشیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آخته باشید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته باشید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آخته باشند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته باشند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آخته بوده باشم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته بوده باشم', '2', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آخته بوده باش', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته بوده باش', '2', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آخته بوده باشد', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته بوده باشد', '2', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آخته بوده باشیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته بوده باشیم', '2', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آخته بوده باشید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته بوده باشید', '2', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آخته بوده باشند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاخته بوده باشند', '2', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آراستم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاراستم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آراستی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاراستی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آراست', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاراست', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آراستیم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاراستیم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آراستید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاراستید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آراستند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاراستند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('می آراستم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراستم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراستی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراستی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراست', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراست', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراستیم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراستیم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراستید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراستید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراستند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراستند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشتم می آراستم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتی می آراستی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشت می آراست', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتیم می آراستیم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتید می آراستید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتند می آراستند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('آراسته ام', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته ام', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته ای', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته ای', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته ', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته ', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته است', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته است', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته ایم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته ایم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته اید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته اید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته اند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته اند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('می آراسته ام', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته ام', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته ای', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته ای', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته ', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته ', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته است', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته است', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته ایم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته ایم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته اید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته اید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته اند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته اند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشته ام می آراسته ام', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ای می آراسته ای', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته  می آراسته ', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته است می آراسته است', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ایم می آراسته ایم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اید می آراسته اید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اند می آراسته اند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آراسته بودم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاراسته بودم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آراسته بودی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاراسته بودی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آراسته بود', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاراسته بود', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آراسته بودیم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاراسته بودیم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آراسته بودید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاراسته بودید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آراسته بودند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاراسته بودند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('می آراسته بودم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته بودم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته بودی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته بودی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته بود', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته بود', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته بودیم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته بودیم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته بودید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته بودید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته بودند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته بودند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشتم می آراسته بودم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتی می آراسته بودی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشت می آراسته بود', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتیم می آراسته بودیم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتید می آراسته بودید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتند می آراسته بودند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آراسته بوده ام', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته بوده ام', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته بوده ای', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته بوده ای', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته بوده ', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته بوده ', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته بوده است', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته بوده است', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته بوده ایم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته بوده ایم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته بوده اید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته بوده اید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته بوده اند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته بوده اند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('می آراسته بوده ام', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته بوده ام', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته بوده ای', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته بوده ای', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته بوده ', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته بوده ', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته بوده است', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته بوده است', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته بوده ایم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته بوده ایم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته بوده اید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته بوده اید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته بوده اند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته بوده اند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشته ام می آراسته بوده ام', '3', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ای می آراسته بوده ای', '3', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته  می آراسته بوده ', '3', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته است می آراسته بوده است', '3', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ایم می آراسته بوده ایم', '3', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اید می آراسته بوده اید', '3', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اند می آراسته بوده اند', '3', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آرایم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیارایم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آرایی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیارایی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آراید', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاراید', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آراییم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاراییم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آرایید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیارایید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آرایند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیارایند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('می آرایم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آرایم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آرایی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آرایی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراید', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراید', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراییم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراییم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آرایید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آرایید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آرایند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آرایند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('دارم می آرایم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داری می آرایی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارد می آراید', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داریم می آراییم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارید می آرایید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارند می آرایند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('خواهم آراست', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهم آراست', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهی آراست', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهی آراست', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهد آراست', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهد آراست', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهیم آراست', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهیم آراست', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهید آراست', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهید آراست', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهند آراست', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهند آراست', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیارایم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیارایم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیارایی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیارایی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاراید', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاراید', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاراییم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاراییم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیارایید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیارایید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیارایند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیارایند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آراسته باشم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته باشم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته باشی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته باشی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته باشد', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته باشد', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته باشیم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته باشیم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته باشید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته باشید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته باشند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته باشند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('می آراسته باشم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته باشم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته باشی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته باشی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته باشد', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته باشد', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته باشیم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته باشیم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته باشید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته باشید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته باشند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته باشند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('آراسته بوده باشم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته بوده باشم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته بوده باشی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته بوده باشی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته بوده باشد', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته بوده باشد', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته بوده باشیم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته بوده باشیم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته بوده باشید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته بوده باشید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته بوده باشند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته بوده باشند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('می آراسته بوده باشم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته بوده باشم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته بوده باشی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته بوده باشی', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته بوده باشد', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته بوده باشد', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته بوده باشیم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته بوده باشیم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته بوده باشید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته بوده باشید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آراسته بوده باشند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آراسته بوده باشند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('بیارایم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیارایم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیارای', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیارای', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاراید', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاراید', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاراییم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاراییم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیارایید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیارایید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیارایند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیارایند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آراسته باشم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته باشم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته باش', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته باش', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته باشد', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته باشد', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته باشیم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته باشیم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته باشید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته باشید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته باشند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته باشند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته بوده باشم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته بوده باشم', '3', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته بوده باش', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته بوده باش', '3', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته بوده باشد', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته بوده باشد', '3', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته بوده باشیم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته بوده باشیم', '3', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته بوده باشید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته بوده باشید', '3', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آراسته بوده باشند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاراسته بوده باشند', '3', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزردم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازردم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزردی', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازردی', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزرد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازرد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزردیم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازردیم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزردید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازردید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزردند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازردند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('می آزردم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزردم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزردی', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزردی', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزردیم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزردیم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزردید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزردید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزردند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزردند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشتم می آزردم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتی می آزردی', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشت می آزرد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتیم می آزردیم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتید می آزردید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتند می آزردند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('آزرده ام', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده ام', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده ای', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده ای', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده ', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده ', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده است', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده است', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده ایم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده ایم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده اید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده اید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده اند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده اند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('می آزرده ام', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده ام', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده ای', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده ای', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده ', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده ', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده است', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده است', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده ایم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده ایم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده اید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده اید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده اند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده اند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشته ام می آزرده ام', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ای می آزرده ای', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته  می آزرده ', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته است می آزرده است', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ایم می آزرده ایم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اید می آزرده اید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اند می آزرده اند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آزرده بودم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیازرده بودم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آزرده بودی', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیازرده بودی', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آزرده بود', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیازرده بود', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آزرده بودیم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیازرده بودیم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آزرده بودید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیازرده بودید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آزرده بودند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیازرده بودند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('می آزرده بودم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده بودم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده بودی', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده بودی', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده بود', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده بود', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده بودیم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده بودیم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده بودید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده بودید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده بودند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده بودند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشتم می آزرده بودم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتی می آزرده بودی', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشت می آزرده بود', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتیم می آزرده بودیم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتید می آزرده بودید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتند می آزرده بودند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آزرده بوده ام', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده بوده ام', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده بوده ای', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده بوده ای', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده بوده ', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده بوده ', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده بوده است', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده بوده است', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده بوده ایم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده بوده ایم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده بوده اید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده بوده اید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده بوده اند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده بوده اند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('می آزرده بوده ام', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده بوده ام', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده بوده ای', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده بوده ای', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده بوده ', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده بوده ', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده بوده است', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده بوده است', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده بوده ایم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده بوده ایم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده بوده اید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده بوده اید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده بوده اند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده بوده اند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشته ام می آزرده بوده ام', '4', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ای می آزرده بوده ای', '4', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته  می آزرده بوده ', '4', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته است می آزرده بوده است', '4', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ایم می آزرده بوده ایم', '4', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اید می آزرده بوده اید', '4', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اند می آزرده بوده اند', '4', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آزرم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازرم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزری', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازری', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزرد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازرد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزریم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازریم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزرید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازرید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزرند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازرند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('می آزرم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزری', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزری', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزریم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزریم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('دارم می آزرم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داری می آزری', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارد می آزرد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داریم می آزریم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارید می آزرید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارند می آزرند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('خواهم آزرد', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهم آزرد', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهی آزرد', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهی آزرد', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهد آزرد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهد آزرد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهیم آزرد', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهیم آزرد', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهید آزرد', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهید آزرد', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهند آزرد', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهند آزرد', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازرم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازرم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازری', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازری', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازرد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازرد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازریم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازریم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازرید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازرید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازرند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازرند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزرده باشم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده باشم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده باشی', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده باشی', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده باشد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده باشد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده باشیم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده باشیم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده باشید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده باشید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده باشند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده باشند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('می آزرده باشم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده باشم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده باشی', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده باشی', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده باشد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده باشد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده باشیم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده باشیم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده باشید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده باشید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده باشند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده باشند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('آزرده بوده باشم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده بوده باشم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده بوده باشی', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده بوده باشی', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده بوده باشد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده بوده باشد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده بوده باشیم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده بوده باشیم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده بوده باشید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده بوده باشید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده بوده باشند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده بوده باشند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('می آزرده بوده باشم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده بوده باشم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده بوده باشی', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده بوده باشی', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده بوده باشد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده بوده باشد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده بوده باشیم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده بوده باشیم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده بوده باشید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده بوده باشید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزرده بوده باشند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزرده بوده باشند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('بیازرم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازرم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازر', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازر', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازرد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازرد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازریم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازریم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازرید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازرید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازرند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازرند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزرده باشم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده باشم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده باش', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده باش', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده باشد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده باشد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده باشیم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده باشیم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده باشید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده باشید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده باشند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده باشند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده بوده باشم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده بوده باشم', '4', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده بوده باش', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده بوده باش', '4', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده بوده باشد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده بوده باشد', '4', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده بوده باشیم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده بوده باشیم', '4', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده بوده باشید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده بوده باشید', '4', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزرده بوده باشند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازرده بوده باشند', '4', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزمودم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازمودم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزمودی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازمودی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزمود', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازمود', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزمودیم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازمودیم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزمودید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازمودید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزمودند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازمودند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('می آزمودم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزمودم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزمودی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزمودی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزمود', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزمود', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزمودیم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزمودیم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزمودید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزمودید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزمودند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزمودند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشتم می آزمودم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتی می آزمودی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشت می آزمود', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتیم می آزمودیم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتید می آزمودید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتند می آزمودند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('آزموده ام', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده ام', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده ای', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده ای', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده ', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده ', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده است', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده است', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده ایم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده ایم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده اید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده اید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده اند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده اند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('می آزموده ام', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده ام', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده ای', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده ای', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده ', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده ', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده است', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده است', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده ایم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده ایم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده اید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده اید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده اند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده اند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشته ام می آزموده ام', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ای می آزموده ای', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته  می آزموده ', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته است می آزموده است', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ایم می آزموده ایم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اید می آزموده اید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اند می آزموده اند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آزموده بودم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیازموده بودم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آزموده بودی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیازموده بودی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آزموده بود', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیازموده بود', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آزموده بودیم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیازموده بودیم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آزموده بودید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیازموده بودید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آزموده بودند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیازموده بودند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('می آزموده بودم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده بودم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده بودی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده بودی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده بود', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده بود', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده بودیم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده بودیم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده بودید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده بودید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده بودند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده بودند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشتم می آزموده بودم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتی می آزموده بودی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشت می آزموده بود', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتیم می آزموده بودیم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتید می آزموده بودید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتند می آزموده بودند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آزموده بوده ام', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده بوده ام', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده بوده ای', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده بوده ای', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده بوده ', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده بوده ', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده بوده است', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده بوده است', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده بوده ایم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده بوده ایم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده بوده اید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده بوده اید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده بوده اند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده بوده اند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('می آزموده بوده ام', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده بوده ام', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده بوده ای', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده بوده ای', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده بوده ', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده بوده ', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده بوده است', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده بوده است', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده بوده ایم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده بوده ایم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده بوده اید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده بوده اید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده بوده اند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده بوده اند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشته ام می آزموده بوده ام', '5', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ای می آزموده بوده ای', '5', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته  می آزموده بوده ', '5', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته است می آزموده بوده است', '5', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ایم می آزموده بوده ایم', '5', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اید می آزموده بوده اید', '5', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اند می آزموده بوده اند', '5', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آزمایم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازمایم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزمایی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازمایی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزماید', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازماید', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزماییم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازماییم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزمایید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازمایید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزمایند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازمایند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('می آزمایم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزمایم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزمایی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزمایی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزماید', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزماید', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزماییم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزماییم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزمایید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزمایید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزمایند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزمایند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('دارم می آزمایم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داری می آزمایی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارد می آزماید', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داریم می آزماییم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارید می آزمایید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارند می آزمایند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('خواهم آزمود', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهم آزمود', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهی آزمود', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهی آزمود', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهد آزمود', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهد آزمود', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهیم آزمود', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهیم آزمود', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهید آزمود', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهید آزمود', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهند آزمود', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهند آزمود', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازمایم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازمایم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازمایی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازمایی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازماید', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازماید', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازماییم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازماییم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازمایید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازمایید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازمایند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازمایند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزموده باشم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده باشم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده باشی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده باشی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده باشد', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده باشد', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده باشیم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده باشیم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده باشید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده باشید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده باشند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده باشند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('می آزموده باشم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده باشم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده باشی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده باشی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده باشد', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده باشد', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده باشیم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده باشیم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده باشید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده باشید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده باشند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده باشند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('آزموده بوده باشم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده بوده باشم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده بوده باشی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده بوده باشی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده بوده باشد', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده بوده باشد', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده بوده باشیم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده بوده باشیم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده بوده باشید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده بوده باشید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده بوده باشند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده بوده باشند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('می آزموده بوده باشم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده بوده باشم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده بوده باشی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده بوده باشی', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده بوده باشد', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده بوده باشد', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده بوده باشیم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده بوده باشیم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده بوده باشید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده بوده باشید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آزموده بوده باشند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آزموده بوده باشند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('بیازمایم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازمایم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازمای', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازمای', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازماید', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازماید', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازماییم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازماییم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازمایید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازمایید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیازمایند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیازمایند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آزموده باشم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده باشم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده باش', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده باش', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده باشد', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده باشد', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده باشیم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده باشیم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده باشید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده باشید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده باشند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده باشند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده بوده باشم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده بوده باشم', '5', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده بوده باش', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده بوده باش', '5', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده بوده باشد', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده بوده باشد', '5', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده بوده باشیم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده بوده باشیم', '5', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده بوده باشید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده بوده باشید', '5', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آزموده بوده باشند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیازموده بوده باشند', '5', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آسودم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاسودم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آسودی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاسودی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آسود', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاسود', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آسودیم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاسودیم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آسودید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاسودید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آسودند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاسودند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('می آسودم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسودم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسودی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسودی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسود', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسود', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسودیم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسودیم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسودید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسودید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسودند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسودند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشتم می آسودم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتی می آسودی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشت می آسود', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتیم می آسودیم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتید می آسودید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتند می آسودند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('آسوده ام', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده ام', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده ای', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده ای', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده ', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده ', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده است', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده است', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده ایم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده ایم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده اید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده اید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده اند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده اند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('می آسوده ام', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده ام', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده ای', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده ای', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده ', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده ', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده است', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده است', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده ایم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده ایم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده اید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده اید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده اند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده اند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشته ام می آسوده ام', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ای می آسوده ای', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته  می آسوده ', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته است می آسوده است', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ایم می آسوده ایم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اید می آسوده اید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اند می آسوده اند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آسوده بودم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاسوده بودم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آسوده بودی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاسوده بودی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آسوده بود', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاسوده بود', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آسوده بودیم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاسوده بودیم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آسوده بودید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاسوده بودید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آسوده بودند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاسوده بودند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('می آسوده بودم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده بودم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده بودی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده بودی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده بود', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده بود', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده بودیم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده بودیم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده بودید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده بودید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده بودند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده بودند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشتم می آسوده بودم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتی می آسوده بودی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشت می آسوده بود', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتیم می آسوده بودیم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتید می آسوده بودید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتند می آسوده بودند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آسوده بوده ام', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده بوده ام', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده بوده ای', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده بوده ای', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده بوده ', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده بوده ', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده بوده است', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده بوده است', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده بوده ایم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده بوده ایم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده بوده اید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده بوده اید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده بوده اند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده بوده اند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('می آسوده بوده ام', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده بوده ام', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده بوده ای', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده بوده ای', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده بوده ', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده بوده ', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده بوده است', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده بوده است', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده بوده ایم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده بوده ایم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده بوده اید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده بوده اید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده بوده اند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده بوده اند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشته ام می آسوده بوده ام', '6', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ای می آسوده بوده ای', '6', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته  می آسوده بوده ', '6', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته است می آسوده بوده است', '6', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ایم می آسوده بوده ایم', '6', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اید می آسوده بوده اید', '6', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اند می آسوده بوده اند', '6', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آسایم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاسایم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آسایی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاسایی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آساید', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاساید', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آساییم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاساییم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آسایید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاسایید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آسایند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاسایند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('می آسایم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسایم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسایی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسایی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آساید', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آساید', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آساییم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آساییم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسایید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسایید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسایند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسایند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('دارم می آسایم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داری می آسایی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارد می آساید', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داریم می آساییم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارید می آسایید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارند می آسایند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('خواهم آسود', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهم آسود', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهی آسود', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهی آسود', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهد آسود', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهد آسود', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهیم آسود', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهیم آسود', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهید آسود', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهید آسود', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهند آسود', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهند آسود', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاسایم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاسایم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاسایی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاسایی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاساید', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاساید', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاساییم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاساییم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاسایید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاسایید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاسایند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاسایند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آسوده باشم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده باشم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده باشی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده باشی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده باشد', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده باشد', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده باشیم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده باشیم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده باشید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده باشید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده باشند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده باشند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('می آسوده باشم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده باشم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده باشی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده باشی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده باشد', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده باشد', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده باشیم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده باشیم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده باشید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده باشید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده باشند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده باشند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('آسوده بوده باشم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده بوده باشم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده بوده باشی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده بوده باشی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده بوده باشد', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده بوده باشد', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده بوده باشیم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده بوده باشیم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده بوده باشید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده بوده باشید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده بوده باشند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده بوده باشند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('می آسوده بوده باشم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده بوده باشم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده بوده باشی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده بوده باشی', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده بوده باشد', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده بوده باشد', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده بوده باشیم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده بوده باشیم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده بوده باشید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده بوده باشید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آسوده بوده باشند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آسوده بوده باشند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('بیاسایم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاسایم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاسای', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاسای', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاساید', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاساید', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاساییم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاساییم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاسایید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاسایید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاسایند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاسایند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آسوده باشم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده باشم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده باش', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده باش', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده باشد', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده باشد', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده باشیم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده باشیم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده باشید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده باشید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده باشند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده باشند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده بوده باشم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده بوده باشم', '6', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده بوده باش', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده بوده باش', '6', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده بوده باشد', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده بوده باشد', '6', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده بوده باشیم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده بوده باشیم', '6', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده بوده باشید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده بوده باشید', '6', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آسوده بوده باشند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاسوده بوده باشند', '6', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آشفتم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاشفتم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آشفتی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاشفتی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آشفت', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاشفت', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آشفتیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاشفتیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آشفتید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاشفتید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آشفتند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاشفتند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('می آشفتم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفتم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفتی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفتی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفت', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفت', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفتیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفتیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفتید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفتید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفتند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفتند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشتم می آشفتم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتی می آشفتی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشت می آشفت', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتیم می آشفتیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتید می آشفتید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتند می آشفتند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('آشفته ام', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته ام', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته ای', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته ای', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته ', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته ', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته است', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته است', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته ایم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته ایم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته اید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته اید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته اند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته اند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('می آشفته ام', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته ام', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته ای', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته ای', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته ', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته ', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته است', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته است', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته ایم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته ایم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته اید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته اید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته اند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته اند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشته ام می آشفته ام', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ای می آشفته ای', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته  می آشفته ', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته است می آشفته است', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ایم می آشفته ایم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اید می آشفته اید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اند می آشفته اند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آشفته بودم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاشفته بودم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آشفته بودی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاشفته بودی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آشفته بود', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاشفته بود', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آشفته بودیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاشفته بودیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آشفته بودید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاشفته بودید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آشفته بودند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاشفته بودند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('می آشفته بودم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته بودم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته بودی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته بودی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته بود', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته بود', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته بودیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته بودیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته بودید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته بودید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته بودند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته بودند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشتم می آشفته بودم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتی می آشفته بودی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشت می آشفته بود', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتیم می آشفته بودیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتید می آشفته بودید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتند می آشفته بودند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آشفته بوده ام', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته بوده ام', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته بوده ای', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته بوده ای', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته بوده ', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته بوده ', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته بوده است', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته بوده است', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته بوده ایم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته بوده ایم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته بوده اید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته بوده اید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته بوده اند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته بوده اند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('می آشفته بوده ام', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته بوده ام', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته بوده ای', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته بوده ای', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته بوده ', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته بوده ', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته بوده است', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته بوده است', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته بوده ایم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته بوده ایم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته بوده اید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته بوده اید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته بوده اند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته بوده اند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشته ام می آشفته بوده ام', '7', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ای می آشفته بوده ای', '7', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته  می آشفته بوده ', '7', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته است می آشفته بوده است', '7', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ایم می آشفته بوده ایم', '7', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اید می آشفته بوده اید', '7', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اند می آشفته بوده اند', '7', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آشوبم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاشوبم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آشوبی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاشوبی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آشوبد', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاشوبد', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آشوبیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاشوبیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آشوبید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاشوبید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آشوبند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاشوبند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('می آشوبم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشوبم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشوبی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشوبی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشوبد', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشوبد', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشوبیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشوبیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشوبید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشوبید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشوبند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشوبند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('دارم می آشوبم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داری می آشوبی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارد می آشوبد', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داریم می آشوبیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارید می آشوبید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارند می آشوبند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('خواهم آشفت', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهم آشفت', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهی آشفت', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهی آشفت', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهد آشفت', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهد آشفت', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهیم آشفت', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهیم آشفت', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهید آشفت', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهید آشفت', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهند آشفت', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهند آشفت', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاشوبم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاشوبم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاشوبی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاشوبی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاشوبد', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاشوبد', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاشوبیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاشوبیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاشوبید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاشوبید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاشوبند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاشوبند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آشفته باشم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته باشم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته باشی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته باشی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته باشد', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته باشد', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته باشیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته باشیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته باشید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته باشید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته باشند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته باشند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('می آشفته باشم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته باشم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته باشی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته باشی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته باشد', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته باشد', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته باشیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته باشیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته باشید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته باشید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته باشند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته باشند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('آشفته بوده باشم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته بوده باشم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته بوده باشی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته بوده باشی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته بوده باشد', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته بوده باشد', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته بوده باشیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته بوده باشیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته بوده باشید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته بوده باشید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته بوده باشند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته بوده باشند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('می آشفته بوده باشم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته بوده باشم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته بوده باشی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته بوده باشی', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته بوده باشد', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته بوده باشد', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته بوده باشیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته بوده باشیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته بوده باشید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته بوده باشید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آشفته بوده باشند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آشفته بوده باشند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('بیاشوبم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاشوبم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاشوب', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاشوب', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاشوبد', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاشوبد', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاشوبیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاشوبیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاشوبید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاشوبید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاشوبند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاشوبند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آشفته باشم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته باشم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته باش', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته باش', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته باشد', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته باشد', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته باشیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته باشیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته باشید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته باشید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته باشند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته باشند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته بوده باشم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته بوده باشم', '7', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته بوده باش', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته بوده باش', '7', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته بوده باشد', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته بوده باشد', '7', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته بوده باشیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته بوده باشیم', '7', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته بوده باشید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته بوده باشید', '7', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آشفته بوده باشند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاشفته بوده باشند', '7', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشتم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغشتم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آغشتی', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغشتی', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آغشت', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغشت', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آغشتیم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغشتیم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آغشتید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغشتید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آغشتند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغشتند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('می آغشتم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشتم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشتی', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشتی', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشت', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشت', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشتیم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشتیم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشتید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشتید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشتند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشتند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشتم می آغشتم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتی می آغشتی', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشت می آغشت', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتیم می آغشتیم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتید می آغشتید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتند می آغشتند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('آغشته ام', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته ام', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته ای', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته ای', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته ', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته ', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته است', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته است', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته ایم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته ایم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته اید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته اید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته اند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته اند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('می آغشته ام', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته ام', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته ای', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته ای', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته ', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته ', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته است', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته است', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته ایم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته ایم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته اید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته اید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته اند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته اند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشته ام می آغشته ام', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ای می آغشته ای', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته  می آغشته ', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته است می آغشته است', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ایم می آغشته ایم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اید می آغشته اید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اند می آغشته اند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آغشته بودم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاغشته بودم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آغشته بودی', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاغشته بودی', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آغشته بود', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاغشته بود', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آغشته بودیم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاغشته بودیم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آغشته بودید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاغشته بودید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آغشته بودند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاغشته بودند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('می آغشته بودم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بودم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بودی', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بودی', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بود', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بود', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بودیم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بودیم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بودید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بودید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بودند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بودند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشتم می آغشته بودم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتی می آغشته بودی', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشت می آغشته بود', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتیم می آغشته بودیم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتید می آغشته بودید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتند می آغشته بودند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آغشته بوده ام', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده ام', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده ای', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده ای', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده ', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده ', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده است', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده است', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده ایم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده ایم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده اید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده اید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده اند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده اند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده ام', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده ام', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده ای', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده ای', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده ', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده ', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده است', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده است', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده ایم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده ایم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده اید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده اید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده اند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده اند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشته ام می آغشته بوده ام', '8', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ای می آغشته بوده ای', '8', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته  می آغشته بوده ', '8', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته است می آغشته بوده است', '8', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ایم می آغشته بوده ایم', '8', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اید می آغشته بوده اید', '8', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اند می آغشته بوده اند', '8', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آغرم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغرم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آغری', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغری', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آغرد', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغرد', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آغریم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغریم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آغرید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغرید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آغرند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغرند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('می آغرم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغرم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغری', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغری', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغرد', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغرد', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغریم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغریم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغرید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغرید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغرند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغرند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('دارم می آغرم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داری می آغری', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارد می آغرد', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داریم می آغریم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارید می آغرید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارند می آغرند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('خواهم آغشت', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهم آغشت', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهی آغشت', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهی آغشت', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهد آغشت', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهد آغشت', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهیم آغشت', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهیم آغشت', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهید آغشت', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهید آغشت', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهند آغشت', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهند آغشت', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاغرم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغرم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاغری', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغری', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاغرد', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغرد', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاغریم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغریم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاغرید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغرید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاغرند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغرند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آغشته باشم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته باشم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته باشی', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته باشی', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته باشد', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته باشد', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته باشیم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته باشیم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته باشید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته باشید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته باشند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته باشند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('می آغشته باشم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته باشم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته باشی', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته باشی', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته باشد', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته باشد', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته باشیم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته باشیم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته باشید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته باشید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته باشند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته باشند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('آغشته بوده باشم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده باشم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده باشی', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده باشی', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده باشد', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده باشد', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده باشیم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده باشیم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده باشید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده باشید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده باشند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده باشند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده باشم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده باشم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده باشی', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده باشی', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده باشد', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده باشد', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده باشیم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده باشیم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده باشید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده باشید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده باشند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده باشند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('بیاغرم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغرم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاغر', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغر', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاغرد', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغرد', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاغریم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغریم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاغرید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغرید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاغرند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغرند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آغشته باشم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته باشم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته باش', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته باش', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته باشد', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته باشد', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته باشیم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته باشیم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته باشید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته باشید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته باشند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته باشند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده باشم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده باشم', '8', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده باش', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده باش', '8', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده باشد', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده باشد', '8', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده باشیم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده باشیم', '8', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده باشید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده باشید', '8', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده باشند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده باشند', '8', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشتم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغشتم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آغشتی', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغشتی', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آغشت', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغشت', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آغشتیم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغشتیم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آغشتید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغشتید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آغشتند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغشتند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('می آغشتم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشتم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشتی', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشتی', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشت', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشت', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشتیم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشتیم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشتید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشتید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشتند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشتند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشتم می آغشتم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتی می آغشتی', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشت می آغشت', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتیم می آغشتیم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتید می آغشتید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتند می آغشتند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('آغشته ام', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته ام', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته ای', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته ای', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته ', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته ', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته است', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته است', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته ایم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته ایم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته اید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته اید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته اند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته اند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('می آغشته ام', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته ام', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته ای', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته ای', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته ', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته ', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته است', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته است', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته ایم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته ایم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته اید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته اید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته اند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته اند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشته ام می آغشته ام', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ای می آغشته ای', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته  می آغشته ', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته است می آغشته است', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ایم می آغشته ایم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اید می آغشته اید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اند می آغشته اند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آغشته بودم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاغشته بودم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آغشته بودی', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاغشته بودی', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آغشته بود', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاغشته بود', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آغشته بودیم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاغشته بودیم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آغشته بودید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاغشته بودید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آغشته بودند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاغشته بودند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('می آغشته بودم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بودم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بودی', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بودی', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بود', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بود', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بودیم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بودیم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بودید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بودید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بودند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بودند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشتم می آغشته بودم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتی می آغشته بودی', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشت می آغشته بود', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتیم می آغشته بودیم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتید می آغشته بودید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتند می آغشته بودند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آغشته بوده ام', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده ام', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده ای', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده ای', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده ', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده ', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده است', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده است', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده ایم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده ایم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده اید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده اید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده اند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده اند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده ام', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده ام', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده ای', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده ای', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده ', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده ', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده است', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده است', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده ایم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده ایم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده اید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده اید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده اند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده اند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشته ام می آغشته بوده ام', '9', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ای می آغشته بوده ای', '9', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته  می آغشته بوده ', '9', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته است می آغشته بوده است', '9', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ایم می آغشته بوده ایم', '9', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اید می آغشته بوده اید', '9', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اند می آغشته بوده اند', '9', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آغرم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغرم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آغری', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغری', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آغرد', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغرد', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آغریم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغریم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آغرید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغرید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آغرند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغرند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('می آغرم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغرم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغری', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغری', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغرد', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغرد', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغریم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغریم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغرید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغرید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغرند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغرند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('دارم می آغرم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داری می آغری', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارد می آغرد', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داریم می آغریم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارید می آغرید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارند می آغرند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('خواهم آغشت', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهم آغشت', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهی آغشت', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهی آغشت', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهد آغشت', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهد آغشت', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهیم آغشت', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهیم آغشت', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهید آغشت', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهید آغشت', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهند آغشت', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهند آغشت', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاغرم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغرم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاغری', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغری', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاغرد', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغرد', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاغریم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغریم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاغرید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغرید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاغرند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغرند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آغشته باشم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته باشم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته باشی', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته باشی', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته باشد', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته باشد', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته باشیم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته باشیم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته باشید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته باشید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته باشند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته باشند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('می آغشته باشم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته باشم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته باشی', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته باشی', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته باشد', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته باشد', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته باشیم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته باشیم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته باشید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته باشید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته باشند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته باشند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('آغشته بوده باشم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده باشم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده باشی', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده باشی', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده باشد', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده باشد', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده باشیم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده باشیم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده باشید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده باشید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده باشند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده باشند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده باشم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده باشم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده باشی', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده باشی', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده باشد', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده باشد', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده باشیم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده باشیم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده باشید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده باشید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آغشته بوده باشند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آغشته بوده باشند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('بیاغرم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغرم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاغر', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغر', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاغرد', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغرد', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاغریم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغریم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاغرید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغرید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاغرند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاغرند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آغشته باشم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته باشم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته باش', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته باش', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته باشد', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته باشد', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته باشیم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته باشیم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته باشید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته باشید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته باشند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته باشند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده باشم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده باشم', '9', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده باش', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده باش', '9', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده باشد', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده باشد', '9', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده باشیم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده باشیم', '9', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده باشید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده باشید', '9', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آغشته بوده باشند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاغشته بوده باشند', '9', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آفریدم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیافریدم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آفریدی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیافریدی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آفرید', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیافرید', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آفریدیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیافریدیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آفریدید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیافریدید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آفریدند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیافریدند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('می آفریدم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریدم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریدی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریدی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفرید', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفرید', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریدیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریدیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریدید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریدید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریدند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریدند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشتم می آفریدم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتی می آفریدی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشت می آفرید', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتیم می آفریدیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتید می آفریدید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتند می آفریدند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('آفریده ام', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده ام', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده ای', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده ای', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده ', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده ', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده است', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده است', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده ایم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده ایم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده اید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده اید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده اند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده اند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('می آفریده ام', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده ام', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده ای', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده ای', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده ', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده ', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده است', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده است', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده ایم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده ایم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده اید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده اید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده اند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده اند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشته ام می آفریده ام', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ای می آفریده ای', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته  می آفریده ', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته است می آفریده است', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ایم می آفریده ایم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اید می آفریده اید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اند می آفریده اند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آفریده بودم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیافریده بودم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آفریده بودی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیافریده بودی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آفریده بود', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیافریده بود', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آفریده بودیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیافریده بودیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آفریده بودید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیافریده بودید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آفریده بودند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیافریده بودند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('می آفریده بودم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده بودم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده بودی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده بودی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده بود', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده بود', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده بودیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده بودیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده بودید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده بودید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده بودند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده بودند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشتم می آفریده بودم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتی می آفریده بودی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشت می آفریده بود', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتیم می آفریده بودیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتید می آفریده بودید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتند می آفریده بودند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آفریده بوده ام', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده بوده ام', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده بوده ای', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده بوده ای', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده بوده ', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده بوده ', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده بوده است', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده بوده است', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده بوده ایم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده بوده ایم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده بوده اید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده بوده اید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده بوده اند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده بوده اند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('می آفریده بوده ام', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده بوده ام', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده بوده ای', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده بوده ای', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده بوده ', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده بوده ', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده بوده است', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده بوده است', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده بوده ایم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده بوده ایم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده بوده اید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده بوده اید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده بوده اند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده بوده اند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشته ام می آفریده بوده ام', '10', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ای می آفریده بوده ای', '10', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته  می آفریده بوده ', '10', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته است می آفریده بوده است', '10', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ایم می آفریده بوده ایم', '10', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اید می آفریده بوده اید', '10', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اند می آفریده بوده اند', '10', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آفرینم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیافرینم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آفرینی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیافرینی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آفریند', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیافریند', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آفرینیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیافرینیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آفرینید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیافرینید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آفرینند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیافرینند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('می آفرینم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفرینم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفرینی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفرینی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریند', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریند', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفرینیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفرینیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفرینید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفرینید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفرینند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفرینند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('دارم می آفرینم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داری می آفرینی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارد می آفریند', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داریم می آفرینیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارید می آفرینید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارند می آفرینند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('خواهم آفرید', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهم آفرید', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهی آفرید', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهی آفرید', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهد آفرید', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهد آفرید', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهیم آفرید', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهیم آفرید', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهید آفرید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهید آفرید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهند آفرید', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهند آفرید', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیافرینم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیافرینم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیافرینی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیافرینی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیافریند', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیافریند', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیافرینیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیافرینیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیافرینید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیافرینید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیافرینند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیافرینند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آفریده باشم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده باشم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده باشی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده باشی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده باشد', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده باشد', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده باشیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده باشیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده باشید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده باشید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده باشند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده باشند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('می آفریده باشم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده باشم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده باشی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده باشی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده باشد', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده باشد', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده باشیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده باشیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده باشید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده باشید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده باشند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده باشند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('آفریده بوده باشم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده بوده باشم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده بوده باشی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده بوده باشی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده بوده باشد', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده بوده باشد', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده بوده باشیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده بوده باشیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده بوده باشید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده بوده باشید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده بوده باشند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده بوده باشند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('می آفریده بوده باشم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده بوده باشم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده بوده باشی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده بوده باشی', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده بوده باشد', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده بوده باشد', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده بوده باشیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده بوده باشیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده بوده باشید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده بوده باشید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آفریده بوده باشند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آفریده بوده باشند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('بیافرینم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیافرینم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیافرین', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیافرین', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیافریند', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیافریند', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیافرینیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیافرینیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیافرینید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیافرینید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیافرینند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیافرینند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آفریده باشم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده باشم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده باش', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده باش', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده باشد', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده باشد', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده باشیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده باشیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده باشید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده باشید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده باشند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده باشند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده بوده باشم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده بوده باشم', '10', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده بوده باش', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده بوده باش', '10', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده بوده باشد', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده بوده باشد', '10', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده بوده باشیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده بوده باشیم', '10', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده بوده باشید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده بوده باشید', '10', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آفریده بوده باشند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیافریده بوده باشند', '10', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آکندم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاکندم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آکندی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاکندی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آکند', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاکند', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آکندیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاکندیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آکندید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاکندید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آکندند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاکندند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('می آکندم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکندم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکندی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکندی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکند', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکند', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکندیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکندیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکندید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکندید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکندند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکندند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشتم می آکندم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتی می آکندی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشت می آکند', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتیم می آکندیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتید می آکندید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتند می آکندند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('آکنده ام', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده ام', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده ای', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده ای', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده ', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده ', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده است', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده است', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده ایم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده ایم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده اید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده اید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده اند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده اند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('می آکنده ام', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده ام', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده ای', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده ای', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده ', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده ', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده است', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده است', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده ایم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده ایم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده اید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده اید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده اند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده اند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشته ام می آکنده ام', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ای می آکنده ای', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته  می آکنده ', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته است می آکنده است', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ایم می آکنده ایم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اید می آکنده اید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اند می آکنده اند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آکنده بودم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاکنده بودم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آکنده بودی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاکنده بودی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آکنده بود', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاکنده بود', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آکنده بودیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاکنده بودیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آکنده بودید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاکنده بودید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آکنده بودند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاکنده بودند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('می آکنده بودم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده بودم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده بودی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده بودی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده بود', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده بود', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده بودیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده بودیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده بودید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده بودید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده بودند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده بودند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشتم می آکنده بودم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتی می آکنده بودی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشت می آکنده بود', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتیم می آکنده بودیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتید می آکنده بودید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتند می آکنده بودند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آکنده بوده ام', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده بوده ام', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده بوده ای', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده بوده ای', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده بوده ', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده بوده ', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده بوده است', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده بوده است', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده بوده ایم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده بوده ایم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده بوده اید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده بوده اید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده بوده اند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده بوده اند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('می آکنده بوده ام', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده بوده ام', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده بوده ای', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده بوده ای', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده بوده ', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده بوده ', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده بوده است', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده بوده است', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده بوده ایم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده بوده ایم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده بوده اید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده بوده اید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده بوده اند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده بوده اند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشته ام می آکنده بوده ام', '11', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ای می آکنده بوده ای', '11', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته  می آکنده بوده ', '11', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته است می آکنده بوده است', '11', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ایم می آکنده بوده ایم', '11', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اید می آکنده بوده اید', '11', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اند می آکنده بوده اند', '11', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آکنم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاکنم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آکنی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاکنی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آکند', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاکند', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آکنیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاکنیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آکنید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاکنید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آکنند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاکنند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('می آکنم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکند', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکند', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('دارم می آکنم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داری می آکنی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارد می آکند', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داریم می آکنیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارید می آکنید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارند می آکنند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('خواهم آکند', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهم آکند', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهی آکند', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهی آکند', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهد آکند', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهد آکند', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهیم آکند', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهیم آکند', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهید آکند', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهید آکند', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهند آکند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهند آکند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاکنم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاکنم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاکنی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاکنی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاکند', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاکند', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاکنیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاکنیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاکنید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاکنید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاکنند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاکنند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آکنده باشم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده باشم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده باشی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده باشی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده باشد', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده باشد', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده باشیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده باشیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده باشید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده باشید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده باشند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده باشند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('می آکنده باشم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده باشم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده باشی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده باشی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده باشد', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده باشد', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده باشیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده باشیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده باشید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده باشید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده باشند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده باشند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('آکنده بوده باشم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده بوده باشم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده بوده باشی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده بوده باشی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده بوده باشد', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده بوده باشد', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده بوده باشیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده بوده باشیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده بوده باشید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده بوده باشید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده بوده باشند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده بوده باشند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('می آکنده بوده باشم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده بوده باشم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده بوده باشی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده بوده باشی', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده بوده باشد', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده بوده باشد', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده بوده باشیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده بوده باشیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده بوده باشید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده بوده باشید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آکنده بوده باشند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آکنده بوده باشند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('بیاکنم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاکنم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاکن', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاکن', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاکند', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاکند', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاکنیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاکنیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاکنید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاکنید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاکنند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاکنند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'IMPERATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آکنده باشم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده باشم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده باش', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده باش', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده باشد', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده باشد', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده باشیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده باشیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده باشید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده باشید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده باشند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده باشند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'IMPERATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده بوده باشم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده بوده باشم', '11', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده بوده باش', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده بوده باش', '11', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده بوده باشد', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده بوده باشد', '11', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده بوده باشیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده بوده باشیم', '11', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده بوده باشید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده بوده باشید', '11', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آکنده بوده باشند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاکنده بوده باشند', '11', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'IMPERATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آگندم', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاگندم', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آگندی', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاگندی', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آگند', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاگند', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آگندیم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاگندیم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آگندید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاگندید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آگندند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاگندند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('می آگندم', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگندم', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگندی', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگندی', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگند', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگند', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگندیم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگندیم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگندید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگندید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگندند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگندند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشتم می آگندم', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتی می آگندی', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشت می آگند', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتیم می آگندیم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتید می آگندید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتند می آگندند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('آگنده ام', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاگنده ام', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آگنده ای', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاگنده ای', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آگنده ', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاگنده ', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آگنده است', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاگنده است', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آگنده ایم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاگنده ایم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آگنده اید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاگنده اید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آگنده اند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاگنده اند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('می آگنده ام', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنده ام', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگنده ای', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنده ای', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگنده ', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنده ', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگنده است', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنده است', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگنده ایم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنده ایم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگنده اید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنده اید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگنده اند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنده اند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشته ام می آگنده ام', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ای می آگنده ای', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته  می آگنده ', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته است می آگنده است', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ایم می آگنده ایم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اید می آگنده اید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اند می آگنده اند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آگنده بودم', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاگنده بودم', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آگنده بودی', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاگنده بودی', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آگنده بود', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاگنده بود', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آگنده بودیم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاگنده بودیم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آگنده بودید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاگنده بودید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('آگنده بودند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('نیاگنده بودند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT');
INSERT INTO `verb` VALUES ('می آگنده بودم', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنده بودم', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگنده بودی', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنده بودی', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگنده بود', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنده بود', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگنده بودیم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنده بودیم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگنده بودید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنده بودید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگنده بودند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنده بودند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشتم می آگنده بودم', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتی می آگنده بودی', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشت می آگنده بود', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتیم می آگنده بودیم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتید می آگنده بودید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشتند می آگنده بودند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'INDICATIVE', 'PRECEDENT_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آگنده بوده ام', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاگنده بوده ام', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آگنده بوده ای', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاگنده بوده ای', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آگنده بوده ', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاگنده بوده ', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آگنده بوده است', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاگنده بوده است', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آگنده بوده ایم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاگنده بوده ایم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آگنده بوده اید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاگنده بوده اید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('آگنده بوده اند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('نیاگنده بوده اند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE');
INSERT INTO `verb` VALUES ('می آگنده بوده ام', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنده بوده ام', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'ام', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگنده بوده ای', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنده بوده ای', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ای', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگنده بوده ', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنده بوده ', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگنده بوده است', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنده بوده است', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'است', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگنده بوده ایم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنده بوده ایم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'ایم', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگنده بوده اید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنده بوده اید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'اید', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگنده بوده اند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنده بوده اند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'اند', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('داشته ام می آگنده بوده ام', '12', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ای می آگنده بوده ای', '12', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته  می آگنده بوده ', '12', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته است می آگنده بوده است', '12', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته ایم می آگنده بوده ایم', '12', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اید می آگنده بوده اید', '12', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('داشته اند می آگنده بوده اند', '12', 'ACTIVE', '', '', 'POSITIVE', '', 'PAST', 'INDICATIVE', 'PRECEDENT_NARRATIVE_PROGRESSIVE');
INSERT INTO `verb` VALUES ('آگنم', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاگنم', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آگنی', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاگنی', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آگند', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاگند', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آگنیم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاگنیم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آگنید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاگنید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آگنند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاگنند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('می آگنم', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنم', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگنی', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنی', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگند', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگند', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگنیم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنیم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگنید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگنند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'INDICATIVE', 'IMPERFECTIVE');
INSERT INTO `verb` VALUES ('دارم می آگنم', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داری می آگنی', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارد می آگند', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('داریم می آگنیم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارید می آگنید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('دارند می آگنند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'INDICATIVE', 'PROGRESSIVE');
INSERT INTO `verb` VALUES ('خواهم آگند', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهم آگند', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهی آگند', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهی آگند', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهد آگند', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهد آگند', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهیم آگند', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهیم آگند', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهید آگند', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهید آگند', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('خواهند آگند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نخواهند آگند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', '', 'FUTURE', 'INDICATIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاگنم', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاگنم', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاگنی', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاگنی', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاگند', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاگند', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاگنیم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاگنیم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاگنید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاگنید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('بیاگنند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('نیاگنند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PRESENT', 'SUBJUNCTIVE', 'SIMPLE');
INSERT INTO `verb` VALUES ('آگنده باشم', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاگنده باشم', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آگنده باشی', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاگنده باشی', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آگنده باشد', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاگنده باشد', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آگنده باشیم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاگنده باشیم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آگنده باشید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'POSITIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاگنده باشید', '12', 'ACTIVE', 'PLURAR', 'SECOND_PERSON', 'NEGATIVE', 'ید', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('آگنده باشند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'POSITIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('نیاگنده باشند', '12', 'ACTIVE', 'PLURAR', 'THIRD_PERSON', 'NEGATIVE', 'ند', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE');
INSERT INTO `verb` VALUES ('می آگنده باشم', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'POSITIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنده باشم', '12', 'ACTIVE', 'SINGULAR', 'FIRST_PERSON', 'NEGATIVE', 'م', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگنده باشی', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'POSITIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنده باشی', '12', 'ACTIVE', 'SINGULAR', 'SECOND_PERSON', 'NEGATIVE', 'ی', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگنده باشد', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'POSITIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنده باشد', '12', 'ACTIVE', 'SINGULAR', 'THIRD_PERSON', 'NEGATIVE', 'د', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('می آگنده باشیم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'POSITIVE', 'یم', 'PAST', 'SUBJUNCTIVE', 'NARRATIVE_IMPERFECTIVE');
INSERT INTO `verb` VALUES ('نمی آگنده باشیم', '12', 'ACTIVE', 'PLURAR', 'FIRST_PERSON', 'NEGATIVE', '